/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.querycache;

import com.hazelcast.client.impl.querycache.subscriber.ClientInvokerWrapper;
import com.hazelcast.client.impl.querycache.subscriber.ClientQueryCacheConfigurator;
import com.hazelcast.client.impl.querycache.subscriber.ClientQueryCacheEventService;
import com.hazelcast.client.impl.querycache.subscriber.ClientQueryCacheScheduler;
import com.hazelcast.client.impl.querycache.subscriber.ClientSubscriberContext;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.core.Member;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.map.impl.querycache.InvokerWrapper;
import com.hazelcast.map.impl.querycache.QueryCacheConfigurator;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.QueryCacheEventService;
import com.hazelcast.map.impl.querycache.QueryCacheScheduler;
import com.hazelcast.map.impl.querycache.publisher.PublisherContext;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberContext;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ContextMutexFactory;
import java.util.Collection;

public class ClientQueryCacheContext
implements QueryCacheContext {
    private final ClientContext clientContext;
    private final InvokerWrapper invokerWrapper;
    private final QueryCacheScheduler queryCacheScheduler;
    private final QueryCacheEventService queryCacheEventService;
    private final QueryCacheConfigurator queryCacheConfigurator;
    private final ContextMutexFactory mutexFactory = new ContextMutexFactory();
    private SubscriberContext subscriberContext;

    public ClientQueryCacheContext(ClientContext clientContext) {
        this.clientContext = clientContext;
        this.queryCacheEventService = new ClientQueryCacheEventService(clientContext);
        this.queryCacheConfigurator = new ClientQueryCacheConfigurator(clientContext.getClientConfig(), this.queryCacheEventService);
        this.queryCacheScheduler = new ClientQueryCacheScheduler(clientContext.getExecutionService());
        this.invokerWrapper = new ClientInvokerWrapper(this, clientContext);
        this.subscriberContext = new ClientSubscriberContext(this);
    }

    @Override
    public SubscriberContext getSubscriberContext() {
        return this.subscriberContext;
    }

    @Override
    public Object toObject(Object obj) {
        SerializationService serializationService = this.clientContext.getSerializationService();
        return serializationService.toObject(obj);
    }

    @Override
    public void destroy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InternalSerializationService getSerializationService() {
        return (InternalSerializationService)this.clientContext.getSerializationService();
    }

    @Override
    public Collection<Member> getMemberList() {
        return this.clientContext.getClusterService().getMemberList();
    }

    @Override
    public int getPartitionId(Object object) {
        return this.clientContext.getPartitionService().getPartitionId(object);
    }

    @Override
    public ContextMutexFactory getLifecycleMutexFactory() {
        return this.mutexFactory;
    }

    @Override
    public InvokerWrapper getInvokerWrapper() {
        return this.invokerWrapper;
    }

    @Override
    public QueryCacheEventService getQueryCacheEventService() {
        return this.queryCacheEventService;
    }

    @Override
    public QueryCacheConfigurator getQueryCacheConfigurator() {
        return this.queryCacheConfigurator;
    }

    @Override
    public QueryCacheScheduler getQueryCacheScheduler() {
        return this.queryCacheScheduler;
    }

    @Override
    public void setSubscriberContext(SubscriberContext subscriberContext) {
        this.subscriberContext = subscriberContext;
    }

    @Override
    public PublisherContext getPublisherContext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Address getThisNodesAddress() {
        throw new UnsupportedOperationException();
    }
}

