/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.impl.AbstractHazelcastCacheManager;
import com.hazelcast.cache.impl.ICacheInternal;
import com.hazelcast.client.cache.impl.ClientCacheHelper;
import com.hazelcast.client.cache.impl.ClientCacheProxyFactory;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.impl.ClientICacheManager;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public final class HazelcastClientCacheManager
extends AbstractHazelcastCacheManager {
    private final HazelcastClientInstanceImpl client;
    private final ClientCacheProxyFactory clientCacheProxyFactory;

    public HazelcastClientCacheManager(HazelcastClientCachingProvider cachingProvider, HazelcastInstance hazelcastInstance, URI uri, ClassLoader classLoader, Properties properties) {
        super(cachingProvider, hazelcastInstance, uri, classLoader, properties);
        this.client = hazelcastInstance instanceof HazelcastClientProxy ? ((HazelcastClientProxy)hazelcastInstance).client : (HazelcastClientInstanceImpl)hazelcastInstance;
        this.clientCacheProxyFactory = (ClientCacheProxyFactory)this.client.getProxyManager().getClientProxyFactory("hz:impl:cacheService");
    }

    public void enableManagement(String cacheName, boolean enabled) {
        this.enableStatisticManagementOnNodes(cacheName, false, enabled);
    }

    public void enableStatistics(String cacheName, boolean enabled) {
        this.enableStatisticManagementOnNodes(cacheName, true, enabled);
    }

    private void enableStatisticManagementOnNodes(String cacheName, boolean statOrMan, boolean enabled) {
        this.ensureOpen();
        Preconditions.checkNotNull(cacheName, "cacheName cannot be null");
        ClientCacheHelper.enableStatisticManagementOnNodes(this.client, this.getCacheNameWithPrefix(cacheName), statOrMan, enabled);
    }

    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_OF_PUTIFABSENT_IGNORED"})
    protected <K, V> void addCacheConfigIfAbsent(CacheConfig<K, V> cacheConfig) {
        this.clientCacheProxyFactory.addCacheConfig(cacheConfig.getNameWithPrefix(), cacheConfig);
    }

    @Override
    protected void removeCacheConfigFromLocal(String cacheNameWithPrefix) {
        this.clientCacheProxyFactory.removeCacheConfig(cacheNameWithPrefix);
    }

    @Override
    protected <K, V> CacheConfig<K, V> getCacheConfig(String cacheName, String simpleCacheName) {
        return ClientCacheHelper.getCacheConfig(this.client, cacheName, simpleCacheName);
    }

    @Override
    protected <K, V> ICacheInternal<K, V> createCacheProxy(CacheConfig<K, V> cacheConfig) {
        this.clientCacheProxyFactory.addCacheConfig(cacheConfig.getNameWithPrefix(), cacheConfig);
        try {
            ClientICacheManager cacheManager = this.client.getCacheManager();
            String nameWithPrefix = cacheConfig.getNameWithPrefix();
            ICacheInternal cache = (ICacheInternal)cacheManager.getCacheByFullName(nameWithPrefix);
            cache.setCacheManager(this);
            return cache;
        }
        catch (Throwable t) {
            this.clientCacheProxyFactory.removeCacheConfig(cacheConfig.getNameWithPrefix());
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    protected <K, V> CacheConfig<K, V> findCacheConfig(String cacheName, String simpleCacheName, boolean createAlsoOnOthers, boolean syncCreate) {
        CacheConfig<K, V> config = this.clientCacheProxyFactory.getCacheConfig(cacheName);
        if (config == null && (config = this.getCacheConfig(cacheName, simpleCacheName)) != null) {
            this.createCacheConfig(cacheName, config, createAlsoOnOthers, syncCreate);
        }
        return config;
    }

    @Override
    protected <K, V> CacheConfig<K, V> createCacheConfig(String cacheName, CacheConfig<K, V> config, boolean createAlsoOnOthers, boolean syncCreate) {
        return ClientCacheHelper.createCacheConfig(this.client, this.clientCacheProxyFactory.getCacheConfig(cacheName), config, createAlsoOnOthers, syncCreate);
    }

    public <T> T unwrap(Class<T> clazz) {
        if (HazelcastClientCacheManager.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected void postClose() {
        if (this.properties.getProperty("hazelcast.config.location") != null) {
            this.hazelcastInstance.shutdown();
        }
    }

    @Override
    protected void postDestroy() {
        Iterator<Map.Entry<String, CacheConfig>> iter = this.clientCacheProxyFactory.configs().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, CacheConfig> entry = iter.next();
            String cacheName = entry.getKey();
            this.clientCacheProxyFactory.removeCacheConfig(cacheName);
            iter.remove();
        }
    }

    @Override
    protected void onShuttingDown() {
    }

    public NearCacheManager getNearCacheManager() {
        return this.client.getNearCacheManager();
    }
}

