/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.tx;

import com.hazelcast.map.operation.LockAwareOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.map.tx.VersionedValue;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.transaction.TransactionException;
import java.io.IOException;

public class TxnLockAndGetOperation
extends LockAwareOperation {
    private long timeout;
    private VersionedValue response;
    private String ownerUuid;

    public TxnLockAndGetOperation() {
    }

    public TxnLockAndGetOperation(String name, Data dataKey, long timeout, long ttl, String ownerUuid) {
        super(name, dataKey, ttl);
        this.timeout = timeout;
        this.ownerUuid = ownerUuid;
    }

    @Override
    public void run() throws Exception {
        if (!this.recordStore.txnLock(this.getKey(), this.ownerUuid, this.getThreadId(), this.ttl)) {
            throw new TransactionException("Transaction couldn't obtain lock!");
        }
        Record record = this.recordStore.getRecord(this.dataKey);
        Data value = record == null ? null : this.mapService.toData(record.getValue());
        this.response = new VersionedValue(value, record == null ? 0L : record.getVersion());
    }

    @Override
    public boolean shouldWait() {
        return !this.recordStore.canAcquireLock(this.dataKey, this.ownerUuid, this.getThreadId());
    }

    @Override
    public long getWaitTimeoutMillis() {
        return this.timeout;
    }

    @Override
    public void onWaitExpire() {
        ResponseHandler responseHandler = this.getResponseHandler();
        responseHandler.sendResponse(null);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.timeout);
        out.writeUTF(this.ownerUuid);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.timeout = in.readLong();
        this.ownerUuid = in.readUTF();
    }

    public String toString() {
        return "TxnLockAndGetOperation{timeout=" + this.timeout + ", thread=" + this.getThreadId() + '}';
    }
}

