/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn.proxy;

import com.hazelcast.client.txn.TransactionContextProxy;
import com.hazelcast.client.txn.proxy.ClientTxnProxy;
import com.hazelcast.core.TransactionalMultiMap;
import com.hazelcast.multimap.operations.client.TxnMultiMapGetRequest;
import com.hazelcast.multimap.operations.client.TxnMultiMapPutRequest;
import com.hazelcast.multimap.operations.client.TxnMultiMapRemoveAllRequest;
import com.hazelcast.multimap.operations.client.TxnMultiMapRemoveRequest;
import com.hazelcast.multimap.operations.client.TxnMultiMapSizeRequest;
import com.hazelcast.multimap.operations.client.TxnMultiMapValueCountRequest;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.PortableCollection;
import com.hazelcast.transaction.TransactionException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class ClientTxnMultiMapProxy<K, V>
extends ClientTxnProxy
implements TransactionalMultiMap<K, V> {
    public ClientTxnMultiMapProxy(String name, TransactionContextProxy proxy) {
        super(name, proxy);
    }

    @Override
    public boolean put(K key, V value) throws TransactionException {
        int threadId = (int)Thread.currentThread().getId();
        TxnMultiMapPutRequest request = new TxnMultiMapPutRequest(this.getName(), this.toData(key), this.toData(value), threadId);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public Collection<V> get(K key) {
        int threadId = (int)Thread.currentThread().getId();
        TxnMultiMapGetRequest request = new TxnMultiMapGetRequest(this.getName(), this.toData(key), threadId);
        PortableCollection portableCollection = (PortableCollection)this.invoke(request);
        Collection<Data> collection = portableCollection.getCollection();
        AbstractCollection coll = collection instanceof List ? new ArrayList(collection.size()) : new HashSet(collection.size());
        for (Data data : collection) {
            coll.add(this.toObject(data));
        }
        return coll;
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.throwExceptionIfNull(key);
        this.throwExceptionIfNull(value);
        int threadId = (int)Thread.currentThread().getId();
        TxnMultiMapRemoveRequest request = new TxnMultiMapRemoveRequest(this.getName(), this.toData(key), this.toData(value), threadId);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public Collection<V> remove(Object key) {
        this.throwExceptionIfNull(key);
        int threadId = (int)Thread.currentThread().getId();
        TxnMultiMapRemoveAllRequest request = new TxnMultiMapRemoveAllRequest(this.getName(), this.toData(key), threadId);
        PortableCollection portableCollection = (PortableCollection)this.invoke(request);
        Collection<Data> collection = portableCollection.getCollection();
        AbstractCollection coll = collection instanceof List ? new ArrayList(collection.size()) : new HashSet(collection.size());
        for (Data data : collection) {
            coll.add(this.toObject(data));
        }
        return coll;
    }

    @Override
    public int valueCount(K key) {
        int threadId = (int)Thread.currentThread().getId();
        TxnMultiMapValueCountRequest request = new TxnMultiMapValueCountRequest(this.getName(), this.toData(key), threadId);
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    @Override
    public int size() {
        int threadId = (int)Thread.currentThread().getId();
        TxnMultiMapSizeRequest request = new TxnMultiMapSizeRequest(this.getName(), threadId);
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    @Override
    public String getName() {
        return (String)this.getId();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:multiMapService";
    }

    @Override
    void onDestroy() {
    }

    private void throwExceptionIfNull(Object o) {
        if (o == null) {
            throw new NullPointerException("Object is null");
        }
    }
}

