/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.connection.Connection;
import com.hazelcast.client.txn.TransactionProxy;
import com.hazelcast.client.txn.proxy.ClientTxnListProxy;
import com.hazelcast.client.txn.proxy.ClientTxnMapProxy;
import com.hazelcast.client.txn.proxy.ClientTxnMultiMapProxy;
import com.hazelcast.client.txn.proxy.ClientTxnProxy;
import com.hazelcast.client.txn.proxy.ClientTxnQueueProxy;
import com.hazelcast.client.txn.proxy.ClientTxnSetProxy;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.TransactionalList;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.core.TransactionalMultiMap;
import com.hazelcast.core.TransactionalQueue;
import com.hazelcast.core.TransactionalSet;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionNotActiveException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.transaction.impl.Transaction;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TransactionContextProxy
implements TransactionContext {
    final int CONNECTION_TRY_COUNT = 5;
    final HazelcastClient client;
    final TransactionProxy transaction;
    final Connection connection;
    private final Map<TransactionalObjectKey, TransactionalObject> txnObjectMap = new HashMap<TransactionalObjectKey, TransactionalObject>(2);

    public TransactionContextProxy(HazelcastClient client, TransactionOptions options) {
        this.client = client;
        this.connection = this.connect();
        if (this.connection == null) {
            throw new HazelcastException("Could not obtain Connection!!!");
        }
        this.transaction = new TransactionProxy(client, options, this.connection);
    }

    @Override
    public String getTxnId() {
        return this.transaction.getTxnId();
    }

    @Override
    public void beginTransaction() {
        this.transaction.begin();
    }

    @Override
    public void commitTransaction() throws TransactionException {
        this.transaction.commit();
    }

    @Override
    public void rollbackTransaction() {
        this.transaction.rollback();
    }

    @Override
    public <K, V> TransactionalMap<K, V> getMap(String name) {
        return (TransactionalMap)this.getTransactionalObject("hz:impl:mapService", name);
    }

    @Override
    public <E> TransactionalQueue<E> getQueue(String name) {
        return (TransactionalQueue)this.getTransactionalObject("hz:impl:queueService", name);
    }

    @Override
    public <K, V> TransactionalMultiMap<K, V> getMultiMap(String name) {
        return (TransactionalMultiMap)this.getTransactionalObject("hz:impl:multiMapService", name);
    }

    @Override
    public <E> TransactionalList<E> getList(String name) {
        return (TransactionalList)this.getTransactionalObject("hz:impl:listService", name);
    }

    @Override
    public <E> TransactionalSet<E> getSet(String name) {
        return (TransactionalSet)this.getTransactionalObject("hz:impl:setService", name);
    }

    @Override
    public <T extends TransactionalObject> T getTransactionalObject(String serviceName, String name) {
        if (this.transaction.getState() != Transaction.State.ACTIVE) {
            throw new TransactionNotActiveException("No transaction is found while accessing transactional object -> " + serviceName + "[" + name + "]!");
        }
        TransactionalObjectKey key = new TransactionalObjectKey(serviceName, name);
        ClientTxnProxy obj = this.txnObjectMap.get(key);
        if (obj == null) {
            if (serviceName.equals("hz:impl:queueService")) {
                obj = new ClientTxnQueueProxy(name, this);
            } else if (serviceName.equals("hz:impl:mapService")) {
                obj = new ClientTxnMapProxy(name, this);
            } else if (serviceName.equals("hz:impl:multiMapService")) {
                obj = new ClientTxnMultiMapProxy(name, this);
            } else if (serviceName.equals("hz:impl:listService")) {
                obj = new ClientTxnListProxy(name, this);
            } else if (serviceName.equals("hz:impl:setService")) {
                obj = new ClientTxnSetProxy(name, this);
            }
            if (obj == null) {
                throw new IllegalArgumentException("Service[" + serviceName + "] is not transactional!");
            }
            this.txnObjectMap.put(key, obj);
        }
        return (T)obj;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public HazelcastClient getClient() {
        return this.client;
    }

    private Connection connect() {
        Connection conn = null;
        for (int i = 0; i < 5; ++i) {
            try {
                conn = this.client.getConnectionManager().getRandomConnection();
            }
            catch (IOException e) {
                continue;
            }
            if (conn != null) break;
        }
        return conn;
    }

    private class TransactionalObjectKey {
        private final String serviceName;
        private final String name;

        TransactionalObjectKey(String serviceName, String name) {
            this.serviceName = serviceName;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TransactionalObjectKey)) {
                return false;
            }
            TransactionalObjectKey that = (TransactionalObjectKey)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return this.serviceName.equals(that.serviceName);
        }

        public int hashCode() {
            int result = this.serviceName.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }
}

