/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock;

import com.hazelcast.concurrent.lock.AwaitBackupOperation;
import com.hazelcast.concurrent.lock.BaseLockOperation;
import com.hazelcast.concurrent.lock.ConditionKey;
import com.hazelcast.concurrent.lock.LockStoreImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.WaitSupport;
import java.io.IOException;

public class AwaitOperation
extends BaseLockOperation
implements WaitSupport,
BackupAwareOperation {
    private String conditionId;
    private transient boolean firstRun = false;
    private transient boolean expired = false;

    public AwaitOperation() {
    }

    public AwaitOperation(ObjectNamespace namespace, Data key, int threadId, long timeout, String conditionId) {
        super(namespace, key, threadId, timeout);
        this.conditionId = conditionId;
    }

    @Override
    public void beforeRun() throws Exception {
        LockStoreImpl lockStore = this.getLockStore();
        this.firstRun = lockStore.startAwaiting(this.key, this.conditionId, this.getCallerUuid(), this.threadId);
    }

    @Override
    public void run() throws Exception {
        LockStoreImpl lockStore = this.getLockStore();
        if (!lockStore.lock(this.key, this.getCallerUuid(), this.threadId)) {
            throw new IllegalMonitorStateException("Current thread is not owner of the lock! -> " + lockStore.getOwnerInfo(this.key));
        }
        if (!this.expired) {
            lockStore.removeSignalKey(this.getWaitKey());
            lockStore.removeAwait(this.key, this.conditionId, this.getCallerUuid(), this.threadId);
            this.response = true;
        } else {
            this.response = false;
        }
    }

    @Override
    public ConditionKey getWaitKey() {
        return new ConditionKey(this.namespace.getObjectName(), this.key, this.conditionId);
    }

    @Override
    public boolean shouldWait() {
        boolean shouldWait = this.firstRun || !this.getLockStore().canAcquireLock(this.key, this.getCallerUuid(), this.threadId);
        this.firstRun = false;
        return shouldWait;
    }

    @Override
    public long getWaitTimeoutMillis() {
        return this.timeout;
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public Operation getBackupOperation() {
        return new AwaitBackupOperation(this.namespace, this.key, this.threadId, this.conditionId, this.getCallerUuid());
    }

    @Override
    public void onWaitExpire() {
        this.expired = true;
        LockStoreImpl lockStore = this.getLockStore();
        lockStore.removeSignalKey(this.getWaitKey());
        lockStore.removeAwait(this.key, this.conditionId, this.getCallerUuid(), this.threadId);
        if (lockStore.lock(this.key, this.getCallerUuid(), this.threadId)) {
            this.getResponseHandler().sendResponse(false);
        } else {
            lockStore.registerExpiredAwaitOp(this);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.conditionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.conditionId = in.readUTF();
    }
}

