/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.permission;

import com.hazelcast.security.permission.InstancePermission;

public class MapPermission
extends InstancePermission {
    private static final int PUT = 4;
    private static final int REMOVE = 8;
    private static final int READ = 22;
    private static final int LISTEN = 50;
    private static final int LOCK = 100;
    private static final int INDEX = 296;
    private static final int INTERCEPT = 598;
    private static final int ALL = 895;

    public MapPermission(String name, String ... actions) {
        super(name, actions);
    }

    @Override
    protected int initMask(String[] actions) {
        int mask = 0;
        for (int i = 0; i < actions.length; ++i) {
            if ("all".equals(actions[i])) {
                return 895;
            }
            if ("create".equals(actions[i])) {
                mask |= 1;
                continue;
            }
            if ("destroy".equals(actions[i])) {
                mask |= 2;
                continue;
            }
            if ("put".equals(actions[i])) {
                mask |= 4;
                continue;
            }
            if ("remove".equals(actions[i])) {
                mask |= 8;
                continue;
            }
            if ("read".equals(actions[i])) {
                mask |= 0x16;
                continue;
            }
            if ("listen".equals(actions[i])) {
                mask |= 0x32;
                continue;
            }
            if ("lock".equals(actions[i])) {
                mask |= 0x64;
                continue;
            }
            if ("index".equals(actions[i])) {
                mask |= 0x128;
                continue;
            }
            if (!"intercept".equals(actions[i])) continue;
            mask |= 0x256;
        }
        return mask;
    }
}

