/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.client;

import com.hazelcast.client.CallableClientRequest;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.InitializingObjectRequest;
import com.hazelcast.core.TransactionalQueue;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.queue.QueuePortableHook;
import com.hazelcast.transaction.TransactionContext;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class TxnPeekRequest
extends CallableClientRequest
implements Portable,
InitializingObjectRequest {
    private String name;
    private long timeout;

    public TxnPeekRequest() {
    }

    public TxnPeekRequest(String name, long timeout) {
        this.name = name;
        this.timeout = timeout;
    }

    public Object call() throws Exception {
        ClientEndpoint endpoint = this.getEndpoint();
        TransactionContext context = endpoint.getTransactionContext();
        TransactionalQueue queue = context.getQueue(this.name);
        return queue.peek(this.timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:queueService";
    }

    @Override
    public String getObjectName() {
        return this.name;
    }

    @Override
    public int getFactoryId() {
        return QueuePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 17;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeLong("t", this.timeout);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.timeout = reader.readLong("t");
    }
}

