/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomiclong.proxy;

import com.hazelcast.concurrent.atomiclong.AddAndGetOperation;
import com.hazelcast.concurrent.atomiclong.AtomicLongService;
import com.hazelcast.concurrent.atomiclong.CompareAndSetOperation;
import com.hazelcast.concurrent.atomiclong.GetAndAddOperation;
import com.hazelcast.concurrent.atomiclong.GetAndSetOperation;
import com.hazelcast.concurrent.atomiclong.SetOperation;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.Future;

public class AtomicLongProxy
extends AbstractDistributedObject<AtomicLongService>
implements IAtomicLong {
    private final String name;
    private final int partitionId;

    public AtomicLongProxy(String name, NodeEngine nodeEngine, AtomicLongService service) {
        super(nodeEngine, service);
        this.name = name;
        this.partitionId = nodeEngine.getPartitionService().getPartitionId(this.getNameAsPartitionAwareData());
    }

    @Override
    public long addAndGet(long delta) {
        try {
            AddAndGetOperation operation = new AddAndGetOperation(this.name, delta);
            Invocation inv = this.getNodeEngine().getOperationService().createInvocationBuilder("hz:impl:atomicLongService", (Operation)operation, this.partitionId).build();
            Future f = inv.invoke();
            return (Long)f.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public boolean compareAndSet(long expect, long update) {
        try {
            CompareAndSetOperation operation = new CompareAndSetOperation(this.name, expect, update);
            Invocation inv = this.getNodeEngine().getOperationService().createInvocationBuilder("hz:impl:atomicLongService", (Operation)operation, this.partitionId).build();
            Future f = inv.invoke();
            return (Boolean)f.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public void set(long newValue) {
        try {
            SetOperation operation = new SetOperation(this.name, newValue);
            Invocation inv = this.getNodeEngine().getOperationService().createInvocationBuilder("hz:impl:atomicLongService", (Operation)operation, this.partitionId).build();
            inv.invoke();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public long getAndSet(long newValue) {
        try {
            GetAndSetOperation operation = new GetAndSetOperation(this.name, newValue);
            Invocation inv = this.getNodeEngine().getOperationService().createInvocationBuilder("hz:impl:atomicLongService", (Operation)operation, this.partitionId).build();
            Future f = inv.invoke();
            return (Long)f.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public long getAndAdd(long delta) {
        try {
            GetAndAddOperation operation = new GetAndAddOperation(this.name, delta);
            Invocation inv = this.getNodeEngine().getOperationService().createInvocationBuilder("hz:impl:atomicLongService", (Operation)operation, this.partitionId).build();
            Future f = inv.invoke();
            return (Long)f.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public long decrementAndGet() {
        return this.addAndGet(-1L);
    }

    @Override
    public long get() {
        return this.getAndAdd(0L);
    }

    @Override
    public long incrementAndGet() {
        return this.addAndGet(1L);
    }

    @Override
    public long getAndIncrement() {
        return this.getAndAdd(1L);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:atomicLongService";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IAtomicLong{");
        sb.append("name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

