/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.AuthenticationRequest;
import com.hazelcast.client.ClientPrincipal;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.RetryableRequest;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.connection.Authenticator;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.Connection;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ResponseHandler;
import com.hazelcast.client.spi.ResponseStream;
import com.hazelcast.client.spi.impl.ClientPartitionServiceImpl;
import com.hazelcast.client.spi.impl.ResponseStreamImpl;
import com.hazelcast.client.util.AddressHelper;
import com.hazelcast.client.util.ErrorHandler;
import com.hazelcast.cluster.client.AddMembershipListenerRequest;
import com.hazelcast.cluster.client.ClientMembershipEvent;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.InitialMembershipEvent;
import com.hazelcast.core.InitialMembershipListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.security.Credentials;
import com.hazelcast.spi.impl.SerializableCollection;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class ClientClusterServiceImpl
implements ClientClusterService {
    private static final ILogger logger = Logger.getLogger(ClientClusterService.class);
    private static int RETRY_COUNT = 20;
    private static int RETRY_WAIT_TIME = 500;
    private final HazelcastClient client;
    private final ClusterListenerThread clusterThread;
    private final AtomicReference<Map<Address, MemberImpl>> membersRef = new AtomicReference();
    private final ConcurrentMap<String, MembershipListener> listeners = new ConcurrentHashMap<String, MembershipListener>();
    private final boolean redoOperation;
    private final Credentials credentials;
    private volatile ClientPrincipal principal;
    private volatile boolean active = false;
    private final ConnectionFactory randomConnectionFactory = new ConnectionFactory(){

        @Override
        public Connection create() throws IOException {
            return ClientClusterServiceImpl.this.getRandomConnection();
        }
    };

    public ClientClusterServiceImpl(HazelcastClient client) {
        this.client = client;
        this.clusterThread = new ClusterListenerThread(client.getThreadGroup(), client.getName() + ".cluster-listener");
        ClientConfig clientConfig = this.getClientConfig();
        this.redoOperation = clientConfig.isRedoOperation();
        this.credentials = clientConfig.getCredentials();
        List<ListenerConfig> listenerConfigs = client.getClientConfig().getListenerConfigs();
        if (listenerConfigs != null && !listenerConfigs.isEmpty()) {
            for (ListenerConfig listenerConfig : listenerConfigs) {
                EventListener listener = listenerConfig.getImplementation();
                if (listener == null) {
                    try {
                        listener = (EventListener)ClassLoaderUtil.newInstance(clientConfig.getClassLoader(), listenerConfig.getClassName());
                    }
                    catch (Exception e) {
                        logger.severe(e);
                    }
                }
                if (!(listener instanceof MembershipListener)) continue;
                this.addMembershipListener((MembershipListener)listener);
            }
        }
    }

    @Override
    public MemberImpl getMember(Address address) {
        Map<Address, MemberImpl> members = this.membersRef.get();
        return members != null ? members.get(address) : null;
    }

    @Override
    public MemberImpl getMember(String uuid) {
        Collection<MemberImpl> memberList = this.getMemberList();
        for (MemberImpl member : memberList) {
            if (!uuid.equals(member.getUuid())) continue;
            return member;
        }
        return null;
    }

    @Override
    public Collection<MemberImpl> getMemberList() {
        Map<Address, MemberImpl> members = this.membersRef.get();
        return members != null ? members.values() : Collections.emptySet();
    }

    @Override
    public Address getMasterAddress() {
        Collection<MemberImpl> memberList = this.getMemberList();
        return !memberList.isEmpty() ? memberList.iterator().next().getAddress() : null;
    }

    @Override
    public int getSize() {
        return this.getMemberList().size();
    }

    @Override
    public long getClusterTime() {
        return Clock.currentTimeMillis();
    }

    <T> T sendAndReceive(Object obj) throws IOException {
        return this._sendAndReceive(this.randomConnectionFactory, obj);
    }

    <T> T sendAndReceive(Address address, Object obj) throws IOException {
        return this._sendAndReceive(new TargetConnectionFactory(address), obj);
    }

    private <T> T _sendAndReceive(ConnectionFactory connectionFactory, Object obj) throws IOException {
        while (this.active) {
            Connection conn = null;
            boolean release = true;
            try {
                conn = connectionFactory.create();
                SerializationService serializationService = this.getSerializationService();
                Data request = serializationService.toData(obj);
                conn.write(request);
                Data response = conn.read();
                Object result = serializationService.toObject(response);
                Object t = ErrorHandler.returnResultOrThrowException(result);
                return t;
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    if (logger.isFinestEnabled()) {
                        logger.finest("Error on connection... conn: " + conn + ", error: " + e);
                    }
                    IOUtil.closeResource(conn);
                    release = false;
                }
                if (ErrorHandler.isRetryable(e) && (this.redoOperation || obj instanceof RetryableRequest)) {
                    if (logger.isFinestEnabled()) {
                        logger.finest("Retrying " + obj + ", last-conn: " + conn + ", last-error: " + e);
                    }
                    this.beforeRetry();
                    continue;
                }
                throw ExceptionUtil.rethrow(e, IOException.class);
            }
            finally {
                if (!release || conn == null) continue;
                conn.release();
            }
        }
        throw new HazelcastInstanceNotActiveException();
    }

    public <T> T sendAndReceiveFixedConnection(Connection conn, Object obj) throws IOException {
        SerializationService serializationService = this.getSerializationService();
        Data request = serializationService.toData(obj);
        conn.write(request);
        Data response = conn.read();
        Object result = serializationService.toObject(response);
        return ErrorHandler.returnResultOrThrowException(result);
    }

    private SerializationService getSerializationService() {
        return this.client.getSerializationService();
    }

    private ClientConnectionManager getConnectionManager() {
        return this.client.getConnectionManager();
    }

    private Connection getRandomConnection() throws IOException {
        return this.getConnection(null);
    }

    private Connection getConnection(Address address) throws IOException {
        if (!this.client.getLifecycleService().isRunning()) {
            throw new HazelcastInstanceNotActiveException();
        }
        Connection connection = null;
        int retryCount = RETRY_COUNT;
        while (connection == null && retryCount > 0) {
            if (address != null) {
                connection = this.client.getConnectionManager().getConnection(address);
                address = null;
            } else {
                connection = this.client.getConnectionManager().getRandomConnection();
            }
            if (connection != null) continue;
            --retryCount;
            this.beforeRetry();
        }
        if (connection == null) {
            throw new IOException("Unable to connect to " + address);
        }
        return connection;
    }

    private void beforeRetry() {
        try {
            Thread.sleep(RETRY_WAIT_TIME);
            ((ClientPartitionServiceImpl)this.client.getClientPartitionService()).refreshPartitions();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void sendAndHandle(Address address, Object obj, ResponseHandler handler) throws IOException {
        this._sendAndHandle(new TargetConnectionFactory(address), obj, handler);
    }

    void sendAndHandle(Object obj, ResponseHandler handler) throws IOException {
        this._sendAndHandle(this.randomConnectionFactory, obj, handler);
    }

    private void _sendAndHandle(ConnectionFactory connectionFactory, Object obj, ResponseHandler handler) throws IOException {
        ResponseStream stream = null;
        while (stream == null) {
            if (!this.active) {
                throw new HazelcastInstanceNotActiveException();
            }
            Connection conn = null;
            try {
                conn = connectionFactory.create();
                SerializationService serializationService = this.getSerializationService();
                Data request = serializationService.toData(obj);
                conn.write(request);
                stream = new ResponseStreamImpl(serializationService, conn);
            }
            catch (Exception e) {
                if (e instanceof IOException && logger.isFinestEnabled()) {
                    logger.finest("Error on connection... conn: " + conn + ", error: " + e);
                }
                if (conn != null) {
                    IOUtil.closeResource(conn);
                }
                if (ErrorHandler.isRetryable(e) && (this.redoOperation || obj instanceof RetryableRequest)) {
                    if (logger.isFinestEnabled()) {
                        logger.finest("Retrying " + obj + ", last-conn: " + conn + ", last-error: " + e);
                    }
                    this.beforeRetry();
                    continue;
                }
                throw ExceptionUtil.rethrow(e, IOException.class);
            }
        }
        try {
            handler.handle(stream);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e, IOException.class);
        }
        finally {
            stream.end();
        }
    }

    public Authenticator getAuthenticator() {
        return new ClusterAuthenticator();
    }

    public String addMembershipListener(MembershipListener listener) {
        String id = UUID.randomUUID().toString();
        if (listener instanceof InitialMembershipListener) {
            Cluster cluster = this.client.getCluster();
            ((InitialMembershipListener)listener).init(new InitialMembershipEvent(cluster, cluster.getMembers()));
        }
        this.listeners.put(id, listener);
        return id;
    }

    public boolean removeMembershipListener(String registrationId) {
        return this.listeners.remove(registrationId) != null;
    }

    public void start() {
        Future<Connection> f = this.client.getClientExecutionService().submit(new InitialConnectionCall());
        try {
            int connectionAttemptPeriodMs = this.client.getClientConfig().getConnectionAttemptPeriod();
            int connectionAttempts = this.client.getClientConfig().getConnectionAttemptLimit();
            long timeoutMs = (long)connectionAttempts * (long)connectionAttemptPeriodMs + 1000L;
            Connection connection = f.get(timeoutMs, TimeUnit.MILLISECONDS);
            this.clusterThread.setInitialConn(connection);
        }
        catch (Throwable e) {
            if (e instanceof ExecutionException && e.getCause() != null) {
                e = e.getCause();
                ExceptionUtil.fixRemoteStackTrace(e, Thread.currentThread().getStackTrace());
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new HazelcastException(e);
        }
        this.clusterThread.start();
        while (this.membersRef.get() == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new HazelcastException(e);
            }
        }
        this.active = true;
    }

    public void stop() {
        this.active = false;
        this.clusterThread.shutdown();
    }

    private Connection connectToOne(Collection<InetSocketAddress> socketAddresses) throws Exception {
        this.active = false;
        int connectionAttemptLimit = this.getClientConfig().getConnectionAttemptLimit();
        ManagerAuthenticator authenticator = new ManagerAuthenticator();
        int attempt = 0;
        Exception lastError = null;
        while (true) {
            long nextTry = Clock.currentTimeMillis() + (long)this.getClientConfig().getConnectionAttemptPeriod();
            for (InetSocketAddress isa : socketAddresses) {
                Address address = new Address(isa);
                try {
                    Connection connection = this.getConnectionManager().firstConnection(address, authenticator);
                    this.active = true;
                    return connection;
                }
                catch (IOException e) {
                    lastError = e;
                    logger.finest("IO error during initial connection...", e);
                }
                catch (AuthenticationException e) {
                    lastError = e;
                    logger.warning("Authentication error on " + address, e);
                }
            }
            if (attempt++ >= connectionAttemptLimit) break;
            long remainingTime = nextTry - Clock.currentTimeMillis();
            logger.warning(String.format("Unable to get alive cluster connection, try in %d ms later, attempt %d of %d.", Math.max(0L, remainingTime), attempt, connectionAttemptLimit));
            if (remainingTime <= 0L) continue;
            try {
                Thread.sleep(remainingTime);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        throw new IllegalStateException("Unable to connect to any address in the config!", lastError);
    }

    private Collection<InetSocketAddress> getConfigAddresses() {
        LinkedList<InetSocketAddress> socketAddresses = new LinkedList<InetSocketAddress>();
        for (String address : this.getClientConfig().getAddresses()) {
            socketAddresses.addAll(AddressHelper.getSocketAddresses(address));
        }
        Collections.shuffle(socketAddresses);
        return socketAddresses;
    }

    private ClientConfig getClientConfig() {
        return this.client.getClientConfig();
    }

    private Object authenticate(Connection connection, Credentials credentials, ClientPrincipal principal, boolean reAuth, boolean firstConnection) throws IOException {
        AuthenticationRequest auth = new AuthenticationRequest(credentials, principal);
        auth.setReAuth(reAuth);
        auth.setFirstConnection(firstConnection);
        SerializationService serializationService = this.getSerializationService();
        connection.write(serializationService.toData(auth));
        Data addressData = connection.read();
        Address address = (Address)ErrorHandler.returnResultOrThrowException(serializationService.toObject(addressData));
        connection.setEndpoint(address);
        Data data = connection.read();
        return ErrorHandler.returnResultOrThrowException(serializationService.toObject(data));
    }

    public String membersString() {
        StringBuilder sb = new StringBuilder("\n\nMembers [");
        Collection<MemberImpl> members = this.getMemberList();
        sb.append(members != null ? members.size() : 0);
        sb.append("] {");
        if (members != null) {
            for (Member member : members) {
                sb.append("\n\t").append(member);
            }
        }
        sb.append("\n}\n");
        return sb.toString();
    }

    private class ClusterAuthenticator
    implements Authenticator {
        private ClusterAuthenticator() {
        }

        @Override
        public void auth(Connection connection) throws AuthenticationException, IOException {
            ClientClusterServiceImpl.this.authenticate(connection, ClientClusterServiceImpl.this.credentials, ClientClusterServiceImpl.this.principal, false, false);
        }
    }

    private class ManagerAuthenticator
    implements Authenticator {
        private ManagerAuthenticator() {
        }

        @Override
        public void auth(Connection connection) throws AuthenticationException, IOException {
            Object response = ClientClusterServiceImpl.this.authenticate(connection, ClientClusterServiceImpl.this.credentials, ClientClusterServiceImpl.this.principal, true, true);
            ClientClusterServiceImpl.this.principal = (ClientPrincipal)response;
        }
    }

    private class ClusterListenerThread
    extends Thread {
        private volatile Connection conn;
        private final List<MemberImpl> members;

        private ClusterListenerThread(ThreadGroup group, String name) {
            super(group, name);
            this.members = new LinkedList<MemberImpl>();
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (this.conn == null) {
                        try {
                            this.conn = this.pickConnection();
                        }
                        catch (Exception e) {
                            logger.severe("Error while connecting to cluster!", e);
                            ClientClusterServiceImpl.this.client.getLifecycleService().shutdown();
                            return;
                        }
                    }
                    this.loadInitialMemberList();
                    this.listenMembershipEvents();
                }
                catch (Exception e) {
                    if (ClientClusterServiceImpl.this.client.getLifecycleService().isRunning()) {
                        if (logger.isFinestEnabled()) {
                            logger.warning("Error while listening cluster events! -> " + this.conn, e);
                        } else {
                            logger.warning("Error while listening cluster events! -> " + this.conn + ", Error: " + e.toString());
                        }
                    }
                    IOUtil.closeResource(this.conn);
                    this.conn = null;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        private Connection pickConnection() throws Exception {
            HashSet<InetSocketAddress> addresses = new HashSet<InetSocketAddress>();
            if (!this.members.isEmpty()) {
                addresses.addAll(this.getClusterAddresses());
            }
            addresses.addAll(ClientClusterServiceImpl.this.getConfigAddresses());
            return ClientClusterServiceImpl.this.connectToOne(addresses);
        }

        private void loadInitialMemberList() throws IOException {
            SerializationService serializationService = ClientClusterServiceImpl.this.getSerializationService();
            Data request = serializationService.toData(new AddMembershipListenerRequest());
            this.conn.write(request);
            Data response = this.conn.read();
            SerializableCollection coll = (SerializableCollection)ErrorHandler.returnResultOrThrowException(serializationService.toObject(response));
            Map<String, MemberImpl> prevMembers = Collections.emptyMap();
            if (!this.members.isEmpty()) {
                prevMembers = new HashMap(this.members.size());
                for (MemberImpl member : this.members) {
                    prevMembers.put(member.getUuid(), member);
                }
                this.members.clear();
            }
            for (Data d : coll.getCollection()) {
                this.members.add((MemberImpl)serializationService.toObject(d));
            }
            this.updateMembersRef();
            logger.info(ClientClusterServiceImpl.this.membersString());
            LinkedList<MembershipEvent> events = new LinkedList<MembershipEvent>();
            Set<Member> eventMembers = Collections.unmodifiableSet(new LinkedHashSet<MemberImpl>(this.members));
            for (MemberImpl member : this.members) {
                MemberImpl former = (MemberImpl)prevMembers.remove(member.getUuid());
                if (former != null) continue;
                events.add(new MembershipEvent(ClientClusterServiceImpl.this.client.getCluster(), member, 1, eventMembers));
            }
            for (MemberImpl member : prevMembers.values()) {
                events.add(new MembershipEvent(ClientClusterServiceImpl.this.client.getCluster(), member, 2, eventMembers));
            }
            for (MembershipEvent event : events) {
                this.fireMembershipEvent(event);
            }
        }

        private void listenMembershipEvents() throws IOException {
            SerializationService serializationService = ClientClusterServiceImpl.this.getSerializationService();
            while (!Thread.currentThread().isInterrupted()) {
                Data eventData = this.conn.read();
                ClientMembershipEvent event = (ClientMembershipEvent)serializationService.toObject(eventData);
                MemberImpl member = (MemberImpl)event.getMember();
                if (event.getEventType() == 1) {
                    this.members.add(member);
                } else {
                    this.members.remove(member);
                    ClientClusterServiceImpl.this.getConnectionManager().removeConnectionPool(member.getAddress());
                }
                this.updateMembersRef();
                logger.info(ClientClusterServiceImpl.this.membersString());
                this.fireMembershipEvent(new MembershipEvent(ClientClusterServiceImpl.this.client.getCluster(), member, event.getEventType(), Collections.unmodifiableSet(new LinkedHashSet<MemberImpl>(this.members))));
            }
        }

        private void fireMembershipEvent(final MembershipEvent event) {
            ClientClusterServiceImpl.this.client.getClientExecutionService().execute(new Runnable(){

                @Override
                public void run() {
                    for (MembershipListener listener : ClientClusterServiceImpl.this.listeners.values()) {
                        if (event.getEventType() == 1) {
                            listener.memberAdded(event);
                            continue;
                        }
                        listener.memberRemoved(event);
                    }
                }
            });
        }

        private void updateMembersRef() {
            LinkedHashMap<Address, MemberImpl> map = new LinkedHashMap<Address, MemberImpl>(this.members.size());
            for (MemberImpl member : this.members) {
                map.put(member.getAddress(), member);
            }
            ClientClusterServiceImpl.this.membersRef.set(Collections.unmodifiableMap(map));
        }

        private Collection<InetSocketAddress> getClusterAddresses() {
            LinkedList<InetSocketAddress> socketAddresses = new LinkedList<InetSocketAddress>();
            for (MemberImpl member : this.members) {
                socketAddresses.add(member.getInetSocketAddress());
            }
            Collections.shuffle(socketAddresses);
            return socketAddresses;
        }

        void setInitialConn(Connection conn) {
            this.conn = conn;
        }

        void shutdown() {
            this.interrupt();
            Connection c = this.conn;
            if (c != null) {
                try {
                    c.close();
                }
                catch (IOException e) {
                    logger.warning("Error while closing connection!", e);
                }
            }
        }
    }

    private class InitialConnectionCall
    implements Callable<Connection> {
        private InitialConnectionCall() {
        }

        @Override
        public Connection call() throws Exception {
            return ClientClusterServiceImpl.this.connectToOne(ClientClusterServiceImpl.this.getConfigAddresses());
        }
    }

    private class TargetConnectionFactory
    implements ConnectionFactory {
        final Address target;

        private TargetConnectionFactory(Address target) {
            this.target = target;
        }

        @Override
        public Connection create() throws IOException {
            return ClientClusterServiceImpl.this.getConnection(this.target);
        }
    }

    private static interface ConnectionFactory {
        public Connection create() throws IOException;
    }
}

