/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.client.AllPartitionsClientRequest;
import com.hazelcast.client.InitializingObjectRequest;
import com.hazelcast.map.MapEntrySet;
import com.hazelcast.map.MapPortableHook;
import com.hazelcast.map.MapService;
import com.hazelcast.map.operation.MapPutAllOperationFactory;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.OperationFactory;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class MapPutAllRequest
extends AllPartitionsClientRequest
implements Portable,
InitializingObjectRequest {
    protected String name;
    private MapEntrySet entrySet;

    public MapPutAllRequest() {
    }

    public MapPutAllRequest(String name, MapEntrySet entrySet) {
        this.name = name;
        this.entrySet = entrySet;
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 40;
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new MapPutAllOperationFactory(this.name, this.entrySet);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        MapEntrySet resultSet = new MapEntrySet();
        MapService mapService = (MapService)this.getService();
        for (Map.Entry<Integer, Object> entry : map.entrySet()) {
            MapEntrySet mapEntrySet = (MapEntrySet)mapService.toObject(entry.getValue());
            Set<Map.Entry<Data, Data>> set = mapEntrySet.getEntrySet();
            for (Map.Entry<Data, Data> dataEntry : set) {
                resultSet.add(dataEntry);
            }
        }
        return resultSet;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Object getObjectId() {
        return this.name;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        ObjectDataOutput output = writer.getRawDataOutput();
        this.entrySet.writeData(output);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        ObjectDataInput input = reader.getRawDataInput();
        this.entrySet = new MapEntrySet();
        this.entrySet.readData(input);
    }
}

