/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ThreadWatcher;
import java.io.IOException;
import java.nio.channels.Selector;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class InOutSelector
implements Runnable {
    protected final ILogger logger;
    protected final Selector selector;
    protected final Queue<Runnable> selectorQueue = new ConcurrentLinkedQueue<Runnable>();
    protected final ConnectionManager connectionManager;
    private final int waitTime;
    protected boolean live = true;
    protected final ThreadWatcher threadWatcher = new ThreadWatcher();
    static final long TEN_SECOND_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    private long lastPublish = 0L;

    public InOutSelector(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.logger = connectionManager.ioService.getLogger(this.getClass().getName());
        this.waitTime = 500;
        Selector selectorTemp = null;
        try {
            selectorTemp = Selector.open();
        }
        catch (IOException e) {
            this.handleSelectorException(e);
        }
        this.selector = selectorTemp;
        this.live = true;
    }

    public void shutdown() {
        this.selectorQueue.clear();
        try {
            final CountDownLatch l = new CountDownLatch(1);
            this.addTask(new Runnable(){

                public void run() {
                    InOutSelector.this.live = false;
                    InOutSelector.this.threadLocalShutdown();
                    l.countDown();
                }
            });
            l.await(5L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void threadLocalShutdown() {
    }

    public void addTask(Runnable runnable) {
        this.selectorQueue.offer(runnable);
    }

    private void processSelectionQueue() {
        while (this.live) {
            Runnable runnable = this.selectorQueue.poll();
            if (runnable == null) {
                return;
            }
            runnable.run();
        }
    }

    public void publishUtilization() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run() {
        block26: {
            block25: {
                block23: {
                    try {
                        try {
                            this.connectionManager.ioService.onIOThreadStart();
                            while (this.live) {
                                block24: {
                                    this.threadWatcher.incrementRunCount();
                                    currentMillis = Clock.currentTimeMillis();
                                    if (currentMillis - this.lastPublish > InOutSelector.TEN_SECOND_MILLIS) {
                                        this.publishUtilization();
                                        this.lastPublish = currentMillis;
                                    }
                                    this.processSelectionQueue();
                                    if (!this.live) {
                                        var9_13 = null;
                                        break block23;
                                    }
                                    try {
                                        startWait = System.nanoTime();
                                        selectedKeyCount = this.selector.select(this.waitTime);
                                        now = System.nanoTime();
                                        this.threadWatcher.addWait(now - startWait, now);
                                        if (!Thread.interrupted()) break block24;
                                        this.connectionManager.ioService.handleInterruptedException(Thread.currentThread(), new RuntimeException());
                                        break block25;
                                    }
                                    catch (Throwable exp) {
                                        continue;
                                    }
                                }
                                if (selectedKeyCount == 0) continue;
                                setSelectedKeys = this.selector.selectedKeys();
                                it = setSelectedKeys.iterator();
                                while (it.hasNext()) {
                                    sk = it.next();
                                    try {
                                        it.remove();
                                        if (sk.isValid() && sk.isReadable()) {
                                            connection = (Connection)sk.attachment();
                                            connection.getReadHandler().handle();
                                        }
                                        if (!sk.isValid() || !sk.isWritable()) continue;
                                        sk.interestOps(sk.interestOps() & -5);
                                        connection = (Connection)sk.attachment();
                                        connection.getWriteHandler().handle();
                                    }
                                    catch (Throwable e) {
                                        this.handleSelectorException(e);
                                    }
                                }
                            }
                            break block26;
                        }
                        catch (OutOfMemoryError e) {
                            this.connectionManager.ioService.onOutOfMemory(e);
                            var9_16 = null;
                            try {
                                this.logger.log(Level.FINEST, "closing selector " + Thread.currentThread().getName());
                                this.selector.close();
                                return;
                            }
                            catch (Exception ignored) {
                                return;
                            }
                        }
                        catch (Throwable e) {
                            this.logger.log(Level.WARNING, "unhandled exception in " + Thread.currentThread().getName(), e);
                            var9_17 = null;
                            try {}
                            catch (Exception ignored) {
                                return;
                            }
                            this.logger.log(Level.FINEST, "closing selector " + Thread.currentThread().getName());
                            this.selector.close();
                            return;
                        }
                    }
                    catch (Throwable var8_25) {
                        var9_18 = null;
                        ** try [egrp 4[TRYBLOCK] [14 : 378->424)] { 
lbl72:
                        // 1 sources

                        this.logger.log(Level.FINEST, "closing selector " + Thread.currentThread().getName());
                        this.selector.close();
                        throw var8_25;
lbl75:
                        // 1 sources

                        catch (Exception ignored) {
                            // empty catch block
                        }
                        throw var8_25;
                    }
                }
                ** try [egrp 4[TRYBLOCK] [14 : 378->424)] { 
lbl80:
                // 1 sources

                this.logger.log(Level.FINEST, "closing selector " + Thread.currentThread().getName());
                this.selector.close();
                return;
lbl83:
                // 1 sources

                catch (Exception ignored) {
                    // empty catch block
                }
                return;
            }
            var9_14 = null;
            try {}
            catch (Exception ignored) {
                // empty catch block
                return;
            }
            this.logger.log(Level.FINEST, "closing selector " + Thread.currentThread().getName());
            this.selector.close();
            return;
        }
        var9_15 = null;
        try {}
        catch (Exception ignored) {}
        this.logger.log(Level.FINEST, "closing selector " + Thread.currentThread().getName());
        this.selector.close();
        return;
    }

    protected void handleSelectorException(Throwable e) {
        String msg = "Selector exception at  " + Thread.currentThread().getName() + ", cause= " + e.toString();
        this.logger.log(Level.WARNING, msg, e);
        if (e instanceof OutOfMemoryError) {
            this.connectionManager.ioService.onOutOfMemory((OutOfMemoryError)e);
        }
    }
}

