/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.monitor;

import com.hazelcast.monitor.LocalInstanceOperationStats;
import com.hazelcast.util.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class OperationsCounterSupport<T extends LocalInstanceOperationStats> {
    final long interval;
    final Object lock = new Object();
    long startTime = this.now();
    long endTime = Long.MAX_VALUE;
    volatile transient T published = null;
    final List listOfSubCounters = new ArrayList();

    public OperationsCounterSupport() {
        this(5000L);
    }

    public OperationsCounterSupport(long interval) {
        this.interval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T getPublishedStats() {
        if (this.published == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.published == null) {
                    this.published = this.getThis();
                }
            }
        }
        if (this.published.getPeriodEnd() < this.now() - this.interval) {
            return this.getEmpty();
        }
        return this.published;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void publishSubResult() {
        long subInterval = this.interval / 5L;
        if (this.now() - this.startTime > subInterval) {
            Object object = this.lock;
            synchronized (object) {
                if (this.now() - this.startTime >= subInterval) {
                    OperationsCounterSupport<T> copy = this.getAndReset();
                    if (this.listOfSubCounters.size() == 5) {
                        this.listOfSubCounters.remove(0);
                    }
                    this.listOfSubCounters.add(copy);
                    this.published = this.aggregateSubCounterStats();
                }
            }
        }
    }

    abstract T getThis();

    abstract T getEmpty();

    abstract OperationsCounterSupport<T> getAndReset();

    abstract T aggregateSubCounterStats();

    final long now() {
        return Clock.currentTimeMillis();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class OperationCounter {
        final AtomicLong count;
        final AtomicLong totalLatency;

        public OperationCounter() {
            this(0L, 0L);
        }

        public OperationCounter(long c, long l) {
            this.count = new AtomicLong(c);
            this.totalLatency = new AtomicLong(l);
        }

        public OperationCounter copyAndReset() {
            OperationCounter copy = new OperationCounter(this.count.get(), this.totalLatency.get());
            this.count.set(0L);
            this.totalLatency.set(0L);
            return copy;
        }

        public void set(OperationCounter now) {
            this.count.set(now.count.get());
            this.totalLatency.set(now.totalLatency.get());
        }

        public void count(long elapsed) {
            this.count.incrementAndGet();
            this.totalLatency.addAndGet(elapsed);
        }

        public String toString() {
            long count = this.count.get();
            return "OperationStat{count=" + count + ", averageLatency=" + (count == 0L ? 0L : this.totalLatency.get() / count) + '}';
        }
    }
}

