/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.region;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.HazelcastTimestamper;
import com.hazelcast.hibernate.RegionCache;
import com.hazelcast.hibernate.region.HazelcastRegion;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cache.CacheException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractHazelcastRegion<Cache extends RegionCache>
implements HazelcastRegion<Cache> {
    private final HazelcastInstance instance;
    private final String regionName;
    private final int timeout;
    protected final Properties props;

    protected AbstractHazelcastRegion(HazelcastInstance instance, String regionName, Properties props) {
        this.instance = instance;
        this.regionName = regionName;
        this.timeout = HazelcastTimestamper.getTimeout(instance, regionName);
        this.props = props;
    }

    public void destroy() throws CacheException {
    }

    public long getElementCountInMemory() {
        return this.getCache().size();
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public String getName() {
        return this.regionName;
    }

    public long getSizeInMemory() {
        return this.getCache().getSizeInMemory();
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final long nextTimestamp() {
        return HazelcastTimestamper.nextTimestamp(this.instance);
    }

    public Map toMap() {
        return this.getCache().asMap();
    }

    public boolean contains(Object key) {
        return this.getCache().contains(key);
    }

    @Override
    public final HazelcastInstance getInstance() {
        return this.instance;
    }

    @Override
    public final ILogger getLogger() {
        String name = this.getClass().getName();
        try {
            return this.instance.getLoggingService().getLogger(name);
        }
        catch (UnsupportedOperationException e) {
            return Logger.getLogger(name);
        }
    }
}

