/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

import com.hazelcast.impl.Util;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Installer {
    protected static final Logger logger = Logger.getLogger(Installer.class.getName());
    private static final boolean DEBUG = false;
    private String clusteredFilePrefix = "clustered-";
    private boolean addHazelcastLib = true;
    private boolean replaceOld = false;
    private boolean appsSharingSessions = false;
    private String version = "1.9.4";
    private String libDir = "../lib/";

    public static void main(String[] args) {
        Installer installer = new Installer();
        installer.install(args);
    }

    public Document createDocument(InputStream in) {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    public String getClusteredFilePrefix() {
        return this.clusteredFilePrefix;
    }

    public boolean isAddHazelcastLib() {
        return this.addHazelcastLib;
    }

    public boolean isAppsSharingSessions() {
        return this.appsSharingSessions;
    }

    public boolean isReplaceOld() {
        return this.replaceOld;
    }

    public final void modify(File src, File dest) {
        try {
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(dest)));
            ZipFile zipFile = new ZipFile(src);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            String jarLocation = null;
            if (src.getName().endsWith("war")) {
                jarLocation = "WEB-INF/lib/";
            }
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                this.log("entry name " + entry.getName());
                out.putNextEntry(new ZipEntry(entry.getName()));
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                if (jarLocation == null && name.endsWith(".jar")) {
                    int slashIndex = name.lastIndexOf(47);
                    jarLocation = slashIndex == -1 ? "" : name.substring(0, slashIndex) + "/";
                }
                InputStream in = zipFile.getInputStream(entry);
                if (name.endsWith(".war")) {
                    this.modifyWar(in, out);
                } else if (name.equals("WEB-INF/web.xml")) {
                    this.readModifyWrite(in, out);
                } else {
                    Util.copyStream(in, out);
                }
                in.close();
            }
            if (jarLocation == null) {
                jarLocation = "";
            }
            if (this.isAddHazelcastLib()) {
                this.log("Jar Location " + jarLocation);
                String hazelcastJarName = "hazelcast-" + this.version + ".jar";
                String hazelcastWMJarName = "hazelcast-wm-" + this.version + ".jar";
                this.addFileToZipStream(this.libDir + hazelcastJarName, jarLocation + hazelcastJarName, out);
                this.addFileToZipStream(this.libDir + hazelcastWMJarName, jarLocation + hazelcastWMJarName, out);
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void addFileToZipStream(String fileName, String zipFilePath, ZipOutputStream out) throws Exception {
        ZipEntry hazelcastZip = new ZipEntry(zipFilePath);
        out.putNextEntry(hazelcastZip);
        FileInputStream in = new FileInputStream(fileName);
        Util.copyStream(in, out);
        ((InputStream)in).close();
    }

    public Document modifyWebXml(Document doc) {
        Node first;
        Element docElement = doc.getDocumentElement();
        NodeList nodelist = docElement.getChildNodes();
        ArrayList<String> lsListeners = new ArrayList<String>();
        Node firstFilter = null;
        Node displayElement = null;
        Node afterDisplayElement = null;
        int sessionTimeoutDefault = -23490375;
        int sessionTimeout = -23490375;
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node node = nodelist.item(i);
            String name = node.getNodeName();
            if ("display-name".equals(name)) {
                displayElement = node;
                continue;
            }
            if ("listener".equals(name)) {
                String className = null;
                NodeList nl = node.getChildNodes();
                for (int a = 0; a < nl.getLength(); ++a) {
                    Node n = nl.item(a);
                    if (!n.getNodeName().equals("listener-class")) continue;
                    className = n.getTextContent();
                }
                lsListeners.add(className);
                docElement.removeChild(node);
            } else if ("filter".equals(name)) {
                if (firstFilter == null) {
                    firstFilter = node;
                }
            } else if ("session-config".equals(name)) {
                NodeList nl = node.getChildNodes();
                for (int a = 0; a < nl.getLength(); ++a) {
                    Node n = nl.item(a);
                    if (!n.getNodeName().equals("session-timeout")) continue;
                    try {
                        sessionTimeout = Integer.parseInt(n.getTextContent().trim());
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (displayElement == null || afterDisplayElement != null) continue;
            afterDisplayElement = node;
        }
        Element filter = doc.createElement("filter");
        this.append(doc, filter, "filter-name", "hazel-filter");
        this.append(doc, filter, "filter-class", "com.hazelcast.web.WebFilter");
        Node initParam = this.append(doc, filter, "init-param", null);
        this.append(doc, initParam, "param-name", "apps-sharing-sessions");
        this.append(doc, initParam, "param-value", String.valueOf(this.appsSharingSessions));
        if (sessionTimeout != -23490375) {
            initParam = this.append(doc, filter, "init-param", null);
            this.append(doc, initParam, "param-name", "session-timeout");
            this.append(doc, initParam, "param-value", "" + sessionTimeout);
        }
        if ((first = firstFilter) == null && afterDisplayElement != null) {
            first = afterDisplayElement;
        }
        if (first == null) {
            first = docElement.getFirstChild();
        }
        docElement.insertBefore(filter, first);
        Element filterMapping = doc.createElement("filter-mapping");
        this.append(doc, filterMapping, "filter-name", "hazel-filter");
        this.append(doc, filterMapping, "url-pattern", "/*");
        this.append(doc, filterMapping, "dispatcher", "FORWARD");
        this.append(doc, filterMapping, "dispatcher", "INCLUDE");
        this.append(doc, filterMapping, "dispatcher", "REQUEST");
        Element contextListener = doc.createElement("listener");
        this.append(doc, contextListener, "listener-class", "com.hazelcast.web.WebFilter$ContextListener");
        docElement.insertBefore(filterMapping, this.after(docElement, "filter"));
        docElement.insertBefore(contextListener, this.after(docElement, "filter-mapping"));
        return doc;
    }

    public void readModifyWrite(InputStream in, OutputStream out) {
        Document finalDoc = this.modifyWebXml(this.createDocument(in));
        Util.streamXML(finalDoc, out);
    }

    public void setAddHazelcastLib(boolean addHazelcastLib) {
        this.addHazelcastLib = addHazelcastLib;
    }

    public void setAppsSharingSessions(boolean appsSharingSessions) {
        this.appsSharingSessions = appsSharingSessions;
    }

    public void setClusteredFilePrefix(String clusteredFilePrefix) {
        this.clusteredFilePrefix = clusteredFilePrefix;
    }

    public void setReplaceOld(boolean replaceOld) {
        this.replaceOld = replaceOld;
    }

    public final void unzip(File file) {
        String warFilename = file.getName();
        String destDirName = warFilename.substring(0, warFilename.lastIndexOf(46));
        File destDir = new File(destDirName);
        destDir.mkdirs();
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    new File(destDir, entry.getName()).mkdir();
                    continue;
                }
                File entryFile = new File(destDir, entry.getName());
                InputStream in = zipFile.getInputStream(entry);
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(entryFile));
                Util.copyStream(in, out);
                in.close();
                ((OutputStream)out).close();
            }
            zipFile.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private Node after(Node parent, String nodeName) {
        NodeList nodelist = parent.getChildNodes();
        int index = -1;
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node node = nodelist.item(i);
            String name = node.getNodeName();
            if (!nodeName.equals(name)) continue;
            index = i;
        }
        if (index == -1) {
            return null;
        }
        if (nodelist.getLength() > index + 1) {
            return nodelist.item(index + 1);
        }
        return null;
    }

    private Node append(Document doc, Node parent, String element, String value) {
        Element child = doc.createElement(element);
        if (value != null) {
            child.setTextContent(value);
        }
        parent.appendChild(child);
        return child;
    }

    private void install(String[] args) {
        if (args == null || args.length == 0) {
            this.print("No application is specified!");
            this.printHelp();
        }
        HashSet<String> setApps = new HashSet<String>();
        if (args != null) {
            for (String arg : args) {
                if (arg.startsWith("-")) {
                    if (arg.equals("-apps-sharing-sessions")) {
                        this.appsSharingSessions = true;
                        this.addHazelcastLib = false;
                        continue;
                    }
                    if (arg.startsWith("-version")) {
                        this.version = arg.substring(arg.indexOf("-version") + "-version".length());
                        continue;
                    }
                    if (arg.startsWith("-libDir")) {
                        this.libDir = arg.substring(arg.indexOf("-libDir") + "-libDir".length());
                        continue;
                    }
                    if (!arg.startsWith("-excludeJar")) continue;
                    this.addHazelcastLib = false;
                    continue;
                }
                setApps.add(arg);
            }
        }
        for (String appFilename : setApps) {
            this.processApp(appFilename);
        }
        logger.log(Level.INFO, "Done!");
    }

    private void log(Object obj) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyWar(InputStream in, OutputStream os) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream out = new ZipOutputStream(bos);
        ZipInputStream zin = new ZipInputStream(in);
        try {
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                out.putNextEntry(new ZipEntry(entry.getName()));
                this.log("war file " + entry.getName());
                if (entry.isDirectory()) continue;
                if (entry.getName().equals("WEB-INF/web.xml")) {
                    ByteArrayOutputStream bosWebXml = new ByteArrayOutputStream();
                    Util.copyStream(zin, bosWebXml);
                    bosWebXml.flush();
                    byte[] webxmlBytes = bosWebXml.toByteArray();
                    bosWebXml.close();
                    ByteArrayInputStream binWebXml = new ByteArrayInputStream(webxmlBytes);
                    this.readModifyWrite(binWebXml, out);
                    binWebXml.close();
                } else {
                    Util.copyStream(zin, out);
                }
                out.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                out.flush();
                out.close();
                bos.writeTo(os);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void print(Object obj) {
        logger.log(Level.INFO, obj.toString());
    }

    private void printHelp() {
        this.print("clusterWebapp.bat <war-file-path or ear-file-path>");
    }

    private void processApp(String appFilename) {
        boolean success;
        File file = new File(appFilename);
        String clusteredFileName = this.clusteredFilePrefix + file.getName();
        File fileOriginal = new File(file.getParentFile(), clusteredFileName);
        this.modify(file, fileOriginal);
        if (this.isReplaceOld() && (success = file.renameTo(fileOriginal))) {
            logger.log(Level.INFO, "old Application File was replaced!");
        }
        logger.log(Level.INFO, "Done. New clustered application at " + fileOriginal.getAbsolutePath());
    }
}

