/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.config.AsymmetricEncryptionConfig;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.Interfaces;
import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.config.Join;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.MemberGroupConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.PermissionConfig;
import com.hazelcast.config.PermissionPolicyConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.config.WanTargetClusterConfig;
import com.hazelcast.spring.AbstractHazelcastBeanDefinitionParser;
import com.hazelcast.spring.context.SpringManagedContext;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HazelcastConfigBeanDefinitionParser
extends AbstractHazelcastBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlConfigBuilder springXmlConfigBuilder = new SpringXmlConfigBuilder(parserContext);
        springXmlConfigBuilder.handleConfig(element);
        return springXmlConfigBuilder.getBeanDefinition();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SpringXmlConfigBuilder
    extends AbstractHazelcastBeanDefinitionParser.SpringXmlBuilderHelper {
        private final ParserContext parserContext;
        private BeanDefinitionBuilder configBuilder;
        private ManagedMap mapConfigManagedMap;
        private ManagedMap queueManagedMap;
        private ManagedMap topicManagedMap;
        private ManagedMap multiMapManagedMap;
        private ManagedMap executorManagedMap;
        private ManagedMap wanReplicationManagedMap;
        private ManagedMap mergePolicyConfigMap;

        public SpringXmlConfigBuilder(ParserContext parserContext) {
            this.parserContext = parserContext;
            this.configBuilder = BeanDefinitionBuilder.rootBeanDefinition(Config.class);
            this.mapConfigManagedMap = new ManagedMap();
            this.queueManagedMap = new ManagedMap();
            this.topicManagedMap = new ManagedMap();
            this.multiMapManagedMap = new ManagedMap();
            this.executorManagedMap = new ManagedMap();
            this.wanReplicationManagedMap = new ManagedMap();
            this.mergePolicyConfigMap = new ManagedMap();
            this.configBuilder.addPropertyValue("mapConfigs", (Object)this.mapConfigManagedMap);
            this.configBuilder.addPropertyValue("QConfigs", (Object)this.queueManagedMap);
            this.configBuilder.addPropertyValue("topicConfigs", (Object)this.topicManagedMap);
            this.configBuilder.addPropertyValue("multiMapConfigs", (Object)this.multiMapManagedMap);
            this.configBuilder.addPropertyValue("executorConfigMap", (Object)this.executorManagedMap);
            this.configBuilder.addPropertyValue("wanReplicationConfigs", (Object)this.wanReplicationManagedMap);
            this.configBuilder.addPropertyValue("mergePolicyConfigs", (Object)this.mergePolicyConfigMap);
            BeanDefinitionBuilder managedContextBeanBuilder = this.createBeanBuilder(SpringManagedContext.class);
            this.configBuilder.addPropertyValue("managedContext", (Object)managedContextBeanBuilder.getBeanDefinition());
        }

        public AbstractBeanDefinition getBeanDefinition() {
            return this.configBuilder.getBeanDefinition();
        }

        protected BeanDefinitionBuilder createBeanBuilder(Class clazz) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((Class)clazz);
            builder.setScope(this.configBuilder.getBeanDefinition().getScope());
            builder.setLazyInit(this.configBuilder.getBeanDefinition().isLazyInit());
            return builder;
        }

        protected BeanDefinitionBuilder createAndFillBeanBuilder(Node node, Class clazz, String propertyName, BeanDefinitionBuilder parent, String ... exceptPropertyNames) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(clazz);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            this.fillValues(node, builder, exceptPropertyNames);
            parent.addPropertyValue(propertyName, (Object)beanDefinition);
            return builder;
        }

        protected void createAndFillListedBean(Node node, Class clazz, String propertyName, ManagedMap managedMap) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(clazz);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getValue(attName);
            builder.addPropertyValue("name", (Object)name);
            this.fillValues(node, builder, new String[0]);
            managedMap.put((Object)name, (Object)beanDefinition);
        }

        protected void fillValues(Node node, BeanDefinitionBuilder builder, String ... excludeNames) {
            HashSet<String> epn = excludeNames != null && excludeNames.length > 0 ? new HashSet<String>(Arrays.asList(excludeNames)) : null;
            this.fillAttributeValues(node, builder, (Collection<String>)epn);
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String name = this.xmlToJavaName(this.cleanNodeName(n));
                if (epn != null && epn.contains(name)) continue;
                String value = this.getValue(n);
                builder.addPropertyValue(name, (Object)value);
            }
        }

        private void fillAttributeValues(Node node, BeanDefinitionBuilder builder, String ... excludeNames) {
            HashSet<String> epn = excludeNames != null && excludeNames.length > 0 ? new HashSet<String>(Arrays.asList(excludeNames)) : null;
            this.fillAttributeValues(node, builder, (Collection<String>)epn);
        }

        private void fillAttributeValues(Node node, BeanDefinitionBuilder builder, Collection<String> epn) {
            NamedNodeMap atts = node.getAttributes();
            if (atts != null) {
                for (int a = 0; a < atts.getLength(); ++a) {
                    Node att = atts.item(a);
                    String name = this.xmlToJavaName(att.getNodeName());
                    if (epn != null && epn.contains(name)) continue;
                    String value = att.getNodeValue();
                    builder.addPropertyValue(name, (Object)value);
                }
            }
        }

        public void handleConfig(Element element) {
            this.handleCommonBeanAttributes(element, this.configBuilder, this.parserContext);
            for (Node node : new AbstractXmlConfigHelper.IterableNodeList(element, 1)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(node.getNodeName());
                if ("network".equals(nodeName)) {
                    this.handleNetwork(node);
                    continue;
                }
                if ("group".equals(nodeName)) {
                    this.handleGroup(node);
                    continue;
                }
                if ("properties".equals(nodeName)) {
                    this.handleProperties(node);
                    continue;
                }
                if ("executor-service".equals(nodeName)) {
                    this.handleExecutor(node);
                    continue;
                }
                if ("queue".equals(nodeName)) {
                    this.handleQueue(node);
                    continue;
                }
                if ("map".equals(nodeName)) {
                    this.handleMap(node);
                    continue;
                }
                if ("multimap".equals(nodeName)) {
                    this.handleMultiMap(node);
                    continue;
                }
                if ("topic".equals(nodeName)) {
                    this.handleTopic(node);
                    continue;
                }
                if ("merge-policies".equals(nodeName)) {
                    this.handleMergePolicies(node);
                    continue;
                }
                if ("wan-replication".equals(nodeName)) {
                    this.handleWanReplication(node);
                    continue;
                }
                if ("partition-group".equals(nodeName)) {
                    this.handlePartitionGroup(node);
                    continue;
                }
                if ("security".equals(nodeName)) {
                    this.handleSecurity(node);
                    continue;
                }
                if ("instance-name".equals(nodeName)) {
                    this.configBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getValue(node));
                    continue;
                }
                if ("listeners".equals(nodeName)) {
                    ManagedList listeners = this.parseListeners(node, ListenerConfig.class);
                    this.configBuilder.addPropertyValue("listenerConfigs", (Object)listeners);
                    continue;
                }
                if ("lite-member".equals(nodeName)) {
                    this.configBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getValue(node));
                    continue;
                }
                if ("license-key".equals(nodeName)) {
                    this.configBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getValue(node));
                    continue;
                }
                if (!"management-center".equals(nodeName)) continue;
                this.handleManagementCenter(node);
            }
        }

        public void handleNetwork(Node node) {
            BeanDefinitionBuilder networkConfigBuilder = this.createBeanBuilder(NetworkConfig.class);
            AbstractBeanDefinition beanDefinition = networkConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, this.configBuilder, new String[0]);
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String nodeName = this.cleanNodeName(child);
                if ("join".equals(nodeName)) {
                    this.handleJoin(child, networkConfigBuilder);
                    continue;
                }
                if ("interfaces".equals(nodeName)) {
                    this.handleInterfaces(child, networkConfigBuilder);
                    continue;
                }
                if ("symmetric-encryption".equals(nodeName)) {
                    this.handleSymmetricEncryption(child, networkConfigBuilder);
                    continue;
                }
                if ("asymmetric-encryption".equals(nodeName)) {
                    this.handleAsymmetricEncryption(child, networkConfigBuilder);
                    continue;
                }
                if ("ssl".equals(nodeName)) {
                    this.handleSSLConfig(child, networkConfigBuilder);
                    continue;
                }
                if (!"socket-interceptor".equals(nodeName)) continue;
                this.handleSocketInterceptorConfig(child, networkConfigBuilder);
            }
            this.configBuilder.addPropertyValue("networkConfig", (Object)beanDefinition);
        }

        protected void handleViaReflection(Node child) {
            Method method;
            String methodName = this.xmlToJavaName("handle-" + this.cleanNodeName(child));
            try {
                method = this.getClass().getMethod(methodName, Node.class);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                return;
            }
            try {
                method.invoke((Object)this, child);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void handleGroup(Node node) {
            this.createAndFillBeanBuilder(node, GroupConfig.class, "groupConfig", this.configBuilder, new String[0]);
        }

        public void handleProperties(Node node) {
            this.handleProperties(node, this.configBuilder);
        }

        public void handleInterfaces(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(Interfaces.class);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            NamedNodeMap atts = node.getAttributes();
            if (atts != null) {
                for (int a = 0; a < atts.getLength(); ++a) {
                    Node att = atts.item(a);
                    String name = this.xmlToJavaName(att.getNodeName());
                    String value = att.getNodeValue();
                    builder.addPropertyValue(name, (Object)value);
                }
            }
            ManagedList interfacesSet = new ManagedList();
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String name = this.xmlToJavaName(this.cleanNodeName(n));
                String value = this.getValue(n);
                if (!"interface".equals(name)) continue;
                interfacesSet.add((Object)value);
            }
            builder.addPropertyValue("interfaces", (Object)interfacesSet);
            networkConfigBuilder.addPropertyValue("interfaces", (Object)beanDefinition);
        }

        public void handleJoin(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder joinConfigBuilder = this.createBeanBuilder(Join.class);
            AbstractBeanDefinition beanDefinition = joinConfigBuilder.getBeanDefinition();
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String name = this.cleanNodeName(child);
                if ("multicast".equals(name)) {
                    this.handleMulticast(child, joinConfigBuilder);
                    continue;
                }
                if ("tcp-ip".equals(name)) {
                    this.handleTcpIp(child, joinConfigBuilder);
                    continue;
                }
                if (!"aws".equals(name)) continue;
                this.handleAws(child, joinConfigBuilder);
            }
            networkConfigBuilder.addPropertyValue("join", (Object)beanDefinition);
        }

        private void handleSocketInterceptorConfig(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            String implementation;
            BeanDefinitionBuilder socketInterceptorConfigBuilder = this.createBeanBuilder(SocketInterceptorConfig.class);
            String implAttribute = "implementation";
            this.fillAttributeValues(node, socketInterceptorConfigBuilder, "implementation");
            Node implNode = node.getAttributes().getNamedItem("implementation");
            String string = implementation = implNode != null ? this.getValue(implNode) : null;
            if (implementation != null) {
                socketInterceptorConfigBuilder.addPropertyReference(this.xmlToJavaName("implementation"), implementation);
            }
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String name = this.cleanNodeName(child);
                if (!"properties".equals(name)) continue;
                this.handleProperties(child, socketInterceptorConfigBuilder);
            }
            networkConfigBuilder.addPropertyValue("socketInterceptorConfig", (Object)socketInterceptorConfigBuilder.getBeanDefinition());
        }

        private void handleSSLConfig(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            String implementation;
            BeanDefinitionBuilder sslConfigBuilder = this.createBeanBuilder(SSLConfig.class);
            String implAttribute = "factory-implementation";
            this.fillAttributeValues(node, sslConfigBuilder, "factory-implementation");
            Node implNode = node.getAttributes().getNamedItem("factory-implementation");
            String string = implementation = implNode != null ? this.getValue(implNode) : null;
            if (implementation != null) {
                sslConfigBuilder.addPropertyReference(this.xmlToJavaName("factory-implementation"), implementation);
            }
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String name = this.cleanNodeName(child);
                if (!"properties".equals(name)) continue;
                this.handleProperties(child, sslConfigBuilder);
            }
            networkConfigBuilder.addPropertyValue("SSLConfig", (Object)sslConfigBuilder.getBeanDefinition());
        }

        public void handleAsymmetricEncryption(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            this.createAndFillBeanBuilder(node, AsymmetricEncryptionConfig.class, "asymmetricEncryptionConfig", networkConfigBuilder, new String[0]);
        }

        public void handleSymmetricEncryption(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            this.createAndFillBeanBuilder(node, SymmetricEncryptionConfig.class, "symmetricEncryptionConfig", networkConfigBuilder, new String[0]);
        }

        public void handleExecutor(Node node) {
            this.createAndFillListedBean(node, ExecutorConfig.class, "executorConfig", this.executorManagedMap);
        }

        public void handleMulticast(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            this.createAndFillBeanBuilder(node, MulticastConfig.class, "multicastConfig", joinConfigBuilder, new String[0]);
        }

        public void handleTcpIp(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            BeanDefinitionBuilder builder = this.createAndFillBeanBuilder(node, TcpIpConfig.class, "tcpIpConfig", joinConfigBuilder, "interface", "member", "members");
            ManagedList members = new ManagedList();
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                String name = this.xmlToJavaName(SpringXmlConfigBuilder.cleanNodeName(n.getNodeName()));
                if (!"member".equals(name) && !"members".equals(name) && !"interface".equals(name)) continue;
                String value = this.getValue(n);
                members.add((Object)value);
            }
            builder.addPropertyValue("members", (Object)members);
        }

        public void handleAws(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            this.createAndFillBeanBuilder(node, AwsConfig.class, "awsConfig", joinConfigBuilder, new String[0]);
        }

        public void handleQueue(Node node) {
            BeanDefinitionBuilder queueConfigBuilder = this.createBeanBuilder(QueueConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getValue(attName);
            this.fillAttributeValues(node, queueConfigBuilder, new String[0]);
            for (Node childNode : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                if (!"item-listeners".equals(this.cleanNodeName(childNode))) continue;
                ManagedList listeners = this.parseListeners(childNode, ItemListenerConfig.class);
                queueConfigBuilder.addPropertyValue("itemListenerConfigs", (Object)listeners);
            }
            this.queueManagedMap.put((Object)name, (Object)queueConfigBuilder.getBeanDefinition());
        }

        public void handleMap(Node node) {
            Node maxSizePolicyNode;
            BeanDefinitionBuilder mapConfigBuilder = this.createBeanBuilder(MapConfig.class);
            AbstractBeanDefinition beanDefinition = mapConfigBuilder.getBeanDefinition();
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getValue(attName);
            mapConfigBuilder.addPropertyValue("name", (Object)name);
            this.fillAttributeValues(node, mapConfigBuilder, "maxSize", "maxSizePolicy");
            BeanDefinitionBuilder maxSizeConfigBuilder = this.createBeanBuilder(MaxSizeConfig.class);
            AbstractBeanDefinition maxSizeConfigBeanDefinition = maxSizeConfigBuilder.getBeanDefinition();
            mapConfigBuilder.addPropertyValue("maxSizeConfig", (Object)maxSizeConfigBeanDefinition);
            Node maxSizeNode = node.getAttributes().getNamedItem("max-size");
            if (maxSizeNode != null) {
                maxSizeConfigBuilder.addPropertyValue("size", (Object)this.getValue(maxSizeNode));
            }
            if ((maxSizePolicyNode = node.getAttributes().getNamedItem("max-size-policy")) != null) {
                maxSizeConfigBuilder.addPropertyValue(this.xmlToJavaName(this.cleanNodeName(maxSizePolicyNode)), (Object)this.getValue(maxSizePolicyNode));
            }
            for (Node childNode : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(childNode.getNodeName());
                if ("map-store".equals(nodeName)) {
                    this.handleMapStoreConfig(childNode, mapConfigBuilder);
                    continue;
                }
                if ("near-cache".equals(nodeName)) {
                    this.handleNearCacheConfig(childNode, mapConfigBuilder);
                    continue;
                }
                if ("wan-replication-ref".equals(nodeName)) {
                    BeanDefinitionBuilder wanReplicationRefBuilder = this.createBeanBuilder(WanReplicationRef.class);
                    AbstractBeanDefinition wanReplicationRefBeanDefinition = wanReplicationRefBuilder.getBeanDefinition();
                    this.fillValues(childNode, wanReplicationRefBuilder, new String[0]);
                    mapConfigBuilder.addPropertyValue("wanReplicationRef", (Object)wanReplicationRefBeanDefinition);
                    continue;
                }
                if ("indexes".equals(nodeName)) {
                    ManagedList indexes = new ManagedList();
                    for (Node indexNode : new AbstractXmlConfigHelper.IterableNodeList(childNode.getChildNodes(), 1)) {
                        BeanDefinitionBuilder indexConfBuilder = this.createBeanBuilder(MapIndexConfig.class);
                        this.fillAttributeValues(indexNode, indexConfBuilder, new String[0]);
                        indexes.add((Object)indexConfBuilder.getBeanDefinition());
                    }
                    mapConfigBuilder.addPropertyValue("mapIndexConfigs", (Object)indexes);
                    continue;
                }
                if (!"entry-listeners".equals(nodeName)) continue;
                ManagedList listeners = this.parseListeners(childNode, EntryListenerConfig.class);
                mapConfigBuilder.addPropertyValue("entryListenerConfigs", (Object)listeners);
            }
            this.mapConfigManagedMap.put((Object)name, (Object)beanDefinition);
        }

        public void handleWanReplication(Node node) {
            BeanDefinitionBuilder wanRepConfigBuilder = this.createBeanBuilder(WanReplicationConfig.class);
            AbstractBeanDefinition beanDefinition = wanRepConfigBuilder.getBeanDefinition();
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getValue(attName);
            wanRepConfigBuilder.addPropertyValue("name", (Object)name);
            ManagedList targetClusters = new ManagedList();
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                String nName = this.cleanNodeName(n);
                if (!"target-cluster".equals(nName)) continue;
                BeanDefinitionBuilder targetClusterConfigBuilder = this.createBeanBuilder(WanTargetClusterConfig.class);
                AbstractBeanDefinition childBeanDefinition = targetClusterConfigBuilder.getBeanDefinition();
                this.fillAttributeValues(n, targetClusterConfigBuilder, Collections.EMPTY_LIST);
                for (Node childNode : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes(), 1)) {
                    String childNodeName = this.cleanNodeName(childNode);
                    if ("replication-impl".equals(childNodeName)) {
                        targetClusterConfigBuilder.addPropertyValue(this.xmlToJavaName(childNodeName), (Object)this.getValue(childNode));
                        continue;
                    }
                    if ("replication-impl-object".equals(childNodeName)) {
                        Node refName = childNode.getAttributes().getNamedItem("ref");
                        targetClusterConfigBuilder.addPropertyReference(this.xmlToJavaName(childNodeName), this.getValue(refName));
                        continue;
                    }
                    if (!"end-points".equals(childNodeName)) continue;
                    ManagedList addresses = new ManagedList();
                    for (Node addressNode : new AbstractXmlConfigHelper.IterableNodeList(childNode.getChildNodes(), 1)) {
                        if (!"address".equals(this.cleanNodeName(addressNode))) continue;
                        addresses.add((Object)this.getValue(addressNode));
                    }
                    targetClusterConfigBuilder.addPropertyValue("endpoints", (Object)addresses);
                }
                targetClusters.add((Object)childBeanDefinition);
            }
            wanRepConfigBuilder.addPropertyValue("targetClusterConfigs", (Object)targetClusters);
            this.wanReplicationManagedMap.put((Object)name, (Object)beanDefinition);
        }

        private void handlePartitionGroup(Node node) {
            BeanDefinitionBuilder partitionConfigBuilder = this.createBeanBuilder(PartitionGroupConfig.class);
            this.fillAttributeValues(node, partitionConfigBuilder, new String[0]);
            ManagedList memberGroups = new ManagedList();
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                String name = SpringXmlConfigBuilder.cleanNodeName(child.getNodeName());
                if (!"member-group".equals(name)) continue;
                BeanDefinitionBuilder memberGroupBuilder = this.createBeanBuilder(MemberGroupConfig.class);
                ManagedList interfaces = new ManagedList();
                for (Node n : new AbstractXmlConfigHelper.IterableNodeList(child.getChildNodes(), 1)) {
                    if (!"interface".equals(SpringXmlConfigBuilder.cleanNodeName(n.getNodeName()))) continue;
                    interfaces.add((Object)this.getValue(n));
                }
                memberGroupBuilder.addPropertyValue("interfaces", (Object)interfaces);
                memberGroups.add((Object)memberGroupBuilder.getBeanDefinition());
            }
            partitionConfigBuilder.addPropertyValue("memberGroupConfigs", (Object)memberGroups);
            this.configBuilder.addPropertyValue("partitionGroupConfig", (Object)partitionConfigBuilder.getBeanDefinition());
        }

        private void handleManagementCenter(Node node) {
            this.createAndFillBeanBuilder(node, ManagementCenterConfig.class, "managementCenterConfig", this.configBuilder, new String[0]);
        }

        public void handleNearCacheConfig(Node node, BeanDefinitionBuilder mapConfigBuilder) {
            BeanDefinitionBuilder nearCacheConfigBuilder = this.createBeanBuilder(NearCacheConfig.class);
            AbstractBeanDefinition beanDefinition = nearCacheConfigBuilder.getBeanDefinition();
            this.fillValues(node, nearCacheConfigBuilder, new String[0]);
            mapConfigBuilder.addPropertyValue("nearCacheConfig", (Object)beanDefinition);
        }

        public void handleMapStoreConfig(Node node, BeanDefinitionBuilder mapConfigBuilder) {
            BeanDefinitionBuilder mapStoreConfigBuilder = this.createBeanBuilder(MapStoreConfig.class);
            AbstractBeanDefinition beanDefinition = mapStoreConfigBuilder.getBeanDefinition();
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                if (!"properties".equals(this.cleanNodeName(child))) continue;
                this.handleProperties(child, mapStoreConfigBuilder);
                break;
            }
            String implAttrName = "implementation";
            String factoryImplAttrName = "factory-implementation";
            this.fillAttributeValues(node, mapStoreConfigBuilder, "implementation", "factory-implementation");
            NamedNodeMap attrs = node.getAttributes();
            Node implRef = attrs.getNamedItem("implementation");
            Node factoryImplRef = attrs.getNamedItem("factory-implementation");
            if (factoryImplRef != null) {
                mapStoreConfigBuilder.addPropertyReference(this.xmlToJavaName("factory-implementation"), this.getValue(factoryImplRef));
            }
            if (implRef != null) {
                mapStoreConfigBuilder.addPropertyReference(this.xmlToJavaName("implementation"), this.getValue(implRef));
            }
            mapConfigBuilder.addPropertyValue("mapStoreConfig", (Object)beanDefinition);
            mapStoreConfigBuilder = null;
        }

        public void handleProperties(Node node, BeanDefinitionBuilder beanDefinitionBuilder) {
            ManagedMap properties = new ManagedMap();
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                String name = SpringXmlConfigBuilder.cleanNodeName(n.getNodeName());
                if (!"property".equals(name)) continue;
                String propertyName = this.getTextContent(n.getAttributes().getNamedItem("name")).trim();
                String value = this.getValue(n);
                properties.put((Object)propertyName, (Object)value);
            }
            beanDefinitionBuilder.addPropertyValue("properties", (Object)properties);
        }

        public void handleMultiMap(Node node) {
            BeanDefinitionBuilder multiMapConfigBuilder = this.createBeanBuilder(MultiMapConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getValue(attName);
            this.fillAttributeValues(node, multiMapConfigBuilder, new String[0]);
            for (Node childNode : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                if (!"entry-listeners".equals(this.cleanNodeName(childNode))) continue;
                ManagedList listeners = this.parseListeners(childNode, EntryListenerConfig.class);
                multiMapConfigBuilder.addPropertyValue("entryListenerConfigs", (Object)listeners);
            }
            this.multiMapManagedMap.put((Object)name, (Object)multiMapConfigBuilder.getBeanDefinition());
        }

        public void handleTopic(Node node) {
            BeanDefinitionBuilder topicConfigBuilder = this.createBeanBuilder(TopicConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getValue(attName);
            this.fillAttributeValues(node, topicConfigBuilder, new String[0]);
            for (Node childNode : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                if (!"message-listeners".equals(this.cleanNodeName(childNode))) continue;
                ManagedList listeners = this.parseListeners(childNode, ListenerConfig.class);
                topicConfigBuilder.addPropertyValue("messageListenerConfigs", (Object)listeners);
            }
            this.topicManagedMap.put((Object)name, (Object)topicConfigBuilder.getBeanDefinition());
        }

        public void handleMergePolicies(Node node) {
            String implAttr = "implementation";
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                if (!"map-merge-policy".equals(this.cleanNodeName(n))) continue;
                BeanDefinitionBuilder mergePolicyConfigBuilder = this.createBeanBuilder(MergePolicyConfig.class);
                AbstractBeanDefinition beanDefinition = mergePolicyConfigBuilder.getBeanDefinition();
                this.fillValues(n, mergePolicyConfigBuilder, "implementation");
                Node impl = n.getAttributes().getNamedItem("implementation");
                if ("implementation" != null) {
                    mergePolicyConfigBuilder.addPropertyReference("implementation", this.getValue(impl));
                }
                String name = this.getValue(n.getAttributes().getNamedItem("name"));
                this.mergePolicyConfigMap.put((Object)name, (Object)beanDefinition);
            }
        }

        private void handleSecurity(Node node) {
            BeanDefinitionBuilder securityConfigBuilder = this.createBeanBuilder(SecurityConfig.class);
            AbstractBeanDefinition beanDefinition = securityConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, securityConfigBuilder, new String[0]);
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child.getNodeName());
                if ("member-credentials-factory".equals(nodeName)) {
                    this.handleCredentialsFactory(child, securityConfigBuilder);
                    continue;
                }
                if ("member-login-modules".equals(nodeName)) {
                    this.handleLoginModules(child, securityConfigBuilder, true);
                    continue;
                }
                if ("client-login-modules".equals(nodeName)) {
                    this.handleLoginModules(child, securityConfigBuilder, false);
                    continue;
                }
                if ("client-permission-policy".equals(nodeName)) {
                    this.handlePermissionPolicy(child, securityConfigBuilder);
                    continue;
                }
                if (!"client-permissions".equals(nodeName)) continue;
                this.handleSecurityPermissions(child, securityConfigBuilder);
            }
            this.configBuilder.addPropertyValue("securityConfig", (Object)beanDefinition);
        }

        private void handleCredentialsFactory(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            BeanDefinitionBuilder credentialsConfigBuilder = this.createBeanBuilder(CredentialsFactoryConfig.class);
            AbstractBeanDefinition beanDefinition = credentialsConfigBuilder.getBeanDefinition();
            NamedNodeMap attrs = node.getAttributes();
            Node classNameNode = attrs.getNamedItem("class-name");
            String className = classNameNode != null ? this.getValue(classNameNode) : null;
            Node implNode = attrs.getNamedItem("implementation");
            String implementation = implNode != null ? this.getValue(implNode) : null;
            credentialsConfigBuilder.addPropertyValue("className", (Object)className);
            if (implementation != null) {
                credentialsConfigBuilder.addPropertyReference("implementation", implementation);
            }
            Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create CredentialsFactory!");
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child.getNodeName());
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, credentialsConfigBuilder);
                break;
            }
            securityConfigBuilder.addPropertyValue("memberCredentialsConfig", (Object)beanDefinition);
        }

        private void handleLoginModules(Node node, BeanDefinitionBuilder securityConfigBuilder, boolean member) {
            String name = (member ? "member" : "client") + "LoginModuleConfigs";
            ManagedList lms = new ManagedList();
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child.getNodeName());
                if (!"login-module".equals(nodeName)) continue;
                this.handleLoginModule(child, (List)lms);
            }
            if (member) {
                securityConfigBuilder.addPropertyValue("memberLoginModuleConfigs", (Object)lms);
            } else {
                securityConfigBuilder.addPropertyValue("clientLoginModuleConfigs", (Object)lms);
            }
        }

        private void handleLoginModule(Node node, List list) {
            BeanDefinitionBuilder lmConfigBuilder = this.createBeanBuilder(LoginModuleConfig.class);
            AbstractBeanDefinition beanDefinition = lmConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, lmConfigBuilder, new String[0]);
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child.getNodeName());
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, lmConfigBuilder);
                break;
            }
            list.add(beanDefinition);
        }

        private void handlePermissionPolicy(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            BeanDefinitionBuilder permPolicyConfigBuilder = this.createBeanBuilder(PermissionPolicyConfig.class);
            AbstractBeanDefinition beanDefinition = permPolicyConfigBuilder.getBeanDefinition();
            NamedNodeMap attrs = node.getAttributes();
            Node classNameNode = attrs.getNamedItem("class-name");
            String className = classNameNode != null ? this.getValue(classNameNode) : null;
            Node implNode = attrs.getNamedItem("implementation");
            String implementation = implNode != null ? this.getValue(implNode) : null;
            permPolicyConfigBuilder.addPropertyValue("className", (Object)className);
            if (implementation != null) {
                permPolicyConfigBuilder.addPropertyReference("implementation", implementation);
            }
            Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create PermissionPolicy!");
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child.getNodeName());
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, permPolicyConfigBuilder);
                break;
            }
            securityConfigBuilder.addPropertyValue("clientPolicyConfig", (Object)beanDefinition);
        }

        private void handleSecurityPermissions(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            ManagedSet permissions = new ManagedSet();
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
                PermissionConfig.PermissionType type;
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child.getNodeName());
                if ("map-permission".equals(nodeName)) {
                    type = PermissionConfig.PermissionType.MAP;
                } else if ("queue-permission".equals(nodeName)) {
                    type = PermissionConfig.PermissionType.QUEUE;
                } else if ("multimap-permission".equals(nodeName)) {
                    type = PermissionConfig.PermissionType.MULTIMAP;
                } else if ("topic-permission".equals(nodeName)) {
                    type = PermissionConfig.PermissionType.TOPIC;
                } else if ("list-permission".equals(nodeName)) {
                    type = PermissionConfig.PermissionType.LIST;
                } else if ("set-permission".equals(nodeName)) {
                    type = PermissionConfig.PermissionType.SET;
                } else if ("lock-permission".equals(nodeName)) {
                    type = PermissionConfig.PermissionType.LOCK;
                } else if ("atomic-number-permission".equals(nodeName)) {
                    type = PermissionConfig.PermissionType.ATOMIC_NUMBER;
                } else if ("countdown-latch-permission".equals(nodeName)) {
                    type = PermissionConfig.PermissionType.COUNTDOWN_LATCH;
                } else if ("semaphore-permission".equals(nodeName)) {
                    type = PermissionConfig.PermissionType.SEMAPHORE;
                } else if ("id-generator-permission".equals(nodeName)) {
                    type = PermissionConfig.PermissionType.ID_GENERATOR;
                } else if ("executor-service-permission".equals(nodeName)) {
                    type = PermissionConfig.PermissionType.EXECUTOR_SERVICE;
                } else if ("listener-permission".equals(nodeName)) {
                    type = PermissionConfig.PermissionType.LISTENER;
                } else if ("transaction-permission".equals(nodeName)) {
                    type = PermissionConfig.PermissionType.TRANSACTION;
                } else {
                    if (!"all-permissions".equals(nodeName)) continue;
                    type = PermissionConfig.PermissionType.ALL;
                }
                this.handleSecurityPermission(child, (Set)permissions, type);
            }
            securityConfigBuilder.addPropertyValue("clientPermissionConfigs", (Object)permissions);
        }

        private void handleSecurityPermission(Node node, Set permissions, PermissionConfig.PermissionType type) {
            BeanDefinitionBuilder permissionConfigBuilder = this.createBeanBuilder(PermissionConfig.class);
            AbstractBeanDefinition beanDefinition = permissionConfigBuilder.getBeanDefinition();
            permissionConfigBuilder.addPropertyValue("type", (Object)type);
            NamedNodeMap attrs = node.getAttributes();
            Node nameNode = attrs.getNamedItem("name");
            String name = nameNode != null ? this.getValue(nameNode) : "*";
            permissionConfigBuilder.addPropertyValue("name", (Object)name);
            Node principalNode = attrs.getNamedItem("principal");
            String principal = principalNode != null ? this.getValue(principalNode) : "*";
            permissionConfigBuilder.addPropertyValue("principal", (Object)principal);
            ManagedList endpoints = new ManagedList();
            ManagedList actions = new ManagedList();
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child.getNodeName());
                if ("endpoints".equals(nodeName)) {
                    this.handleSecurityPermissionEndpoints(child, (List)endpoints);
                    continue;
                }
                if (!"actions".equals(nodeName)) continue;
                this.handleSecurityPermissionActions(child, (List)actions);
            }
            permissionConfigBuilder.addPropertyValue("endpoints", (Object)endpoints);
            permissionConfigBuilder.addPropertyValue("actions", (Object)actions);
            permissions.add(beanDefinition);
        }

        private void handleSecurityPermissionEndpoints(Node node, List endpoints) {
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child.getNodeName());
                if (!"endpoint".equals(nodeName)) continue;
                endpoints.add(this.getValue(child));
            }
        }

        private void handleSecurityPermissionActions(Node node, List actions) {
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child.getNodeName());
                if (!"action".equals(nodeName)) continue;
                actions.add(this.getValue(child));
            }
        }

        private ManagedList parseListeners(Node node, Class listenerConfigClass) {
            ManagedList listeners = new ManagedList();
            String implementationAttr = "implementation";
            for (Node listenerNode : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                BeanDefinitionBuilder listenerConfBuilder = this.createBeanBuilder(listenerConfigClass);
                this.fillAttributeValues(listenerNode, listenerConfBuilder, "implementation");
                Node implementationNode = null;
                implementationNode = listenerNode.getAttributes().getNamedItem("implementation");
                if (implementationNode != null) {
                    listenerConfBuilder.addPropertyReference("implementation", this.getValue(implementationNode));
                }
                listeners.add((Object)listenerConfBuilder.getBeanDefinition());
            }
            return listeners;
        }
    }
}

