/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.Instance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.MultiTask;
import com.hazelcast.impl.AtomicNumberProxy;
import com.hazelcast.impl.CountDownLatchProxy;
import com.hazelcast.impl.ExecutorManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.HazelcastInstanceAwareInstance;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.QProxy;
import com.hazelcast.impl.SemaphoreProxy;
import com.hazelcast.impl.TopicProxy;
import com.hazelcast.impl.ascii.rest.HttpCommand;
import com.hazelcast.impl.management.ConsoleCommandHandler;
import com.hazelcast.impl.management.ConsoleCommandRequest;
import com.hazelcast.impl.management.ConsoleRequest;
import com.hazelcast.impl.management.DetectDeadlockRequest;
import com.hazelcast.impl.management.EvictLocalMapRequest;
import com.hazelcast.impl.management.ExecuteScriptRequest;
import com.hazelcast.impl.management.LockInformationCallable;
import com.hazelcast.impl.management.ManagementCenterConfigCallable;
import com.hazelcast.impl.management.MapConfigRequest;
import com.hazelcast.impl.management.RuntimeStateRequest;
import com.hazelcast.impl.management.ThreadDumpRequest;
import com.hazelcast.impl.monitor.LocalAtomicNumberStatsImpl;
import com.hazelcast.impl.monitor.LocalCountDownLatchStatsImpl;
import com.hazelcast.impl.monitor.LocalMapStatsImpl;
import com.hazelcast.impl.monitor.LocalQueueStatsImpl;
import com.hazelcast.impl.monitor.LocalSemaphoreStatsImpl;
import com.hazelcast.impl.monitor.LocalTopicStatsImpl;
import com.hazelcast.impl.monitor.MemberStateImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.monitor.TimedMemberState;
import com.hazelcast.nio.Address;
import com.hazelcast.partition.Partition;
import com.hazelcast.partition.PartitionService;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementCenterService
implements LifecycleListener,
MembershipListener {
    private final FactoryImpl factory;
    private AtomicBoolean running = new AtomicBoolean(false);
    private final TaskPoller taskPoller;
    private final StateSender stateSender;
    private final ILogger logger;
    private final ConsoleCommandHandler commandHandler;
    private final StatsInstanceFilter instanceFilterMap;
    private final StatsInstanceFilter instanceFilterQueue;
    private final StatsInstanceFilter instanceFilterTopic;
    private final StatsInstanceFilter instanceFilterAtomicNumber;
    private final StatsInstanceFilter instanceFilterCountDownLatch;
    private final StatsInstanceFilter instanceFilterSemaphore;
    private final int maxVisibleInstanceCount;
    private volatile String webServerUrl;
    private volatile boolean urlChanged = false;
    private final int updateIntervalMs;
    private final ManagementCenterConfig managementCenterConfig;

    public ManagementCenterService(FactoryImpl factoryImpl) {
        String tmpWebServerUrl;
        this.factory = factoryImpl;
        this.logger = this.factory.node.getLogger(ManagementCenterService.class.getName());
        this.managementCenterConfig = this.factory.node.config.getManagementCenterConfig();
        if (this.managementCenterConfig == null) {
            throw new IllegalStateException("ManagementCenterConfig should not be null!");
        }
        this.factory.getLifecycleService().addLifecycleListener(this);
        this.factory.getCluster().addMembershipListener(this);
        this.instanceFilterMap = new StatsInstanceFilter(factoryImpl.node.getGroupProperties().MC_MAP_EXCLUDES.getString());
        this.instanceFilterQueue = new StatsInstanceFilter(factoryImpl.node.getGroupProperties().MC_QUEUE_EXCLUDES.getString());
        this.instanceFilterTopic = new StatsInstanceFilter(factoryImpl.node.getGroupProperties().MC_TOPIC_EXCLUDES.getString());
        this.instanceFilterAtomicNumber = new StatsInstanceFilter(factoryImpl.node.getGroupProperties().MC_ATOMIC_NUMBER_EXCLUDES.getString());
        this.instanceFilterCountDownLatch = new StatsInstanceFilter(factoryImpl.node.getGroupProperties().MC_COUNT_DOWN_LATCH_EXCLUDES.getString());
        this.instanceFilterSemaphore = new StatsInstanceFilter(factoryImpl.node.getGroupProperties().MC_SEMAPHORE_EXCLUDES.getString());
        this.maxVisibleInstanceCount = this.factory.node.groupProperties.MC_MAX_INSTANCE_COUNT.getInteger();
        this.commandHandler = new ConsoleCommandHandler(this.factory);
        String string = tmpWebServerUrl = this.managementCenterConfig != null ? this.managementCenterConfig.getUrl() : null;
        this.webServerUrl = tmpWebServerUrl != null ? (!tmpWebServerUrl.endsWith("/") ? tmpWebServerUrl + '/' : tmpWebServerUrl) : tmpWebServerUrl;
        this.updateIntervalMs = this.managementCenterConfig != null && this.managementCenterConfig.getUpdateInterval() > 0 ? this.managementCenterConfig.getUpdateInterval() * 1000 : 5000;
        this.taskPoller = new TaskPoller();
        this.stateSender = new StateSender();
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            if (this.webServerUrl != null) {
                this.taskPoller.start();
                this.stateSender.start();
                this.logger.log(Level.INFO, "Hazelcast Management Center is listening from " + this.webServerUrl);
            } else {
                this.logger.log(Level.WARNING, "Hazelcast Management Center Web server url is null!");
            }
        }
    }

    public void shutdown() {
        if (this.running.compareAndSet(true, false)) {
            this.logger.log(Level.INFO, "Shutting down Hazelcast Management Center");
            try {
                this.interruptThread(this.stateSender);
                this.interruptThread(this.taskPoller);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void stateChanged(LifecycleEvent event) {
        if (event.getState() == LifecycleEvent.LifecycleState.STARTED && this.managementCenterConfig.isEnabled()) {
            try {
                this.start();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "ManagementCenterService could not be started!", e);
            }
        }
    }

    public byte[] changeWebServerUrlOverCluster(String groupName, String groupPass, String newUrl) {
        try {
            GroupConfig groupConfig = this.factory.getConfig().getGroupConfig();
            if (!groupConfig.getName().equals(groupName) || !groupConfig.getPassword().equals(groupPass)) {
                return HttpCommand.RES_403;
            }
            ManagementCenterConfigCallable callable = new ManagementCenterConfigCallable(newUrl);
            callable.setHazelcastInstance(this.factory);
            Set<Member> members = this.factory.getCluster().getMembers();
            MultiTask<Void> task = new MultiTask<Void>(callable, members);
            ExecutorService executorService = this.factory.getExecutorService();
            executorService.execute(task);
        }
        catch (Throwable throwable) {
            this.logger.log(Level.WARNING, "New web server url cannot be assigned.", throwable);
            return HttpCommand.RES_500;
        }
        return HttpCommand.RES_204;
    }

    @Override
    public void memberAdded(MembershipEvent membershipEvent) {
        try {
            Member member = membershipEvent.getMember();
            if (member != null && this.factory.node.isMaster() && this.urlChanged) {
                ManagementCenterConfigCallable callable = new ManagementCenterConfigCallable(this.webServerUrl);
                DistributedTask<Void> task = new DistributedTask<Void>(callable, member);
                ExecutorService executorService = this.factory.getExecutorService();
                executorService.execute(task);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Web server url cannot be assigned to the newly joined member", e);
        }
    }

    @Override
    public void memberRemoved(MembershipEvent membershipEvent) {
    }

    public void changeWebServerUrl(String newUrl) {
        if (newUrl == null) {
            return;
        }
        String string = this.webServerUrl = newUrl.endsWith("/") ? newUrl : newUrl + "/";
        if (!this.running.get()) {
            this.start();
        }
        this.urlChanged = true;
        this.logger.log(Level.INFO, "Web server url has been changed. Management Center is now listening from " + this.webServerUrl);
    }

    private void interruptThread(Thread t) {
        if (t != null) {
            t.interrupt();
        }
    }

    List<DetectDeadlockRequest.Edge> detectDeadlock() {
        Collection collection = this.callOnAllMembers(new LockInformationCallable());
        ArrayList<DetectDeadlockRequest.Vertex> graph = new ArrayList<DetectDeadlockRequest.Vertex>();
        for (Map mapLockStateMap : collection) {
            for (LockInformationCallable.MapLockState map : mapLockStateMap.values()) {
                for (Object key : map.getLockOwners().keySet()) {
                    DetectDeadlockRequest.Vertex owner = new DetectDeadlockRequest.Vertex(map.getLockOwners().get(key));
                    DetectDeadlockRequest.Vertex requester = new DetectDeadlockRequest.Vertex(map.getLockRequested().get(key));
                    int index = graph.indexOf(owner);
                    if (index >= 0) {
                        owner = (DetectDeadlockRequest.Vertex)graph.get(index);
                    } else {
                        graph.add(owner);
                    }
                    index = graph.indexOf(requester);
                    if (index >= 0) {
                        requester = (DetectDeadlockRequest.Vertex)graph.get(index);
                    } else {
                        graph.add(requester);
                    }
                    DetectDeadlockRequest.Edge edge = new DetectDeadlockRequest.Edge();
                    edge.from = requester;
                    edge.to = owner;
                    edge.key = key;
                    edge.mapName = map.getMapName();
                    edge.globalLock = map.isGlobalLock();
                    owner.addIncoming(edge);
                    requester.addOutgoing(edge);
                }
            }
        }
        ArrayList<DetectDeadlockRequest.Edge> list = new ArrayList<DetectDeadlockRequest.Edge>();
        if (graph != null && graph.size() > 0) {
            try {
                ((DetectDeadlockRequest.Vertex)graph.get(0)).visit(list);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        return list;
    }

    private void createMemberState(MemberStateImpl memberState) {
        Node node = this.factory.node;
        memberState.setAddress(node.getThisAddress());
        memberState.getMemberHealthStats().setOutOfMemory(node.isOutOfMemory());
        memberState.getMemberHealthStats().setActive(node.isActive());
        memberState.getMemberHealthStats().setServiceThreadStats(node.getCpuUtilization().serviceThread);
        memberState.getMemberHealthStats().setOutThreadStats(node.getCpuUtilization().outThread);
        memberState.getMemberHealthStats().setInThreadStats(node.getCpuUtilization().inThread);
        PartitionService partitionService = this.factory.getPartitionService();
        Set<Partition> partitions = partitionService.getPartitions();
        memberState.clearPartitions();
        for (Partition partition : partitions) {
            if (partition.getOwner() == null || !partition.getOwner().localMember()) continue;
            memberState.addPartition(partition.getPartitionId());
        }
        ArrayList<HazelcastInstanceAwareInstance> proxyObjects = new ArrayList<HazelcastInstanceAwareInstance>(this.factory.getProxies());
        ExecutorManager executorManager = this.factory.node.executorManager;
        memberState.putInternalThroughputStats(executorManager.getInternalThroughputMap());
        memberState.putThroughputStats(executorManager.getThroughputMap());
        this.createMemState(memberState, proxyObjects.iterator(), Instance.InstanceType.MAP);
        this.createMemState(memberState, proxyObjects.iterator(), Instance.InstanceType.QUEUE);
        this.createMemState(memberState, proxyObjects.iterator(), Instance.InstanceType.TOPIC);
        this.createRuntimeProps(memberState);
    }

    private void createRuntimeProps(MemberStateImpl memberState) {
        Runtime runtime = Runtime.getRuntime();
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        ClassLoadingMXBean clMxBean = ManagementFactory.getClassLoadingMXBean();
        MemoryMXBean memoryMxBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemory = memoryMxBean.getHeapMemoryUsage();
        MemoryUsage nonHeapMemory = memoryMxBean.getNonHeapMemoryUsage();
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("runtime.availableProcessors", Integer.valueOf(runtime.availableProcessors()).longValue());
        map.put("date.startTime", runtimeMxBean.getStartTime());
        map.put("seconds.upTime", runtimeMxBean.getUptime());
        map.put("memory.maxMemory", runtime.maxMemory());
        map.put("memory.freeMemory", runtime.freeMemory());
        map.put("memory.totalMemory", runtime.totalMemory());
        map.put("memory.heapMemoryMax", heapMemory.getMax());
        map.put("memory.heapMemoryUsed", heapMemory.getUsed());
        map.put("memory.nonHeapMemoryMax", nonHeapMemory.getMax());
        map.put("memory.nonHeapMemoryUsed", nonHeapMemory.getUsed());
        map.put("runtime.totalLoadedClassCount", clMxBean.getTotalLoadedClassCount());
        map.put("runtime.loadedClassCount", Integer.valueOf(clMxBean.getLoadedClassCount()).longValue());
        map.put("runtime.unloadedClassCount", clMxBean.getUnloadedClassCount());
        map.put("runtime.totalStartedThreadCount", threadMxBean.getTotalStartedThreadCount());
        map.put("runtime.threadCount", Integer.valueOf(threadMxBean.getThreadCount()).longValue());
        map.put("runtime.peakThreadCount", Integer.valueOf(threadMxBean.getPeakThreadCount()).longValue());
        map.put("runtime.daemonThreadCount", Integer.valueOf(threadMxBean.getDaemonThreadCount()).longValue());
        memberState.setRuntimeProps(map);
    }

    private void createMemState(MemberStateImpl memberState, Iterator<HazelcastInstanceAwareInstance> it, Instance.InstanceType type) {
        int count = 0;
        while (it.hasNext()) {
            HazelcastInstanceAwareInstance proxyObject = it.next();
            if (proxyObject.getInstanceType() != type) continue;
            if (count < this.maxVisibleInstanceCount) {
                SemaphoreProxy semaphoreProxy;
                if (type.isMap()) {
                    MProxy mapProxy = (MProxy)proxyObject;
                    if (this.instanceFilterMap.visible(mapProxy.getName())) {
                        memberState.putLocalMapStats(mapProxy.getName(), (LocalMapStatsImpl)mapProxy.getLocalMapStats());
                        ++count;
                    }
                } else if (type.isQueue()) {
                    QProxy qProxy = (QProxy)proxyObject;
                    if (this.instanceFilterQueue.visible(qProxy.getName())) {
                        memberState.putLocalQueueStats(qProxy.getName(), (LocalQueueStatsImpl)qProxy.getLocalQueueStats());
                        ++count;
                    }
                } else if (type.isTopic()) {
                    TopicProxy topicProxy = (TopicProxy)proxyObject;
                    if (this.instanceFilterTopic.visible(topicProxy.getName())) {
                        memberState.putLocalTopicStats(topicProxy.getName(), (LocalTopicStatsImpl)topicProxy.getLocalTopicStats());
                        ++count;
                    }
                } else if (type.isAtomicNumber()) {
                    AtomicNumberProxy atomicLongProxy = (AtomicNumberProxy)proxyObject;
                    if (this.instanceFilterAtomicNumber.visible(atomicLongProxy.getName())) {
                        memberState.putLocalAtomicNumberStats(atomicLongProxy.getName(), (LocalAtomicNumberStatsImpl)atomicLongProxy.getLocalAtomicNumberStats());
                        ++count;
                    }
                } else if (type.isCountDownLatch()) {
                    CountDownLatchProxy cdlProxy = (CountDownLatchProxy)proxyObject;
                    if (this.instanceFilterCountDownLatch.visible(cdlProxy.getName())) {
                        memberState.putLocalCountDownLatchStats(cdlProxy.getName(), (LocalCountDownLatchStatsImpl)cdlProxy.getLocalCountDownLatchStats());
                        ++count;
                    }
                } else if (type.isSemaphore() && this.instanceFilterSemaphore.visible((semaphoreProxy = (SemaphoreProxy)proxyObject).getName())) {
                    memberState.putLocalSemaphoreStats(semaphoreProxy.getName(), (LocalSemaphoreStatsImpl)semaphoreProxy.getLocalSemaphoreStats());
                    ++count;
                }
            }
            it.remove();
        }
    }

    private List<String> getExecutorNames() {
        ExecutorManager executorManager = this.factory.node.executorManager;
        ArrayList<String> executorNames = new ArrayList<String>(executorManager.getExecutorNames());
        Collections.sort(executorNames);
        return executorNames;
    }

    private Set<String> getLongInstanceNames() {
        HashSet<String> setLongInstanceNames = new HashSet<String>(this.maxVisibleInstanceCount);
        ArrayList<HazelcastInstanceAwareInstance> proxyObjects = new ArrayList<HazelcastInstanceAwareInstance>(this.factory.getProxies());
        this.collectInstanceNames(setLongInstanceNames, proxyObjects.iterator(), Instance.InstanceType.MAP);
        this.collectInstanceNames(setLongInstanceNames, proxyObjects.iterator(), Instance.InstanceType.QUEUE);
        this.collectInstanceNames(setLongInstanceNames, proxyObjects.iterator(), Instance.InstanceType.TOPIC);
        return setLongInstanceNames;
    }

    private void collectInstanceNames(Set<String> setLongInstanceNames, Iterator<HazelcastInstanceAwareInstance> it, Instance.InstanceType type) {
        int count = 0;
        while (it.hasNext()) {
            HazelcastInstanceAwareInstance proxyObject = it.next();
            if (proxyObject.getInstanceType() != type) continue;
            if (count < this.maxVisibleInstanceCount) {
                SemaphoreProxy semaphoreProxy;
                if (type.isMap()) {
                    MProxy mapProxy = (MProxy)proxyObject;
                    if (this.instanceFilterMap.visible(mapProxy.getName())) {
                        setLongInstanceNames.add(mapProxy.getLongName());
                        ++count;
                    }
                } else if (type.isQueue()) {
                    QProxy qProxy = (QProxy)proxyObject;
                    if (this.instanceFilterQueue.visible(qProxy.getName())) {
                        setLongInstanceNames.add(qProxy.getLongName());
                        ++count;
                    }
                } else if (type.isTopic()) {
                    TopicProxy topicProxy = (TopicProxy)proxyObject;
                    if (this.instanceFilterTopic.visible(topicProxy.getName())) {
                        setLongInstanceNames.add(topicProxy.getLongName());
                        ++count;
                    }
                } else if (type.isAtomicNumber()) {
                    AtomicNumberProxy atomicLongProxy = (AtomicNumberProxy)proxyObject;
                    if (this.instanceFilterAtomicNumber.visible(atomicLongProxy.getName())) {
                        setLongInstanceNames.add(atomicLongProxy.getLongName());
                        ++count;
                    }
                } else if (type.isCountDownLatch()) {
                    CountDownLatchProxy cdlProxy = (CountDownLatchProxy)proxyObject;
                    if (this.instanceFilterCountDownLatch.visible(cdlProxy.getName())) {
                        setLongInstanceNames.add(cdlProxy.getLongName());
                        ++count;
                    }
                } else if (type.isSemaphore() && this.instanceFilterSemaphore.visible((semaphoreProxy = (SemaphoreProxy)proxyObject).getName())) {
                    setLongInstanceNames.add(semaphoreProxy.getLongName());
                    ++count;
                }
            }
            it.remove();
        }
    }

    Object call(Address address, Callable callable) {
        Set<Member> members = this.factory.getCluster().getMembers();
        for (Member member : members) {
            if (!address.equals(((MemberImpl)member).getAddress())) continue;
            DistributedTask task = new DistributedTask(callable, member);
            return this.executeTaskAndGet(task);
        }
        return null;
    }

    Object call(Callable callable) {
        DistributedTask task = new DistributedTask(callable);
        return this.executeTaskAndGet(task);
    }

    Collection callOnMembers(Set<Address> addresses, Callable callable) {
        Set<Member> allMembers = this.factory.getCluster().getMembers();
        HashSet<Member> selectedMembers = new HashSet<Member>(addresses.size());
        for (Member member : allMembers) {
            if (!addresses.contains(((MemberImpl)member).getAddress())) continue;
            selectedMembers.add(member);
        }
        return this.callOnMembers0(selectedMembers, callable);
    }

    Collection callOnAllMembers(Callable callable) {
        Set<Member> members = this.factory.getCluster().getMembers();
        return this.callOnMembers0(members, callable);
    }

    private Collection callOnMembers0(Set<Member> members, Callable callable) {
        MultiTask task = new MultiTask(callable, members);
        return (Collection)this.executeTaskAndGet(task);
    }

    private Object executeTaskAndGet(DistributedTask task) {
        try {
            this.factory.getExecutorService().execute(task);
            try {
                return task.get(3L, TimeUnit.SECONDS);
            }
            catch (Throwable e) {
                this.logger.log(Level.FINEST, e.getMessage(), e);
                return null;
            }
        }
        catch (Throwable e) {
            if (this.running.get() && this.factory.node.isActive()) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
            return null;
        }
    }

    private TimedMemberState getTimedMemberState() {
        if (this.running.get()) {
            MemberStateImpl memberState = new MemberStateImpl();
            this.createMemberState(memberState);
            GroupConfig groupConfig = this.factory.getConfig().getGroupConfig();
            TimedMemberState timedMemberState = new TimedMemberState();
            timedMemberState.setMaster(this.factory.node.isMaster());
            if (timedMemberState.getMaster().booleanValue()) {
                timedMemberState.setMemberList(new ArrayList<String>());
                Set<Member> memberSet = this.factory.getCluster().getMembers();
                for (Member member : memberSet) {
                    MemberImpl memberImpl = (MemberImpl)member;
                    Address address = memberImpl.getAddress();
                    timedMemberState.getMemberList().add(address.getHost() + ":" + address.getPort());
                }
            }
            timedMemberState.setExecutorList(this.getExecutorNames());
            timedMemberState.setMemberState(memberState);
            timedMemberState.setClusterName(groupConfig.getName());
            timedMemberState.setInstanceNames(this.getLongInstanceNames());
            return timedMemberState;
        }
        return null;
    }

    FactoryImpl getHazelcastInstance() {
        return this.factory;
    }

    ConsoleCommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    class StatsInstanceFilter {
        final Set<Pattern> setExcludes;
        final Set<String> setIncludeCache;
        final Set<String> setExcludeCache;

        StatsInstanceFilter(String excludes) {
            if (excludes != null) {
                this.setExcludes = new HashSet<Pattern>();
                this.setIncludeCache = new HashSet<String>();
                this.setExcludeCache = new HashSet<String>();
                StringTokenizer st = new StringTokenizer(excludes, ",");
                while (st.hasMoreTokens()) {
                    this.setExcludes.add(Pattern.compile(st.nextToken().trim()));
                }
            } else {
                this.setExcludes = null;
                this.setIncludeCache = null;
                this.setExcludeCache = null;
            }
        }

        boolean visible(String instanceName) {
            if (this.setExcludes == null) {
                return true;
            }
            if (this.setIncludeCache.contains(instanceName)) {
                return true;
            }
            if (this.setExcludeCache.contains(instanceName)) {
                return false;
            }
            for (Pattern pattern : this.setExcludes) {
                if (!pattern.matcher(instanceName).matches()) continue;
                this.setExcludeCache.add(instanceName);
                return false;
            }
            this.setIncludeCache.add(instanceName);
            return true;
        }
    }

    class TaskPoller
    extends Thread {
        final ConsoleRequest[] consoleRequests;

        TaskPoller() {
            super(((ManagementCenterService)ManagementCenterService.this).factory.node.threadGroup, ((ManagementCenterService)ManagementCenterService.this).factory.node.getThreadNamePrefix("MC.Task.Poller"));
            this.consoleRequests = new ConsoleRequest[10];
            this.register(new RuntimeStateRequest());
            this.register(new ThreadDumpRequest());
            this.register(new ExecuteScriptRequest());
            this.register(new EvictLocalMapRequest());
            this.register(new ConsoleCommandRequest());
            this.register(new MapConfigRequest());
            this.register(new DetectDeadlockRequest());
        }

        public void register(ConsoleRequest consoleRequest) {
            this.consoleRequests[consoleRequest.getType()] = consoleRequest;
        }

        public void sendResponse(int taskId, ConsoleRequest request) {
            try {
                URL url = new URL(ManagementCenterService.this.webServerUrl + "putResponse.do");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                connection.setConnectTimeout(2000);
                connection.setReadTimeout(2000);
                OutputStream outputStream = connection.getOutputStream();
                DataOutputStream output = new DataOutputStream(outputStream);
                output.writeInt(taskId);
                output.writeInt(request.getType());
                request.writeResponse(ManagementCenterService.this, output);
                connection.getInputStream();
            }
            catch (Exception e) {
                ManagementCenterService.this.logger.log(Level.FINEST, e.getMessage(), e);
            }
        }

        public void run() {
            if (ManagementCenterService.this.webServerUrl == null) {
                ManagementCenterService.this.logger.log(Level.WARNING, "Web server url is null!");
                return;
            }
            try {
                Random rand = new Random();
                Address address = ((MemberImpl)((ManagementCenterService)ManagementCenterService.this).factory.node.getClusterImpl().getLocalMember()).getAddress();
                GroupConfig groupConfig = ManagementCenterService.this.factory.getConfig().getGroupConfig();
                while (ManagementCenterService.this.running.get()) {
                    try {
                        ConsoleRequest request;
                        URL url = new URL(ManagementCenterService.this.webServerUrl + "getTask.do?member=" + address.getHost() + ":" + address.getPort() + "&cluster=" + groupConfig.getName());
                        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                        connection.setRequestProperty("Connection", "keep-alive");
                        InputStream inputStream = connection.getInputStream();
                        DataInputStream input = new DataInputStream(inputStream);
                        int taskId = input.readInt();
                        int requestType = input.readInt();
                        if (taskId > 0 && requestType < this.consoleRequests.length && (request = this.consoleRequests[requestType]) != null) {
                            request.readData(input);
                            this.sendResponse(taskId, request);
                        }
                    }
                    catch (Exception e) {
                        ManagementCenterService.this.logger.log(Level.FINEST, e.getMessage(), e);
                    }
                    Thread.sleep(700 + rand.nextInt(300));
                }
            }
            catch (Throwable throwable) {
                ManagementCenterService.this.logger.log(Level.FINEST, "Problem on management center while polling task.", throwable);
            }
        }
    }

    class StateSender
    extends Thread {
        StateSender() {
            super(((ManagementCenterService)ManagementCenterService.this).factory.node.threadGroup, ((ManagementCenterService)ManagementCenterService.this).factory.node.getThreadNamePrefix("MC.State.Sender"));
        }

        public void run() {
            if (ManagementCenterService.this.webServerUrl == null) {
                ManagementCenterService.this.logger.log(Level.WARNING, "Web server url is null!");
                return;
            }
            try {
                while (ManagementCenterService.this.running.get()) {
                    try {
                        URL url = new URL(ManagementCenterService.this.webServerUrl + "collector.do");
                        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                        connection.setDoOutput(true);
                        connection.setRequestMethod("POST");
                        connection.setConnectTimeout(1000);
                        connection.setReadTimeout(1000);
                        DataOutputStream out = new DataOutputStream(connection.getOutputStream());
                        TimedMemberState ts = ManagementCenterService.this.getTimedMemberState();
                        ts.writeData(out);
                        out.flush();
                        connection.getInputStream();
                    }
                    catch (Exception e) {
                        ManagementCenterService.this.logger.log(Level.FINEST, e.getMessage(), e);
                    }
                    Thread.sleep(ManagementCenterService.this.updateIntervalMs);
                }
            }
            catch (Throwable throwable) {
                ManagementCenterService.this.logger.log(Level.FINEST, "Web Management Center will be closed due to exception.", throwable);
                ManagementCenterService.this.shutdown();
            }
        }
    }
}

