/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.AbstractRemotelyProcessable;
import com.hazelcast.cluster.ClusterImpl;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.AtomicNumber;
import com.hazelcast.core.ClientService;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.DuplicateInstanceNameException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.HazelcastInstanceAwareObject;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceEvent;
import com.hazelcast.core.InstanceListener;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.MultiTask;
import com.hazelcast.core.Transaction;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.HazelcastInstanceAwareInstance;
import com.hazelcast.impl.LifecycleServiceImpl;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.ProxyFactory;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.TransactionImpl;
import com.hazelcast.impl.Util;
import com.hazelcast.impl.base.HazelcastManagedContext;
import com.hazelcast.impl.executor.ParallelExecutor;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.SerializationHelper;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.util.ResponseQueueFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryImpl
implements HazelcastInstance {
    static final ConcurrentMap<String, FactoryImpl> factories = new ConcurrentHashMap<String, FactoryImpl>(5);
    private static final AtomicInteger factoryIdGen = new AtomicInteger();
    private static final Object INIT_LOCK = new Object();
    final ConcurrentMap<String, HazelcastInstanceAwareInstance> proxiesByName = new ConcurrentHashMap<String, HazelcastInstanceAwareInstance>(1000);
    final ConcurrentMap<ProxyKey, HazelcastInstanceAwareInstance> proxies = new ConcurrentHashMap<ProxyKey, HazelcastInstanceAwareInstance>(1000);
    final MProxy locksMapProxy;
    final ConcurrentMap<String, ExecutorService> executorServiceProxies = new ConcurrentHashMap<String, ExecutorService>(2);
    final CopyOnWriteArrayList<InstanceListener> lsInstanceListeners = new CopyOnWriteArrayList();
    final String name;
    final ProxyFactory proxyFactory;
    final HazelcastInstanceProxy hazelcastInstanceProxy;
    final ManagementService managementService;
    final ILogger logger;
    final LifecycleServiceImpl lifecycleService;
    final ManagedContext managedContext;
    public final Node node;

    public static Set<HazelcastInstance> getAllHazelcastInstanceProxies() {
        Collection factoryColl = factories.values();
        HashSet<HazelcastInstance> instanceSet = new HashSet<HazelcastInstance>(factoryColl.size());
        for (FactoryImpl factoryImpl : factoryColl) {
            if (!factoryImpl.getLifecycleService().isRunning()) continue;
            instanceSet.add(factoryImpl.hazelcastInstanceProxy);
        }
        return instanceSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HazelcastInstanceProxy getHazelcastInstanceProxy(String instanceName) {
        Object object = INIT_LOCK;
        synchronized (object) {
            FactoryImpl factory = (FactoryImpl)factories.get(instanceName);
            return factory != null ? factory.hazelcastInstanceProxy : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HazelcastInstanceProxy newHazelcastInstanceProxy(Config config) {
        String name;
        if (config == null) {
            config = new XmlConfigBuilder().build();
        }
        if ((name = config.getInstanceName()) == null || name.trim().length() == 0) {
            name = "_hzInstance_" + factoryIdGen.incrementAndGet() + "_" + config.getGroupConfig().getName();
            return FactoryImpl.newHazelcastInstanceProxy(config, name);
        }
        Object object = INIT_LOCK;
        synchronized (object) {
            if (factories.containsKey(name)) {
                throw new DuplicateInstanceNameException("HazelcastInstance with name '" + name + "' already exists!");
            }
            return FactoryImpl.newHazelcastInstanceProxy(config, name);
        }
    }

    private static HazelcastInstanceProxy newHazelcastInstanceProxy(Config config, String instanceName) {
        FactoryImpl factory = null;
        try {
            factory = new FactoryImpl(instanceName, config);
            factories.put(instanceName, factory);
            boolean firstMember = factory.node.getClusterImpl().getMembers().iterator().next().localMember();
            int initialWaitSeconds = factory.node.groupProperties.INITIAL_WAIT_SECONDS.getInteger();
            if (initialWaitSeconds > 0) {
                try {
                    Thread.sleep(initialWaitSeconds * 1000);
                    if (firstMember) {
                        final ConcurrentMapManager concurrentMapManager = factory.node.concurrentMapManager;
                        concurrentMapManager.enqueueAndReturn(new Processable(){

                            public void process() {
                                concurrentMapManager.partitionManager.firstArrangement();
                            }
                        });
                    } else {
                        Thread.sleep(4000L);
                    }
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
            int initialMinClusterSize = factory.node.groupProperties.INITIAL_MIN_CLUSTER_SIZE.getInteger();
            while (factory.node.getClusterImpl().getMembers().size() < initialMinClusterSize) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {}
            }
            if (initialMinClusterSize > 0) {
                if (firstMember) {
                    final ConcurrentMapManager concurrentMapManager = factory.node.concurrentMapManager;
                    concurrentMapManager.enqueueAndReturn(new Processable(){

                        public void process() {
                            concurrentMapManager.partitionManager.firstArrangement();
                        }
                    });
                } else {
                    Thread.sleep(4000L);
                }
                factory.logger.log(Level.INFO, "HazelcastInstance starting after waiting for cluster size of " + initialMinClusterSize);
            }
            factory.lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTED);
            return factory.hazelcastInstanceProxy;
        }
        catch (Throwable t) {
            if (factory != null) {
                factory.logger.log(Level.SEVERE, t.getMessage(), t);
            }
            Util.throwUncheckedException(t);
            return null;
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return o == this || this.name.equals(((FactoryImpl)o).getName());
    }

    public HazelcastInstanceProxy getHazelcastInstanceProxy() {
        return this.hazelcastInstanceProxy;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static void shutdownAll() {
        Collection colFactories = factories.values();
        for (FactoryImpl factory : colFactories) {
            factory.shutdown();
        }
        factories.clear();
        FactoryImpl.shutdownManagementService();
        ThreadContext.shutdownAll();
    }

    public static void kill(FactoryImpl factory) {
        factory.managementService.unregister();
        factories.remove(factory.getName());
        if (factories.size() == 0) {
            FactoryImpl.shutdownManagementService();
        }
        factory.proxies.clear();
        for (ExecutorService esp : factory.executorServiceProxies.values()) {
            esp.shutdown();
        }
        factory.node.shutdown(true, true);
    }

    public static void shutdown(FactoryImpl factory) {
        factory.managementService.unregister();
        factories.remove(factory.getName());
        if (factories.size() == 0) {
            FactoryImpl.shutdownManagementService();
        }
        factory.proxies.clear();
        factory.node.shutdown(false, true);
        for (ExecutorService esp : factory.executorServiceProxies.values()) {
            esp.shutdown();
        }
    }

    private static void shutdownManagementService() {
        ManagementService.shutdown();
    }

    public FactoryImpl(String name, Config config) {
        this.name = name;
        this.lifecycleService = new LifecycleServiceImpl(this);
        this.managedContext = new HazelcastManagedContext(this, config.getManagedContext());
        this.node = new Node(this, config);
        this.lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTING);
        this.proxyFactory = this.node.initializer.getProxyFactory();
        this.logger = this.node.getLogger(FactoryImpl.class.getName());
        this.hazelcastInstanceProxy = new HazelcastInstanceProxy(this);
        this.locksMapProxy = this.proxyFactory.createMapProxy("c:__hz_Locks");
        this.node.start();
        if (!this.node.isActive()) {
            this.node.connectionManager.shutdown();
            throw new IllegalStateException("Node failed to start!");
        }
        Set<Member> members = this.node.getClusterImpl().getMembers();
        if (members.size() > 1) {
            Member target = null;
            for (Member member : members) {
                if (member.isLiteMember() || member.localMember()) continue;
                target = member;
                break;
            }
            if (target != null) {
                DistributedTask<Set<ProxyKey>> task = new DistributedTask<Set<ProxyKey>>(new GetAllProxyKeysCallable(), target);
                Future<?> f = this.getExecutorService().submit(task);
                try {
                    Set proxyKeys = (Set)f.get(10L, TimeUnit.SECONDS);
                    for (final ProxyKey proxyKey : proxyKeys) {
                        if (this.proxies.containsKey(proxyKey)) continue;
                        this.node.clusterService.enqueueAndReturn(new Processable(){

                            public void process() {
                                FactoryImpl.this.createProxy(proxyKey);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
        this.managementService = new ManagementService(this);
        this.managementService.register();
    }

    public String toString() {
        return "HazelcastInstance {name='" + this.name + "'}";
    }

    @Override
    public Config getConfig() {
        return this.node.getConfig();
    }

    @Override
    public Collection<Instance> getInstances() {
        return new ArrayList<Instance>(this.proxies.values());
    }

    public Collection<HazelcastInstanceAwareInstance> getProxies() {
        this.initialChecks();
        return this.proxies.values();
    }

    @Override
    public ExecutorService getExecutorService() {
        this.initialChecks();
        return this.getExecutorService("default");
    }

    @Override
    public ExecutorService getExecutorService(String name) {
        ExecutorService old;
        if (name == null) {
            throw new IllegalArgumentException("ExecutorService name cannot be null");
        }
        this.initialChecks();
        name = "x:" + name;
        ExecutorService executorServiceProxy = (ExecutorService)this.executorServiceProxies.get(name);
        if (executorServiceProxy == null && (old = this.executorServiceProxies.putIfAbsent(name, executorServiceProxy = this.proxyFactory.createExecutorServiceProxy(name))) != null) {
            executorServiceProxy = old;
        }
        return executorServiceProxy;
    }

    @Override
    public ClusterImpl getCluster() {
        this.initialChecks();
        return this.node.getClusterImpl();
    }

    @Override
    public IdGenerator getIdGenerator(String name) {
        return (IdGenerator)this.getOrCreateProxyByName("i:" + name);
    }

    @Override
    public AtomicNumber getAtomicNumber(String name) {
        return (AtomicNumber)this.getOrCreateProxyByName("a:" + name);
    }

    @Override
    public ICountDownLatch getCountDownLatch(String name) {
        return (ICountDownLatch)this.getOrCreateProxyByName("d:" + name);
    }

    @Override
    public ISemaphore getSemaphore(String name) {
        return (ISemaphore)this.getOrCreateProxyByName("4:" + name);
    }

    @Override
    public Transaction getTransaction() {
        this.initialChecks();
        ThreadContext threadContext = ThreadContext.get();
        threadContext.setCurrentFactory(this);
        TransactionImpl txn = threadContext.getCallContext().getTransaction();
        if (txn == null) {
            txn = this.proxyFactory.createTransaction();
            threadContext.getCallContext().setTransaction(txn);
        }
        return txn;
    }

    @Override
    public PartitionService getPartitionService() {
        return this.node.concurrentMapManager.partitionServiceImpl;
    }

    @Override
    public ClientService getClientService() {
        return this.node.clientService;
    }

    @Override
    public LoggingService getLoggingService() {
        return this.node.loggingService;
    }

    @Override
    public LifecycleService getLifecycleService() {
        return this.lifecycleService;
    }

    @Override
    public void restart() {
        this.lifecycleService.restart();
    }

    @Override
    public void shutdown() {
        this.lifecycleService.shutdown();
    }

    @Override
    public <K, V> IMap<K, V> getMap(String name) {
        return (IMap)this.getOrCreateProxyByName("c:" + name);
    }

    @Override
    public <E> IQueue<E> getQueue(String name) {
        return (IQueue)this.getOrCreateProxyByName("q:" + name);
    }

    @Override
    public <E> ITopic<E> getTopic(String name) {
        return (ITopic)this.getOrCreateProxyByName("t:" + name);
    }

    @Override
    public <E> ISet<E> getSet(String name) {
        return (ISet)this.getOrCreateProxyByName("m:s:" + name);
    }

    @Override
    public <E> IList<E> getList(String name) {
        return (IList)this.getOrCreateProxyByName("l:" + name);
    }

    @Override
    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        return (MultiMap)this.getOrCreateProxyByName("m:u:" + name);
    }

    @Override
    public ILock getLock(Object key) {
        return (ILock)this.getOrCreateProxy(new ProxyKey("lock", key));
    }

    public Object getOrCreateProxyByName(String name) {
        Object proxy = this.proxiesByName.get(name);
        if (proxy == null) {
            proxy = this.getOrCreateProxy(new ProxyKey(name, null));
        }
        this.checkInitialization(proxy);
        return proxy;
    }

    public Object getOrCreateProxy(ProxyKey proxyKey) {
        this.initialChecks();
        Object proxy = this.proxies.get(proxyKey);
        if (proxy == null) {
            this.proxyFactory.checkProxy(proxyKey);
            proxy = this.createInstanceClusterWide(proxyKey);
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitialization(Object proxy) {
        if (proxy instanceof MProxy) {
            MProxy mProxy = (MProxy)proxy;
            CMap cmap = this.node.concurrentMapManager.getMap(mProxy.getLongName());
            if (cmap == null) {
                this.logger.log(Level.WARNING, "CMap[" + mProxy.getLongName() + "] has not been created yet! Initialization attempt failed!");
                return;
            }
            if (!cmap.isMapForQueue() && cmap.notInitialized()) {
                while (!this.node.concurrentMapManager.partitionServiceImpl.allPartitionsOwned()) {
                    try {
                        Thread.sleep(250L);
                        this.logger.log(Level.FINEST, "Waiting for all partitions to be owned...");
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                Object object = cmap.getInitLock();
                synchronized (object) {
                    block14: {
                        MapStoreConfig mapStoreConfig;
                        if (cmap.notInitialized() && (mapStoreConfig = cmap.getMapConfig().getMapStoreConfig()) != null && mapStoreConfig.isEnabled()) {
                            cmap.setInitState(CMap.InitializationState.INITIALIZING);
                            try {
                                Set keys;
                                ExecutorService es = this.getExecutorService();
                                HashSet<Member> members = new HashSet<Member>(this.getCluster().getMembers());
                                members.remove(this.node.localMember);
                                MultiTask<Boolean> task = new MultiTask<Boolean>(new InitializeMap(mProxy.getName()), members);
                                es.execute(task);
                                if (cmap.loader != null && (keys = cmap.loader.loadAllKeys()) != null) {
                                    int count = 0;
                                    LinkedList<Set> chunks = new LinkedList<Set>();
                                    HashSet ownedKeys = new HashSet();
                                    PartitionService partitionService = this.getPartitionService();
                                    for (Object key : keys) {
                                        Member owner = partitionService.getPartition(key).getOwner();
                                        if (owner != null && !owner.localMember()) continue;
                                        ownedKeys.add(key);
                                        ++count;
                                        if (ownedKeys.size() < this.node.groupProperties.MAP_LOAD_CHUNK_SIZE.getInteger()) continue;
                                        chunks.add(ownedKeys);
                                        ownedKeys = new HashSet();
                                    }
                                    chunks.add(ownedKeys);
                                    this.loadChunks(mProxy, cmap, chunks);
                                    this.logger.log(Level.INFO, this.node.address + "[" + mProxy.getName() + "] loaded " + count + " in total.");
                                }
                                task.get();
                            }
                            catch (Throwable e) {
                                if (!this.node.isActive()) break block14;
                                this.logger.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                    }
                    cmap.setInitState(CMap.InitializationState.INITIALIZED);
                }
            }
        }
    }

    private void loadChunks(final MProxy mProxy, final CMap cmap, Queue<Set> chunks) throws InterruptedException {
        if (chunks.size() > 0) {
            ParallelExecutor es = this.node.executorManager.getMapLoaderExecutorService();
            final CountDownLatch latch = new CountDownLatch(chunks.size());
            for (final Set chunk : chunks) {
                es.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        if (chunk == null) {
                            return;
                        }
                        try {
                            try {
                                FactoryImpl.this.loadKeys(mProxy, cmap, chunk);
                            }
                            catch (Exception e) {
                                FactoryImpl.this.logger.log(Level.SEVERE, "Initial loading failed.", e);
                                Object var3_2 = null;
                                latch.countDown();
                            }
                            Object var3_1 = null;
                            latch.countDown();
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            latch.countDown();
                            throw throwable;
                        }
                    }
                });
            }
            latch.await();
        }
    }

    private void loadKeys(MProxy mProxy, CMap cmap, Set keys) {
        Map map;
        if (keys.size() > 0 && (map = cmap.loader.loadAll(keys)) != null && map.size() > 0) {
            Set entries = map.entrySet();
            for (Map.Entry entry : entries) {
                mProxy.putTransient(entry.getKey(), entry.getValue(), 0L, null);
            }
        }
    }

    public void initialChecks() {
        ThreadContext.get().setCurrentFactory(this);
        while (this.node.isActive() && this.lifecycleService.paused.get()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
        if (!this.node.isActive()) {
            throw new IllegalStateException("Hazelcast Instance is not active!");
        }
    }

    public void destroyProxy(ProxyKey proxyKey) {
        this.proxiesByName.remove(proxyKey.name);
        Instance proxy = (Instance)this.proxies.remove(proxyKey);
        if (proxy != null) {
            String name = proxyKey.name;
            if (name.startsWith("q:")) {
                this.node.blockingQueueManager.destroy(name);
            } else if (name.startsWith("c:")) {
                this.node.concurrentMapManager.destroy(name);
            } else if (name.startsWith("m:")) {
                this.node.concurrentMapManager.destroy(name);
            } else if (name.startsWith("t:")) {
                this.node.topicManager.destroy(name);
            }
            this.logger.log(Level.FINEST, "Instance destroyed " + proxyKey);
            this.fireInstanceDestroyEvent(proxy);
        }
    }

    public Object createProxy(ProxyKey proxyKey) {
        this.node.clusterManager.checkServiceThread();
        boolean created = false;
        HazelcastInstanceAwareInstance proxy = (HazelcastInstanceAwareInstance)this.proxies.get(proxyKey);
        if (proxy == null) {
            created = true;
            String name = proxyKey.name;
            if (name.startsWith("q:")) {
                proxy = this.proxyFactory.createQueueProxy(name);
                this.node.blockingQueueManager.getOrCreateBQ(name);
            } else if (name.startsWith("t:")) {
                proxy = this.proxyFactory.createTopicProxy(name);
                this.node.topicManager.getTopicInstance(name);
            } else if (name.startsWith("c:")) {
                proxy = this.proxyFactory.createMapProxy(name);
                this.node.concurrentMapManager.getOrCreateMap(name);
            } else if (name.startsWith("l:")) {
                proxy = this.proxyFactory.createListProxy(name);
            } else if (name.startsWith("m:u:")) {
                proxy = this.proxyFactory.createMultiMapProxy(name);
                this.node.concurrentMapManager.getOrCreateMap(name);
            } else if (name.startsWith("m:s:")) {
                proxy = this.proxyFactory.createSetProxy(name);
            } else if (name.startsWith("a:")) {
                proxy = this.proxyFactory.createAtomicNumberProxy(name);
            } else if (name.startsWith("i:")) {
                proxy = this.proxyFactory.createIdGeneratorProxy(name);
            } else if (name.startsWith("4:")) {
                proxy = this.proxyFactory.createSemaphoreProxy(name);
            } else if (name.startsWith("d:")) {
                proxy = this.proxyFactory.createCountDownLatchProxy(name);
            } else if (name.equals("lock")) {
                proxy = this.proxyFactory.createLockProxy(proxyKey.key);
            }
            HazelcastInstanceAwareInstance anotherProxy = this.proxies.putIfAbsent(proxyKey, proxy);
            if (anotherProxy != null) {
                created = false;
                proxy = anotherProxy;
            }
            if (proxyKey.key == null) {
                this.proxiesByName.put(proxyKey.name, proxy);
            }
        }
        if (created) {
            this.logger.log(Level.FINEST, "Instance created " + proxyKey);
            this.fireInstanceCreateEvent(proxy);
        }
        return proxy;
    }

    @Override
    public void addInstanceListener(InstanceListener instanceListener) {
        this.lsInstanceListeners.add(instanceListener);
    }

    @Override
    public void removeInstanceListener(InstanceListener instanceListener) {
        this.lsInstanceListeners.remove(instanceListener);
    }

    void fireInstanceCreateEvent(Instance instance) {
        if (this.lsInstanceListeners.size() > 0) {
            final InstanceEvent instanceEvent = new InstanceEvent(InstanceEvent.InstanceEventType.CREATED, instance);
            for (final InstanceListener instanceListener : this.lsInstanceListeners) {
                this.node.executorManager.executeLocally(new Runnable(){

                    public void run() {
                        instanceListener.instanceCreated(instanceEvent);
                    }
                });
            }
        }
    }

    void fireInstanceDestroyEvent(Instance instance) {
        if (this.lsInstanceListeners.size() > 0) {
            final InstanceEvent instanceEvent = new InstanceEvent(InstanceEvent.InstanceEventType.DESTROYED, instance);
            for (final InstanceListener instanceListener : this.lsInstanceListeners) {
                this.node.executorManager.executeLocally(new Runnable(){

                    public void run() {
                        instanceListener.instanceDestroyed(instanceEvent);
                    }
                });
            }
        }
    }

    Object createInstanceClusterWide(final ProxyKey proxyKey) {
        final BlockingQueue result = ResponseQueueFactory.newResponseQueue();
        this.node.clusterService.enqueueAndWait(new Processable(){

            public void process() {
                try {
                    result.put(FactoryImpl.this.createProxy(proxyKey));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }, 10);
        Object proxy = null;
        try {
            proxy = result.take();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.node.clusterManager.sendProcessableToAll(new CreateOrDestroyInstanceProxy(proxyKey, true), false);
        return proxy;
    }

    void destroyInstanceClusterWide(String name, Object key) {
        ProxyKey proxyKey = new ProxyKey(name, key);
        if (this.proxies.containsKey(proxyKey)) {
            if (name.equals("lock")) {
                this.locksMapProxy.remove(key);
            }
            this.node.clusterManager.sendProcessableToAll(new CreateOrDestroyInstanceProxy(proxyKey, false), true);
        } else {
            this.logger.log(Level.WARNING, "Destroying unknown instance name: " + name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetAllProxyKeysCallable
    extends HazelcastInstanceAwareObject
    implements Callable<Set<ProxyKey>> {
        @Override
        public Set<ProxyKey> call() throws Exception {
            FactoryImpl factory = (FactoryImpl)this.hazelcastInstance;
            return new HashSet<ProxyKey>(factory.proxies.keySet());
        }
    }

    public static class ProxyKey
    extends SerializationHelper
    implements DataSerializable {
        String name;
        Object key;

        public ProxyKey() {
        }

        public ProxyKey(String name, Object key) {
            this.name = name;
            this.key = key;
        }

        public void writeData(DataOutput out) throws IOException {
            out.writeUTF(this.name);
            boolean keyNull = this.key == null;
            out.writeBoolean(keyNull);
            if (!keyNull) {
                ProxyKey.writeObject(out, this.key);
            }
        }

        public void readData(DataInput in) throws IOException {
            this.name = in.readUTF();
            boolean keyNull = in.readBoolean();
            if (!keyNull) {
                this.key = ProxyKey.readObject(in);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProxyKey pk = (ProxyKey)o;
            return (this.name != null ? this.name.equals(pk.name) : pk.name == null) && (this.key != null ? this.key.equals(pk.key) : pk.key == null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ProxyKey {name='" + this.name + "', key=" + this.key + '}';
        }

        public String getName() {
            return this.name;
        }

        public Object getKey() {
            return this.key;
        }
    }

    public static class CreateOrDestroyInstanceProxy
    extends AbstractRemotelyProcessable {
        private ProxyKey proxyKey;
        private boolean create;

        public CreateOrDestroyInstanceProxy() {
        }

        public CreateOrDestroyInstanceProxy(ProxyKey proxyKey, boolean create) {
            this.proxyKey = proxyKey;
            this.create = create;
        }

        public void process() {
            if (this.create) {
                this.node.factory.createProxy(this.proxyKey);
            } else {
                this.node.factory.destroyProxy(this.proxyKey);
            }
        }

        public void readData(DataInput in) throws IOException {
            super.readData(in);
            this.create = in.readBoolean();
            this.proxyKey = new ProxyKey();
            this.proxyKey.readData(in);
        }

        public void writeData(DataOutput out) throws IOException {
            super.writeData(out);
            out.writeBoolean(this.create);
            this.proxyKey.writeData(out);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InitializeMap
    implements Callable<Boolean>,
    DataSerializable,
    HazelcastInstanceAware {
        String name;
        private transient FactoryImpl factory = null;

        public InitializeMap(String name) {
            this.name = name;
        }

        public InitializeMap() {
        }

        @Override
        public Boolean call() throws Exception {
            this.factory.getMap(this.name).getName();
            return Boolean.TRUE;
        }

        @Override
        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.factory = (FactoryImpl)hazelcastInstance;
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            out.writeUTF(this.name);
        }

        @Override
        public void readData(DataInput in) throws IOException {
            this.name = in.readUTF();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HazelcastInstanceProxy
    extends HazelcastInstanceAwareObject
    implements HazelcastInstance {
        public HazelcastInstanceProxy() {
        }

        public HazelcastInstanceProxy(FactoryImpl factory) {
            this.hazelcastInstance = factory;
        }

        public FactoryImpl getFactory() {
            return (FactoryImpl)this.hazelcastInstance;
        }

        @Override
        public String getName() {
            return this.hazelcastInstance.getName();
        }

        @Override
        public void shutdown() {
            this.hazelcastInstance.shutdown();
        }

        @Override
        public void restart() {
            this.hazelcastInstance.restart();
        }

        @Override
        public Collection<Instance> getInstances() {
            return this.hazelcastInstance.getInstances();
        }

        @Override
        public ExecutorService getExecutorService() {
            return this.hazelcastInstance.getExecutorService();
        }

        @Override
        public ExecutorService getExecutorService(String name) {
            return this.hazelcastInstance.getExecutorService(name);
        }

        @Override
        public Cluster getCluster() {
            return this.hazelcastInstance.getCluster();
        }

        @Override
        public IdGenerator getIdGenerator(String name) {
            return this.hazelcastInstance.getIdGenerator(name);
        }

        @Override
        public AtomicNumber getAtomicNumber(String name) {
            return this.hazelcastInstance.getAtomicNumber(name);
        }

        @Override
        public Transaction getTransaction() {
            return this.hazelcastInstance.getTransaction();
        }

        @Override
        public <K, V> IMap<K, V> getMap(String name) {
            return this.hazelcastInstance.getMap(name);
        }

        @Override
        public <E> IQueue<E> getQueue(String name) {
            return this.hazelcastInstance.getQueue(name);
        }

        @Override
        public <E> ITopic<E> getTopic(String name) {
            return this.hazelcastInstance.getTopic(name);
        }

        @Override
        public <E> ISet<E> getSet(String name) {
            return this.hazelcastInstance.getSet(name);
        }

        @Override
        public <E> IList<E> getList(String name) {
            return this.hazelcastInstance.getList(name);
        }

        @Override
        public <K, V> MultiMap<K, V> getMultiMap(String name) {
            return this.hazelcastInstance.getMultiMap(name);
        }

        @Override
        public ILock getLock(Object key) {
            return this.hazelcastInstance.getLock(key);
        }

        @Override
        public ICountDownLatch getCountDownLatch(String name) {
            return this.hazelcastInstance.getCountDownLatch(name);
        }

        @Override
        public ISemaphore getSemaphore(String name) {
            return this.hazelcastInstance.getSemaphore(name);
        }

        @Override
        public void addInstanceListener(InstanceListener instanceListener) {
            this.hazelcastInstance.addInstanceListener(instanceListener);
        }

        @Override
        public void removeInstanceListener(InstanceListener instanceListener) {
            this.hazelcastInstance.removeInstanceListener(instanceListener);
        }

        @Override
        public Config getConfig() {
            return this.hazelcastInstance.getConfig();
        }

        @Override
        public PartitionService getPartitionService() {
            return this.hazelcastInstance.getPartitionService();
        }

        @Override
        public ClientService getClientService() {
            return this.hazelcastInstance.getClientService();
        }

        @Override
        public LoggingService getLoggingService() {
            return this.hazelcastInstance.getLoggingService();
        }

        @Override
        public LifecycleService getLifecycleService() {
            return this.hazelcastInstance.getLifecycleService();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj instanceof HazelcastInstanceProxy) {
                HazelcastInstanceProxy that = (HazelcastInstanceProxy)obj;
                return this.hazelcastInstance.equals(that.hazelcastInstance);
            }
            return false;
        }

        public int hashCode() {
            return this.hazelcastInstance.hashCode();
        }
    }
}

