/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.Join;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.TcpIpJoiner;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.util.AddressUtil;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AddressPicker {
    private final Node node;
    private final ILogger logger;
    private ServerSocketChannel serverSocketChannel;
    private Address address;

    public AddressPicker(Node node) {
        this.node = node;
        this.logger = Logger.getLogger(AddressPicker.class.getName());
    }

    public void pickAddress() throws Exception {
        if (this.address != null) {
            return;
        }
        try {
            Config config = this.node.getConfig();
            AddressDefinition addressDef = this.pickAddress(config);
            boolean reuseAddress = config.isReuseAddress();
            boolean bindAny = this.node.getGroupProperties().SOCKET_BIND_ANY.getBoolean();
            this.serverSocketChannel = ServerSocketChannel.open();
            ServerSocket serverSocket = this.serverSocketChannel.socket();
            this.log(Level.FINEST, "inet reuseAddress:" + reuseAddress);
            serverSocket.setReuseAddress(reuseAddress);
            serverSocket.setSoTimeout(1000);
            int port = config.getPort();
            for (int i = 0; i < 100; ++i) {
                try {
                    InetSocketAddress isa = bindAny ? new InetSocketAddress(port) : new InetSocketAddress(addressDef.inetAddress, port);
                    this.log(Level.FINEST, "Trying to bind inet socket address:" + isa);
                    serverSocket.bind(isa, 100);
                    this.log(Level.FINEST, "Bind successful to inet socket address:" + isa);
                    break;
                }
                catch (Exception e) {
                    if (config.isPortAutoIncrement()) {
                        ++port;
                        continue;
                    }
                    String msg = "Port [" + port + "] is already in use and auto-increment is " + "disabled. Hazelcast cannot start.";
                    this.logger.log(Level.SEVERE, msg, e);
                    throw e;
                }
            }
            this.serverSocketChannel.configureBlocking(false);
            this.address = addressDef.host != null ? new Address(addressDef.host, port) : new Address(addressDef.inetAddress, port);
            this.log(Level.INFO, "Picked " + this.address + ", using socket " + serverSocket + ", bind any local is " + bindAny);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
    }

    private AddressDefinition pickAddress(Config config) throws UnknownHostException, SocketException {
        AddressDefinition addressDef = this.getSystemConfiguredAddress();
        if (addressDef == null) {
            NetworkConfig networkConfig = config.getNetworkConfig();
            Collection<InterfaceDefinition> interfaces = this.getInterfaces(networkConfig);
            if (interfaces.contains(new InterfaceDefinition("127.0.0.1")) || interfaces.contains(new InterfaceDefinition("localhost"))) {
                addressDef = this.pickLoopbackAddress();
            } else {
                if (this.preferIPv4Stack()) {
                    this.log(Level.INFO, "Prefer IPv4 stack is true.");
                }
                if (interfaces.size() > 0) {
                    addressDef = this.pickMatchingAddress(interfaces);
                }
                if (addressDef == null) {
                    if (networkConfig.getInterfaces().isEnabled()) {
                        String msg = "Hazelcast CANNOT start on this node. No matching network interface found. ";
                        msg = msg + "\nInterface matching must be either disabled or updated in the hazelcast.xml config file.";
                        this.logger.log(Level.SEVERE, msg);
                        throw new RuntimeException(msg);
                    }
                    if (networkConfig.getJoin().getTcpIpConfig().isEnabled()) {
                        this.logger.log(Level.WARNING, "Could not find a matching address to start with! Picking one of non-loopback addresses.");
                    }
                    addressDef = this.pickMatchingAddress(null);
                }
            }
        }
        if (addressDef != null) {
            addressDef.inetAddress = AddressUtil.fixScopeIdAndGetInetAddress(addressDef.inetAddress);
        }
        if (addressDef == null) {
            addressDef = this.pickLoopbackAddress();
        }
        return addressDef;
    }

    private Collection<InterfaceDefinition> getInterfaces(NetworkConfig networkConfig) throws UnknownHostException {
        LinkedHashMap<String, String> addressDomainMap;
        TcpIpConfig tcpIpConfig = networkConfig.getJoin().getTcpIpConfig();
        if (tcpIpConfig.isEnabled()) {
            addressDomainMap = new LinkedHashMap<String, String>();
            Collection<String> possibleAddresses = TcpIpJoiner.getConfigurationMembers(this.node.config);
            for (String string : possibleAddresses) {
                String s = AddressUtil.getAddressHolder((String)string).address;
                if (AddressUtil.isIpAddress(s)) {
                    if (addressDomainMap.containsKey(s)) continue;
                    addressDomainMap.put(s, null);
                    continue;
                }
                Collection<String> addresses = this.resolveDomainNames(s);
                for (String address : addresses) {
                    addressDomainMap.put(address, s);
                }
            }
        } else {
            addressDomainMap = Collections.EMPTY_MAP;
        }
        HashSet<InterfaceDefinition> interfaces = new HashSet<InterfaceDefinition>();
        if (networkConfig.getInterfaces().isEnabled()) {
            Collection<String> configInterfaces = networkConfig.getInterfaces().getInterfaces();
            for (String configInterface : configInterfaces) {
                if (AddressUtil.isIpAddress(configInterface)) {
                    interfaces.add(new InterfaceDefinition((String)addressDomainMap.get(configInterface), configInterface));
                    continue;
                }
                this.logger.log(Level.INFO, "'" + configInterface + "' is not an IP address! Removing from interface list.");
            }
            this.log(Level.INFO, "Interfaces is enabled, trying to pick one address matching to one of: " + interfaces);
        } else if (tcpIpConfig.isEnabled()) {
            for (Map.Entry entry : addressDomainMap.entrySet()) {
                interfaces.add(new InterfaceDefinition((String)entry.getValue(), (String)entry.getKey()));
            }
            this.log(Level.INFO, "Interfaces is disabled, trying to pick one address from TCP-IP config addresses: " + interfaces);
        }
        return interfaces;
    }

    private Collection<String> resolveDomainNames(String domainName) throws UnknownHostException {
        InetAddress[] inetAddresses = InetAddress.getAllByName(domainName);
        LinkedList<String> addresses = new LinkedList<String>();
        for (InetAddress inetAddress : inetAddresses) {
            addresses.add(inetAddress.getHostAddress());
        }
        this.logger.log(Level.INFO, "Resolving domain name '" + domainName + "' to address(es): " + addresses);
        return addresses;
    }

    private AddressDefinition getSystemConfiguredAddress() throws UnknownHostException {
        String localAddress = System.getProperty("hazelcast.local.localAddress");
        if (localAddress != null) {
            if ("127.0.0.1".equals(localAddress = localAddress.trim()) || "localhost".equals(localAddress)) {
                return this.pickLoopbackAddress();
            }
            this.log(Level.INFO, "Picking address configured by System property 'hazelcast.local.localAddress'");
            return new AddressDefinition(localAddress, InetAddress.getByName(localAddress));
        }
        return null;
    }

    private AddressDefinition pickLoopbackAddress() throws UnknownHostException {
        if (System.getProperty("java.net.preferIPv6Addresses") == null && System.getProperty("java.net.preferIPv4Stack") == null) {
            this.log(Level.WARNING, "Picking loopback address [127.0.0.1]; setting 'java.net.preferIPv4Stack' to true.");
            System.setProperty("java.net.preferIPv4Stack", "true");
        }
        return new AddressDefinition("127.0.0.1", InetAddress.getByName("127.0.0.1"));
    }

    private AddressDefinition pickMatchingAddress(Collection<InterfaceDefinition> interfaces) throws SocketException {
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        boolean preferIPv4Stack = this.preferIPv4Stack();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface ni = networkInterfaces.nextElement();
            Enumeration<InetAddress> e = ni.getInetAddresses();
            while (e.hasMoreElements()) {
                InetAddress inetAddress = e.nextElement();
                if (preferIPv4Stack && inetAddress instanceof Inet6Address) continue;
                if (interfaces != null && !interfaces.isEmpty()) {
                    AddressDefinition address = this.match(inetAddress, interfaces);
                    if (address == null) continue;
                    return address;
                }
                if (inetAddress.isLoopbackAddress()) continue;
                return new AddressDefinition(inetAddress);
            }
        }
        return null;
    }

    private AddressDefinition match(InetAddress address, Collection<InterfaceDefinition> interfaces) {
        for (InterfaceDefinition inf : interfaces) {
            if (!AddressUtil.matchInterface(address.getHostAddress(), inf.address)) continue;
            return new AddressDefinition(inf.host, address);
        }
        return null;
    }

    private boolean preferIPv4Stack() {
        boolean preferIPv4Stack = Boolean.getBoolean("java.net.preferIPv4Stack") || this.node.groupProperties.PREFER_IPv4_STACK.getBoolean();
        Join join = this.node.getConfig().getNetworkConfig().getJoin();
        AwsConfig awsConfig = join.getAwsConfig();
        boolean awsEnabled = awsConfig != null && awsConfig.isEnabled();
        return preferIPv4Stack || awsEnabled;
    }

    public Address getAddress() {
        return this.address;
    }

    public ServerSocketChannel getServerSocketChannel() {
        return this.serverSocketChannel;
    }

    private void log(Level level, String message) {
        this.logger.log(level, message);
        this.node.getSystemLogService().logNode(message);
    }

    private class AddressDefinition
    extends InterfaceDefinition {
        InetAddress inetAddress;

        private AddressDefinition() {
        }

        private AddressDefinition(InetAddress inetAddress) {
            super(inetAddress.getHostAddress());
            this.inetAddress = inetAddress;
        }

        private AddressDefinition(String host, InetAddress inetAddress) {
            super(host, inetAddress.getHostAddress());
            this.inetAddress = inetAddress;
        }
    }

    private class InterfaceDefinition {
        String host;
        String address;

        private InterfaceDefinition() {
        }

        private InterfaceDefinition(String address) {
            this.host = null;
            this.address = address;
        }

        private InterfaceDefinition(String host, String address) {
            this.host = host;
            this.address = address;
        }

        public String toString() {
            return this.host != null ? this.host : this.address;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InterfaceDefinition that = (InterfaceDefinition)o;
            if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
                return false;
            }
            return !(this.host != null ? !this.host.equals(that.host) : that.host != null);
        }

        public int hashCode() {
            int result = this.host != null ? this.host.hashCode() : 0;
            result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
            return result;
        }
    }
}

