/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.CollectionClientProxy;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.core.IList;
import com.hazelcast.core.Instance;
import com.hazelcast.impl.ClusterOperation;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListClientProxy<E>
extends CollectionClientProxy<E>
implements IList<E> {
    public ListClientProxy(HazelcastClient hazelcastClient, String name) {
        super(hazelcastClient, name);
    }

    @Override
    public boolean add(E o) {
        ProxyHelper.check(o);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_ADD_TO_LIST, o, null);
    }

    @Override
    public boolean remove(Object o) {
        ProxyHelper.check(o);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_REMOVE_ITEM, o, null);
    }

    @Override
    public boolean contains(Object o) {
        ProxyHelper.check(o);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_CONTAINS_KEY, o, null);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof IList && o != null) {
            return this.getName().equals(((IList)o).getName());
        }
        return false;
    }

    @Override
    protected Collection<E> getTheCollection() {
        final Collection entries = this.proxyHelper.entries(null);
        final Iterator it = entries.iterator();
        final ListClientProxy thisListProxy = this;
        return new AbstractCollection<E>(){

            @Override
            public Iterator<E> iterator() {
                return new Iterator<E>(){
                    volatile E lastRecord;

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public E next() {
                        this.lastRecord = ((Map.Entry)it.next()).getValue();
                        return this.lastRecord;
                    }

                    @Override
                    public void remove() {
                        if (this.lastRecord == null) {
                            throw new IllegalStateException();
                        }
                        it.remove();
                        thisListProxy.remove(this.lastRecord);
                    }
                };
            }

            @Override
            public int size() {
                return entries.size();
            }
        };
    }

    @Override
    public String getName() {
        return this.name.substring("l:".length());
    }

    @Override
    public Instance.InstanceType getInstanceType() {
        return Instance.InstanceType.LIST;
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E get(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }
}

