/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.config.Config;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.TcpIpJoiner;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.util.AddressUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressPicker {
    final Node node;
    final ServerSocketChannel serverSocketChannel;
    final ILogger logger;

    public AddressPicker(Node node, ServerSocketChannel serverSocketChannel) {
        this.node = node;
        this.logger = Logger.getLogger(AddressPicker.class.getName());
        this.serverSocketChannel = serverSocketChannel;
    }

    public static boolean matchAddress(String address, Collection<String> interfaces) {
        return AddressUtil.matchAnyInterface(address, interfaces);
    }

    public Address pickAddress() throws Exception {
        InetAddress currentInetAddress = null;
        try {
            Config config = this.node.getConfig();
            String localAddress = System.getProperty("hazelcast.local.localAddress");
            if (localAddress != null) {
                currentInetAddress = InetAddress.getByName(localAddress.trim());
            }
            if (currentInetAddress == null) {
                HashSet<String> interfaces = new HashSet<String>();
                if (config.getNetworkConfig().getInterfaces().isEnabled()) {
                    interfaces.addAll(config.getNetworkConfig().getInterfaces().getInterfaces());
                    this.logger.log(Level.INFO, "Interfaces is enabled, trying to pick one address matching to one of: " + interfaces);
                } else if (config.getNetworkConfig().getJoin().getTcpIpConfig().isEnabled()) {
                    Collection<String> possibleAddresses = TcpIpJoiner.getConfigurationMembers(this.node.config);
                    for (String possibleAddress : possibleAddresses) {
                        interfaces.add(AddressUtil.getAddressHolder((String)possibleAddress).address);
                    }
                    this.logger.log(Level.FINEST, "Interfaces is disabled, trying to pick one address from TCP-IP config addresses: " + interfaces);
                }
                if (interfaces.contains("127.0.0.1") || interfaces.contains("localhost")) {
                    currentInetAddress = InetAddress.getByName("127.0.0.1");
                } else {
                    if (interfaces.size() > 0) {
                        currentInetAddress = this.pickInetAddress(interfaces);
                    }
                    if (currentInetAddress == null) {
                        if (config.getNetworkConfig().getInterfaces().isEnabled()) {
                            String msg = "Hazelcast CANNOT start on this node. No matching network interface found. ";
                            msg = msg + "\nInterface matching must be either disabled or updated in the hazelcast.xml config file.";
                            this.logger.log(Level.SEVERE, msg);
                            throw new RuntimeException(msg);
                        }
                        currentInetAddress = this.pickInetAddress(null);
                    }
                }
            }
            if (currentInetAddress != null) {
                currentInetAddress = AddressUtil.fixAndGetInetAddress(currentInetAddress);
            }
            if (currentInetAddress == null) {
                currentInetAddress = InetAddress.getByName("127.0.0.1");
            }
            InetAddress inetAddress = currentInetAddress;
            boolean reuseAddress = config.isReuseAddress();
            ServerSocket serverSocket = this.serverSocketChannel.socket();
            this.logger.log(Level.FINEST, "inet reuseAddress:" + reuseAddress);
            serverSocket.setReuseAddress(reuseAddress);
            serverSocket.setSoTimeout(1000);
            int port = config.getPort();
            for (int i = 0; i < 100; ++i) {
                try {
                    boolean bindAny = this.node.getGroupProperties().SOCKET_BIND_ANY.getBoolean();
                    InetSocketAddress isa = bindAny ? new InetSocketAddress(port) : new InetSocketAddress(inetAddress, port);
                    this.logger.log(Level.FINEST, "inet socket address:" + isa);
                    serverSocket.bind(isa, 100);
                    break;
                }
                catch (Exception e) {
                    if (config.isPortAutoIncrement()) {
                        serverSocket = this.serverSocketChannel.socket();
                        serverSocket.setReuseAddress(reuseAddress);
                        ++port;
                        continue;
                    }
                    String msg = "Port [" + port + "] is already in use and auto-increment is " + "disabled. Hazelcast cannot start.";
                    this.logger.log(Level.SEVERE, msg, e);
                    throw e;
                }
            }
            this.serverSocketChannel.configureBlocking(false);
            return new Address(inetAddress, port);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
    }

    private InetAddress pickInetAddress(Collection<String> interfaces) throws SocketException {
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface ni = networkInterfaces.nextElement();
            Enumeration<InetAddress> e = ni.getInetAddresses();
            while (e.hasMoreElements()) {
                String address;
                InetAddress inetAddress = e.nextElement();
                if (!(interfaces != null && !interfaces.isEmpty() ? AddressPicker.matchAddress(address = inetAddress.getHostAddress(), interfaces) : !inetAddress.isLoopbackAddress())) continue;
                return inetAddress;
            }
        }
        return null;
    }
}

