/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.MemberSocketInterceptor;
import com.hazelcast.nio.SocketChannelWrapper;
import com.hazelcast.util.AddressUtil;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.logging.Level;

public class SocketConnector
implements Runnable {
    private final ConnectionManager connectionManager;
    private final Address address;
    private final ILogger logger;
    private final boolean silent;

    public SocketConnector(ConnectionManager connectionManager, Address address, boolean silent) {
        this.connectionManager = connectionManager;
        this.address = address;
        this.logger = connectionManager.ioService.getLogger(this.getClass().getName());
        this.silent = silent;
    }

    public void run() {
        if (!this.connectionManager.isLive()) {
            this.logger.log(Level.FINEST, "ConnectionManager is not live, connection attempt to " + this.address + " is cancelled!");
            return;
        }
        try {
            this.connectionManager.ioService.onIOThreadStart();
            Address thisAddress = this.connectionManager.ioService.getThisAddress();
            if (this.address.isIPv4()) {
                this.tryToConnect(this.address.getInetSocketAddress(), 0);
            } else if (thisAddress.isIPv6() && thisAddress.getScopeId() != null) {
                Inet6Address inetAddress = AddressUtil.getInetAddressFor((Inet6Address)this.address.getInetAddress(), thisAddress.getScopeId());
                this.tryToConnect(new InetSocketAddress(inetAddress, this.address.getPort()), 0);
            } else {
                Collection<Inet6Address> possibleInetAddresses = AddressUtil.getPossibleInetAddressesFor((Inet6Address)this.address.getInetAddress());
                this.logger.log(Level.INFO, "Trying to connect possible IPv6 addresses: " + possibleInetAddresses);
                boolean connected = false;
                Exception error = null;
                for (Inet6Address inetAddress : possibleInetAddresses) {
                    try {
                        this.tryToConnect(new InetSocketAddress(inetAddress, this.address.getPort()), 3000);
                        connected = true;
                        break;
                    }
                    catch (Exception e) {
                        error = e;
                    }
                }
                if (!connected) {
                    throw error;
                }
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.FINEST, e.getMessage(), e);
            this.connectionManager.failedConnection(this.address, e, this.silent);
        }
    }

    private void tryToConnect(InetSocketAddress socketAddress, int timeout) throws Exception {
        SocketChannel socketChannel = SocketChannel.open();
        this.connectionManager.initSocket(socketChannel.socket());
        if (!this.connectionManager.ioService.isSocketBindAny()) {
            Address thisAddress = this.connectionManager.ioService.getThisAddress();
            socketChannel.socket().bind(new InetSocketAddress(thisAddress.getInetAddress(), 0));
        }
        this.logger.log(Level.FINEST, "connecting to " + this.address);
        try {
            socketChannel.configureBlocking(true);
            if (timeout > 0) {
                socketChannel.socket().connect(socketAddress, timeout);
            } else {
                socketChannel.connect(socketAddress);
            }
            this.logger.log(Level.FINEST, "connection check. connected to: " + this.address);
            MemberSocketInterceptor memberSocketInterceptor = this.connectionManager.getMemberSocketInterceptor();
            if (memberSocketInterceptor != null) {
                memberSocketInterceptor.onConnect(socketChannel.socket());
            }
            socketChannel.configureBlocking(false);
            this.logger.log(Level.FINEST, "connected to " + this.address);
            SocketChannelWrapper socketChannelWrapper = this.connectionManager.wrapSocketChannel(socketChannel, true);
            Connection connection = this.connectionManager.assignSocketChannel(socketChannelWrapper);
            this.connectionManager.bind(this.address, connection, false);
        }
        catch (Exception e) {
            this.closeSocket(socketChannel);
            Level level = this.silent ? Level.FINEST : Level.INFO;
            this.logger.log(level, "Could not connect to: " + socketAddress + ". Reason: " + e.getClass().getSimpleName() + "[" + e.getMessage() + "]");
            throw e;
        }
    }

    private void closeSocket(SocketChannel socketChannel) {
        if (socketChannel != null) {
            try {
                socketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

