/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.partition;

import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.partition.DefaultMemberGroup;
import com.hazelcast.impl.partition.MemberGroup;
import com.hazelcast.impl.partition.MemberGroupFactory;
import com.hazelcast.nio.Address;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostAwareMemberGroupFactory
implements MemberGroupFactory {
    @Override
    public Collection<MemberGroup> createMemberGroups(Collection<MemberImpl> members) {
        Collection<MemberGroup> groups = this.createHostAwareMemberGroups(members);
        if (groups.size() == 1 && members.size() >= 2) {
            MemberGroup group1 = groups.iterator().next();
            DefaultMemberGroup group2 = new DefaultMemberGroup();
            int sizePerGroup = group1.size() / 2;
            Iterator<MemberImpl> iter = group1.iterator();
            while (group2.size() < sizePerGroup && iter.hasNext()) {
                group2.addMember(iter.next());
                iter.remove();
            }
            groups.add(group2);
        }
        return groups;
    }

    private Collection<MemberGroup> createHostAwareMemberGroups(Collection<MemberImpl> members) {
        HashMap<String, MemberGroup> groups = new HashMap<String, MemberGroup>();
        for (MemberImpl member : members) {
            if (member.isLiteMember()) continue;
            Address address = member.getAddress();
            MemberGroup group = (MemberGroup)groups.get(address.getHost());
            if (group == null) {
                group = new DefaultMemberGroup();
                groups.put(address.getHost(), group);
            }
            group.addMember(member);
        }
        return new HashSet<MemberGroup>(groups.values());
    }
}

