/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.partition;

import com.hazelcast.cluster.AbstractRemotelyProcessable;
import com.hazelcast.cluster.MemberInfo;
import com.hazelcast.impl.PartitionManager;
import com.hazelcast.impl.partition.PartitionInfo;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.util.Clock;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ClusterRuntimeState
extends AbstractRemotelyProcessable {
    private ArrayList<MemberInfo> members = new ArrayList(100);
    private ArrayList<ShortPartitionInfo> partitionInfos = new ArrayList(271);
    private long masterTime = Clock.currentTimeMillis();
    private int version;

    public ClusterRuntimeState(Collection<MemberInfo> memberInfos, PartitionInfo[] partitions, long masterTime, int version) {
        this.masterTime = masterTime;
        this.version = version;
        HashMap<Address, Integer> addressIndexes = new HashMap<Address, Integer>(memberInfos.size());
        int memberIndex = 0;
        for (MemberInfo memberInfo : memberInfos) {
            this.addMemberInfo(memberInfo, addressIndexes, memberIndex);
            ++memberIndex;
        }
        this.setPartitions(partitions, addressIndexes);
    }

    public ClusterRuntimeState() {
    }

    private void addMemberInfo(MemberInfo memberInfo, Map<Address, Integer> addressIndexes, int memberIndex) {
        this.members.add(memberIndex, memberInfo);
        addressIndexes.put(memberInfo.getAddress(), memberIndex);
    }

    private void setPartitions(PartitionInfo[] partitions, Map<Address, Integer> addressIndexes) {
        for (PartitionInfo partition : partitions) {
            ShortPartitionInfo spi = new ShortPartitionInfo(partition.getPartitionId());
            for (int i = 0; i < 7; ++i) {
                Address address = partition.getReplicaAddress(i);
                if (address == null) {
                    spi.addressIndexes[i] = -1;
                    continue;
                }
                Integer knownIndex = addressIndexes.get(address);
                spi.addressIndexes[i] = knownIndex == null ? -1 : knownIndex;
            }
            this.partitionInfos.add(spi);
        }
    }

    @Override
    public void process() {
        PartitionManager partitionManager = this.node.concurrentMapManager.getPartitionManager();
        partitionManager.setClusterRuntimeState(this);
    }

    public PartitionInfo[] getPartitions() {
        int size = this.partitionInfos.size();
        PartitionInfo[] partitions = new PartitionInfo[size];
        for (int i = 0; i < size; ++i) {
            ShortPartitionInfo spi = this.partitionInfos.get(i);
            PartitionInfo partition = new PartitionInfo(spi.partitionId, null);
            int[] addressIndexes = spi.addressIndexes;
            for (int c = 0; c < addressIndexes.length; ++c) {
                int index = addressIndexes[c];
                if (index == -1) continue;
                partition.setReplicaAddress(c, this.members.get(index).getAddress());
            }
            partitions[spi.partitionId] = partition;
        }
        return partitions;
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.masterTime = in.readLong();
        this.version = in.readInt();
        int size = in.readInt();
        HashMap<Address, Integer> addressIndexes = new HashMap<Address, Integer>(size);
        int memberIndex = 0;
        while (size-- > 0) {
            MemberInfo memberInfo = new MemberInfo();
            memberInfo.readData(in);
            this.addMemberInfo(memberInfo, addressIndexes, memberIndex);
            ++memberIndex;
        }
        int partitionCount = in.readInt();
        for (int i = 0; i < partitionCount; ++i) {
            ShortPartitionInfo spi = new ShortPartitionInfo();
            spi.readData(in);
            this.partitionInfos.add(spi);
        }
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeLong(this.masterTime);
        out.writeInt(this.version);
        int memberSize = this.members.size();
        out.writeInt(memberSize);
        for (int i = 0; i < memberSize; ++i) {
            MemberInfo memberInfo = this.members.get(i);
            memberInfo.writeData(out);
        }
        out.writeInt(this.partitionInfos.size());
        for (ShortPartitionInfo spi : this.partitionInfos) {
            spi.writeData(out);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClusterRuntimeState [" + this.version + "]{\n");
        for (MemberInfo address : this.members) {
            sb.append(address).append('\n');
        }
        sb.append('}');
        return sb.toString();
    }

    public int getVersion() {
        return this.version;
    }

    class ShortPartitionInfo
    implements DataSerializable {
        int partitionId;
        int[] addressIndexes = new int[7];

        ShortPartitionInfo(int partitionId) {
            this.partitionId = partitionId;
        }

        ShortPartitionInfo() {
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            out.writeInt(this.partitionId);
            for (int i = 0; i < 7; ++i) {
                out.writeInt(this.addressIndexes[i]);
            }
        }

        @Override
        public void readData(DataInput in) throws IOException {
            this.partitionId = in.readInt();
            for (int i = 0; i < 7; ++i) {
                this.addressIndexes[i] = in.readInt();
            }
        }
    }
}

