/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.impl.management.ConsoleRequest;
import com.hazelcast.impl.management.ManagementCenterService;
import com.hazelcast.impl.management.ThreadDumpCallable;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ThreadDumpRequest
implements ConsoleRequest {
    private boolean isDeadlock;
    private Address target;

    public ThreadDumpRequest() {
    }

    public ThreadDumpRequest(Address target, boolean deadlock) {
        this.target = target;
        this.isDeadlock = deadlock;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, DataOutput dos) throws Exception {
        String threadDump = (String)mcs.call(this.target, new ThreadDumpCallable(this.isDeadlock));
        if (threadDump != null) {
            dos.writeBoolean(true);
            IOUtil.writeLongString(dos, threadDump);
        } else {
            dos.writeBoolean(false);
        }
    }

    @Override
    public String readResponse(DataInput in) throws IOException {
        if (in.readBoolean()) {
            return IOUtil.readLongString(in);
        }
        return null;
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        this.target.writeData(out);
        out.writeBoolean(this.isDeadlock);
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.target = new Address();
        this.target.readData(in);
        this.isDeadlock = in.readBoolean();
    }
}

