/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.ascii;

public interface TextCommandConstants {
    public static final int MONTH_SECONDS = 2592000;
    public static final byte[] SPACE = new String(" ").getBytes();
    public static final byte[] RETURN = new String("\r\n").getBytes();
    public static final byte[] FLAG_ZERO = new String(" 0 ").getBytes();
    public static final byte[] VALUE_SPACE = new String("VALUE ").getBytes();
    public static final byte[] DELETED = new String("DELETED\r\n").getBytes();
    public static final byte[] STORED = new String("STORED\r\n").getBytes();
    public static final byte[] NOT_STORED = new String("NOT_STORED\r\n").getBytes();
    public static final byte[] NOT_FOUND = new String("NOT_FOUND\r\n").getBytes();
    public static final byte[] RETURN_END = new String("\r\nEND\r\n").getBytes();
    public static final byte[] END = new String("END\r\n").getBytes();
    public static final byte[] ERROR = new String("ERROR").getBytes();
    public static final byte[] CLIENT_ERROR = new String("CLIENT_ERROR ").getBytes();
    public static final byte[] SERVER_ERROR = new String("SERVER_ERROR ").getBytes();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextCommandType {
        GET(0),
        PARTIAL_GET(1),
        GETS(2),
        SET(3),
        APPEND(4),
        PREPEND(5),
        ADD(6),
        REPLACE(7),
        DELETE(8),
        QUIT(9),
        STATS(10),
        GET_END(11),
        ERROR_CLIENT(12),
        ERROR_SERVER(13),
        UNKNOWN(14),
        HTTP_GET(30),
        HTTP_POST(31),
        HTTP_PUT(32),
        HTTP_DELETE(33),
        NO_OP(98),
        STOP(99);

        final byte value;

        private TextCommandType(byte type) {
            this.value = type;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

