/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.AbstractRemotelyProcessable;
import com.hazelcast.config.Config;
import com.hazelcast.impl.NodeType;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.SerializationHelper;
import com.hazelcast.security.Credentials;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class JoinRequest
extends AbstractRemotelyProcessable {
    protected NodeType nodeType = NodeType.MEMBER;
    public Address address;
    public Address to;
    public byte packetVersion;
    public int buildNumber;
    public Config config;
    public String uuid;
    private Credentials credentials;

    public JoinRequest() {
    }

    public JoinRequest(Address address, Config config, NodeType type, byte packetVersion, int buildNumber, String nodeUuid) {
        this(null, address, config, type, packetVersion, buildNumber, nodeUuid);
    }

    public JoinRequest(Address to, Address address, Config config, NodeType type, byte packetVersion, int buildNumber, String nodeUuid) {
        this.to = to;
        this.address = address;
        this.config = config;
        this.nodeType = type;
        this.packetVersion = packetVersion;
        this.buildNumber = buildNumber;
        this.uuid = nodeUuid;
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.packetVersion = in.readByte();
        this.buildNumber = in.readInt();
        boolean hasTo = in.readBoolean();
        if (hasTo) {
            this.to = new Address();
            this.to.readData(in);
        }
        this.address = new Address();
        this.address.readData(in);
        this.nodeType = NodeType.create(in.readInt());
        this.config = new Config();
        this.config.readData(in);
        this.uuid = in.readUTF();
        boolean hasCredentials = in.readBoolean();
        if (hasCredentials) {
            this.credentials = (Credentials)SerializationHelper.readObject(in);
            if (this.credentials != null) {
                this.credentials.setEndpoint(this.address.getHost());
            }
        }
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeByte(this.packetVersion);
        out.writeInt(this.buildNumber);
        boolean hasTo = this.to != null;
        out.writeBoolean(hasTo);
        if (hasTo) {
            this.to.writeData(out);
        }
        this.address.writeData(out);
        out.writeInt(this.nodeType.getValue());
        this.config.writeData(out);
        out.writeUTF(this.uuid);
        boolean hasCredentials = this.credentials != null;
        out.writeBoolean(hasCredentials);
        if (hasCredentials) {
            SerializationHelper.writeObject(out, this.credentials);
        }
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String toString() {
        return "JoinRequest{nodeType=" + (Object)((Object)this.nodeType) + ", address=" + this.address + ", buildNumber='" + this.buildNumber + '\'' + ", packetVersion='" + this.packetVersion + '\'' + ", config='" + this.config + "'}";
    }

    @Override
    public void process() {
        this.getNode().clusterManager.handleJoinRequest(this);
    }
}

