/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web.tomcat;

import com.hazelcast.core.IMap;
import com.hazelcast.query.SqlPredicate;
import com.hazelcast.web.tomcat.HazelcastAttribute;
import com.hazelcast.web.tomcat.HazelcastClusterSupport;
import com.hazelcast.web.tomcat.HazelcastSessionFacade;
import com.hazelcast.web.tomcat.LocalRequestId;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.Enumerator;

public class HazelcastSession
extends StandardSession {
    static final String SESSION_MARK = "__hz_ses_mark";
    private static final String SESSION_MARK_EXCEPTION = "'__hz_ses_mark' is a reserved key for Hazelcast!";
    protected static final String info = "HazelcastSession/1.0";

    public HazelcastSession(Manager manager) {
        super(manager);
    }

    public HttpSession getSession() {
        if (this.facade == null) {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                final HazelcastSession fsession = this;
                this.facade = (HazelcastSessionFacade)((Object)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new HazelcastSessionFacade(fsession);
                    }
                }));
            } else {
                this.facade = new HazelcastSessionFacade(this);
            }
        }
        return this.facade;
    }

    public Object getAttribute(String name) {
        IMap<String, HazelcastAttribute> sessionMap;
        if (!this.isValidInternal()) {
            throw new IllegalStateException(sm.getString("standardSession.getAttribute.ise"));
        }
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("standardSession.setAttribute.namenull"));
        }
        if (SESSION_MARK.equals(name)) {
            throw new IllegalArgumentException(SESSION_MARK_EXCEPTION);
        }
        HazelcastAttribute attribute = (HazelcastAttribute)this.attributes.get(name);
        if (attribute == null && (attribute = (HazelcastAttribute)(sessionMap = HazelcastClusterSupport.get().getAttributesMap()).get(this.getIdInternal() + "_" + name)) == null) {
            this.attributes.put(name, new HazelcastAttribute(this.getIdInternal(), name, null));
            return null;
        }
        long requestId = LocalRequestId.get();
        attribute.touch(requestId);
        return attribute.getValue();
    }

    public Object getLocalAttribute(String name) {
        return super.getAttribute(name);
    }

    public void setAttribute(String name, Object value, boolean notify) {
        Object unboundValue;
        HazelcastAttribute oldAttribute;
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("standardSession.setAttribute.namenull"));
        }
        if (SESSION_MARK.equals(name)) {
            throw new IllegalArgumentException(SESSION_MARK_EXCEPTION);
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (!this.isValidInternal()) {
            throw new IllegalStateException(sm.getString("standardSession.setAttribute.ise"));
        }
        if (this.manager != null && this.manager.getDistributable() && !(value instanceof Serializable)) {
            throw new IllegalArgumentException(sm.getString("standardSession.setAttribute.iae"));
        }
        HttpSessionBindingEvent event = null;
        if (notify && value instanceof HttpSessionBindingListener && (oldAttribute = (HazelcastAttribute)this.attributes.get(name)) != null && value != oldAttribute.getValue()) {
            event = new HttpSessionBindingEvent(this.getSession(), name, value);
            try {
                ((HttpSessionBindingListener)value).valueBound(event);
            }
            catch (Throwable t) {
                this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.bindingEvent"), t);
            }
        }
        HazelcastAttribute attribute = new HazelcastAttribute(this.getIdInternal(), name, value);
        long requestId = LocalRequestId.get();
        attribute.touch(requestId);
        HazelcastAttribute unboundAttribute = this.attributes.put(name, attribute);
        Object object = unboundValue = unboundAttribute != null ? unboundAttribute.getValue() : null;
        if (notify && unboundValue != null && unboundValue != value && unboundValue instanceof HttpSessionBindingListener) {
            try {
                ((HttpSessionBindingListener)unboundValue).valueUnbound(new HttpSessionBindingEvent(this.getSession(), name));
            }
            catch (Throwable t) {
                this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.bindingEvent"), t);
            }
        }
        if (!notify) {
            return;
        }
        Context context = (Context)this.manager.getContainer();
        Object[] listeners = context.getApplicationEventListeners();
        if (listeners == null) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof HttpSessionAttributeListener)) continue;
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners[i];
            try {
                if (unboundValue != null) {
                    this.fireContainerEvent(context, "beforeSessionAttributeReplaced", listener);
                    if (event == null) {
                        event = new HttpSessionBindingEvent(this.getSession(), name, unboundValue);
                    }
                    listener.attributeReplaced(event);
                    this.fireContainerEvent(context, "afterSessionAttributeReplaced", listener);
                    continue;
                }
                this.fireContainerEvent(context, "beforeSessionAttributeAdded", listener);
                if (event == null) {
                    event = new HttpSessionBindingEvent(this.getSession(), name, value);
                }
                listener.attributeAdded(event);
                this.fireContainerEvent(context, "afterSessionAttributeAdded", listener);
                continue;
            }
            catch (Throwable t) {
                try {
                    if (unboundValue != null) {
                        this.fireContainerEvent(context, "afterSessionAttributeReplaced", listener);
                    } else {
                        this.fireContainerEvent(context, "afterSessionAttributeAdded", listener);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.attributeEvent"), t);
            }
        }
    }

    protected void removeAttributeInternal(String name, boolean notify) {
        if (name == null) {
            return;
        }
        if (name.equals(SESSION_MARK)) {
            throw new IllegalArgumentException(SESSION_MARK_EXCEPTION);
        }
        HazelcastAttribute attribute = (HazelcastAttribute)this.attributes.remove(name);
        if (attribute == null || attribute.getValue() == null) {
            return;
        }
        Object value = attribute.getValue();
        attribute.setValue(null);
        long requestId = LocalRequestId.get();
        attribute.touch(requestId);
        this.attributes.put(name, attribute);
        this.notifyRemove(name, value, notify);
    }

    protected void removeAttributeHard(String name, boolean notify) {
        if (name == null) {
            return;
        }
        HazelcastAttribute attribute = (HazelcastAttribute)this.attributes.remove(name);
        if (attribute == null) {
            return;
        }
        Object value = attribute.getValue();
        IMap<String, HazelcastAttribute> sessionAttrMap = HazelcastClusterSupport.get().getAttributesMap();
        sessionAttrMap.remove(attribute.getKey());
        this.notifyRemove(name, value, notify);
    }

    protected void notifyRemove(String name, Object value, boolean notify) {
        Context context;
        Object[] listeners;
        if (!notify || value == null) {
            return;
        }
        HttpSessionBindingEvent event = null;
        if (value instanceof HttpSessionBindingListener) {
            event = new HttpSessionBindingEvent(this.getSession(), name, value);
            ((HttpSessionBindingListener)value).valueUnbound(event);
        }
        if ((listeners = (context = (Context)this.manager.getContainer()).getApplicationEventListeners()) == null) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof HttpSessionAttributeListener)) continue;
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners[i];
            try {
                this.fireContainerEvent(context, "beforeSessionAttributeRemoved", listener);
                if (event == null) {
                    event = new HttpSessionBindingEvent(this.getSession(), name, value);
                }
                listener.attributeRemoved(event);
                this.fireContainerEvent(context, "afterSessionAttributeRemoved", listener);
                continue;
            }
            catch (Throwable t) {
                try {
                    this.fireContainerEvent(context, "afterSessionAttributeRemoved", listener);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.attributeEvent"), t);
            }
        }
    }

    public void activate() {
        if (ACTIVITY_CHECK) {
            this.accessCount = new AtomicInteger();
        }
        this.fireSessionEvent("activateSession", null);
        HttpSessionEvent event = null;
        String[] keys = this.keys();
        for (int i = 0; i < keys.length; ++i) {
            Object attribute = ((HazelcastAttribute)this.attributes.get(keys[i])).getValue();
            if (!(attribute instanceof HttpSessionActivationListener)) continue;
            if (event == null) {
                event = new HttpSessionEvent(this.getSession());
            }
            try {
                ((HttpSessionActivationListener)attribute).sessionDidActivate(event);
                continue;
            }
            catch (Throwable t) {
                this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.attributeEvent"), t);
            }
        }
    }

    public void passivate() {
        this.fireSessionEvent("passivateSession", null);
        HttpSessionEvent event = null;
        String[] keys = this.keys();
        for (int i = 0; i < keys.length; ++i) {
            Object attribute = ((HazelcastAttribute)this.attributes.get(keys[i])).getValue();
            if (!(attribute instanceof HttpSessionActivationListener)) continue;
            if (event == null) {
                event = new HttpSessionEvent(this.getSession());
            }
            try {
                ((HttpSessionActivationListener)attribute).sessionWillPassivate(event);
                continue;
            }
            catch (Throwable t) {
                this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.attributeEvent"), t);
            }
        }
    }

    protected void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        this.authType = null;
        this.creationTime = (Long)stream.readObject();
        this.lastAccessedTime = (Long)stream.readObject();
        this.maxInactiveInterval = (Integer)stream.readObject();
        this.isNew = (Boolean)stream.readObject();
        this.isValid = (Boolean)stream.readObject();
        this.thisAccessedTime = (Long)stream.readObject();
        this.principal = null;
        this.id = (String)stream.readObject();
        if (this.manager.getContainer().getLogger().isDebugEnabled()) {
            this.manager.getContainer().getLogger().debug((Object)("readObject() loading session " + this.id));
        }
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        int n = (Integer)stream.readObject();
        boolean isValidSave = this.isValid;
        this.isValid = true;
        for (int i = 0; i < n; ++i) {
            String name = (String)stream.readObject();
            Object value = stream.readObject();
            if (value instanceof String && value.equals("___NOT_SERIALIZABLE_EXCEPTION___")) continue;
            if (this.manager.getContainer().getLogger().isDebugEnabled()) {
                this.manager.getContainer().getLogger().debug((Object)("  loading attribute '" + name + "' with value '" + value + "'"));
            }
            this.attributes.put(name, new HazelcastAttribute(this.id, name, value));
        }
        this.attributes.put(SESSION_MARK, new HazelcastAttribute(this.id, SESSION_MARK, System.currentTimeMillis()));
        this.isValid = isValidSave;
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (this.notes == null) {
            this.notes = new Hashtable();
        }
    }

    protected void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(new Long(this.creationTime));
        stream.writeObject(new Long(this.lastAccessedTime));
        stream.writeObject(new Integer(this.maxInactiveInterval));
        stream.writeObject(new Boolean(this.isNew));
        stream.writeObject(new Boolean(this.isValid));
        stream.writeObject(new Long(this.thisAccessedTime));
        stream.writeObject(this.id);
        if (this.manager.getContainer().getLogger().isDebugEnabled()) {
            this.manager.getContainer().getLogger().debug((Object)("writeObject() storing session " + this.id));
        }
        String[] keys = this.keys();
        ArrayList<String> saveNames = new ArrayList<String>();
        ArrayList<Object> saveValues = new ArrayList<Object>();
        for (int i = 0; i < keys.length; ++i) {
            Object value;
            HazelcastAttribute hattribute = (HazelcastAttribute)this.attributes.get(keys[i]);
            if (hattribute == null || (value = hattribute.getValue()) == null) continue;
            if (value instanceof Serializable && !this.exclude(keys[i])) {
                saveNames.add(keys[i]);
                saveValues.add(value);
                continue;
            }
            this.removeAttributeInternal(keys[i], true);
        }
        int n = saveNames.size();
        stream.writeObject(new Integer(n));
        for (int i = 0; i < n; ++i) {
            stream.writeObject((String)saveNames.get(i));
            try {
                stream.writeObject(saveValues.get(i));
                if (!this.manager.getContainer().getLogger().isDebugEnabled()) continue;
                this.manager.getContainer().getLogger().debug((Object)("  storing attribute '" + saveNames.get(i) + "' with value '" + saveValues.get(i) + "'"));
                continue;
            }
            catch (NotSerializableException e) {
                this.manager.getContainer().getLogger().warn((Object)sm.getString("standardSession.notSerializable", saveNames.get(i), (Object)this.id), (Throwable)e);
                stream.writeObject("___NOT_SERIALIZABLE_EXCEPTION___");
                if (!this.manager.getContainer().getLogger().isDebugEnabled()) continue;
                this.manager.getContainer().getLogger().debug((Object)("  storing attribute '" + saveNames.get(i) + "' with value NOT_SERIALIZED"));
            }
        }
    }

    public void setId(String id) {
        if (this.id != null && this.manager != null) {
            this.manager.remove((Session)this);
        }
        this.id = id;
        IMap<String, HazelcastAttribute> sessionAttrMap = HazelcastClusterSupport.get().getAttributesMap();
        Collection<HazelcastAttribute> colAttributes = sessionAttrMap.values(new SqlPredicate("sessionId=" + id));
        if (colAttributes.size() != 0) {
            for (HazelcastAttribute hattribute : colAttributes) {
                this.attributes.put(hattribute.getName(), hattribute);
            }
        } else {
            HazelcastAttribute mark = new HazelcastAttribute(id, SESSION_MARK, System.currentTimeMillis());
            sessionAttrMap.put(mark.getKey(), mark);
            this.attributes.put(SESSION_MARK, mark);
        }
        if (this.manager != null) {
            this.manager.add((Session)this);
        }
        this.tellNew();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(boolean notify) {
        if (this.expiring) {
            return;
        }
        HazelcastSession hazelcastSession = this;
        synchronized (hazelcastSession) {
            Manager listener;
            if (this.manager == null) {
                return;
            }
            this.expiring = true;
            Context context = (Context)this.manager.getContainer();
            Object[] listeners = context.getApplicationLifecycleListeners();
            if (notify && listeners != null) {
                HttpSessionEvent event = new HttpSessionEvent(this.getSession());
                for (int i = 0; i < listeners.length; ++i) {
                    int j = listeners.length - 1 - i;
                    if (!(listeners[j] instanceof HttpSessionListener)) continue;
                    listener = (HttpSessionListener)listeners[j];
                    try {
                        this.fireContainerEvent(context, "beforeSessionDestroyed", listener);
                        listener.sessionDestroyed(event);
                        this.fireContainerEvent(context, "afterSessionDestroyed", listener);
                        continue;
                    }
                    catch (Throwable t) {
                        try {
                            this.fireContainerEvent(context, "afterSessionDestroyed", listener);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.sessionEvent"), t);
                    }
                }
            }
            if (ACTIVITY_CHECK) {
                this.accessCount.set(0);
            }
            this.setValid(false);
            long timeNow = System.currentTimeMillis();
            int timeAlive = (int)((timeNow - this.creationTime) / 1000L);
            listener = this.manager;
            synchronized (listener) {
                if (timeAlive > this.manager.getSessionMaxAliveTime()) {
                    this.manager.setSessionMaxAliveTime(timeAlive);
                }
                int numExpired = this.manager.getExpiredSessions();
                this.manager.setExpiredSessions(++numExpired);
                int average = this.manager.getSessionAverageAliveTime();
                average = (average * (numExpired - 1) + timeAlive) / numExpired;
                this.manager.setSessionAverageAliveTime(average);
            }
            this.manager.remove((Session)this);
            if (notify) {
                this.fireSessionEvent("destroySession", null);
            }
            this.expiring = false;
            String[] keys = this.keys();
            for (int i = 0; i < keys.length; ++i) {
                this.removeAttributeHard(keys[i], notify);
            }
            this.removeAttributeHard(SESSION_MARK, notify);
        }
    }

    protected String[] keys() {
        Set keySet = this.attributes.keySet();
        keySet.remove(SESSION_MARK);
        return keySet.toArray(EMPTY_ARRAY);
    }

    public Enumeration getAttributeNames() {
        if (!this.isValidInternal()) {
            throw new IllegalStateException(sm.getString("standardSession.getAttributeNames.ise"));
        }
        Set keySet = this.attributes.keySet();
        keySet.remove(SESSION_MARK);
        return new Enumerator(keySet, true);
    }
}

