/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query;

import com.hazelcast.query.EntryKeyObject;
import com.hazelcast.query.Expression;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.PredicateBuilder;
import com.hazelcast.query.Predicates;

public class EntryObject {
    PredicateBuilder qb;

    public EntryObject(PredicateBuilder qb) {
        this.qb = qb;
    }

    public EntryObject get(String property) {
        this.qb.exp = Predicates.get(property);
        return this;
    }

    public PredicateBuilder is(String property) {
        return this.addPredicate(Predicates.equal(Predicates.get(property), true));
    }

    public EntryObject key() {
        EntryKeyObject expression;
        this.qb.exp = expression = new EntryKeyObject();
        return this;
    }

    public PredicateBuilder equal(Object value) {
        return this.addPredicate(Predicates.equal(this.qb.exp, value));
    }

    public PredicateBuilder notEqual(Object value) {
        return this.addPredicate(Predicates.notEqual(this.qb.exp, value));
    }

    public PredicateBuilder isNull() {
        return this.addPredicate(Predicates.equal(this.qb.exp, null));
    }

    public PredicateBuilder isNotNull() {
        return this.addPredicate(Predicates.notEqual(this.qb.exp, null));
    }

    public PredicateBuilder greaterThan(Comparable value) {
        return this.addPredicate(Predicates.greaterThan(this.qb.exp, value));
    }

    public PredicateBuilder greaterEqual(Comparable value) {
        return this.addPredicate(Predicates.greaterEqual(this.qb.exp, value));
    }

    public PredicateBuilder lessThan(Comparable value) {
        return this.addPredicate(Predicates.lessThan(this.qb.exp, value));
    }

    public PredicateBuilder lessEqual(Comparable value) {
        return this.addPredicate(Predicates.lessEqual(this.qb.exp, value));
    }

    public PredicateBuilder between(Comparable from, Comparable to) {
        return this.addPredicate(Predicates.between(this.qb.exp, from, to));
    }

    public PredicateBuilder in(Comparable ... values) {
        return this.addPredicate(Predicates.in((Expression)this.qb.exp, (Comparable[])values));
    }

    private PredicateBuilder addPredicate(Predicate predicate) {
        this.qb.lsPredicates.add(predicate);
        return this.qb;
    }
}

