/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class Address
implements DataSerializable {
    private static final long serialVersionUID = -7626390274220424603L;
    private byte[] ip;
    private int port = -1;

    public Address() {
        this.ip = new byte[4];
    }

    public Address(InetSocketAddress inetSocketAddress) {
        this.ip = inetSocketAddress.getAddress().getAddress();
        this.port = inetSocketAddress.getPort();
    }

    public Address(InetAddress inetAddress, int port) {
        this(new InetSocketAddress(inetAddress, port));
    }

    public Address(Address address) {
        this.ip = address.copyIP();
        this.port = address.getPort();
    }

    public Address(String address, int port) throws UnknownHostException {
        this.port = port;
        this.ip = InetAddress.getByName(address).getAddress();
    }

    public Address(byte[] ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public static String toString(byte[] ip) {
        return (ip[0] & 0xFF) + "." + (ip[1] & 0xFF) + "." + (ip[2] & 0xFF) + "." + (ip[3] & 0xFF);
    }

    public void writeData(DataOutput out) throws IOException {
        out.write(this.ip);
        out.writeInt(this.port);
    }

    public void readData(DataInput in) throws IOException {
        in.readFully(this.ip);
        this.port = in.readInt();
    }

    public void readObject(ByteBuffer buffer) {
        buffer.get(this.ip);
        this.port = buffer.getInt();
    }

    public void writeObject(ByteBuffer buffer) {
        buffer.put(this.ip);
        buffer.putInt(this.port);
    }

    public String getHost() {
        return Address.toString(this.ip);
    }

    public String toString() {
        return "Address[" + this.getHost() + ":" + this.port + "]";
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        return this.getInetSocketAddress().getAddress();
    }

    public InetSocketAddress getInetSocketAddress() throws UnknownHostException {
        return new InetSocketAddress(InetAddress.getByName(this.getHost()), this.port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address address = (Address)o;
        return this.port == address.port && Arrays.equals(this.ip, address.ip);
    }

    public int hashCode() {
        return this.hash(this.ip) * 29 + this.port;
    }

    private int hash(byte[] bytes) {
        int hash = 0;
        for (byte b : bytes) {
            hash = hash * 29 + b;
        }
        return hash;
    }

    public byte[] copyIP() {
        byte[] newOne = new byte[this.ip.length];
        System.arraycopy(this.ip, 0, newOne, 0, this.ip.length);
        return newOne;
    }
}

