/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.instance;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

class ConfigLoader {
    ConfigLoader() {
    }

    public static URL locateConfig(String path) {
        URL url = ConfigLoader.asFile(path);
        if (url == null) {
            url = ConfigLoader.asURL(path);
        }
        if (url == null) {
            url = ConfigLoader.asResource(path);
        }
        return url;
    }

    private static URL asFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private static URL asURL(String path) {
        try {
            return new URL(path);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static final URL asResource(String path) {
        URL url = null;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            url = contextClassLoader.getResource(path);
        }
        if (url == null) {
            url = ConfigLoader.class.getClassLoader().getResource(path);
        }
        if (url == null) {
            url = ClassLoader.getSystemClassLoader().getResource(path);
        }
        return url;
    }
}

