/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.Packet;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.core.ILock;
import com.hazelcast.core.Instance;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.monitor.LocalLockStats;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public class LockClientProxy
implements ILock {
    final ProxyHelper proxyHelper;
    final Object lockObject;

    public LockClientProxy(Object object, HazelcastClient client) {
        this.proxyHelper = new ProxyHelper("", client);
        this.lockObject = object;
        ProxyHelper.check(this.lockObject);
    }

    public Object getLockObject() {
        return this.lockObject;
    }

    public void lockInterruptibly() throws InterruptedException {
        throw new UnsupportedOperationException("lockInterruptibly is not implemented!");
    }

    public void lock() {
        this.doLock(-1L, null);
    }

    public boolean tryLock() {
        return (Boolean)this.doLock(0L, null);
    }

    public boolean tryLock(long time, TimeUnit timeunit) {
        ProxyHelper.checkTime(time, timeunit);
        return (Boolean)this.doLock(time, timeunit);
    }

    public void unlock() {
        this.proxyHelper.doOp(ClusterOperation.LOCK_UNLOCK, this.lockObject, null);
    }

    public void forceUnlock() {
        this.proxyHelper.doOp(ClusterOperation.LOCK_FORCE_UNLOCK, this.lockObject, null);
    }

    private Object doLock(long timeout, TimeUnit timeUnit) {
        ClusterOperation operation = ClusterOperation.LOCK_LOCK;
        Packet request = this.proxyHelper.prepareRequest(operation, this.lockObject, null);
        request.setTimeout(timeUnit == null ? timeout : timeUnit.toMillis(timeout));
        Packet response = this.proxyHelper.callAndGetResult(request);
        return ProxyHelper.getValue(response);
    }

    public Condition newCondition() {
        return null;
    }

    public Instance.InstanceType getInstanceType() {
        return Instance.InstanceType.LOCK;
    }

    public void destroy() {
        this.proxyHelper.destroy();
    }

    public Object getId() {
        return new FactoryImpl.ProxyKey("lock", this.lockObject);
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof ILock) {
            return this.getId().equals(((ILock)o).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public LocalLockStats getLocalLockStats() {
        throw new UnsupportedOperationException();
    }
}

