/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.client.ClientConfig;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.config.GroupConfig;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HazelcastClientBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlBuilder springXmlBuilder = new SpringXmlBuilder(parserContext);
        springXmlBuilder.handle(element);
        return springXmlBuilder.getBeanDefinition();
    }

    private static class SpringXmlBuilder
    extends AbstractXmlConfigHelper {
        private final ParserContext parserContext;
        private BeanDefinitionBuilder builder;
        private ManagedList members;
        private BeanDefinitionBuilder configBuilder;
        private BeanDefinitionBuilder groupConfigBuilder;

        public SpringXmlBuilder(ParserContext parserContext) {
            this.parserContext = parserContext;
            this.builder = BeanDefinitionBuilder.rootBeanDefinition(HazelcastClient.class);
            this.builder.setFactoryMethod("newHazelcastClient");
            this.builder.setDestroyMethodName("shutdown");
            this.members = new ManagedList();
            this.configBuilder = this.createBeanBuilder(ClientConfig.class, "client-config");
            this.groupConfigBuilder = this.createBeanBuilder(GroupConfig.class, "client-group-config");
            this.configBuilder.addPropertyValue("groupConfig", (Object)this.groupConfigBuilder.getBeanDefinition());
        }

        protected BeanDefinitionBuilder createBeanBuilder(Class clazz, String id) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((Class)clazz);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, id);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)this.parserContext.getRegistry());
            return builder;
        }

        public AbstractBeanDefinition getBeanDefinition() {
            return this.builder.getBeanDefinition();
        }

        public void handle(Element element) {
            NamedNodeMap attrs = element.getAttributes();
            if (attrs != null) {
                for (int a = 0; a < attrs.getLength(); ++a) {
                    Node att = attrs.item(a);
                    String name = att.getNodeName();
                    String value = att.getNodeValue();
                    if ("group-name".equals(name)) {
                        this.groupConfigBuilder.addPropertyValue("name", (Object)value);
                        continue;
                    }
                    if ("group-password".equals(name)) {
                        this.groupConfigBuilder.addPropertyValue("password", (Object)value);
                        continue;
                    }
                    if ("auto-update-members".equals(name)) {
                        this.configBuilder.addPropertyValue("updateAutomatic", (Object)value);
                        continue;
                    }
                    if ("shuffle-members".equals(name)) {
                        this.configBuilder.addPropertyValue("shuffle", (Object)value);
                        continue;
                    }
                    if ("connect-attempt-limit".equals(name)) {
                        this.configBuilder.addPropertyValue("initialConnectionAttemptLimit", (Object)value);
                        continue;
                    }
                    if ("connect-timeout".equals(name)) {
                        this.configBuilder.addPropertyValue("connectionTimeout", (Object)value);
                        continue;
                    }
                    if ("reconnect-attempt-limit".equals(name)) {
                        this.configBuilder.addPropertyValue("reconnectionAttemptLimit", (Object)value);
                        continue;
                    }
                    if ("reconnect-timeout".equals(name)) {
                        this.configBuilder.addPropertyValue("reConnectionTimeOut", (Object)value);
                        continue;
                    }
                    if (!"credentials-ref".equals(name)) continue;
                    this.configBuilder.addPropertyReference("credentials", value);
                }
            }
            for (Node node : new AbstractXmlConfigHelper.IterableNodeList(element, 1)) {
                String nodeName = SpringXmlBuilder.cleanNodeName(node.getNodeName());
                if (!"member".equals(nodeName)) continue;
                this.members.add((Object)this.getValue(node));
            }
            this.configBuilder.addPropertyValue("addresses", (Object)this.members);
            this.builder.addConstructorArgValue((Object)this.configBuilder.getBeanDefinition());
        }
    }
}

