/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.examples;

import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAwareObject;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Instance;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.core.MultiTask;
import com.hazelcast.examples.LineReader;
import com.hazelcast.partition.Partition;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestApp
implements EntryListener,
ItemListener,
MessageListener {
    private IQueue<Object> queue = null;
    private ITopic<Object> topic = null;
    private IMap<Object, Object> map = null;
    private ISet<Object> set = null;
    private IList<Object> list = null;
    private String namespace = "default";
    private boolean silent = false;
    private boolean echo = false;
    private volatile HazelcastInstance hazelcast;
    private volatile LineReader lineReader;
    private volatile boolean running = false;

    public TestApp(HazelcastInstance hazelcast) {
        this.hazelcast = hazelcast;
    }

    public IQueue<Object> getQueue() {
        this.queue = this.hazelcast.getQueue(this.namespace);
        return this.queue;
    }

    public ITopic<Object> getTopic() {
        this.topic = this.hazelcast.getTopic(this.namespace);
        return this.topic;
    }

    public IMap<Object, Object> getMap() {
        this.map = this.hazelcast.getMap(this.namespace);
        return this.map;
    }

    public ISet<Object> getSet() {
        this.set = this.hazelcast.getSet(this.namespace);
        return this.set;
    }

    public IList<Object> getList() {
        this.list = this.hazelcast.getList(this.namespace);
        return this.list;
    }

    public void setHazelcast(HazelcastInstance hazelcast) {
        this.hazelcast = hazelcast;
        this.map = null;
        this.list = null;
        this.set = null;
        this.queue = null;
        this.topic = null;
    }

    public static void main(String[] args) throws Exception {
        TestApp testApp = new TestApp(Hazelcast.getDefaultInstance());
        testApp.start(args);
    }

    public void stop() {
        this.running = false;
    }

    public void start(String[] args) throws Exception {
        if (this.lineReader == null) {
            this.lineReader = new DefaultLineReader();
        }
        this.running = true;
        while (this.running) {
            this.print("hazelcast[" + this.namespace + "] > ");
            try {
                String command = this.lineReader.readLine();
                this.handleCommand(command);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void setLineReader(LineReader lineReader) {
        this.lineReader = lineReader;
    }

    protected void handleCommand(String command) {
        if (this.echo) {
            if (Thread.currentThread().getName().toLowerCase().indexOf("main") < 0) {
                this.println(" [" + Thread.currentThread().getName() + "] " + command);
            } else {
                this.println(command);
            }
        }
        if (command == null || command.startsWith("//")) {
            return;
        }
        if ((command = command.trim()) == null || command.length() == 0) {
            return;
        }
        String first = command;
        int spaceIndex = command.indexOf(32);
        String[] argsSplit = command.split(" ");
        String[] args = new String[argsSplit.length];
        for (int i = 0; i < argsSplit.length; ++i) {
            args[i] = argsSplit[i].trim();
        }
        if (spaceIndex != -1) {
            first = args[0];
        }
        if (command.startsWith("help")) {
            this.handleHelp(command);
        } else {
            if (first.startsWith("#") && first.length() > 1) {
                int repeat = Integer.parseInt(first.substring(1));
                long t0 = System.currentTimeMillis();
                for (int i = 0; i < repeat; ++i) {
                    this.handleCommand(command.substring(first.length()).replaceAll("\\$i", "" + i));
                }
                this.println("ops/s = " + (long)(repeat * 1000) / (System.currentTimeMillis() - t0));
                return;
            }
            if (first.startsWith("&") && first.length() > 1) {
                int fork = Integer.parseInt(first.substring(1));
                ExecutorService pool = Executors.newFixedThreadPool(fork);
                final String threadCommand = command.substring(first.length());
                int i = 0;
                while (i < fork) {
                    final int threadID = i++;
                    pool.submit(new Runnable(){

                        public void run() {
                            String command = threadCommand;
                            String[] threadArgs = command.replaceAll("\\$t", "" + threadID).trim().split(" ");
                            if (("m.putmany".equals(threadArgs[0]) || "m.removemany".equals(threadArgs[0])) && threadArgs.length < 4) {
                                command = command + " " + Integer.parseInt(threadArgs[1]) * threadID;
                            }
                            TestApp.this.handleCommand(command);
                        }
                    });
                }
                pool.shutdown();
                try {
                    pool.awaitTermination(3600L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (first.startsWith("@")) {
                if (first.length() == 1) {
                    this.println("usage: @<file-name>");
                    return;
                }
                File f = new File(first.substring(1));
                this.println("Executing script file " + f.getAbsolutePath());
                if (f.exists()) {
                    try {
                        BufferedReader br = new BufferedReader(new FileReader(f));
                        String l = br.readLine();
                        while (l != null) {
                            this.handleCommand(l);
                            l = br.readLine();
                        }
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.println("File not found! " + f.getAbsolutePath());
                }
            } else {
                if (command.indexOf(59) != -1) {
                    StringTokenizer st = new StringTokenizer(command, ";");
                    while (st.hasMoreTokens()) {
                        this.handleCommand(st.nextToken());
                    }
                    return;
                }
                if ("silent".equals(first)) {
                    this.silent = Boolean.parseBoolean(args[1]);
                } else if ("restart".equals(first)) {
                    this.hazelcast.restart();
                } else if ("shutdown".equals(first)) {
                    this.hazelcast.shutdown();
                } else if ("echo".equals(first)) {
                    this.echo = Boolean.parseBoolean(args[1]);
                    this.println("echo: " + this.echo);
                } else if ("ns".equals(first)) {
                    if (args.length > 1) {
                        this.namespace = args[1];
                        this.println("namespace: " + this.namespace);
                    }
                } else if ("whoami".equals(first)) {
                    this.println(this.hazelcast.getCluster().getLocalMember());
                } else if ("who".equals(first)) {
                    this.println(this.hazelcast.getCluster());
                } else if ("jvm".equals(first)) {
                    System.gc();
                    this.println("Memory max: " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + "M");
                    this.println("Memory free: " + Runtime.getRuntime().freeMemory() / 1024L / 1024L + "M " + (int)(Runtime.getRuntime().freeMemory() * 100L / Runtime.getRuntime().maxMemory()) + "%");
                    long total = Runtime.getRuntime().totalMemory();
                    long free = Runtime.getRuntime().freeMemory();
                    this.println("Used Memory:" + (total - free) / 1024L / 1024L + "MB");
                    this.println("# procs: " + Runtime.getRuntime().availableProcessors());
                    this.println("OS info: " + ManagementFactory.getOperatingSystemMXBean().getArch() + " " + ManagementFactory.getOperatingSystemMXBean().getName() + " " + ManagementFactory.getOperatingSystemMXBean().getVersion());
                    this.println("JVM: " + ManagementFactory.getRuntimeMXBean().getVmVendor() + " " + ManagementFactory.getRuntimeMXBean().getVmName() + " " + ManagementFactory.getRuntimeMXBean().getVmVersion());
                } else if (first.indexOf("ock") != -1 && first.indexOf(".") == -1) {
                    this.handleLock(args);
                } else if (first.indexOf(".size") != -1) {
                    this.handleSize(args);
                } else if (first.indexOf(".clear") != -1) {
                    this.handleClear(args);
                } else if (first.indexOf(".destroy") != -1) {
                    this.handleDestroy(args);
                } else if (first.indexOf(".iterator") != -1) {
                    this.handleIterator(args);
                } else if (first.indexOf(".contains") != -1) {
                    this.handleContains(args);
                } else if (first.indexOf(".stats") != -1) {
                    this.handStats(args);
                } else if ("t.publish".equals(first)) {
                    this.handleTopicPublish(args);
                } else if ("q.offer".equals(first)) {
                    this.handleQOffer(args);
                } else if ("q.take".equals(first)) {
                    this.handleQTake(args);
                } else if ("q.poll".equals(first)) {
                    this.handleQPoll(args);
                } else if ("q.peek".equals(first)) {
                    this.handleQPeek(args);
                } else if ("q.capacity".equals(first)) {
                    this.handleQCapacity(args);
                } else if ("q.offermany".equals(first)) {
                    this.handleQOfferMany(args);
                } else if ("q.pollmany".equals(first)) {
                    this.handleQPollMany(args);
                } else if ("s.add".equals(first)) {
                    this.handleSetAdd(args);
                } else if ("s.remove".equals(first)) {
                    this.handleSetRemove(args);
                } else if ("s.addmany".equals(first)) {
                    this.handleSetAddMany(args);
                } else if ("s.removemany".equals(first)) {
                    this.handleSetRemoveMany(args);
                } else if (first.equals("m.replace")) {
                    this.handleMapReplace(args);
                } else if (first.equalsIgnoreCase("m.putIfAbsent")) {
                    this.handleMapPutIfAbsent(args);
                } else if (first.equals("m.putAsync")) {
                    this.handleMapPutAsync(args);
                } else if (first.equals("m.getAsync")) {
                    this.handleMapGetAsync(args);
                } else if (first.equals("m.put")) {
                    this.handleMapPut(args);
                } else if (first.equals("m.get")) {
                    this.handleMapGet(args);
                } else if (first.equalsIgnoreCase("m.getMapEntry")) {
                    this.handleMapGetMapEntry(args);
                } else if (first.equals("m.remove")) {
                    this.handleMapRemove(args);
                } else if (first.equals("m.evict")) {
                    this.handleMapEvict(args);
                } else if (first.equals("m.putmany") || first.equalsIgnoreCase("m.putAll")) {
                    this.handleMapPutMany(args);
                } else if (first.equals("m.getmany")) {
                    this.handleMapGetMany(args);
                } else if (first.equals("m.removemany")) {
                    this.handleMapRemoveMany(args);
                } else if (command.equalsIgnoreCase("m.localKeys")) {
                    this.handleMapLocalKeys();
                } else if (command.equals("m.keys")) {
                    this.handleMapKeys();
                } else if (command.equals("m.values")) {
                    this.handleMapValues();
                } else if (command.equals("m.entries")) {
                    this.handleMapEntries();
                } else if (first.equals("m.lock")) {
                    this.handleMapLock(args);
                } else if (first.equalsIgnoreCase("m.tryLock")) {
                    this.handleMapTryLock(args);
                } else if (first.equals("m.unlock")) {
                    this.handleMapUnlock(args);
                } else if (first.indexOf(".addListener") != -1) {
                    this.handleAddListener(args);
                } else if (first.equals("m.removeMapListener")) {
                    this.handleRemoveListener(args);
                } else if (first.equals("m.unlock")) {
                    this.handleMapUnlock(args);
                } else if (first.equals("l.add")) {
                    this.handleListAdd(args);
                } else if (first.equals("l.set")) {
                    this.handleListSet(args);
                } else if ("l.addmany".equals(first)) {
                    this.handleListAddMany(args);
                } else if (first.equals("l.remove")) {
                    this.handleListRemove(args);
                } else if (first.equals("l.contains")) {
                    this.handleListContains(args);
                } else if (first.equals("execute")) {
                    this.execute(args);
                } else if (first.equals("partitions")) {
                    this.handlePartitions(args);
                } else if (first.equals("txn")) {
                    this.hazelcast.getTransaction().begin();
                } else if (first.equals("commit")) {
                    this.hazelcast.getTransaction().commit();
                } else if (first.equals("rollback")) {
                    this.hazelcast.getTransaction().rollback();
                } else if (first.equalsIgnoreCase("executeOnKey")) {
                    this.executeOnKey(args);
                } else if (first.equalsIgnoreCase("executeOnMember")) {
                    this.executeOnMember(args);
                } else if (first.equalsIgnoreCase("executeOnMembers")) {
                    this.executeOnMembers(args);
                } else if (first.equalsIgnoreCase("longOther") || first.equalsIgnoreCase("executeLongOther")) {
                    this.executeLongTaskOnOtherMember(args);
                } else if (first.equalsIgnoreCase("long") || first.equalsIgnoreCase("executeLong")) {
                    this.executeLong(args);
                } else if (first.equalsIgnoreCase("instances")) {
                    this.handleInstances(args);
                } else if (first.equalsIgnoreCase("quit") || first.equalsIgnoreCase("exit")) {
                    System.exit(0);
                } else {
                    this.println("type 'help' for help");
                }
            }
        }
    }

    protected void handlePartitions(String[] args) {
        Set<Partition> partitions = this.hazelcast.getPartitionService().getPartitions();
        HashMap<Member, Integer> partitionCounts = new HashMap<Member, Integer>();
        for (Partition partition : partitions) {
            Member owner = partition.getOwner();
            if (owner != null) {
                Integer count = (Integer)partitionCounts.get(owner);
                int newCount = 1;
                if (count != null) {
                    newCount = count + 1;
                }
                partitionCounts.put(owner, newCount);
            }
            this.println(partition);
        }
        Set entries = partitionCounts.entrySet();
        for (Map.Entry entry : entries) {
            this.println(entry.getKey() + ":" + entry.getValue());
        }
    }

    protected void handleInstances(String[] args) {
        Collection<Instance> instances = this.hazelcast.getInstances();
        for (Instance instance : instances) {
            this.println(instance);
        }
    }

    protected void handleListContains(String[] args) {
        this.println(this.getList().contains(args[1]));
    }

    protected void handleListRemove(String[] args) {
        int index = -1;
        try {
            index = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (index >= 0) {
            this.println(this.getList().remove(index));
        } else {
            this.println(this.getList().remove(args[1]));
        }
    }

    protected void handleListAdd(String[] args) {
        if (args.length == 3) {
            int index = Integer.parseInt(args[1]);
            this.getList().add(index, args[2]);
            this.println("true");
        } else {
            this.println(this.getList().add(args[1]));
        }
    }

    protected void handleListSet(String[] args) {
        int index = Integer.parseInt(args[1]);
        this.println(this.getList().set(index, args[2]));
    }

    protected void handleMapPut(String[] args) {
        this.println(this.getMap().put(args[1], args[2]));
    }

    protected void handleMapPutAsync(String[] args) {
        try {
            this.println(this.getMap().putAsync(args[1], args[2]).get());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    protected void handleMapPutIfAbsent(String[] args) {
        this.println(this.getMap().putIfAbsent(args[1], args[2]));
    }

    protected void handleMapReplace(String[] args) {
        this.println(this.getMap().replace(args[1], args[2]));
    }

    protected void handleMapGet(String[] args) {
        this.println(this.getMap().get(args[1]));
    }

    protected void handleMapGetAsync(String[] args) {
        try {
            this.println(this.getMap().getAsync(args[1]).get());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    protected void handleMapGetMapEntry(String[] args) {
        this.println(this.getMap().getMapEntry(args[1]));
    }

    protected void handleMapRemove(String[] args) {
        this.println(this.getMap().remove(args[1]));
    }

    protected void handleMapEvict(String[] args) {
        this.println(this.getMap().evict(args[1]));
    }

    protected void handleMapPutMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        int b = 100;
        byte[] value = new byte[b];
        if (args.length > 2) {
            b = Integer.parseInt(args[2]);
            value = new byte[b];
        }
        int start = this.getMap().size();
        if (args.length > 3) {
            start = Integer.parseInt(args[3]);
        }
        HashMap<String, byte[]> theMap = new HashMap<String, byte[]>(count);
        for (int i = 0; i < count; ++i) {
            theMap.put("key" + (start + i), value);
        }
        long t0 = System.currentTimeMillis();
        this.getMap().putAll(theMap);
        long t1 = System.currentTimeMillis();
        if (t1 - t0 > 1L) {
            this.println("size = " + this.getMap().size() + ", " + (long)(count * 1000) / (t1 - t0) + " evt/s, " + (long)(count * 1000) / (t1 - t0) * (long)(b * 8) / 1024L + " Kbit/s, " + count * b / 1024 + " KB added");
        }
    }

    private void handStats(String[] args) {
        String iteratorStr = args[0];
        if (!iteratorStr.startsWith("s.")) {
            if (iteratorStr.startsWith("m.")) {
                this.println(this.getMap().getLocalMapStats());
            } else if (iteratorStr.startsWith("q.")) {
                this.println(this.getQueue().getLocalQueueStats());
            } else if (iteratorStr.startsWith("l.")) {
                // empty if block
            }
        }
    }

    protected void handleMapGetMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        for (int i = 0; i < count; ++i) {
            this.println(this.getMap().get("key" + i));
        }
    }

    protected void handleMapRemoveMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        int start = 0;
        if (args.length > 2) {
            start = Integer.parseInt(args[2]);
        }
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            this.getMap().remove("key" + (start + i));
        }
        long t1 = System.currentTimeMillis();
        this.println("size = " + this.getMap().size() + ", " + (long)(count * 1000) / (t1 - t0) + " evt/s");
    }

    protected void handleMapLock(String[] args) {
        this.getMap().lock(args[1]);
        this.println("true");
    }

    protected void handleLock(String[] args) {
        String lockStr = args[0];
        String key = args[1];
        ILock lock = this.hazelcast.getLock(key);
        if (lockStr.equalsIgnoreCase("lock")) {
            lock.lock();
            this.println("true");
        } else if (lockStr.equalsIgnoreCase("unlock")) {
            lock.unlock();
            this.println("true");
        } else if (lockStr.equalsIgnoreCase("trylock")) {
            String timeout;
            String string = timeout = args.length > 2 ? args[2] : null;
            if (timeout == null) {
                this.println(lock.tryLock());
            } else {
                long time = Long.valueOf(timeout);
                try {
                    this.println(lock.tryLock(time, TimeUnit.SECONDS));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void handleMapTryLock(String[] args) {
        String key = args[1];
        long time = args.length > 2 ? Long.valueOf(args[2]) : 0L;
        boolean locked = false;
        locked = time == 0L ? this.getMap().tryLock(key) : this.getMap().tryLock(key, time, TimeUnit.SECONDS);
        this.println(locked);
    }

    protected void handleMapUnlock(String[] args) {
        this.getMap().unlock(args[1]);
        this.println("true");
    }

    protected void handleAddListener(String[] args) {
        String first = args[0];
        if (first.startsWith("s.")) {
            this.getSet().addItemListener(this, true);
        } else if (first.startsWith("m.")) {
            if (args.length > 1) {
                this.getMap().addEntryListener(this, args[1], true);
            } else {
                this.getMap().addEntryListener(this, true);
            }
        } else if (first.startsWith("q.")) {
            this.getQueue().addItemListener(this, true);
        } else if (first.startsWith("t.")) {
            this.getTopic().addMessageListener(this);
        } else if (first.startsWith("l.")) {
            this.getList().addItemListener(this, true);
        }
    }

    protected void handleRemoveListener(String[] args) {
        String first = args[0];
        if (first.startsWith("s.")) {
            this.getSet().removeItemListener(this);
        } else if (first.startsWith("m.")) {
            if (args.length > 1) {
                this.getMap().removeEntryListener(this, args[1]);
            } else {
                this.getMap().removeEntryListener(this);
            }
        } else if (first.startsWith("q.")) {
            this.getQueue().removeItemListener(this);
        } else if (first.startsWith("t.")) {
            this.getTopic().removeMessageListener(this);
        } else if (first.startsWith("l.")) {
            this.getList().removeItemListener(this);
        }
    }

    protected void handleMapLocalKeys() {
        Set<Object> set = this.getMap().localKeySet();
        Iterator<Object> it = set.iterator();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            this.println(it.next());
        }
        this.println("Total " + count);
    }

    protected void handleMapKeys() {
        Set set = this.getMap().keySet();
        Iterator it = set.iterator();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            this.println(it.next());
        }
        this.println("Total " + count);
    }

    protected void handleMapEntries() {
        Set set = this.getMap().entrySet();
        Iterator it = set.iterator();
        int count = 0;
        long time = System.currentTimeMillis();
        while (it.hasNext()) {
            ++count;
            Map.Entry entry = it.next();
            this.println(entry.getKey() + " : " + entry.getValue());
        }
        this.println("Total " + count);
    }

    protected void handleMapValues() {
        Collection set = this.getMap().values();
        Iterator it = set.iterator();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            this.println(it.next());
        }
        this.println("Total " + count);
    }

    protected void handleSetAdd(String[] args) {
        this.println(this.getSet().add(args[1]));
    }

    protected void handleSetRemove(String[] args) {
        this.println(this.getSet().remove(args[1]));
    }

    protected void handleSetAddMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        int successCount = 0;
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            boolean success = this.getSet().add("obj" + i);
            if (!success) continue;
            ++successCount;
        }
        long t1 = System.currentTimeMillis();
        this.println("Added " + successCount + " objects.");
        this.println("size = " + this.getSet().size() + ", " + (long)(successCount * 1000) / (t1 - t0) + " evt/s");
    }

    protected void handleListAddMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        int successCount = 0;
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            boolean success = this.getList().add("obj" + i);
            if (!success) continue;
            ++successCount;
        }
        long t1 = System.currentTimeMillis();
        this.println("Added " + successCount + " objects.");
        this.println("size = " + this.list.size() + ", " + (long)(successCount * 1000) / (t1 - t0) + " evt/s");
    }

    protected void handleSetRemoveMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        int successCount = 0;
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            boolean success = this.getSet().remove("obj" + i);
            if (!success) continue;
            ++successCount;
        }
        long t1 = System.currentTimeMillis();
        this.println("Removed " + successCount + " objects.");
        this.println("size = " + this.getSet().size() + ", " + (long)(successCount * 1000) / (t1 - t0) + " evt/s");
    }

    protected void handleIterator(String[] args) {
        Iterator<Object> it = null;
        String iteratorStr = args[0];
        if (iteratorStr.startsWith("s.")) {
            it = this.getSet().iterator();
        } else if (iteratorStr.startsWith("m.")) {
            it = this.getMap().keySet().iterator();
        } else if (iteratorStr.startsWith("q.")) {
            it = this.getQueue().iterator();
        } else if (iteratorStr.startsWith("l.")) {
            it = this.getList().iterator();
        }
        boolean remove = false;
        if (args.length > 1) {
            String removeStr = args[1];
            remove = removeStr.equals("remove");
        }
        int count = 1;
        while (it.hasNext()) {
            this.print(count++ + " " + it.next());
            if (remove) {
                it.remove();
                this.print(" removed");
            }
            this.println("");
        }
    }

    protected void handleContains(String[] args) {
        String iteratorStr = args[0];
        boolean key = false;
        boolean value = false;
        if (iteratorStr.toLowerCase().endsWith("key")) {
            key = true;
        } else if (iteratorStr.toLowerCase().endsWith("value")) {
            value = true;
        }
        String data = args[1];
        boolean result = false;
        if (iteratorStr.startsWith("s.")) {
            result = this.getSet().contains(data);
        } else if (iteratorStr.startsWith("m.")) {
            result = key ? this.getMap().containsKey(data) : this.getMap().containsValue(data);
        } else if (iteratorStr.startsWith("q.")) {
            result = this.getQueue().contains(data);
        } else if (iteratorStr.startsWith("l.")) {
            result = this.getList().contains(data);
        }
        this.println("Contains : " + result);
    }

    protected void handleSize(String[] args) {
        int size = 0;
        String iteratorStr = args[0];
        if (iteratorStr.startsWith("s.")) {
            size = this.getSet().size();
        } else if (iteratorStr.startsWith("m.")) {
            size = this.getMap().size();
        } else if (iteratorStr.startsWith("q.")) {
            size = this.getQueue().size();
        } else if (iteratorStr.startsWith("l.")) {
            size = this.getList().size();
        }
        this.println("Size = " + size);
    }

    protected void handleClear(String[] args) {
        String iteratorStr = args[0];
        if (iteratorStr.startsWith("s.")) {
            this.getSet().clear();
        } else if (iteratorStr.startsWith("m.")) {
            this.getMap().clear();
        } else if (iteratorStr.startsWith("q.")) {
            this.getQueue().clear();
        } else if (iteratorStr.startsWith("l.")) {
            this.getList().clear();
        }
        this.println("Cleared all.");
    }

    protected void handleDestroy(String[] args) {
        String iteratorStr = args[0];
        if (iteratorStr.startsWith("s.")) {
            this.getSet().destroy();
        } else if (iteratorStr.startsWith("m.")) {
            this.getMap().destroy();
        } else if (iteratorStr.startsWith("q.")) {
            this.getQueue().destroy();
        } else if (iteratorStr.startsWith("l.")) {
            this.getList().destroy();
        } else if (iteratorStr.startsWith("t.")) {
            this.getTopic().destroy();
        }
        this.println("Destroyed!");
    }

    protected void handleQOffer(String[] args) {
        long timeout = 0L;
        if (args.length > 2) {
            timeout = Long.valueOf(args[2]);
        }
        try {
            boolean offered = this.getQueue().offer(args[1], timeout, TimeUnit.SECONDS);
            this.println(offered);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void handleQTake(String[] args) {
        try {
            this.println(this.getQueue().take());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void handleQPoll(String[] args) {
        long timeout = 0L;
        if (args.length > 1) {
            timeout = Long.valueOf(args[1]);
        }
        try {
            this.println(this.getQueue().poll(timeout, TimeUnit.SECONDS));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void handleTopicPublish(String[] args) {
        this.getTopic().publish(args[1]);
    }

    protected void handleQOfferMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        byte[] value = null;
        if (args.length > 2) {
            value = new byte[Integer.parseInt(args[2])];
        }
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            if (value == null) {
                this.getQueue().offer("obj");
                continue;
            }
            this.getQueue().offer(value);
        }
        long t1 = System.currentTimeMillis();
        this.print("size = " + this.getQueue().size() + ", " + (long)(count * 1000) / (t1 - t0) + " evt/s");
        if (value == null) {
            this.println("");
        } else {
            int b = Integer.parseInt(args[2]);
            this.println(", " + (long)(count * 1000) / (t1 - t0) * (long)(b * 8) / 1024L + " Kbit/s, " + count * b / 1024 + " KB added");
        }
    }

    protected void handleQPollMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        int c = 1;
        for (int i = 0; i < count; ++i) {
            Object obj = this.getQueue().poll();
            if (obj instanceof byte[]) {
                this.println(c++ + " " + ((byte[])obj).length);
                continue;
            }
            this.println(c++ + " " + obj);
        }
    }

    protected void handleQPeek(String[] args) {
        this.println(this.getQueue().peek());
    }

    protected void handleQCapacity(String[] args) {
        this.println(this.getQueue().remainingCapacity());
    }

    private void execute(String[] args) {
        this.doExecute(false, false, args);
    }

    private void executeOnKey(String[] args) {
        this.doExecute(true, false, args);
    }

    private void executeOnMember(String[] args) {
        this.doExecute(false, true, args);
    }

    private void ex(String input) throws Exception {
        DistributedTask<String> task = new DistributedTask<String>(new Echo(input));
        ExecutorService executorService = this.hazelcast.getExecutorService();
        executorService.execute(task);
        String echoResult = (String)((FutureTask)task).get();
    }

    private void doExecute(boolean onKey, boolean onMember, String[] args) {
        try {
            ExecutorService executorService = this.hazelcast.getExecutorService();
            Echo callable = new Echo(args[1]);
            DistributedTask<String> task = null;
            if (onKey) {
                String key = args[2];
                task = new DistributedTask<String>(callable, (Object)key);
            } else if (onMember) {
                int memberIndex = Integer.parseInt(args[2]);
                Member member = (Member)this.hazelcast.getCluster().getMembers().toArray()[memberIndex];
                task = new DistributedTask<String>(callable, member);
            } else {
                task = new DistributedTask<String>(callable);
            }
            executorService.execute(task);
            this.println("Result: " + (String)((FutureTask)task).get());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void executeOnMembers(String[] args) {
        try {
            ExecutorService executorService = this.hazelcast.getExecutorService();
            MultiTask<String> echoTask = new MultiTask<String>(new Echo(args[1]), this.hazelcast.getCluster().getMembers());
            executorService.execute(echoTask);
            Object results = echoTask.get();
            Iterator i$ = results.iterator();
            while (i$.hasNext()) {
                String result = (String)i$.next();
                this.println(result);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void executeLong(String[] args) {
        try {
            ExecutorService executorService = this.hazelcast.getExecutorService();
            MultiTask echoTask = new MultiTask(new LongTask(args[1]), this.hazelcast.getCluster().getMembers()){

                public void setMemberLeft(Member member) {
                    TestApp.this.println("Member Left " + member);
                }

                public void done() {
                    TestApp.this.println("Done!");
                }
            };
            executorService.execute(echoTask);
            Object results = echoTask.get();
            Iterator i$ = results.iterator();
            while (i$.hasNext()) {
                String result = (String)i$.next();
                this.println(result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void executeLongTaskOnOtherMember(String[] args) {
        try {
            ExecutorService executorService = this.hazelcast.getExecutorService();
            Member otherMember = null;
            Set<Member> members = this.hazelcast.getCluster().getMembers();
            for (Member member : members) {
                if (member.localMember()) continue;
                otherMember = member;
            }
            if (otherMember == null) {
                otherMember = this.hazelcast.getCluster().getLocalMember();
            }
            DistributedTask echoTask = new DistributedTask(new LongTask(args[1]), otherMember){

                public void setMemberLeft(Member member) {
                    TestApp.this.println("Member Left " + member);
                }

                public void done() {
                    TestApp.this.println("Done!");
                }
            };
            executorService.execute(echoTask);
            Object result = echoTask.get();
            this.println(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void entryAdded(EntryEvent event) {
        this.println(event);
    }

    public void entryRemoved(EntryEvent event) {
        this.println(event);
    }

    public void entryUpdated(EntryEvent event) {
        this.println(event);
    }

    public void entryEvicted(EntryEvent event) {
        this.println(event);
    }

    public void itemAdded(ItemEvent itemEvent) {
        this.println("Item added = " + itemEvent.getItem());
    }

    public void itemRemoved(ItemEvent itemEvent) {
        this.println("Item removed = " + itemEvent.getItem());
    }

    public void onMessage(Message msg) {
        this.println("Topic received = " + msg.getMessageObject());
    }

    protected void handleHelp(String command) {
        boolean silentBefore = this.silent;
        this.silent = false;
        this.println("Commands:");
        this.println("-- General commands");
        this.println("echo true|false                      //turns on/off echo of commands (default false)");
        this.println("silent true|false                    //turns on/off silent of command output (default false)");
        this.println("#<number> <command>                  //repeats <number> time <command>, replace $i in <command> with current iteration (0..<number-1>)");
        this.println("&<number> <command>                  //forks <number> threads to execute <command>, replace $t in <command> with current thread number (0..<number-1>");
        this.println("     When using #x or &x, is is advised to use silent true as well.");
        this.println("     When using &x with m.putmany and m.removemany, each thread will get a different share of keys unless a start key index is specified");
        this.println("jvm                                  //displays info about the runtime");
        this.println("who                                  //displays info about the cluster");
        this.println("whoami                               //displays info about this cluster member");
        this.println("ns <string>                          //switch the namespace for using the distributed queue/map/set/list <string> (defaults to \"default\"");
        this.println("@<file>                              //executes the given <file> script. Use '//' for comments in the script");
        this.println("");
        this.println("-- Queue commands");
        this.println("q.offer <string>                     //adds a string object to the queue");
        this.println("q.poll                               //takes an object from the queue");
        this.println("q.offermany <number> [<size>]        //adds indicated number of string objects to the queue ('obj<i>' or byte[<size>]) ");
        this.println("q.pollmany <number>                  //takes indicated number of objects from the queue");
        this.println("q.iterator [remove]                  //iterates the queue, remove if specified");
        this.println("q.size                               //size of the queue");
        this.println("q.clear                              //clears the queue");
        this.println("");
        this.println("-- Set commands");
        this.println("s.add <string>                       //adds a string object to the set");
        this.println("s.remove <string>                    //removes the string object from the set");
        this.println("s.addmany <number>                   //adds indicated number of string objects to the set ('obj<i>')");
        this.println("s.removemany <number>                //takes indicated number of objects from the set");
        this.println("s.iterator [remove]                  //iterates the set, removes if specified");
        this.println("s.size                               //size of the set");
        this.println("s.clear                              //clears the set");
        this.println("");
        this.println("-- Lock commands");
        this.println("lock <key>                           //same as Hazelcast.getLock(key).lock()");
        this.println("tryLock <key>                        //same as Hazelcast.getLock(key).tryLock()");
        this.println("tryLock <key> <time>                 //same as tryLock <key> with timeout in seconds");
        this.println("unlock <key>                         //same as Hazelcast.getLock(key).unlock()");
        this.println("");
        this.println("-- Map commands");
        this.println("m.put <key> <value>                  //puts an entry to the map");
        this.println("m.remove <key>                       //removes the entry of given key from the map");
        this.println("m.get <key>                          //returns the value of given key from the map");
        this.println("m.putmany <number> [<size>] [<index>]//puts indicated number of entries to the map ('key<i>':byte[<size>], <index>+(0..<number>)");
        this.println("m.removemany <number> [<index>]      //removes indicated number of entries from the map ('key<i>', <index>+(0..<number>)");
        this.println("     When using &x with m.putmany and m.removemany, each thread will get a different share of keys unless a start key <index> is specified");
        this.println("m.keys                               //iterates the keys of the map");
        this.println("m.values                             //iterates the values of the map");
        this.println("m.entries                            //iterates the entries of the map");
        this.println("m.iterator [remove]                  //iterates the keys of the map, remove if specified");
        this.println("m.size                               //size of the map");
        this.println("m.clear                              //clears the map");
        this.println("m.destroy                            //destroys the map");
        this.println("m.lock <key>                         //locks the key");
        this.println("m.tryLock <key>                      //tries to lock the key and returns immediately");
        this.println("m.tryLock <key> <time>               //tries to lock the key within given seconds");
        this.println("m.unlock <key>                       //unlocks the key");
        this.println("");
        this.println("-- List commands:");
        this.println("l.add <string>");
        this.println("l.add <index> <string>");
        this.println("l.contains <string>");
        this.println("l.remove <string>");
        this.println("l.remove <index>");
        this.println("l.set <index> <string>");
        this.println("l.iterator [remove]");
        this.println("l.size");
        this.println("l.clear");
        this.println("execute\t<echo-input>\t\t\t\t//executes an echo task on random member");
        this.println("execute0nKey\t<echo-input> <key>\t\t//executes an echo task on the member that owns the given key");
        this.println("execute0nMember <echo-input> <key>\t//executes an echo task on the member with given index");
        this.println("execute0nMembers <echo-input> \t\t//executes an echo task on all of the members");
        this.println("");
        this.silent = silentBefore;
    }

    public void println(Object obj) {
        if (!this.silent) {
            System.out.println(obj);
        }
    }

    public void print(Object obj) {
        if (!this.silent) {
            System.out.print(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Echo
    extends HazelcastInstanceAwareObject
    implements Callable<String>,
    Serializable {
        String input = null;

        public Echo() {
        }

        public Echo(String input) {
            this.input = input;
        }

        @Override
        public String call() {
            return this.getHazelcastInstance().getCluster().getLocalMember().toString() + ":" + this.input;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongTask
    extends HazelcastInstanceAwareObject
    implements Callable<String>,
    Serializable {
        String input = null;

        public LongTask() {
        }

        public LongTask(String input) {
            this.input = input;
        }

        @Override
        public String call() {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                System.out.println("Interrupted! Cancelling task!");
                return "No-result";
            }
            return this.getHazelcastInstance().getCluster().getLocalMember().toString() + ":" + this.input;
        }
    }

    class HistoricLineReader
    implements LineReader {
        InputStream in = System.in;

        HistoricLineReader() {
        }

        public String readLine() throws Exception {
            while (true) {
                System.in.read();
                TestApp.this.println("char " + System.in.read());
            }
        }

        int readCharacter() throws Exception {
            return this.in.read();
        }
    }

    class DefaultLineReader
    implements LineReader {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

        DefaultLineReader() {
        }

        public String readLine() throws Exception {
            return this.in.readLine();
        }
    }
}

