/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.config.TopicConfig;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.MessageListener;
import com.hazelcast.jmx.AbstractMBean;
import com.hazelcast.jmx.JMXAttribute;
import com.hazelcast.jmx.JMXDescription;
import com.hazelcast.jmx.JMXOperation;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.jmx.ObjectNameSpec;
import com.hazelcast.jmx.StatisticsCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JMXDescription(value="A distributed queue")
public class TopicMBean
extends AbstractMBean<ITopic<?>> {
    protected MessageListener listener;
    private StatisticsCollector servedStats = null;

    public TopicMBean(ITopic<?> topic, ManagementService managementService) {
        super(topic, managementService);
    }

    @Override
    public ObjectNameSpec getNameSpec() {
        return this.getParentName().getNested("Topic", this.getName());
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        super.postRegister(registrationDone);
        if (!registrationDone.booleanValue()) {
            return;
        }
        if (this.managementService.showDetails()) {
            this.servedStats = ManagementService.newStatisticsCollector();
            this.listener = new MessageListener(){

                public void onMessage(Object msg) {
                    TopicMBean.this.servedStats.addEvent();
                }
            };
            ((ITopic)this.getManagedObject()).addMessageListener(this.listener);
        }
    }

    @Override
    public void preDeregister() throws Exception {
        if (this.listener != null) {
            ((ITopic)this.getManagedObject()).removeMessageListener(this.listener);
            this.listener = null;
        }
        if (this.servedStats != null) {
            this.servedStats.destroy();
            this.servedStats = null;
        }
        super.preDeregister();
    }

    @JMXOperation(value="resetStats")
    public void resetStats() {
        if (this.servedStats != null) {
            this.servedStats.reset();
        }
    }

    @JMXAttribute(value="Name")
    @JMXDescription(value="Registration name of the queue")
    public String getName() {
        return ((ITopic)this.getManagedObject()).getName();
    }

    @JMXAttribute(value="Config")
    @JMXDescription(value="Topic configuration")
    public String getConfig() {
        TopicConfig config = this.managementService.instance.getConfig().getTopicConfig(this.getName());
        return config.toString();
    }

    @JMXAttribute(value="MessagesDispatched")
    @JMXDescription(value="Total messages dispatched since creation")
    public long getItemsReceived() {
        return this.servedStats.getTotal();
    }

    @JMXAttribute(value="MessagesDispatchedLast")
    @JMXDescription(value="Messages dispatched in the last second")
    public double getItemsReceivedAvg() {
        return this.servedStats.getAverage();
    }

    @JMXAttribute(value="MessagesDispatchedPeak")
    @JMXDescription(value="Max messages dispatched  per second")
    public double getItemsReceivedMax() {
        return this.servedStats.getMax();
    }
}

