/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.HazelcastInstanceFactory;
import com.hazelcast.hibernate.IHazelcastInstanceLoader;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Properties;
import java.util.logging.Level;
import org.hibernate.cache.CacheException;
import org.hibernate.util.PropertiesHelper;

class HazelcastClientLoader
implements IHazelcastInstanceLoader {
    private static final ILogger logger = Logger.getLogger(HazelcastInstanceFactory.class.getName());

    HazelcastClientLoader() {
    }

    public HazelcastInstance loadInstance(Properties props) throws CacheException {
        if (props == null) {
            throw new NullPointerException("Hibernate environment properties is null!");
        }
        String[] hosts = PropertiesHelper.toStringArray((String)"hibernate.cache.hazelcast.native_client_hosts", (String)",", (Properties)props);
        String group = PropertiesHelper.getString((String)"hibernate.cache.hazelcast.native_client_group", (Properties)props, null);
        String pass = PropertiesHelper.getString((String)"hibernate.cache.hazelcast.native_client_password", (Properties)props, null);
        if (hosts == null || hosts.length == 0 || group == null || pass == null) {
            throw new CacheException("Configuration properties hibernate.cache.hazelcast.native_client_hosts, hibernate.cache.hazelcast.native_client_group and hibernate.cache.hazelcast.native_client_password are mandatory to use native client!");
        }
        StringBuilder msg = new StringBuilder("Creating HazelcastClient for group: '");
        msg.append(group).append("' via hosts: '");
        for (int i = 0; i < hosts.length; ++i) {
            msg.append(hosts[i]).append("'").append(", ");
        }
        msg.deleteCharAt(msg.length() - 1).append(".");
        logger.log(Level.INFO, msg.toString());
        return HazelcastClient.newHazelcastClient(group, pass, hosts);
    }
}

