/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AddressUtil {
    private AddressUtil() {
    }

    public static List<String> handleMembers(Collection<String> members) {
        ArrayList<String> lsAddresses = new ArrayList<String>();
        for (String address : members) {
            lsAddresses.addAll(AddressUtil.handleMember(address));
        }
        return lsAddresses;
    }

    public static List<String> handleMember(String value) {
        ArrayList<String> members = new ArrayList<String>();
        Pattern ipPattern = Pattern.compile("(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})\\.((\\*)||(\\d{1,3}-\\d{1,3}))");
        for (String token : value.split("[;, ]")) {
            if ((token = token.trim()).length() == 0) continue;
            Matcher matcher = ipPattern.matcher(token);
            if (matcher.matches()) {
                String first3 = matcher.group(1);
                String star = matcher.group(3);
                String range = matcher.group(4);
                if (star != null && star.length() > 0) {
                    for (int j = 0; j < 256; ++j) {
                        members.add(first3 + "." + j);
                    }
                    continue;
                }
                if (range != null && range.length() > 0) {
                    int dashPos = range.indexOf(45);
                    int start = Integer.parseInt(range.substring(0, dashPos));
                    int end = Integer.parseInt(range.substring(dashPos + 1));
                    for (int j = start; j <= end; ++j) {
                        members.add(first3 + "." + j);
                    }
                    continue;
                }
                members.add(token);
                continue;
            }
            members.add(token);
        }
        return members;
    }
}

