/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.config.SemaphoreConfig;
import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceDestroyedException;
import com.hazelcast.core.MapEntry;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.core.SemaphoreFactory;
import com.hazelcast.impl.AtomicNumberProxy;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.Block;
import com.hazelcast.impl.Blocks;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.Constants;
import com.hazelcast.impl.Entries;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.FallThroughRunnable;
import com.hazelcast.impl.GetAllCallable;
import com.hazelcast.impl.Keys;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.NearCache;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.PartitionManager;
import com.hazelcast.impl.PartitionServiceImpl;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.Request;
import com.hazelcast.impl.SemaphoreProxy;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.TransactionImpl;
import com.hazelcast.impl.base.AddressAwareException;
import com.hazelcast.impl.base.CpuUtilization;
import com.hazelcast.impl.base.DataRecordEntry;
import com.hazelcast.impl.base.DistributedCountDownLatch;
import com.hazelcast.impl.base.DistributedLock;
import com.hazelcast.impl.base.DistributedSemaphore;
import com.hazelcast.impl.base.KeyValue;
import com.hazelcast.impl.base.PacketProcessor;
import com.hazelcast.impl.base.Pairs;
import com.hazelcast.impl.base.RuntimeInterruptedException;
import com.hazelcast.impl.base.ScheduledAction;
import com.hazelcast.impl.concurrentmap.MultiData;
import com.hazelcast.impl.executor.ParallelExecutor;
import com.hazelcast.impl.monitor.AtomicNumberOperationsCounter;
import com.hazelcast.impl.monitor.CountDownLatchOperationsCounter;
import com.hazelcast.impl.monitor.LocalMapStatsImpl;
import com.hazelcast.impl.monitor.SemaphoreOperationsCounter;
import com.hazelcast.merge.MergePolicy;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.Serializer;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.QueryContext;
import com.hazelcast.util.DistributedTimeoutException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentMapManager
extends BaseManager {
    final int PARTITION_COUNT;
    final int MAX_BACKUP_COUNT;
    final long GLOBAL_REMOVE_DELAY_MILLIS;
    final long CLEANUP_DELAY_MILLIS;
    final boolean LOG_STATE;
    long lastLogStateTime = System.currentTimeMillis();
    final Block[] blocks;
    final ConcurrentMap<String, CMap> maps;
    final ConcurrentMap<String, NearCache> mapCaches;
    final PartitionManager partitionManager;
    long newRecordId = 0L;
    volatile long nextCleanup = 0L;
    final ParallelExecutor storeExecutor;
    final ParallelExecutor evictionExecutor;
    private static final String BATCH_OPS_EXECUTOR_NAME = "hz_batch";
    final DistributedTimeoutException distributedTimeoutException = new DistributedTimeoutException();
    final Data dataTimeoutException = IOUtil.toData(this.distributedTimeoutException);

    ConcurrentMapManager(Node node) {
        super(node);
        this.storeExecutor = node.executorManager.newParallelExecutor(node.groupProperties.EXECUTOR_STORE_THREAD_COUNT.getInteger());
        this.evictionExecutor = node.executorManager.newParallelExecutor(node.groupProperties.EXECUTOR_STORE_THREAD_COUNT.getInteger());
        this.PARTITION_COUNT = node.groupProperties.CONCURRENT_MAP_PARTITION_COUNT.getInteger();
        this.MAX_BACKUP_COUNT = node.groupProperties.CONCURRENT_MAP_MAX_BACKUP_COUNT.getInteger();
        this.GLOBAL_REMOVE_DELAY_MILLIS = node.groupProperties.REMOVE_DELAY_SECONDS.getLong() * 1000L;
        this.CLEANUP_DELAY_MILLIS = node.groupProperties.CLEANUP_DELAY_SECONDS.getLong() * 1000L;
        this.LOG_STATE = node.groupProperties.LOG_STATE.getBoolean();
        this.blocks = new Block[this.PARTITION_COUNT];
        this.maps = new ConcurrentHashMap<String, CMap>(10, 0.75f, 1);
        this.mapCaches = new ConcurrentHashMap<String, NearCache>(10, 0.75f, 1);
        this.partitionManager = new PartitionManager(this);
        node.clusterService.registerPeriodicRunnable(new FallThroughRunnable(){

            public void doRun() {
                ConcurrentMapManager.this.logState();
                long now = System.currentTimeMillis();
                Collection cmaps = ConcurrentMapManager.this.maps.values();
                for (CMap cmap : cmaps) {
                    if (cmap.cleanupState != CMap.CleanupState.SHOULD_CLEAN) continue;
                    ConcurrentMapManager.this.executeCleanup(cmap, true);
                }
                if (now > ConcurrentMapManager.this.nextCleanup) {
                    for (CMap cmap : cmaps) {
                        if (cmap.cleanupState != CMap.CleanupState.NONE) continue;
                        ConcurrentMapManager.this.executeCleanup(cmap, false);
                    }
                    ConcurrentMapManager.this.nextCleanup = now + ConcurrentMapManager.this.CLEANUP_DELAY_MILLIS;
                }
            }
        });
        node.clusterService.registerPeriodicRunnable(this.partitionManager);
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_GET_MAP_ENTRY, new GetMapEntryOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_GET_DATA_RECORD_ENTRY, new GetDataRecordEntryOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_GET, new GetOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_ASYNC_MERGE, new AsyncMergePacketProcessor());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_WAN_MERGE, new WanMergePacketProcessor());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_MERGE, new MergeOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_TRY_PUT, new PutOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_SET, new PutOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_PUT, new PutOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_PUT_AND_UNLOCK, new PutOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_PUT_TRANSIENT, new PutTransientOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT, new PutOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_REPLACE_IF_NOT_NULL, new PutOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_REPLACE_IF_SAME, new PutOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_PUT_MULTI, new PutMultiOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_REMOVE, new RemoveOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_EVICT, new EvictOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_REMOVE_IF_SAME, new RemoveOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_REMOVE_ITEM, new RemoveItemOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT, new BackupPacketProcessor());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_BACKUP_ADD, new BackupPacketProcessor());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE_MULTI, new BackupPacketProcessor());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE, new BackupPacketProcessor());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_BACKUP_LOCK, new BackupPacketProcessor());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_LOCK, new LockOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_TRY_LOCK_AND_GET, new LockOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_UNLOCK, new UnlockOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_LOCK_MAP, new LockMapOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_UNLOCK_MAP, new LockMapOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_ITERATE_ENTRIES, new QueryOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_ITERATE_VALUES, new QueryOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS, new QueryOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS_ALL, new QueryOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_MIGRATE_RECORD, new MigrationOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_REMOVE_MULTI, new RemoveMultiOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_ADD_TO_LIST, new AddOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_ADD_TO_SET, new AddOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_SIZE, new SizeOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_CONTAINS_KEY, new ContainsKeyOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_CONTAINS_ENTRY, new ContainsOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_CONTAINS_VALUE, new ContainsValueOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_BLOCK_INFO, new BlockInfoOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_BLOCKS, new BlocksOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_BLOCK_MIGRATION_CHECK, new BlockMigrationCheckHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_VALUE_COUNT, new ValueCountOperationHandler());
        this.registerPacketProcessor(ClusterOperation.CONCURRENT_MAP_INVALIDATE, new InvalidateOperationHandler());
        this.registerPacketProcessor(ClusterOperation.ATOMIC_NUMBER_ADD_AND_GET, new AtomicNumberAddAndGetOperationHandler());
        this.registerPacketProcessor(ClusterOperation.ATOMIC_NUMBER_COMPARE_AND_SET, new AtomicNumberCompareAndSetOperationHandler());
        this.registerPacketProcessor(ClusterOperation.ATOMIC_NUMBER_GET_AND_ADD, new AtomicNumberGetAndAddOperationHandler());
        this.registerPacketProcessor(ClusterOperation.ATOMIC_NUMBER_GET_AND_SET, new AtomicNumberGetAndSetOperationHandler());
        this.registerPacketProcessor(ClusterOperation.COUNT_DOWN_LATCH_AWAIT, new CountDownLatchAwaitOperationHandler());
        this.registerPacketProcessor(ClusterOperation.COUNT_DOWN_LATCH_COUNT_DOWN, new CountDownLatchCountDownOperationHandler());
        this.registerPacketProcessor(ClusterOperation.COUNT_DOWN_LATCH_DESTROY, new CountDownLatchDestroyOperationHandler());
        this.registerPacketProcessor(ClusterOperation.COUNT_DOWN_LATCH_GET_COUNT, new CountDownLatchGetCountOperationHandler());
        this.registerPacketProcessor(ClusterOperation.COUNT_DOWN_LATCH_GET_OWNER, new CountDownLatchGetOwnerOperationHandler());
        this.registerPacketProcessor(ClusterOperation.COUNT_DOWN_LATCH_SET_COUNT, new CountDownLatchSetCountOperationHandler());
        this.registerPacketProcessor(ClusterOperation.SEMAPHORE_ATTACH_DETACH_PERMITS, new SemaphoreAttachDetachOperationHandler());
        this.registerPacketProcessor(ClusterOperation.SEMAPHORE_CANCEL_ACQUIRE, new SemaphoreCancelAcquireOperationHandler());
        this.registerPacketProcessor(ClusterOperation.SEMAPHORE_DESTROY, new SemaphoreDestroyOperationHandler());
        this.registerPacketProcessor(ClusterOperation.SEMAPHORE_DRAIN_PERMITS, new SemaphoreDrainOperationHandler());
        this.registerPacketProcessor(ClusterOperation.SEMAPHORE_GET_ATTACHED_PERMITS, new SemaphoreGetAttachedOperationHandler());
        this.registerPacketProcessor(ClusterOperation.SEMAPHORE_GET_AVAILABLE_PERMITS, new SemaphoreGetAvailableOperationHandler());
        this.registerPacketProcessor(ClusterOperation.SEMAPHORE_REDUCE_PERMITS, new SemaphoreReduceOperationHandler());
        this.registerPacketProcessor(ClusterOperation.SEMAPHORE_RELEASE, new SemaphoreReleaseOperationHandler());
        this.registerPacketProcessor(ClusterOperation.SEMAPHORE_TRY_ACQUIRE, new SemaphoreTryAcquireOperationHandler());
    }

    private void executeCleanup(final CMap cmap, final boolean forced) {
        if (cmap.cleanupState == CMap.CleanupState.CLEANING) {
            return;
        }
        cmap.cleanupState = CMap.CleanupState.CLEANING;
        this.executeLocally(new FallThroughRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doRun() {
                try {
                    cmap.startCleanup(forced);
                }
                catch (Exception e) {
                    try {
                        ConcurrentMapManager.this.logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        ConcurrentMapManager.this.enqueueAndReturn(new Processable(){

                            public void process() {
                                cmap.cleanupState = CMap.CleanupState.NONE;
                            }
                        });
                        throw throwable;
                    }
                    ConcurrentMapManager.this.enqueueAndReturn(new /* invalid duplicate definition of identical inner class */);
                }
                ConcurrentMapManager.this.enqueueAndReturn(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    public void onRestart() {
        this.enqueueAndWait(new Processable(){

            public void process() {
                ConcurrentMapManager.this.partitionManager.reset();
                for (CMap cmap : ConcurrentMapManager.this.maps.values()) {
                    cmap.reset();
                }
            }
        }, 5);
    }

    public void reset() {
        this.maps.clear();
        this.mapCaches.clear();
        this.partitionManager.reset();
    }

    public void shutdown() {
        for (CMap cmap : this.maps.values()) {
            try {
                this.flush(cmap.name);
                cmap.reset();
            }
            catch (Throwable e) {
                if (!this.node.isActive()) continue;
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public void flush(String name) {
        CMap cmap = this.getMap(name);
        if (cmap != null && cmap.store != null && cmap.writeDelayMillis > 0L) {
            HashMap<Object, Object> mapDirtyEntries = new HashMap<Object, Object>();
            for (Record record : cmap.mapRecords.values()) {
                if (!record.isDirty()) continue;
                Object key = record.getKey();
                Object value = record.getValue();
                if (key == null || value == null) continue;
                mapDirtyEntries.put(key, value);
            }
            if (mapDirtyEntries.size() > 0) {
                cmap.store.storeAll(mapDirtyEntries);
            }
        }
    }

    public void syncForDead(MemberImpl deadMember) {
        this.partitionManager.syncForDead(deadMember);
        this.syncForDeadSemaphores(deadMember.getAddress());
        this.syncForDeadCountDownLatches(deadMember.getAddress());
    }

    void syncForDeadSemaphores(Address deadAddress) {
        CMap cmap = (CMap)this.maps.get("c:__hz_SemaphoreMap");
        if (cmap != null) {
            for (Record record : cmap.mapRecords.values()) {
                DistributedSemaphore semaphore = (DistributedSemaphore)record.getValue();
                if (!semaphore.onDisconnect(deadAddress)) continue;
                record.setValue(IOUtil.toData(semaphore));
                record.incrementVersion();
            }
        }
    }

    void syncForDeadCountDownLatches(Address deadAddress) {
        CMap cmap = (CMap)this.maps.get("c:__hz_CountDownLatcheMap");
        if (deadAddress != null && cmap != null) {
            for (Record record : cmap.mapRecords.values()) {
                DistributedCountDownLatch cdl = (DistributedCountDownLatch)record.getValue();
                if (cdl == null || !cdl.isOwnerOrMemberAddress(deadAddress)) continue;
                List<ScheduledAction> scheduledActions = record.getScheduledActions();
                if (scheduledActions != null) {
                    for (ScheduledAction sa : scheduledActions) {
                        this.node.clusterManager.deregisterScheduledAction(sa);
                        Request sr = sa.getRequest();
                        sr.clearForResponse();
                        sr.lockAddress = deadAddress;
                        sr.longValue = 3L;
                        this.returnResponse(sr);
                    }
                    scheduledActions.clear();
                }
                cdl.setOwnerLeft();
            }
        }
    }

    public void syncForAdd() {
        this.partitionManager.syncForAdd();
    }

    void logState() {
        long now = System.currentTimeMillis();
        if (this.LOG_STATE && now - this.lastLogStateTime > 15000L) {
            StringBuffer sbState = new StringBuffer(this.thisAddress + " State[" + new Date(now));
            sbState.append("]");
            Collection calls = this.mapCalls.values();
            sbState.append("\nCall Count:" + calls.size());
            for (Block block : this.blocks) {
                if (block == null || !block.isMigrating()) continue;
                sbState.append("\n");
                sbState.append(block);
            }
            Collection cmaps = this.maps.values();
            for (CMap cmap : cmaps) {
                cmap.appendState(sbState);
            }
            CpuUtilization cpuUtilization = this.node.getCpuUtilization();
            this.node.connectionManager.appendState(sbState);
            this.node.executorManager.appendState(sbState);
            this.node.clusterManager.appendState(sbState);
            long total = Runtime.getRuntime().totalMemory();
            long free = Runtime.getRuntime().freeMemory();
            sbState.append("\nCluster Size:" + this.lsMembers.size());
            sbState.append("\n" + cpuUtilization);
            sbState.append("\nUsed Memory:");
            sbState.append((total - free) / 1024L / 1024L);
            sbState.append("MB");
            this.logger.log(Level.INFO, sbState.toString());
            this.lastLogStateTime = now;
        }
    }

    void backupRecord(Record rec) {
        if (rec.getMultiValues() != null) {
            Set<Data> values = rec.getMultiValues();
            int initialVersion = (int)rec.getVersion() - values.size();
            int version = initialVersion < 0 ? 0 : initialVersion;
            for (Data value : values) {
                Record record = rec.copy();
                record.setValue(value);
                record.setVersion(++version);
                MBackupOp backupOp = new MBackupOp();
                backupOp.backup(record);
            }
        } else {
            MBackupOp backupOp = new MBackupOp();
            backupOp.backup(rec);
        }
    }

    public void mergeWanRecord(DataRecordEntry mergingEntry) {
        String name = mergingEntry.getName();
        DataRecordEntry existingEntry = new MGetDataRecordEntry().get(name, mergingEntry.getKeyData());
        CMap cmap = this.node.concurrentMapManager.getMap(name);
        MergePolicy mergePolicy = cmap.wanMergePolicy;
        if (mergePolicy == null) {
            this.logger.log(Level.SEVERE, "Received wan merge but no merge policy defined!");
        } else {
            Object winner = mergePolicy.merge(cmap.getName(), mergingEntry, existingEntry);
            if (winner != null) {
                ThreadContext.CallCache callCache = ThreadContext.get().getCallCache(this.node.factory);
                if (winner == MergePolicy.REMOVE_EXISTING) {
                    callCache.getMRemove().removeForSync(name, mergingEntry.getKey());
                } else {
                    callCache.getMPut().putForSync(name, mergingEntry.getKeyData(), winner);
                }
            }
        }
    }

    void migrateRecord(CMap cmap, Record rec) {
        if (!this.node.isActive() || this.node.factory.restarted) {
            return;
        }
        MMigrate mmigrate = new MMigrate();
        if (cmap.isMultiMap()) {
            Set<Data> values = rec.getMultiValues();
            if (values == null || values.size() == 0) {
                mmigrate.migrateMulti(rec, null);
            } else {
                for (Data value : values) {
                    mmigrate.migrateMulti(rec, value);
                }
            }
        } else {
            boolean migrated = mmigrate.migrate(rec);
            if (!migrated) {
                this.logger.log(Level.FINEST, "Migration failed " + rec.getKeyData());
            }
        }
    }

    public boolean isOwned(Record record) {
        Block block = this.partitionManager.getOrCreateBlock(record.getBlockId());
        return this.thisAddress.equals(block.getOwner());
    }

    public int getPartitionCount() {
        return this.PARTITION_COUNT;
    }

    public Block[] getBlocks() {
        return this.blocks;
    }

    public Map<String, CMap> getCMaps() {
        return this.maps;
    }

    Object tryLockAndGet(String name, Object key, long timeout) throws TimeoutException {
        MLock mlock = new MLock();
        boolean locked = mlock.lockAndGetValue(name, key, timeout);
        if (!locked) {
            throw new TimeoutException();
        }
        return IOUtil.toObject(mlock.oldValue);
    }

    void putAndUnlock(String name, Object key, Object value) {
        MPut mput = ThreadContext.get().getCallCache(this.node.factory).getMPut();
        mput.txnalPut(ClusterOperation.CONCURRENT_MAP_PUT_AND_UNLOCK, name, key, value, -1L, -1L);
    }

    public void destroyEndpointThreads(Address endpoint, Set<Integer> threadIds) {
        this.node.clusterManager.invalidateScheduledActionsFor(endpoint, threadIds);
        for (CMap cmap : this.maps.values()) {
            for (Record record : cmap.mapRecords.values()) {
                DistributedLock lock = record.getLock();
                if (lock == null || !lock.isLocked() || !endpoint.equals(record.getLockAddress()) || !threadIds.contains(record.getLock().getLockThreadId())) continue;
                record.setLock(null);
                cmap.fireScheduledActions(record);
            }
        }
    }

    void putTransient(String name, Object key, Object value, long timeout, long ttl) {
        MPut mput = new MPut();
        mput.putTransient(name, key, value, timeout, ttl);
    }

    void putTransientAsync(Request request) {
        final MPut mput = new MPut();
        mput.request.key = request.key;
        mput.request.value = request.value;
        mput.request.timeout = 0L;
        mput.request.ttl = -1L;
        mput.request.indexes = request.indexes;
        mput.request.indexTypes = request.indexTypes;
        mput.request.local = true;
        mput.request.setFromRequest(request);
        mput.request.operation = ClusterOperation.CONCURRENT_MAP_PUT_TRANSIENT;
        mput.request.longValue = request.value == null ? Integer.MIN_VALUE : (long)request.value.hashCode();
        request.setBooleanRequest();
        this.node.executorManager.executeNow(new Runnable(){

            public void run() {
                mput.doOp();
                boolean success = mput.getResultAsBoolean();
                if (success) {
                    mput.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
                }
            }
        });
    }

    Map getAll(String name, Set keys) {
        Object key;
        Object value;
        HashSet theKeys = keys;
        HashMap<Object, Object> map = new HashMap<Object, Object>(keys.size());
        CMap cmap = this.getMap(name);
        if (cmap != null && cmap.nearCache != null) {
            theKeys = new HashSet(keys);
            Iterator iterator = theKeys.iterator();
            while (iterator.hasNext()) {
                Object key2 = iterator.next();
                Object value2 = cmap.nearCache.get(key2);
                if (value2 == null) continue;
                map.put(key2, value2);
                iterator.remove();
            }
        }
        if (theKeys.size() > 1) {
            NearCache nearCache;
            Pairs results = this.getAllPairs(name, theKeys);
            final List<KeyValue> lsKeyValues = results.getKeyValues();
            cmap = this.getMap(name);
            if (lsKeyValues.size() > 0 && cmap != null && (nearCache = cmap.nearCache) != null) {
                final HashMap<Data, Object> keyObjects = new HashMap<Data, Object>(lsKeyValues.size());
                for (KeyValue keyValue : lsKeyValues) {
                    keyObjects.put(keyValue.getKeyData(), keyValue.getKey());
                }
                this.enqueueAndReturn(new Processable(){

                    public void process() {
                        for (KeyValue keyValue : lsKeyValues) {
                            Object key = keyObjects.get(keyValue.getKeyData());
                            if (key == null) continue;
                            nearCache.put(key, keyValue.getKeyData(), keyValue.getValueData());
                        }
                    }
                });
            }
            for (KeyValue keyValue : lsKeyValues) {
                map.put(keyValue.getKey(), keyValue.getValue());
            }
        } else if (theKeys.size() == 1 && (value = new MGet().get(name, key = theKeys.iterator().next(), -1L)) != null) {
            map.put(key, value);
        }
        return map;
    }

    Pairs getAllPairs(String name, Set keys) {
        while (true) {
            this.node.checkNodeState();
            try {
                return this.doGetAll(name, keys);
            }
            catch (Throwable e) {
                TransactionImpl txn;
                if ((txn = ThreadContext.get().getCallContext().getTransaction()) == null || txn.getStatus() != 1) continue;
                throw new RuntimeException(e);
            }
            break;
        }
    }

    Pairs doGetAll(String name, Set keys) throws ExecutionException, InterruptedException {
        Pairs results = new Pairs(keys.size());
        HashMap<Member, Keys> targetMembers = new HashMap<Member, Keys>(10);
        PartitionServiceImpl partitionService = this.partitionManager.partitionServiceImpl;
        for (Object key : keys) {
            Keys targetKeys;
            Data data = IOUtil.toData(key);
            Member owner = partitionService.getPartition(data).getOwner();
            if (owner == null) {
                owner = this.thisMember;
            }
            if ((targetKeys = (Keys)targetMembers.get(owner)) == null) {
                targetKeys = new Keys();
                targetMembers.put(owner, targetKeys);
            }
            targetKeys.add(data);
        }
        ArrayList<DistributedTask<Pairs>> lsFutures = new ArrayList<DistributedTask<Pairs>>(targetMembers.size());
        for (Member member : targetMembers.keySet()) {
            Keys targetKeys = (Keys)targetMembers.get(member);
            GetAllCallable callable = new GetAllCallable(name, targetKeys);
            DistributedTask<Pairs> dt = new DistributedTask<Pairs>(callable, member);
            lsFutures.add(dt);
            this.node.factory.getExecutorService(BATCH_OPS_EXECUTOR_NAME).execute(dt);
        }
        for (Future future : lsFutures) {
            Pairs pairs = (Pairs)future.get();
            if (pairs == null || pairs.getKeyValues() == null) continue;
            for (KeyValue keyValue : pairs.getKeyValues()) {
                results.addKeyValue(keyValue);
            }
        }
        return results;
    }

    void doPutAll(String name, Map entries) {
        Pairs pairs = new Pairs(entries.size());
        for (Object key : entries.keySet()) {
            Object value = entries.get(key);
            pairs.addKeyValue(new KeyValue(IOUtil.toData(key), IOUtil.toData(value)));
        }
        while (true) {
            this.node.checkNodeState();
            try {
                this.doPutAll(name, pairs);
                return;
            }
            catch (Throwable e) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    void doPutAll(String name, Pairs pairs) throws ExecutionException, InterruptedException {
        Pairs targetPairs;
        HashMap<void, Pairs> targetMembers = new HashMap<void, Pairs>(10);
        PartitionServiceImpl partitionService = this.partitionManager.partitionServiceImpl;
        for (KeyValue keyValue : pairs.getKeyValues()) {
            void var7_7;
            Member member = partitionService.getPartition(keyValue.getKeyData()).getOwner();
            if (member == null) {
                MemberImpl memberImpl = this.thisMember;
            }
            if ((targetPairs = (Pairs)targetMembers.get(var7_7)) == null) {
                targetPairs = new Pairs();
                targetMembers.put(var7_7, targetPairs);
            }
            targetPairs.addKeyValue(keyValue);
        }
        ArrayList<DistributedTask<Boolean>> lsFutures = new ArrayList<DistributedTask<Boolean>>(targetMembers.size());
        for (Member member : targetMembers.keySet()) {
            targetPairs = (Pairs)targetMembers.get(member);
            if (targetPairs == null || targetMembers.size() <= 0) continue;
            PutAllCallable callable = new PutAllCallable(name, targetPairs);
            DistributedTask<Boolean> dt = new DistributedTask<Boolean>(callable, member);
            lsFutures.add(dt);
            this.node.factory.getExecutorService(BATCH_OPS_EXECUTOR_NAME).execute(dt);
        }
        for (Future future : lsFutures) {
            future.get();
        }
    }

    public void destroy(String name) {
        CMap cmap = (CMap)this.maps.remove(name);
        if (cmap != null) {
            cmap.reset();
        }
        this.mapCaches.remove(name);
    }

    boolean isMapIndexed(String name) {
        CMap cmap = this.getMap(name);
        return cmap != null && cmap.getMapIndexService().hasIndexedAttributes();
    }

    void setIndexValues(Request request, Object value) {
        Long[] indexes;
        CMap cmap = this.getMap(request.name);
        if (cmap != null && (indexes = cmap.getMapIndexService().getIndexValues(value)) != null) {
            byte[] indexTypes = cmap.getMapIndexService().getIndexTypes();
            request.setIndexes(indexes, indexTypes);
            for (byte b : indexTypes) {
                if (b != -1) continue;
                throw new RuntimeException("Index type cannot be -1: " + b);
            }
        }
    }

    final void fireMapEvent(Map<Address, Boolean> mapListeners, int eventType, Data oldValue, Record record, Address callerAddress) {
        if (record.getListeners() == null && (mapListeners == null || mapListeners.size() == 0)) {
            return;
        }
        this.checkServiceThread();
        this.fireMapEvent(mapListeners, record.getName(), eventType, record.getKeyData(), oldValue, record.getValueData(), record.getListeners(), callerAddress);
    }

    public LocalMapStatsImpl getLocalMapStats(String name) {
        CMap cmap = this.getMap(name);
        if (cmap == null) {
            return new LocalMapStatsImpl();
        }
        return cmap.getLocalMapStats();
    }

    public Address getKeyOwner(Request req) {
        return this.getKeyOwner(req.key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Address getKeyOwner(int blockId) {
        this.checkServiceThread();
        Block block = this.blocks[blockId];
        if (block == null) {
            if (!this.isMaster() || this.isSuperClient()) return null;
            block = this.partitionManager.getOrCreateBlock(blockId);
            block.setOwner(this.thisAddress);
            block.setMigrationAddress(null);
            this.partitionManager.lsBlocksToMigrate.clear();
            this.partitionManager.invalidateBlocksHash();
        } else if (block.getOwner() == null && this.isMaster() && !this.isSuperClient()) {
            block.setOwner(this.thisAddress);
            block.setMigrationAddress(null);
            this.partitionManager.lsBlocksToMigrate.clear();
            this.partitionManager.invalidateBlocksHash();
        }
        if (!block.isMigrating()) return block.getOwner();
        return null;
    }

    public Address getKeyOwner(Data key) {
        int blockId = this.getBlockId(key);
        return this.getKeyOwner(blockId);
    }

    @Override
    public boolean isMigrating(Request req) {
        return this.partitionManager.isMigrating(req);
    }

    public int getBlockId(Request req) {
        if (req.blockId == -1) {
            req.blockId = this.getBlockId(req.key);
        }
        return req.blockId;
    }

    public int getBlockId(Data key) {
        int hash = key.getPartitionHash();
        return hash == Integer.MIN_VALUE ? 0 : Math.abs(hash) % this.PARTITION_COUNT;
    }

    public long newRecordId() {
        return this.newRecordId++;
    }

    Block getOrCreateBlock(Request req) {
        return this.partitionManager.getOrCreateBlock(this.getBlockId(req));
    }

    void evict(String name, Data key) {
        MEvict mEvict = new MEvict();
        mEvict.evict(name, key);
    }

    void evictAsync(final String name, final Data key) {
        this.evictionExecutor.execute(new FallThroughRunnable(){

            public void doRun() {
                try {
                    ConcurrentMapManager.this.evict(name, key);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    CMap getMap(String name) {
        return (CMap)this.maps.get(name);
    }

    public CMap getOrCreateMap(String name) {
        this.checkServiceThread();
        CMap map = (CMap)this.maps.get(name);
        if (map == null) {
            map = new CMap(this, name);
            this.maps.put(name, map);
        }
        return map;
    }

    @Override
    void handleListenerRegistrations(boolean add, String name, Data key, Address address, boolean includeValue) {
        CMap cmap = this.getOrCreateMap(name);
        if (add) {
            cmap.addListener(key, address, includeValue);
        } else {
            cmap.removeListener(key, address);
        }
    }

    boolean sendBlockInfo(Block block, Address address) {
        return this.send("mapblock", ClusterOperation.CONCURRENT_MAP_BLOCK_INFO, block, address);
    }

    void scheduleRequest(final SchedulableOperationHandler handler, Request request) {
        Record record = this.ensureRecord(request);
        request.scheduled = true;
        ScheduledAction scheduledAction = new ScheduledAction(request){

            public boolean consume() {
                handler.handle(this.request);
                return true;
            }

            public void onExpire() {
                handler.onNoTimeToSchedule(this.request);
            }

            public void onMigrate() {
                this.request.response = Constants.Objects.OBJECT_REDO;
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        };
        record.addScheduledAction(scheduledAction);
        this.node.clusterManager.registerScheduledAction(scheduledAction);
    }

    Record recordExist(Request req) {
        CMap cmap = (CMap)this.maps.get(req.name);
        if (cmap == null) {
            return null;
        }
        return cmap.getRecord(req);
    }

    Record ensureRecord(Request req) {
        return this.ensureRecord(req, req.value);
    }

    Record ensureRecord(Request req, Data defaultValue) {
        this.checkServiceThread();
        CMap cmap = this.getOrCreateMap(req.name);
        Record record = cmap.getRecord(req);
        if (record == null) {
            record = cmap.createNewRecord(req.key, defaultValue);
            cmap.mapRecords.put(req.key, record);
        }
        return record;
    }

    final boolean testLock(Request req) {
        Record record = this.recordExist(req);
        return record == null || record.testLock(req.lockThreadId, req.lockAddress);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QueryOperationHandler
    extends ExecutedOperationHandler {
        QueryOperationHandler() {
        }

        @Override
        public void handle(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            if (cmap.isNotLocked(request) && !ConcurrentMapManager.this.isMigrating(request)) {
                super.handle(request);
            } else {
                request.response = Constants.Objects.OBJECT_REDO;
                ConcurrentMapManager.this.returnResponse(request);
            }
        }

        @Override
        Runnable createRunnable(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            return new QueryTask(cmap, request);
        }

        void createResultPairs(Request request, Collection<MapEntry> colRecords, boolean evaluateEntries, Predicate predicate) {
            Pairs pairs = new Pairs();
            if (colRecords != null) {
                long now = System.currentTimeMillis();
                for (MapEntry mapEntry : colRecords) {
                    int size;
                    Record record = (Record)mapEntry;
                    if (!record.isActive() || !record.isValid(now)) continue;
                    if (record.getKeyData() == null || record.getKeyData().size() == 0) {
                        throw new RuntimeException("Key cannot be null or zero-size: " + record.getKeyData());
                    }
                    boolean match = !evaluateEntries || predicate.apply(record);
                    if (!match) continue;
                    boolean onlyKeys = request.operation == ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS_ALL || request.operation == ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS;
                    Data key = record.getKeyData();
                    if (record.getValueData() != null) {
                        Data value = onlyKeys ? null : record.getValueData();
                        pairs.addKeyValue(new KeyValue(key, value));
                        continue;
                    }
                    if (record.getCopyCount() > 0) {
                        for (int i = 0; i < record.getCopyCount(); ++i) {
                            pairs.addKeyValue(new KeyValue(key, null));
                        }
                        continue;
                    }
                    if (record.getMultiValues() == null || (size = record.getMultiValues().size()) <= 0) continue;
                    if (request.operation == ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS) {
                        pairs.addKeyValue(new KeyValue(key, null));
                        continue;
                    }
                    Set<Data> values = record.getMultiValues();
                    for (Data value : values) {
                        pairs.addKeyValue(new KeyValue(key, value));
                    }
                }
            }
            if (!request.local) {
                request.value = null;
            }
            request.response = pairs.size() > 0 ? (request.local ? pairs : IOUtil.toData(pairs)) : null;
        }

        class QueryTask
        implements Runnable {
            final CMap cmap;
            final Request request;

            QueryTask(CMap cmap, Request request) {
                this.cmap = cmap;
                this.request = request;
            }

            public void run() {
                try {
                    Predicate predicate = null;
                    if (this.request.value != null) {
                        predicate = (Predicate)IOUtil.toObject(this.request.value);
                    }
                    QueryContext queryContext = new QueryContext(this.cmap.getName(), predicate, this.cmap.getMapIndexService());
                    Set<MapEntry> results = this.cmap.getMapIndexService().doQuery(queryContext);
                    boolean evaluateValues = predicate != null && !queryContext.isStrong();
                    QueryOperationHandler.this.createResultPairs(this.request, results, evaluateValues, predicate);
                    ConcurrentMapManager.this.enqueueAndReturn(new Processable(){

                        public void process() {
                            boolean sent;
                            int callerPartitionHash = QueryTask.this.request.blockId;
                            if (ConcurrentMapManager.this.partitionManager.containsMigratingBlock() || callerPartitionHash != ConcurrentMapManager.this.partitionManager.hashBlocks()) {
                                QueryTask.this.request.response = Constants.Objects.OBJECT_REDO;
                            }
                            if (!(sent = ConcurrentMapManager.this.returnResponse(QueryTask.this.request))) {
                                Connection conn = ConcurrentMapManager.this.node.connectionManager.getConnection(QueryTask.this.request.caller);
                                ConcurrentMapManager.this.logger.log(Level.WARNING, QueryTask.this.request + " !! response cannot be sent to " + QueryTask.this.request.caller + " conn:" + conn);
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    ConcurrentMapManager.this.logger.log(Level.SEVERE, this.request.toString(), e);
                }
            }
        }
    }

    class SizeOperationHandler
    extends ExecutedOperationHandler {
        SizeOperationHandler() {
        }

        public void handle(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            if (cmap.isNotLocked(request) && !ConcurrentMapManager.this.isMigrating(request)) {
                super.handle(request);
            } else {
                request.response = Constants.Objects.OBJECT_REDO;
                ConcurrentMapManager.this.returnResponse(request);
            }
        }

        Runnable createRunnable(final Request request) {
            final CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            return new Runnable(){

                public void run() {
                    request.response = (long)cmap.size();
                    ConcurrentMapManager.this.enqueueAndReturn(new Processable(){

                        public void process() {
                            boolean sent;
                            int callerPartitionHash = request.blockId;
                            int myPartitionHashNow = ConcurrentMapManager.this.partitionManager.hashBlocks();
                            if (callerPartitionHash != myPartitionHashNow) {
                                request.response = Constants.Objects.OBJECT_REDO;
                            }
                            if (!(sent = ConcurrentMapManager.this.returnResponse(request))) {
                                Connection conn = ConcurrentMapManager.this.node.connectionManager.getConnection(request.caller);
                                ConcurrentMapManager.this.logger.log(Level.WARNING, request + " !! response cannot be sent to " + request.caller + " conn:" + conn);
                            }
                        }
                    });
                }
            };
        }
    }

    abstract class ExecutedOperationHandler
    extends BaseManager.ResponsiveOperationHandler {
        ExecutedOperationHandler() {
        }

        public void process(Packet packet) {
            Request request = Request.copy(packet);
            request.local = false;
            this.handle(request);
        }

        public void handle(Request request) {
            ConcurrentMapManager.this.node.executorManager.executeQueryTask(this.createRunnable(request));
        }

        abstract Runnable createRunnable(Request var1);
    }

    class ContainsValueOperationHandler
    extends BaseManager.AbstractOperationHandler {
        ContainsValueOperationHandler() {
        }

        public void process(Packet packet) {
            this.processMigrationAware(packet);
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            cmap.containsValue(request);
        }
    }

    abstract class SchedulableOperationHandler
    extends MTargetAwareOperationHandler {
        SchedulableOperationHandler() {
        }

        protected boolean shouldSchedule(Request request) {
            return !ConcurrentMapManager.this.testLock(request);
        }

        protected void onNoTimeToSchedule(Request request) {
            request.response = null;
            ConcurrentMapManager.this.returnResponse(request);
        }

        protected void schedule(Request request) {
            ConcurrentMapManager.this.scheduleRequest(this, request);
        }

        public void handle(Request request) {
            if (this.shouldSchedule(request)) {
                if (request.hasEnoughTimeToSchedule()) {
                    this.schedule(request);
                } else {
                    this.onNoTimeToSchedule(request);
                }
            } else {
                this.doOperation(request);
                ConcurrentMapManager.this.returnResponse(request);
            }
        }
    }

    class LockOperationHandler
    extends SchedulableOperationHandler {
        LockOperationHandler() {
        }

        protected void onNoTimeToSchedule(Request request) {
            request.response = Boolean.FALSE;
            ConcurrentMapManager.this.returnResponse(request);
        }

        public void handle(Request request) {
            if (this.shouldSchedule(request)) {
                if (request.hasEnoughTimeToSchedule()) {
                    this.schedule(request);
                } else {
                    this.onNoTimeToSchedule(request);
                }
            } else {
                CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
                Record record = cmap.getRecord(request.key);
                if (request.operation == ClusterOperation.CONCURRENT_MAP_TRY_LOCK_AND_GET && cmap.loader != null && (record == null || record.getValueData() == null)) {
                    ConcurrentMapManager.this.storeExecutor.execute(new LockLoader(cmap, request), request.key.hashCode());
                } else {
                    this.doOperation(request);
                    ConcurrentMapManager.this.returnResponse(request);
                }
            }
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            cmap.lock(request);
        }

        class LockLoader
        extends AbstractMapStoreOperation {
            Data valueData;

            LockLoader(CMap cmap, Request request) {
                super(cmap, request);
                this.valueData = null;
            }

            void doMapStoreOperation() {
                Object value = this.cmap.loader.load(IOUtil.toObject(this.request.key));
                this.valueData = IOUtil.toData(value);
            }

            public void process() {
                LockOperationHandler.this.doOperation(this.request);
                this.request.value = this.valueData;
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }
    }

    class UnlockOperationHandler
    extends SchedulableOperationHandler {
        UnlockOperationHandler() {
        }

        protected boolean shouldSchedule(Request request) {
            return false;
        }

        void doOperation(Request request) {
            boolean unlocked = true;
            Record record = ConcurrentMapManager.this.recordExist(request);
            if (record != null && (unlocked = record.unlock(request.lockThreadId, request.lockAddress))) {
                CMap cmap = ConcurrentMapManager.this.getOrCreateMap(record.getName());
                record.incrementVersion();
                request.version = record.getVersion();
                request.lockCount = record.getLockCount();
                if (record.getLockCount() == 0 && record.valueCount() == 0 && !record.hasScheduledAction()) {
                    cmap.markAsEvicted(record);
                }
                cmap.fireScheduledActions(record);
            }
            request.response = unlocked ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    class MigrationOperationHandler
    extends BaseManager.AbstractOperationHandler {
        MigrationOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            cmap.own(request);
            request.response = Boolean.TRUE;
        }
    }

    class ContainsOperationHandler
    extends BaseManager.MigrationAwareOperationHandler {
        ContainsOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            if (request.key != null) {
                boolean callerKnownMember;
                boolean bl = callerKnownMember = request.local || ConcurrentMapManager.this.getMember(request.caller) != null;
                if (!callerKnownMember) {
                    request.response = Constants.Objects.OBJECT_REDO;
                    return;
                }
            }
            request.response = cmap.contains(request);
        }
    }

    class ValueCountOperationHandler
    extends MTargetAwareOperationHandler {
        ValueCountOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            request.response = cmap.valueCount(request.key);
        }
    }

    abstract class AbstractMapStoreOperation
    implements Runnable,
    Processable {
        protected final CMap cmap;
        protected final Request request;
        protected boolean success = true;

        protected AbstractMapStoreOperation(CMap cmap, Request request) {
            this.cmap = cmap;
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.doMapStoreOperation();
            }
            catch (Exception e) {
                CMap cmap;
                this.success = false;
                if (e instanceof ClassCastException && (cmap = ConcurrentMapManager.this.getMap(this.request.name)).isMapForQueue() && e.getMessage().contains("java.lang.Long cannot be")) {
                    ConcurrentMapManager.this.logger.log(Level.SEVERE, "This is MapStore for Queue. Make sure you treat the key as Long");
                }
                ConcurrentMapManager.this.logger.log(Level.WARNING, "Store thrown exception for " + (Object)((Object)this.request.operation), e);
                this.request.response = IOUtil.toData(new AddressAwareException(e, ConcurrentMapManager.this.thisAddress));
            }
            finally {
                ConcurrentMapManager.this.enqueueAndReturn(this);
            }
        }

        abstract void doMapStoreOperation();
    }

    class ContainsKeyOperationHandler
    extends MTargetAwareOperationHandler {
        ContainsKeyOperationHandler() {
        }

        public void handle(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            if (cmap.isNotLocked(request)) {
                Record record = cmap.getRecord(request);
                if (!(cmap.loader == null || record != null && record.isActive() && record.isValid() && record.getValueData() != null)) {
                    ConcurrentMapManager.this.storeExecutor.execute(new ContainsKeyLoader(cmap, request), request.key.hashCode());
                } else {
                    this.doOperation(request);
                    ConcurrentMapManager.this.returnResponse(request);
                }
            } else {
                request.response = Constants.Objects.OBJECT_REDO;
                ConcurrentMapManager.this.returnResponse(request);
            }
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            request.response = cmap.contains(request);
        }

        class ContainsKeyLoader
        extends AbstractMapStoreOperation {
            ContainsKeyLoader(CMap cmap, Request request) {
                super(cmap, request);
            }

            void doMapStoreOperation() {
                Object value = this.cmap.loader.load(IOUtil.toObject(this.request.key));
                if (value != null) {
                    ConcurrentMapManager.this.setIndexValues(this.request, value);
                    this.request.value = IOUtil.toData(value);
                    ConcurrentMapManager.this.putTransientAsync(this.request);
                } else {
                    this.success = false;
                }
            }

            public void process() {
                this.request.response = this.success ? Boolean.TRUE : Boolean.FALSE;
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }
    }

    class GetOperationHandler
    extends MTargetAwareOperationHandler {
        GetOperationHandler() {
        }

        public void handle(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            Record record = cmap.getRecord(request);
            if (!(cmap.loader == null || record != null && record.isActive() && record.isValid() && record.getValueData() != null)) {
                ConcurrentMapManager.this.storeExecutor.execute(new GetLoader(cmap, request), request.key.hashCode());
            } else {
                this.doOperation(request);
                ConcurrentMapManager.this.returnResponse(request);
            }
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            Data value = cmap.get(request);
            request.clearForResponse();
            request.response = value;
        }

        class GetLoader
        extends AbstractMapStoreOperation {
            GetLoader(CMap cmap, Request request) {
                super(cmap, request);
            }

            void doMapStoreOperation() {
                Object value = this.cmap.loader.load(IOUtil.toObject(this.request.key));
                if (value != null) {
                    ConcurrentMapManager.this.setIndexValues(this.request, value);
                    this.request.value = IOUtil.toData(value);
                    ConcurrentMapManager.this.putTransientAsync(this.request);
                } else {
                    this.success = false;
                }
            }

            public void process() {
                if (this.success) {
                    this.request.response = this.request.value;
                }
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }
    }

    class GetDataRecordEntryOperationHandler
    extends MTargetAwareOperationHandler {
        GetDataRecordEntryOperationHandler() {
        }

        public void handle(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            if (cmap.isNotLocked(request)) {
                Record record = cmap.getRecord(request);
                if (!(cmap.loader == null || record != null && record.isActive() && record.isValid() && record.getValueData() != null)) {
                    ConcurrentMapManager.this.storeExecutor.execute(new GetDataRecordEntryLoader(cmap, request), request.key.hashCode());
                } else {
                    this.doOperation(request);
                    ConcurrentMapManager.this.returnResponse(request);
                }
            } else {
                request.response = Constants.Objects.OBJECT_REDO;
                ConcurrentMapManager.this.returnResponse(request);
            }
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            Record record = cmap.getRecord(request.key);
            request.response = record == null ? null : new DataRecordEntry(record);
        }

        class GetDataRecordEntryLoader
        extends AbstractMapStoreOperation {
            GetDataRecordEntryLoader(CMap cmap, Request request) {
                super(cmap, request);
            }

            void doMapStoreOperation() {
                Object value = this.cmap.loader.load(IOUtil.toObject(this.request.key));
                if (value != null) {
                    ConcurrentMapManager.this.setIndexValues(this.request, value);
                    this.request.value = IOUtil.toData(value);
                } else {
                    this.success = false;
                }
            }

            public void process() {
                if (this.success) {
                    Record record = this.cmap.createNewRecord(this.request.key, this.request.value);
                    record.setIndexes(this.request.indexes, this.request.indexTypes);
                    this.request.response = new DataRecordEntry(record);
                } else {
                    this.request.response = null;
                }
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }
    }

    class GetMapEntryOperationHandler
    extends MTargetAwareOperationHandler {
        GetMapEntryOperationHandler() {
        }

        public void handle(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            Record record = cmap.getRecord(request);
            if (!(cmap.loader == null || record != null && record.isActive() && record.isValid() && record.getValueData() != null)) {
                ConcurrentMapManager.this.storeExecutor.execute(new GetMapEntryLoader(cmap, request), request.key.hashCode());
            } else {
                this.doOperation(request);
                ConcurrentMapManager.this.returnResponse(request);
            }
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            request.response = cmap.getMapEntry(request);
        }

        class GetMapEntryLoader
        extends AbstractMapStoreOperation {
            GetMapEntryLoader(CMap cmap, Request request) {
                super(cmap, request);
            }

            void doMapStoreOperation() {
                Object value = this.cmap.loader.load(IOUtil.toObject(this.request.key));
                if (value != null) {
                    ConcurrentMapManager.this.setIndexValues(this.request, value);
                    this.request.value = IOUtil.toData(value);
                    ConcurrentMapManager.this.putTransientAsync(this.request);
                } else {
                    this.success = false;
                }
            }

            public void process() {
                if (this.success) {
                    Record record = this.cmap.createNewRecord(this.request.key, this.request.value);
                    this.request.response = new CMap.CMapEntry(record);
                } else {
                    this.request.response = null;
                }
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }
    }

    class MergeOperationHandler
    extends MTargetAwareOperationHandler {
        MergeOperationHandler() {
        }

        public void handle(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            if (cmap.isNotLocked(request)) {
                Record record = cmap.getRecord(request);
                boolean doesNotExist = record == null || !record.isActive() || !record.isValid() || record.getValueData() == null;
                DataRecordEntry existing = doesNotExist ? null : new DataRecordEntry(record);
                ConcurrentMapManager.this.node.executorManager.executeNow(new MergeLoader(cmap, request, existing));
            } else {
                request.response = Constants.Objects.OBJECT_REDO;
                ConcurrentMapManager.this.returnResponse(request);
            }
        }

        void doOperation(Request request) {
        }

        class MergeLoader
        extends AbstractMapStoreOperation {
            private DataRecordEntry existingRecord;

            MergeLoader(CMap cmap, Request request, DataRecordEntry existingRecord) {
                super(cmap, request);
                this.existingRecord = existingRecord;
            }

            void doMapStoreOperation() {
                Object winner = null;
                this.success = false;
                if (this.cmap.mergePolicy != null) {
                    DataRecordEntry newEntry;
                    Object key;
                    if (this.existingRecord == null && this.cmap.loader != null) {
                        this.existingRecord = new MGetDataRecordEntry().get(this.request.name, this.request.key);
                    }
                    if ((key = (newEntry = (DataRecordEntry)IOUtil.toObject(this.request.value)).getKey()) != null && newEntry.hasValue() && (winner = this.cmap.mergePolicy.merge(this.cmap.getName(), newEntry, this.existingRecord)) != null) {
                        if (this.cmap.isMultiMap()) {
                            MPutMulti mput = ConcurrentMapManager.this.node.concurrentMapManager.new MPutMulti();
                            mput.put(this.request.name, this.request.key, winner);
                        } else {
                            MPut mput = ConcurrentMapManager.this.node.concurrentMapManager.new MPut();
                            mput.put(this.request.name, this.request.key, winner, -1L, -1L);
                        }
                        this.success = true;
                    }
                }
            }

            public void process() {
                this.request.response = this.success ? Boolean.TRUE : Boolean.FALSE;
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }
    }

    class EvictOperationHandler
    extends SchedulableOperationHandler {
        EvictOperationHandler() {
        }

        public void handle(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            if (cmap.isNotLocked(request)) {
                Record record = cmap.getRecord(request);
                if (record != null && record.isActive() && cmap.loader != null && cmap.writeDelayMillis > 0L && record.isValid() && record.isDirty()) {
                    record.setDirty(false);
                    request.value = record.getValueData();
                    ConcurrentMapManager.this.storeExecutor.execute(new EvictStorer(cmap, request), request.key.hashCode());
                } else {
                    this.doOperation(request);
                    ConcurrentMapManager.this.returnResponse(request);
                }
            } else {
                request.response = Constants.Objects.OBJECT_REDO;
                ConcurrentMapManager.this.returnResponse(request);
            }
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            request.response = cmap.evict(request);
        }

        class EvictStorer
        extends AbstractMapStoreOperation {
            EvictStorer(CMap cmap, Request request) {
                super(cmap, request);
            }

            void doMapStoreOperation() {
                Object key = IOUtil.toObject(this.request.key);
                Object value = IOUtil.toObject(this.request.value);
                this.cmap.store.store(key, value);
                Record storedRecord = this.cmap.getRecord(this.request);
                if (storedRecord != null) {
                    storedRecord.setLastStoredTime(System.currentTimeMillis());
                }
            }

            public void process() {
                if (this.success) {
                    EvictOperationHandler.this.doOperation(this.request);
                }
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }
    }

    class AddOperationHandler
    extends MTargetAwareOperationHandler {
        AddOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            request.response = cmap.add(request, false);
        }
    }

    class SemaphoreTryAcquireOperationHandler
    extends SemaphoreOperationHandler {
        SemaphoreTryAcquireOperationHandler() {
        }

        void doSemaphoreOperation(Request request, DistributedSemaphore semaphore) {
            Address attachAddress;
            int permits = (int)request.longValue;
            Boolean attach = SemaphoreProxy.DATA_TRUE.equals(request.value);
            Address address = attachAddress = attach != false ? request.caller : null;
            if (semaphore.tryAcquire(permits, attachAddress)) {
                this.doResponse(request, semaphore, 0L, true);
            } else {
                request.lockThreadId = ThreadContext.get().getThreadId();
                this.schedule(request);
            }
        }
    }

    class SemaphoreReleaseOperationHandler
    extends SemaphoreOperationHandler {
        SemaphoreReleaseOperationHandler() {
        }

        void doSemaphoreOperation(Request request, DistributedSemaphore semaphore) {
            int permits = (int)request.longValue;
            boolean detach = SemaphoreProxy.DATA_TRUE.equals(request.value);
            Address detachAddress = detach ? request.caller : null;
            semaphore.release(permits, detachAddress);
            this.doResponse(request, semaphore, 0L, true);
        }
    }

    class SemaphoreReduceOperationHandler
    extends SemaphoreOperationHandler {
        SemaphoreReduceOperationHandler() {
        }

        void doSemaphoreOperation(Request request, DistributedSemaphore semaphore) {
            int permits = (int)request.longValue;
            semaphore.reduce(permits);
            this.doResponse(request, semaphore, 0L, permits > 0);
        }
    }

    class SemaphoreGetAvailableOperationHandler
    extends SemaphoreOperationHandler {
        SemaphoreGetAvailableOperationHandler() {
        }

        void doSemaphoreOperation(Request request, DistributedSemaphore semaphore) {
            this.doResponse(request, semaphore, semaphore.getAvailable(), false);
        }
    }

    class SemaphoreGetAttachedOperationHandler
    extends SemaphoreOperationHandler {
        SemaphoreGetAttachedOperationHandler() {
        }

        void doSemaphoreOperation(Request request, DistributedSemaphore semaphore) {
            this.doResponse(request, semaphore, semaphore.getAttached(request.caller), false);
        }
    }

    class SemaphoreDrainOperationHandler
    extends SemaphoreOperationHandler {
        SemaphoreDrainOperationHandler() {
        }

        void doSemaphoreOperation(Request request, DistributedSemaphore semaphore) {
            int drainedPermits = semaphore.drain();
            this.doResponse(request, semaphore, drainedPermits, drainedPermits > 0);
        }
    }

    class SemaphoreDestroyOperationHandler
    extends SemaphoreOperationHandler {
        SemaphoreDestroyOperationHandler() {
        }

        void doSemaphoreOperation(Request request, DistributedSemaphore semaphore) {
            List<ScheduledAction> scheduledActions = request.record.getScheduledActions();
            if (scheduledActions != null) {
                for (ScheduledAction sa : scheduledActions) {
                    Request sr = sa.getRequest();
                    if (!sr.caller.equals(request.caller) || sr.lockThreadId != ThreadContext.get().getThreadId()) continue;
                    ConcurrentMapManager.this.node.clusterManager.deregisterScheduledAction(sa);
                    this.doResponse(sr, null, 2L, false);
                }
            }
            request.clearForResponse();
            ConcurrentMapManager.this.returnResponse(request);
        }
    }

    class SemaphoreCancelAcquireOperationHandler
    extends SemaphoreOperationHandler {
        SemaphoreCancelAcquireOperationHandler() {
        }

        void doSemaphoreOperation(Request request, DistributedSemaphore semaphore) {
            long retValue = 0L;
            List<ScheduledAction> scheduledActions = request.record.getScheduledActions();
            if (scheduledActions != null) {
                int threadId = ThreadContext.get().getThreadId();
                Iterator<ScheduledAction> i = scheduledActions.iterator();
                while (i.hasNext()) {
                    ScheduledAction sa = i.next();
                    Request sr = sa.getRequest();
                    if (sr.lockThreadId != threadId || !sr.caller.equals(request.caller)) continue;
                    ConcurrentMapManager.this.node.clusterManager.deregisterScheduledAction(sa);
                    this.doResponse(sr, null, 1L, false);
                    i.remove();
                    retValue = 1L;
                    break;
                }
            }
            request.clearForResponse();
            request.longValue = retValue;
            ConcurrentMapManager.this.returnResponse(request);
        }
    }

    class SemaphoreAttachDetachOperationHandler
    extends SemaphoreOperationHandler {
        SemaphoreAttachDetachOperationHandler() {
        }

        void doSemaphoreOperation(Request request, DistributedSemaphore semaphore) {
            int permitsDelta = (int)request.longValue;
            semaphore.attachDetach(permitsDelta, request.caller);
            this.doResponse(request, semaphore, 0L, true);
        }
    }

    abstract class SemaphoreOperationHandler
    extends SchedulableOperationHandler {
        SemaphoreOperationHandler() {
        }

        abstract void doSemaphoreOperation(Request var1, DistributedSemaphore var2);

        public void handle(Request request) {
            request.record = ConcurrentMapManager.this.ensureRecord(request, null);
            if (request.record.getValue() == null) {
                String name = (String)IOUtil.toObject(request.key);
                SemaphoreConfig sc = ConcurrentMapManager.this.node.getConfig().getSemaphoreConfig(name);
                int initialPermits = sc.getInitialPermits();
                if (sc.isFactoryEnabled()) {
                    try {
                        String factoryClassName;
                        SemaphoreFactory factory = sc.getFactoryImplementation();
                        if (factory == null && (factoryClassName = sc.getFactoryClassName()) != null && factoryClassName.length() != 0) {
                            ClassLoader cl = ConcurrentMapManager.this.node.getConfig().getClassLoader();
                            Class<?> factoryClass = Serializer.loadClass(cl, factoryClassName);
                            factory = (SemaphoreFactory)factoryClass.newInstance();
                        }
                        if (factory != null) {
                            initialPermits = factory.getInitialPermits(name, initialPermits);
                        }
                    }
                    catch (Exception e) {
                        ConcurrentMapManager.this.logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                request.record.setValue(new DistributedSemaphore(initialPermits));
            }
            this.doOperation(request);
        }

        void doOperation(Request request) {
            this.doSemaphoreOperation(request, (DistributedSemaphore)request.record.getValue());
        }

        protected void onNoTimeToSchedule(Request request) {
            this.doResponse(request, null, 1L, false);
            ConcurrentMapManager.this.returnResponse(request);
        }

        protected void doResponse(Request request, DistributedSemaphore semaphore, long retValue, boolean changed) {
            boolean wasScheduled = request.scheduled;
            Record record = request.record;
            List<ScheduledAction> scheduledActions = record.getScheduledActions();
            request.clearForResponse();
            if (changed) {
                record.setValue(IOUtil.toData(semaphore));
                record.incrementVersion();
                request.version = record.getVersion();
                request.response = record.getValueData();
            }
            request.longValue = retValue;
            ConcurrentMapManager.this.returnResponse(request);
            if (!wasScheduled && scheduledActions != null) {
                int remaining = scheduledActions.size();
                while (remaining-- > 0 && semaphore.getAvailable() > 0) {
                    ScheduledAction sa = scheduledActions.remove(0);
                    ConcurrentMapManager.this.node.clusterManager.deregisterScheduledAction(sa);
                    if (!sa.expired()) {
                        sa.consume();
                        continue;
                    }
                    sa.onExpire();
                }
            }
        }
    }

    class CountDownLatchSetCountOperationHandler
    extends CountDownLatchOperationHandler {
        CountDownLatchSetCountOperationHandler() {
        }

        void doCountDownLatchOperation(Request request, DistributedCountDownLatch cdl) {
            boolean countSet = cdl.setCount((int)request.longValue, request.caller, request.lockAddress);
            this.doResponse(request, cdl, countSet ? 1 : 0, countSet);
        }
    }

    class CountDownLatchGetOwnerOperationHandler
    extends CountDownLatchOperationHandler {
        CountDownLatchGetOwnerOperationHandler() {
        }

        void doCountDownLatchOperation(Request request, DistributedCountDownLatch cdl) {
            request.clearForResponse();
            request.response = cdl.getOwnerAddress();
            ConcurrentMapManager.this.returnResponse(request);
        }
    }

    class CountDownLatchGetCountOperationHandler
    extends CountDownLatchOperationHandler {
        CountDownLatchGetCountOperationHandler() {
        }

        void doCountDownLatchOperation(Request request, DistributedCountDownLatch cdl) {
            this.doResponse(request, cdl, cdl.getCount(), false);
        }
    }

    class CountDownLatchDestroyOperationHandler
    extends CountDownLatchOperationHandler {
        CountDownLatchDestroyOperationHandler() {
        }

        void doCountDownLatchOperation(Request request, DistributedCountDownLatch cdl) {
            List<ScheduledAction> scheduledActions = request.record.getScheduledActions();
            if (scheduledActions != null) {
                for (ScheduledAction sa : scheduledActions) {
                    ConcurrentMapManager.this.node.clusterManager.deregisterScheduledAction(sa);
                    this.doResponse(sa.getRequest(), null, 2L, false);
                }
            }
            request.clearForResponse();
            ConcurrentMapManager.this.returnResponse(request);
        }
    }

    class CountDownLatchCountDownOperationHandler
    extends CountDownLatchOperationHandler {
        CountDownLatchCountDownOperationHandler() {
        }

        void doCountDownLatchOperation(Request request, DistributedCountDownLatch cdl) {
            this.doResponse(request, cdl, 0L, cdl.countDown());
        }
    }

    class CountDownLatchAwaitOperationHandler
    extends CountDownLatchOperationHandler {
        CountDownLatchAwaitOperationHandler() {
        }

        void doCountDownLatchOperation(Request request, DistributedCountDownLatch cdl) {
            if (cdl.ownerLeft()) {
                request.clearForResponse();
                this.doResponse(request, null, 3L, false);
            } else if (cdl.getCount() == 0) {
                request.clearForResponse();
                this.doResponse(request, null, 0L, false);
            } else {
                request.lockThreadId = ThreadContext.get().getThreadId();
                this.schedule(request);
            }
        }
    }

    abstract class CountDownLatchOperationHandler
    extends SchedulableOperationHandler {
        CountDownLatchOperationHandler() {
        }

        abstract void doCountDownLatchOperation(Request var1, DistributedCountDownLatch var2);

        public void handle(Request request) {
            request.record = ConcurrentMapManager.this.ensureRecord(request, DistributedCountDownLatch.newInstanceData);
            this.doOperation(request);
        }

        void doOperation(Request request) {
            this.doCountDownLatchOperation(request, (DistributedCountDownLatch)request.record.getValue());
        }

        protected void onNoTimeToSchedule(Request request) {
            this.doResponse(request, null, 1L, false);
        }

        protected void doResponse(Request request, DistributedCountDownLatch cdl, long retValue, boolean changed) {
            Record record = request.record;
            request.clearForResponse();
            if (changed) {
                record.setValue(IOUtil.toData(cdl));
                record.incrementVersion();
                request.version = record.getVersion();
                request.response = record.getValueData();
            }
            request.longValue = retValue;
            if (changed && request.operation == ClusterOperation.COUNT_DOWN_LATCH_COUNT_DOWN && cdl.getCount() == 0) {
                request.longValue = this.releaseThreads(record);
            }
            ConcurrentMapManager.this.returnResponse(request);
        }

        private int releaseThreads(Record record) {
            int threadsReleased = 0;
            List<ScheduledAction> scheduledActions = record.getScheduledActions();
            if (scheduledActions != null) {
                for (ScheduledAction sa : scheduledActions) {
                    ConcurrentMapManager.this.node.clusterManager.deregisterScheduledAction(sa);
                    if (!sa.expired()) {
                        sa.consume();
                        ++threadsReleased;
                        continue;
                    }
                    sa.onExpire();
                }
                scheduledActions.clear();
            }
            return threadsReleased;
        }
    }

    class AtomicNumberCompareAndSetOperationHandler
    extends AtomicNumberOperationHandler {
        AtomicNumberCompareAndSetOperationHandler() {
        }

        long getNewValue(long oldValue, long value) {
            return value;
        }

        long getResponseValue(long oldValue, long value) {
            return 1L;
        }
    }

    class AtomicNumberGetAndSetOperationHandler
    extends AtomicNumberOperationHandler {
        AtomicNumberGetAndSetOperationHandler() {
        }

        long getNewValue(long oldValue, long value) {
            return value;
        }

        long getResponseValue(long oldValue, long value) {
            return oldValue;
        }
    }

    class AtomicNumberGetAndAddOperationHandler
    extends AtomicNumberOperationHandler {
        AtomicNumberGetAndAddOperationHandler() {
        }

        long getNewValue(long oldValue, long value) {
            return oldValue + value;
        }

        long getResponseValue(long oldValue, long value) {
            return oldValue;
        }
    }

    class AtomicNumberAddAndGetOperationHandler
    extends AtomicNumberOperationHandler {
        AtomicNumberAddAndGetOperationHandler() {
        }

        long getNewValue(long oldValue, long value) {
            return oldValue + value;
        }

        long getResponseValue(long oldValue, long value) {
            return oldValue + value;
        }
    }

    abstract class AtomicNumberOperationHandler
    extends MTargetAwareOperationHandler {
        AtomicNumberOperationHandler() {
        }

        abstract long getNewValue(long var1, long var3);

        abstract long getResponseValue(long var1, long var3);

        void doOperation(Request request) {
            Record record = ConcurrentMapManager.this.ensureRecord(request, AtomicNumberProxy.DATA_LONG_ZERO);
            Data oldValueData = record.getValueData();
            Data expectedValue = request.value;
            long value = request.longValue;
            request.clearForResponse();
            if (expectedValue == null || expectedValue.equals(oldValueData)) {
                long oldValue = (Long)IOUtil.toObject(oldValueData);
                long newValue = this.getNewValue(oldValue, value);
                request.longValue = this.getResponseValue(oldValue, value);
                if (oldValue != newValue) {
                    record.setValue(IOUtil.toData(newValue));
                    record.incrementVersion();
                    request.version = record.getVersion();
                    request.response = record.getValueData();
                }
            } else {
                request.longValue = 0L;
            }
        }
    }

    class PutOperationHandler
    extends SchedulableOperationHandler {
        PutOperationHandler() {
        }

        protected void onNoTimeToSchedule(Request request) {
            request.response = null;
            if (request.operation == ClusterOperation.CONCURRENT_MAP_TRY_PUT || request.operation == ClusterOperation.CONCURRENT_MAP_PUT_AND_UNLOCK) {
                request.response = Boolean.FALSE;
            }
            ConcurrentMapManager.this.returnResponse(request);
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            cmap.put(request);
            if (request.operation == ClusterOperation.CONCURRENT_MAP_TRY_PUT || request.operation == ClusterOperation.CONCURRENT_MAP_PUT_AND_UNLOCK) {
                request.response = Boolean.TRUE;
            }
        }

        public void handle(Request request) {
            boolean overCapacity;
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            boolean checkCapacity = request.operation == ClusterOperation.CONCURRENT_MAP_PUT || request.operation == ClusterOperation.CONCURRENT_MAP_TRY_PUT || request.operation == ClusterOperation.CONCURRENT_MAP_PUT_AND_UNLOCK;
            boolean bl = overCapacity = checkCapacity && cmap.overCapacity(request);
            if (cmap.isNotLocked(request) && !overCapacity) {
                if (this.shouldSchedule(request)) {
                    if (request.hasEnoughTimeToSchedule()) {
                        this.schedule(request);
                    } else {
                        this.onNoTimeToSchedule(request);
                    }
                    return;
                }
                Record record = cmap.getRecord(request);
                if ((record == null || record.getValueData() == null) && cmap.loader != null) {
                    ConcurrentMapManager.this.storeExecutor.execute(new PutLoader(cmap, request), request.key.hashCode());
                } else {
                    this.storeProceed(cmap, request);
                }
            } else {
                request.response = Constants.Objects.OBJECT_REDO;
                ConcurrentMapManager.this.returnResponse(request);
            }
        }

        void storeProceed(CMap cmap, Request request) {
            if (cmap.store != null && cmap.writeDelayMillis == 0L && cmap.isApplicable(request.operation, request, System.currentTimeMillis())) {
                ConcurrentMapManager.this.storeExecutor.execute(new PutStorer(cmap, request), request.key.hashCode());
            } else {
                this.doOperation(request);
                ConcurrentMapManager.this.returnResponse(request);
            }
        }

        class PutStorer
        extends AbstractMapStoreOperation {
            PutStorer(CMap cmap, Request request) {
                super(cmap, request);
            }

            void doMapStoreOperation() {
                Object value;
                if (this.request.operation == ClusterOperation.CONCURRENT_MAP_REPLACE_IF_SAME) {
                    MultiData multiData = (MultiData)IOUtil.toObject(this.request.value);
                    value = IOUtil.toObject(multiData.getData(1));
                } else {
                    value = IOUtil.toObject(this.request.value);
                }
                Object key = IOUtil.toObject(this.request.key);
                this.cmap.store.store(key, value);
                Record storedRecord = this.cmap.getRecord(this.request);
                if (storedRecord != null) {
                    storedRecord.setLastStoredTime(System.currentTimeMillis());
                }
            }

            public void process() {
                if (this.success) {
                    PutOperationHandler.this.doOperation(this.request);
                }
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }

        class PutLoader
        extends AbstractMapStoreOperation {
            Data valueData;

            PutLoader(CMap cmap, Request request) {
                super(cmap, request);
                this.valueData = null;
            }

            void doMapStoreOperation() {
                Object key = IOUtil.toObject(this.request.key);
                Object value = this.cmap.loader.load(key);
                this.valueData = IOUtil.toData(value);
            }

            public void process() {
                if (this.valueData != null) {
                    Record record = this.cmap.getRecord(this.request);
                    if (record == null) {
                        record = this.cmap.createNewRecord(this.request.key, this.valueData);
                        this.cmap.mapRecords.put(this.request.key, record);
                    } else {
                        record.setValue(this.valueData);
                    }
                }
                PutOperationHandler.this.storeProceed(this.cmap, this.request);
            }
        }
    }

    class PutTransientOperationHandler
    extends SchedulableOperationHandler {
        PutTransientOperationHandler() {
        }

        protected void onNoTimeToSchedule(Request request) {
            request.response = Boolean.FALSE;
            ConcurrentMapManager.this.returnResponse(request);
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            Record record = ConcurrentMapManager.this.ensureRecord(request);
            boolean dirty = record == null ? false : record.isDirty();
            cmap.put(request);
            if (record != null) {
                record.setDirty(dirty);
            }
            if (!dirty) {
                record.setLastStoredTime(System.currentTimeMillis());
            }
            request.value = null;
            request.response = Boolean.TRUE;
        }
    }

    class PutMultiOperationHandler
    extends SchedulableOperationHandler {
        PutMultiOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            request.response = cmap.putMulti(request);
        }
    }

    class RemoveMultiOperationHandler
    extends SchedulableOperationHandler {
        RemoveMultiOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            request.response = cmap.removeMulti(request);
        }
    }

    class RemoveOperationHandler
    extends SchedulableOperationHandler {
        RemoveOperationHandler() {
        }

        protected void onNoTimeToSchedule(Request request) {
            request.response = request.local ? ConcurrentMapManager.this.distributedTimeoutException : ConcurrentMapManager.this.dataTimeoutException;
            ConcurrentMapManager.this.returnResponse(request);
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            cmap.remove(request);
        }

        public void handle(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            if (cmap.isNotLocked(request)) {
                if (this.shouldSchedule(request)) {
                    if (request.hasEnoughTimeToSchedule()) {
                        this.schedule(request);
                    } else {
                        this.onNoTimeToSchedule(request);
                    }
                    return;
                }
                Record record = cmap.getRecord(request);
                if ((record == null || record.getValueData() == null) && cmap.loader != null) {
                    ConcurrentMapManager.this.storeExecutor.execute(new RemoveLoader(cmap, request), request.key.hashCode());
                } else {
                    this.storeProceed(cmap, request);
                }
            } else {
                request.response = Constants.Objects.OBJECT_REDO;
                ConcurrentMapManager.this.returnResponse(request);
            }
        }

        void storeProceed(CMap cmap, Request request) {
            if (cmap.store != null && cmap.writeDelayMillis == 0L) {
                ConcurrentMapManager.this.storeExecutor.execute(new RemoveStorer(cmap, request), request.key.hashCode());
            } else {
                this.doOperation(request);
                ConcurrentMapManager.this.returnResponse(request);
            }
        }

        class RemoveStorer
        extends AbstractMapStoreOperation {
            RemoveStorer(CMap cmap, Request request) {
                super(cmap, request);
            }

            void doMapStoreOperation() {
                Object key = IOUtil.toObject(this.request.key);
                this.cmap.store.delete(key);
            }

            public void process() {
                if (this.success) {
                    RemoveOperationHandler.this.doOperation(this.request);
                }
                ConcurrentMapManager.this.returnResponse(this.request);
            }
        }

        class RemoveLoader
        extends AbstractMapStoreOperation {
            Data valueData;

            RemoveLoader(CMap cmap, Request request) {
                super(cmap, request);
                this.valueData = null;
            }

            void doMapStoreOperation() {
                Object key = IOUtil.toObject(this.request.key);
                Object value = this.cmap.loader.load(key);
                this.valueData = IOUtil.toData(value);
            }

            public void process() {
                if (this.valueData != null) {
                    Record record = this.cmap.getRecord(this.request);
                    if (record == null) {
                        record = this.cmap.createNewRecord(this.request.key, this.valueData);
                        this.cmap.mapRecords.put(this.request.key, record);
                    } else {
                        record.setValue(this.valueData);
                    }
                    RemoveOperationHandler.this.storeProceed(this.cmap, this.request);
                } else {
                    ConcurrentMapManager.this.returnResponse(this.request);
                }
            }
        }
    }

    class RemoveItemOperationHandler
    extends RemoveOperationHandler {
        RemoveItemOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            request.response = cmap.removeItem(request);
        }
    }

    abstract class MTargetAwareOperationHandler
    extends BaseManager.TargetAwareOperationHandler {
        MTargetAwareOperationHandler() {
        }

        boolean isRightRemoteTarget(Request request) {
            boolean callerKnownMember = request.local || ConcurrentMapManager.this.getMember(request.caller) != null;
            return callerKnownMember && ConcurrentMapManager.this.thisAddress.equals(ConcurrentMapManager.this.getKeyOwner(request));
        }
    }

    class InvalidateOperationHandler
    implements PacketProcessor {
        InvalidateOperationHandler() {
        }

        public void process(Packet packet) {
            NearCache nearCache;
            CMap cmap = ConcurrentMapManager.this.getMap(packet.name);
            if (cmap != null && (nearCache = cmap.nearCache) != null) {
                nearCache.invalidate(packet.getKeyData());
            }
            ConcurrentMapManager.this.releasePacket(packet);
        }
    }

    class WanMergePacketProcessor
    implements PacketProcessor {
        final ParallelExecutor parallelExecutor;

        WanMergePacketProcessor() {
            this.parallelExecutor = ConcurrentMapManager.this.node.executorManager.newParallelExecutor(20);
        }

        public void process(Packet packet) {
            final DataRecordEntry dataRecordEntry = (DataRecordEntry)IOUtil.toObject(packet.getValueData());
            CMap cmap = ConcurrentMapManager.this.node.concurrentMapManager.getOrCreateMap(packet.name);
            this.parallelExecutor.execute(new Runnable(){

                public void run() {
                    ConcurrentMapManager.this.mergeWanRecord(dataRecordEntry);
                }
            });
        }
    }

    class AsyncMergePacketProcessor
    implements PacketProcessor {
        AsyncMergePacketProcessor() {
        }

        public void process(Packet packet) {
            packet.operation = ClusterOperation.CONCURRENT_MAP_WAN_MERGE;
            Data key = packet.getKeyData();
            Address address = ConcurrentMapManager.this.getKeyOwner(key);
            if (ConcurrentMapManager.this.thisAddress.equals(address)) {
                WanMergePacketProcessor p = (WanMergePacketProcessor)ConcurrentMapManager.this.getPacketProcessor(ClusterOperation.CONCURRENT_MAP_WAN_MERGE);
                p.process(packet);
            } else {
                ConcurrentMapManager.this.send(packet, address);
            }
        }
    }

    class BackupPacketProcessor
    extends BaseManager.AbstractOperationHandler {
        BackupPacketProcessor() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            Boolean value = cmap.backup(request);
            request.clearForResponse();
            request.response = value;
        }
    }

    class LockMapOperationHandler
    extends BaseManager.MigrationAwareOperationHandler {
        LockMapOperationHandler() {
        }

        void doOperation(Request request) {
            CMap cmap = ConcurrentMapManager.this.getOrCreateMap(request.name);
            cmap.lockMap(request);
        }
    }

    class BlockInfoOperationHandler
    implements PacketProcessor {
        BlockInfoOperationHandler() {
        }

        public void process(Packet packet) {
            Block blockInfo = (Block)IOUtil.toObject(packet.getValueData());
            ConcurrentMapManager.this.partitionManager.completeMigration(blockInfo.getBlockId());
            if (ConcurrentMapManager.this.isMaster() && !blockInfo.isMigrating()) {
                for (MemberImpl member : ConcurrentMapManager.this.lsMembers) {
                    if (member.localMember() || member.getAddress().equals(packet.conn.getEndPoint())) continue;
                    ConcurrentMapManager.this.sendBlockInfo(new Block(blockInfo), member.getAddress());
                }
            }
            ConcurrentMapManager.this.releasePacket(packet);
        }
    }

    class BlocksOperationHandler
    extends BlockInfoOperationHandler {
        BlocksOperationHandler() {
        }

        public void process(Packet packet) {
            Blocks blocks = (Blocks)IOUtil.toObject(packet.getValueData());
            ConcurrentMapManager.this.partitionManager.handleBlocks(blocks);
            ConcurrentMapManager.this.releasePacket(packet);
        }
    }

    class BlockMigrationCheckHandler
    extends BaseManager.AbstractOperationHandler {
        BlockMigrationCheckHandler() {
        }

        void doOperation(Request request) {
            request.response = ConcurrentMapManager.this.partitionManager.containsMigratingBlock();
        }
    }

    class MGetEntries
    extends MigrationAwareSubCall {
        public MGetEntries(Address target, ClusterOperation operation, String name, Predicate predicate) {
            super(target);
            this.setLocal(operation, name, null, predicate, -1L, -1L);
        }
    }

    public class MIterate
    extends BaseManager.MultiCall {
        Entries entries = null;
        final String name;
        final ClusterOperation operation;
        final Predicate predicate;

        public MIterate(ClusterOperation operation, String name, Predicate predicate) {
            this.name = name;
            this.operation = operation;
            this.predicate = predicate;
        }

        BaseManager.SubCall createNewTargetAwareOp(Address target) {
            return new MGetEntries(target, this.operation, this.name, this.predicate);
        }

        void onCall() {
            this.entries = new Entries(ConcurrentMapManager.this, this.name, this.operation, this.predicate);
        }

        boolean onResponse(Object response) {
            Pairs pairs = null;
            if (response instanceof Data) {
                pairs = (Pairs)IOUtil.toObject((Data)response);
            } else if (response instanceof Pairs) {
                pairs = (Pairs)response;
            } else {
                return true;
            }
            this.entries.addEntries(pairs);
            return true;
        }

        Object returnResult() {
            return this.entries;
        }
    }

    public class MIterateLocal
    extends MGetEntries {
        private final String name;
        private final Predicate predicate;

        public MIterateLocal(String name, Predicate predicate) {
            super(ConcurrentMapManager.this.thisAddress, ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS, name, predicate);
            this.name = name;
            this.predicate = predicate;
            this.doOp();
        }

        public Set iterate() {
            Entries entries = new Entries(ConcurrentMapManager.this, this.name, ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS, this.predicate);
            Pairs pairs = (Pairs)this.getResultAsObject();
            entries.addEntries(pairs);
            return entries;
        }

        public Object getResult() {
            return this.getRedoAwareResult();
        }
    }

    public class MEmpty {
        public boolean isEmpty(String name) {
            NearCache nearCache = (NearCache)ConcurrentMapManager.this.mapCaches.get(name);
            if (nearCache != null && !nearCache.isEmpty()) {
                return false;
            }
            CMap cMap = (CMap)ConcurrentMapManager.this.maps.get(name);
            if (cMap != null) {
                long now = System.currentTimeMillis();
                for (Record record : cMap.mapRecords.values()) {
                    if (!record.isActive() || !record.isValid(now) || record.getValueData() == null) continue;
                    if (cMap.readBackupData) {
                        return false;
                    }
                    PartitionServiceImpl.PartitionProxy partition = ConcurrentMapManager.this.partitionManager.partitionServiceImpl.getPartition(record.getBlockId());
                    if (partition == null || partition.getOwner() == null || !partition.getOwner().localMember()) continue;
                    return false;
                }
            }
            return new MSize(name).getSize() == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MSize
    extends BaseManager.MultiCall<Integer> {
        int size = 0;
        final String name;

        public int getSize() {
            int size = (Integer)this.call();
            TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
            if (txn != null) {
                size += txn.size(this.name);
            }
            return size < 0 ? 0 : size;
        }

        public MSize(String name) {
            this.name = name;
        }

        @Override
        BaseManager.SubCall createNewTargetAwareOp(Address target) {
            return new MGetSize(target);
        }

        @Override
        boolean onResponse(Object response) {
            this.size += ((Long)response).intValue();
            return true;
        }

        @Override
        void onCall() {
            this.size = 0;
        }

        @Override
        Integer returnResult() {
            return this.size;
        }

        class MGetSize
        extends MigrationAwareSubCall {
            public MGetSize(Address target) {
                super(target);
                this.setLocal(ClusterOperation.CONCURRENT_MAP_SIZE, MSize.this.name);
                this.request.setLongRequest();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MLockMap
    extends BaseManager.MultiCall<Boolean> {
        private final String name;
        private final ClusterOperation operation;
        private volatile boolean result;

        public MLockMap(String name, boolean lock) {
            this.name = name;
            this.operation = lock ? ClusterOperation.CONCURRENT_MAP_LOCK_MAP : ClusterOperation.CONCURRENT_MAP_UNLOCK_MAP;
        }

        @Override
        BaseManager.SubCall createNewTargetAwareOp(Address target) {
            return new MTargetLockMap(target);
        }

        @Override
        boolean onResponse(Object response) {
            return Boolean.TRUE.equals(response);
        }

        @Override
        void onCall() {
        }

        @Override
        void onComplete() {
            this.result = true;
        }

        @Override
        Boolean returnResult() {
            return this.result;
        }

        @Override
        protected Address getFirstAddressToMakeCall() {
            return ConcurrentMapManager.this.node.getMasterAddress();
        }

        class MTargetLockMap
        extends BaseManager.SubCall {
            public MTargetLockMap(Address target) {
                super(target);
                this.setLocal(MLockMap.this.operation, MLockMap.this.name, null, null, 0L, -1L);
                this.request.setBooleanRequest();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MContainsValue
    extends BaseManager.MultiCall<Boolean> {
        boolean contains = false;
        final String name;
        final Object value;

        public MContainsValue(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        @Override
        BaseManager.SubCall createNewTargetAwareOp(Address target) {
            return new MGetContainsValue(target);
        }

        @Override
        boolean onResponse(Object response) {
            if (response == Boolean.TRUE) {
                this.contains = true;
                return false;
            }
            return true;
        }

        @Override
        void onCall() {
            this.contains = false;
        }

        @Override
        Boolean returnResult() {
            return this.contains;
        }

        class MGetContainsValue
        extends MigrationAwareSubCall {
            public MGetContainsValue(Address target) {
                super(target);
                this.setLocal(ClusterOperation.CONCURRENT_MAP_CONTAINS_VALUE, MContainsValue.this.name, null, MContainsValue.this.value, 0L, -1L);
                this.request.setBooleanRequest();
            }
        }
    }

    abstract class MigrationAwareSubCall
    extends BaseManager.SubCall {
        protected MigrationAwareSubCall(Address target) {
            super(target);
        }

        public void process() {
            this.request.blockId = ConcurrentMapManager.this.partitionManager.hashBlocks();
            super.process();
        }

        public boolean isMigrationAware() {
            return true;
        }
    }

    abstract class MBackupAwareOp
    extends MTargetAwareOp {
        protected final MBackup[] backupOps;
        protected volatile int backupCount;

        MBackupAwareOp() {
            this.backupOps = new MBackup[ConcurrentMapManager.this.MAX_BACKUP_COUNT];
            this.backupCount = 0;
        }

        protected void backup(ClusterOperation operation) {
            if (ConcurrentMapManager.this.thisAddress.equals(this.target) && (operation == ClusterOperation.CONCURRENT_MAP_LOCK || operation == ClusterOperation.CONCURRENT_MAP_UNLOCK)) {
                return;
            }
            if (this.backupCount > 0) {
                int i;
                if (this.backupCount > this.backupOps.length) {
                    String msg = "Max backup is " + this.backupOps.length + " but backupCount is " + this.backupCount;
                    ConcurrentMapManager.this.logger.log(Level.SEVERE, msg);
                    throw new RuntimeException(msg);
                }
                for (i = 0; i < this.backupCount; ++i) {
                    int distance = i + 1;
                    MBackup backupOp = this.backupOps[i];
                    if (backupOp == null) {
                        this.backupOps[i] = backupOp = new MBackup();
                    }
                    if (this.request.key == null || this.request.key.size() == 0) {
                        throw new RuntimeException("Key is null! " + this.request.key);
                    }
                    backupOp.sendBackup(operation, this.target, distance, this.request);
                }
                for (i = 0; i < this.backupCount; ++i) {
                    MBackup backupOp = this.backupOps[i];
                    backupOp.getResultAsBoolean();
                }
            }
        }

        void prepareForBackup() {
            this.backupCount = 0;
            if (ConcurrentMapManager.this.lsMembers.size() > 1) {
                CMap map = ConcurrentMapManager.this.getOrCreateMap(this.request.name);
                this.backupCount = map.getBackupCount();
                this.backupCount = Math.min(this.backupCount, ConcurrentMapManager.this.lsMembers.size());
            }
        }

        public void process() {
            this.prepareForBackup();
            super.process();
        }

        public void handleNoneRedoResponse(Packet packet) {
            this.handleRemoteResponse(packet);
            super.handleNoneRedoResponse(packet);
        }

        public void handleRemoteResponse(Packet packet) {
            this.request.local = true;
            this.request.version = packet.version;
            this.request.lockCount = packet.lockCount;
            this.request.longValue = packet.longValue;
        }
    }

    class MBackupOp
    extends MBackupAwareOp {
        MBackupOp() {
        }

        public void backup(Record record) {
            this.request.setFromRecord(record);
            this.doOp();
            boolean stillOwner = this.getResultAsBoolean();
            if (stillOwner) {
                this.target = ConcurrentMapManager.this.thisAddress;
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
            }
        }

        public void process() {
            this.prepareForBackup();
            if (!ConcurrentMapManager.this.thisAddress.equals(ConcurrentMapManager.this.getKeyOwner(this.request))) {
                this.setResult(Boolean.FALSE);
            } else {
                this.setResult(Boolean.TRUE);
            }
        }
    }

    class MBackup
    extends MTargetAwareOp {
        protected Address owner;
        protected int distance;

        MBackup() {
            this.owner = null;
            this.distance = 0;
        }

        public void sendBackup(ClusterOperation operation, Address owner, int distance, Request reqBackup) {
            this.reset();
            this.owner = owner;
            this.distance = distance;
            this.request.setFromRequest(reqBackup);
            this.request.operation = operation;
            this.request.caller = ConcurrentMapManager.this.thisAddress;
            this.request.setBooleanRequest();
            this.doOp();
        }

        public void reset() {
            super.reset();
            this.owner = null;
            this.distance = 0;
        }

        public void process() {
            MemberImpl targetMember = ConcurrentMapManager.this.getNextMemberAfter(this.owner, true, this.distance);
            if (targetMember == null) {
                this.setResult(Boolean.TRUE);
                return;
            }
            this.target = targetMember.getAddress();
            if (this.target.equals(ConcurrentMapManager.this.thisAddress)) {
                this.doLocalOp();
            } else {
                this.invoke();
            }
        }
    }

    abstract class MTargetAwareOp
    extends BaseManager.TargetAwareOp {
        MTargetAwareOp() {
        }

        public void doOp() {
            this.target = null;
            super.doOp();
        }

        public void setTarget() {
            if (this.target == null) {
                this.target = ConcurrentMapManager.this.getKeyOwner(this.request);
            }
        }
    }

    abstract class MDefaultBackupAndMigrationAwareOp
    extends MBackupAndMigrationAwareOp {
        MDefaultBackupAndMigrationAwareOp() {
        }

        void prepareForBackup() {
            this.backupCount = Math.min(1, ConcurrentMapManager.this.lsMembers.size() - 1);
        }
    }

    abstract class MBackupAndMigrationAwareOp
    extends MBackupAwareOp {
        MBackupAndMigrationAwareOp() {
        }

        public boolean isMigrationAware() {
            return true;
        }
    }

    class MRemoveMulti
    extends MBackupAndMigrationAwareOp {
        MRemoveMulti() {
        }

        boolean remove(String name, Object key, Object value) {
            ThreadContext threadContext = ThreadContext.get();
            TransactionImpl txn = threadContext.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                if (!txn.has(name, key)) {
                    Data oldValue;
                    MLock mlock = new MLock();
                    boolean locked = mlock.lockAndGetValue(name, key, value, 30000L);
                    if (!locked) {
                        ConcurrentMapManager.this.throwCME(key);
                    }
                    boolean existingRecord = (oldValue = mlock.oldValue) != null;
                    txn.attachRemoveOp(name, key, value, !existingRecord);
                    return existingRecord;
                }
                MContainsKey mContainsKey = new MContainsKey();
                boolean containsEntry = mContainsKey.containsEntry(name, key, value);
                txn.attachRemoveOp(name, key, value, !containsEntry);
                return containsEntry;
            }
            boolean result = this.booleanCall(ClusterOperation.CONCURRENT_MAP_REMOVE_MULTI, name, key, value, 0L, -1L);
            if (result) {
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE_MULTI);
            }
            return result;
        }
    }

    class MPut
    extends MBackupAndMigrationAwareOp {
        MPut() {
        }

        public boolean replace(String name, Object key, Object oldValue, Object newValue, long timeout) {
            Object result = this.txnalReplaceIfSame(ClusterOperation.CONCURRENT_MAP_REPLACE_IF_SAME, name, key, newValue, oldValue, timeout);
            return result == Boolean.TRUE;
        }

        public Object replace(String name, Object key, Object value, long timeout, long ttl) {
            return this.txnalPut(ClusterOperation.CONCURRENT_MAP_REPLACE_IF_NOT_NULL, name, key, value, timeout, ttl);
        }

        public Object putIfAbsent(String name, Object key, Object value, long timeout, long ttl) {
            return this.txnalPut(ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT, name, key, value, timeout, ttl);
        }

        public Object put(String name, Object key, Object value, long timeout, long ttl) {
            return this.txnalPut(ClusterOperation.CONCURRENT_MAP_PUT, name, key, value, timeout, ttl);
        }

        public Object put(String name, Object key, Object value, long timeout, long ttl, long txnId) {
            return this.txnalPut(ClusterOperation.CONCURRENT_MAP_PUT, name, key, value, timeout, ttl, txnId);
        }

        public Object putForSync(String name, Object key, Object value) {
            Object result = this.txnalPut(ClusterOperation.CONCURRENT_MAP_SET, name, key, value, -1L, -1L, Long.MIN_VALUE);
            return result == Boolean.TRUE;
        }

        public Object putTransient(String name, Object key, Object value, long timeout, long ttl) {
            return this.txnalPut(ClusterOperation.CONCURRENT_MAP_PUT_TRANSIENT, name, key, value, timeout, ttl);
        }

        public boolean set(String name, Object key, Object value, long ttl) {
            Object result = this.txnalPut(ClusterOperation.CONCURRENT_MAP_SET, name, key, value, -1L, ttl);
            return result == Boolean.TRUE;
        }

        public void merge(Record record) {
            if (BaseManager.getInstanceType(record.getName()).isMultiMap()) {
                Set<Data> values = record.getMultiValues();
                if (values != null && values.size() > 0) {
                    for (Data value : values) {
                        this.mergeOne(record, value);
                    }
                }
            } else {
                this.mergeOne(record, record.getValueData());
            }
        }

        public void mergeOne(Record record, Data valueData) {
            DataRecordEntry dataRecordEntry = new DataRecordEntry(record, valueData);
            this.request.setFromRecord(record);
            this.request.operation = ClusterOperation.CONCURRENT_MAP_MERGE;
            this.request.value = IOUtil.toData(dataRecordEntry);
            this.request.setBooleanRequest();
            this.doOp();
            Boolean returnObject = this.getResultAsBoolean();
            if (returnObject.booleanValue()) {
                this.request.value = valueData;
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
            }
        }

        public boolean tryPut(String name, Object key, Object value, long timeout, long ttl) {
            return (Boolean)this.txnalPut(ClusterOperation.CONCURRENT_MAP_TRY_PUT, name, key, value, timeout, ttl);
        }

        private Object txnalReplaceIfSame(ClusterOperation operation, String name, Object key, Object newValue, Object expectedValue, long timeout) {
            ThreadContext threadContext = ThreadContext.get();
            TransactionImpl txn = threadContext.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                if (!txn.has(name, key)) {
                    MLock mlock = new MLock();
                    boolean locked = mlock.lockAndGetValue(name, key, 30000L);
                    if (!locked) {
                        ConcurrentMapManager.this.throwCME(key);
                    }
                    Data oldObject = null;
                    Data oldValue = mlock.oldValue;
                    if (oldValue != null) {
                        Data data = oldObject = threadContext.isClient() ? oldValue : threadContext.toObject(oldValue);
                    }
                    if (oldObject == null) {
                        return Boolean.FALSE;
                    }
                    if (expectedValue.equals(oldValue)) {
                        txn.attachPutOp(name, key, newValue, false);
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                if (expectedValue.equals(txn.get(name, key))) {
                    txn.attachPutOp(name, key, newValue, false);
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            Data dataExpected = IOUtil.toData(expectedValue);
            Data dataNew = IOUtil.toData(newValue);
            this.setLocal(operation, name, key, new MultiData(dataExpected, dataNew), timeout, -1L);
            this.request.longValue = this.request.value == null ? Integer.MIN_VALUE : (long)dataNew.hashCode();
            ConcurrentMapManager.this.setIndexValues(this.request, newValue);
            this.request.setBooleanRequest();
            this.doOp();
            Boolean returnObject = this.getResultAsBoolean();
            if (!Boolean.FALSE.equals(returnObject)) {
                this.request.value = dataNew;
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
            }
            return returnObject;
        }

        Object txnalPut(ClusterOperation operation, String name, Object key, Object value, long timeout, long ttl) {
            return this.txnalPut(operation, name, key, value, timeout, ttl, -1L);
        }

        Object txnalPut(ClusterOperation operation, String name, Object key, Object value, long timeout, long ttl, long txnId) {
            ThreadContext threadContext = ThreadContext.get();
            TransactionImpl txn = threadContext.getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                Object existingValue;
                if (!txn.has(name, key)) {
                    MLock mlock = new MLock();
                    boolean locked = mlock.lockAndGetValue(name, key, 30000L);
                    if (!locked) {
                        ConcurrentMapManager.this.throwCME(key);
                    }
                    Data oldObject = null;
                    Data oldValue = mlock.oldValue;
                    if (oldValue != null) {
                        Data data = oldObject = threadContext.isClient() ? oldValue : threadContext.toObject(oldValue);
                    }
                    if (operation == ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT && oldObject != null) {
                        txn.attachPutOp(name, key, oldObject, 0L, ttl, false);
                    } else {
                        txn.attachPutOp(name, key, value, 0L, ttl, oldObject == null);
                    }
                    return oldObject;
                }
                if (operation == ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT && (existingValue = txn.get(name, key)) != null) {
                    return existingValue;
                }
                return txn.attachPutOp(name, key, value, false);
            }
            this.setLocal(operation, name, key, value, timeout, ttl);
            this.request.txnId = txnId;
            this.request.longValue = this.request.value == null ? Integer.MIN_VALUE : (long)this.request.value.hashCode();
            ConcurrentMapManager.this.setIndexValues(this.request, value);
            if (operation == ClusterOperation.CONCURRENT_MAP_TRY_PUT || operation == ClusterOperation.CONCURRENT_MAP_SET || operation == ClusterOperation.CONCURRENT_MAP_PUT_AND_UNLOCK || operation == ClusterOperation.CONCURRENT_MAP_PUT_TRANSIENT) {
                this.request.setBooleanRequest();
                Data valueData = this.request.value;
                this.doOp();
                Boolean successful = this.getResultAsBoolean();
                if (successful.booleanValue()) {
                    this.request.value = valueData;
                    this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
                }
                return successful;
            }
            this.request.setObjectRequest();
            this.doOp();
            Object returnObject = this.getResultAsObject();
            if (operation == ClusterOperation.CONCURRENT_MAP_REPLACE_IF_NOT_NULL && returnObject == null) {
                return null;
            }
            if (returnObject instanceof AddressAwareException) {
                ConcurrentMapManager.this.rethrowException(operation, (AddressAwareException)returnObject);
            }
            this.request.longValue = Long.MIN_VALUE;
            this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
            return returnObject;
        }
    }

    class MSemaphore
    extends MDefaultBackupAndMigrationAwareOp {
        SemaphoreOperationsCounter operationsCounter;
        long begin;

        MSemaphore() {
        }

        public void attachDetach(Data name, int permitsDelta) {
            this.doSemaphoreOp(ClusterOperation.SEMAPHORE_ATTACH_DETACH_PERMITS, name, permitsDelta, null, -1L);
            this.operationsCounter.incrementNonAcquires(System.currentTimeMillis() - this.begin, permitsDelta);
        }

        public boolean cancelAcquire(Data name) {
            this.setLocal(ClusterOperation.SEMAPHORE_CANCEL_ACQUIRE, "c:__hz_SemaphoreMap", name, null, -1L, -1L);
            this.doOp();
            this.getResult();
            return this.request.longValue == 1L;
        }

        public int drainPermits(Data name) {
            int drainedPermits = this.doSemaphoreOp(ClusterOperation.SEMAPHORE_DRAIN_PERMITS, name, -1L, null, -1L);
            this.operationsCounter.incrementNonAcquires(System.currentTimeMillis() - this.begin, 0);
            return drainedPermits;
        }

        public int getAvailable(Data name) {
            int availablePermits = this.doSemaphoreOp(ClusterOperation.SEMAPHORE_GET_AVAILABLE_PERMITS, name, -1L, null, -1L);
            this.operationsCounter.incrementNonAcquires(System.currentTimeMillis() - this.begin, 0);
            return availablePermits;
        }

        public int getAttached(Data name) {
            int attachedPermits = this.doSemaphoreOp(ClusterOperation.SEMAPHORE_GET_ATTACHED_PERMITS, name, -1L, false, -1L);
            this.operationsCounter.incrementNonAcquires(System.currentTimeMillis() - this.begin, 0);
            return attachedPermits;
        }

        public void reduce(Data name, int permits) {
            this.doSemaphoreOp(ClusterOperation.SEMAPHORE_REDUCE_PERMITS, name, permits, null, -1L);
            this.operationsCounter.incrementPermitsReduced(System.currentTimeMillis() - this.begin, 0);
        }

        public void release(Data name, int permits, Boolean detach) {
            this.doSemaphoreOp(ClusterOperation.SEMAPHORE_RELEASE, name, permits, detach, -1L);
            this.operationsCounter.incrementReleases(System.currentTimeMillis() - this.begin, permits, detach);
        }

        public boolean tryAcquire(Data name, int permits, boolean attach, long timeout) throws InstanceDestroyedException {
            try {
                int acquireResult = this.doSemaphoreOp(ClusterOperation.SEMAPHORE_TRY_ACQUIRE, name, permits, attach, timeout);
                switch (acquireResult) {
                    case 2: {
                        this.operationsCounter.incrementRejectedAcquires(System.currentTimeMillis() - this.begin);
                        throw new InstanceDestroyedException(Instance.InstanceType.SEMAPHORE, (String)IOUtil.toObject(name));
                    }
                    case 0: {
                        this.operationsCounter.incrementAcquires(System.currentTimeMillis() - this.begin, permits, attach);
                        return true;
                    }
                }
                this.operationsCounter.incrementRejectedAcquires(System.currentTimeMillis() - this.begin);
                return false;
            }
            catch (RuntimeInterruptedException e) {
                this.operationsCounter.incrementRejectedAcquires(System.currentTimeMillis() - this.begin);
                throw e;
            }
        }

        public void destroy(Data name) {
            this.doSemaphoreOp(ClusterOperation.SEMAPHORE_DESTROY, name, -1L, null, -1L);
            new MRemove().remove("c:__hz_SemaphoreMap", name, -1L);
        }

        void setOperationsCounter(SemaphoreOperationsCounter operationsCounter) {
            this.operationsCounter = operationsCounter;
        }

        private int doSemaphoreOp(ClusterOperation op, Data name, long longValue, Object value, long timeout) {
            this.begin = System.currentTimeMillis();
            int responseValue = 1;
            if (longValue != 0L) {
                this.setLocal(op, "c:__hz_SemaphoreMap", name, value, timeout, -1L);
                this.request.longValue = longValue;
                this.doOp();
                Data backup = (Data)this.getResultAsIs();
                responseValue = (int)this.request.longValue;
                if (backup != null) {
                    this.request.value = backup;
                    this.request.longValue = 0L;
                    this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
                    this.operationsCounter.incrementModified(System.currentTimeMillis() - this.begin);
                } else {
                    this.operationsCounter.incrementNonModified(System.currentTimeMillis() - this.begin);
                }
            }
            return responseValue;
        }
    }

    class MCountDownLatch
    extends MDefaultBackupAndMigrationAwareOp {
        CountDownLatchOperationsCounter operationsCounter;
        long begin;

        MCountDownLatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean await(Data name, long timeout, TimeUnit unit) throws InstanceDestroyedException, MemberLeftException {
            try {
                int awaitResult = this.doCountDownLatchOp(ClusterOperation.COUNT_DOWN_LATCH_AWAIT, name, 0, unit.toMillis(timeout));
                switch (awaitResult) {
                    case 2: {
                        throw new InstanceDestroyedException(Instance.InstanceType.COUNT_DOWN_LATCH, (String)IOUtil.toObject(name));
                    }
                    case 3: {
                        MemberImpl owner = new MemberImpl(this.request.lockAddress, ConcurrentMapManager.this.thisAddress.equals(this.request.lockAddress));
                        throw new MemberLeftException(owner);
                    }
                    case 0: {
                        boolean bl = true;
                        return bl;
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.operationsCounter.incrementAwait(System.currentTimeMillis() - this.begin);
            }
        }

        public boolean countDown(Data name) {
            int threadsReleased = this.doCountDownLatchOp(ClusterOperation.COUNT_DOWN_LATCH_COUNT_DOWN, name, 0, -1L);
            this.operationsCounter.incrementCountDown(System.currentTimeMillis() - this.begin, threadsReleased);
            return threadsReleased > 0;
        }

        public int getCount(Data name) {
            int count = this.doCountDownLatchOp(ClusterOperation.COUNT_DOWN_LATCH_GET_COUNT, name, 0, -1L);
            this.operationsCounter.incrementOther(System.currentTimeMillis() - this.begin);
            return count;
        }

        public Address getOwnerAddress(Data name) {
            this.begin = System.currentTimeMillis();
            this.setLocal(ClusterOperation.COUNT_DOWN_LATCH_GET_OWNER, "c:__hz_CountDownLatcheMap", name, null, 0L, -1L);
            this.doOp();
            return (Address)this.getResultAsObject(false);
        }

        public boolean setCount(Data name, int count, Address ownerAddress) {
            int countSet = this.doCountDownLatchOp(ClusterOperation.COUNT_DOWN_LATCH_SET_COUNT, name, count, -1L, ownerAddress);
            this.operationsCounter.incrementOther(System.currentTimeMillis() - this.begin);
            return countSet == 1;
        }

        public void destroy(Data name) {
            this.doCountDownLatchOp(ClusterOperation.COUNT_DOWN_LATCH_DESTROY, name, 0, -1L);
        }

        void setOperationsCounter(CountDownLatchOperationsCounter operationsCounter) {
            this.operationsCounter = operationsCounter;
        }

        private int doCountDownLatchOp(ClusterOperation op, Data name, int value, long timeout) {
            return this.doCountDownLatchOp(op, name, value, timeout, ConcurrentMapManager.this.thisAddress);
        }

        private int doCountDownLatchOp(ClusterOperation op, Data name, int value, long timeout, Address endPoint) {
            this.begin = System.currentTimeMillis();
            this.setLocal(op, "c:__hz_CountDownLatcheMap", name, null, timeout, -1L);
            this.request.longValue = value;
            this.request.lockAddress = endPoint;
            this.doOp();
            Data backup = (Data)this.getResultAsIs();
            int responseValue = (int)this.request.longValue;
            if (backup != null) {
                this.request.value = backup;
                this.request.longValue = 0L;
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
            }
            return responseValue;
        }
    }

    class MAtomicNumber
    extends MDefaultBackupAndMigrationAwareOp {
        AtomicNumberOperationsCounter operationsCounter;

        MAtomicNumber() {
        }

        public long addAndGet(Data name, long delta) {
            return this.doAtomicOp(ClusterOperation.ATOMIC_NUMBER_ADD_AND_GET, name, delta, null);
        }

        public boolean compareAndSet(Data name, long expectedValue, long newValue) {
            return this.doAtomicOp(ClusterOperation.ATOMIC_NUMBER_COMPARE_AND_SET, name, newValue, IOUtil.toData(expectedValue)) == 1L;
        }

        public long getAndAdd(Data name, long delta) {
            return this.doAtomicOp(ClusterOperation.ATOMIC_NUMBER_GET_AND_ADD, name, delta, null);
        }

        public long getAndSet(Data name, long newValue) {
            return this.doAtomicOp(ClusterOperation.ATOMIC_NUMBER_GET_AND_SET, name, newValue, null);
        }

        public void destroy(Data name) {
            new MRemove().remove("c:__hz_AtomicLongMap", name, -1L);
        }

        void setOperationsCounter(AtomicNumberOperationsCounter operationsCounter) {
            this.operationsCounter = operationsCounter;
        }

        private long doAtomicOp(ClusterOperation op, Data name, long value, Data expected) {
            long begin = System.currentTimeMillis();
            this.setLocal(op, "c:__hz_AtomicLongMap", name, expected, 0L, 0L);
            this.request.longValue = value;
            this.doOp();
            Data backup = (Data)this.getResultAsIs();
            long responseValue = this.request.longValue;
            if (backup != null) {
                this.request.value = backup;
                this.request.longValue = 0L;
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
                this.operationsCounter.incrementModified(System.currentTimeMillis() - begin);
            } else {
                this.operationsCounter.incrementNonModified(System.currentTimeMillis() - begin);
            }
            return responseValue;
        }
    }

    class MPutMulti
    extends MBackupAndMigrationAwareOp {
        MPutMulti() {
        }

        boolean put(String name, Object key, Object value) {
            ThreadContext threadContext = ThreadContext.get();
            TransactionImpl txn = threadContext.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                if (!txn.has(name, key, value)) {
                    boolean added;
                    MLock mlock = new MLock();
                    boolean locked = mlock.lockAndGetValue(name, key, value, 30000L);
                    if (!locked) {
                        ConcurrentMapManager.this.throwCME(key);
                    }
                    boolean bl = added = mlock.oldValue == null;
                    if (added) {
                        txn.attachPutOp(name, key, value, true);
                    }
                    return added;
                }
                return false;
            }
            boolean result = this.booleanCall(ClusterOperation.CONCURRENT_MAP_PUT_MULTI, name, key, value, 0L, -1L);
            if (result) {
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
            }
            return result;
        }
    }

    class MAdd
    extends MBackupAndMigrationAwareOp {
        MAdd() {
        }

        boolean addToList(String name, Object value) {
            ThreadContext threadContext = ThreadContext.get();
            TransactionImpl txn = threadContext.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                txn.attachAddOp(name, value);
                return true;
            }
            Data key = ThreadContext.get().toData(value);
            boolean result = this.booleanCall(ClusterOperation.CONCURRENT_MAP_ADD_TO_LIST, name, key, null, 0L, -1L);
            this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_ADD);
            return result;
        }

        boolean addToSet(String name, Object value) {
            ThreadContext threadContext = ThreadContext.get();
            TransactionImpl txn = threadContext.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                if (!txn.has(name, value)) {
                    MContainsKey containsKey = new MContainsKey();
                    if (!containsKey.containsKey(name, value)) {
                        txn.attachPutOp(name, value, null, true);
                        return true;
                    }
                    return false;
                }
                return false;
            }
            Data key = ThreadContext.get().toData(value);
            boolean result = this.booleanCall(ClusterOperation.CONCURRENT_MAP_ADD_TO_SET, name, key, null, 0L, -1L);
            this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_ADD);
            return result;
        }
    }

    class MRemove
    extends MBackupAndMigrationAwareOp {
        MRemove() {
        }

        public Object remove(String name, Object key, long timeout) {
            return this.txnalRemove(ClusterOperation.CONCURRENT_MAP_REMOVE, name, key, null, timeout, -1L);
        }

        public Object removeIfSame(String name, Object key, Object value, long timeout) {
            return this.txnalRemove(ClusterOperation.CONCURRENT_MAP_REMOVE_IF_SAME, name, key, value, timeout, -1L);
        }

        public Object tryRemove(String name, Object key, long timeout) throws TimeoutException {
            Object result = this.txnalRemove(ClusterOperation.CONCURRENT_MAP_REMOVE, name, key, null, timeout, -1L);
            if (result != null && result instanceof DistributedTimeoutException) {
                throw new TimeoutException();
            }
            return result;
        }

        public void removeForSync(String name, Object key) {
            this.txnalRemove(ClusterOperation.CONCURRENT_MAP_REMOVE, name, key, null, -1L, Long.MIN_VALUE);
        }

        private Object txnalRemove(ClusterOperation operation, String name, Object key, Object value, long timeout, long txnId) {
            ThreadContext threadContext = ThreadContext.get();
            TransactionImpl txn = threadContext.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                if (!txn.has(name, key)) {
                    MLock mlock = new MLock();
                    boolean locked = mlock.lockAndGetValue(name, key, timeout);
                    if (!locked) {
                        ConcurrentMapManager.this.throwCME(key);
                    }
                    Data oldObject = null;
                    Data oldValue = mlock.oldValue;
                    if (oldValue != null) {
                        oldObject = threadContext.isClient() ? oldValue : threadContext.toObject(oldValue);
                    }
                    int removedValueCount = 0;
                    if (oldObject != null) {
                        if (oldObject instanceof DistributedTimeoutException) {
                            return oldObject;
                        }
                        if (oldObject instanceof CMap.Values) {
                            CMap.Values values = (CMap.Values)((Object)oldObject);
                            removedValueCount = values.size();
                        } else {
                            removedValueCount = 1;
                        }
                    }
                    txn.attachRemoveOp(name, key, value, oldObject == null, removedValueCount);
                    return oldObject;
                }
                return txn.attachRemoveOp(name, key, value, false);
            }
            this.request.txnId = txnId;
            Object oldValue = this.objectCall(operation, name, key, value, timeout, -1L);
            if (oldValue != null) {
                if (oldValue instanceof AddressAwareException) {
                    ConcurrentMapManager.this.rethrowException(operation, (AddressAwareException)oldValue);
                }
                if (!(oldValue instanceof DistributedTimeoutException)) {
                    this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE);
                }
            }
            return oldValue;
        }

        public final void handleNoneRedoResponse(Packet packet) {
            NearCache nearCache = (NearCache)ConcurrentMapManager.this.mapCaches.get(this.request.name);
            if (nearCache != null) {
                nearCache.invalidate(this.request.key);
            }
            super.handleNoneRedoResponse(packet);
        }
    }

    class MRemoveItem
    extends MBackupAndMigrationAwareOp {
        MRemoveItem() {
        }

        public boolean removeItem(String name, Object key) {
            return this.removeItem(name, key, null);
        }

        public boolean removeItem(String name, Object key, Object value) {
            ThreadContext threadContext = ThreadContext.get();
            TransactionImpl txn = threadContext.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                try {
                    if (!txn.has(name, key)) {
                        MLock mlock = new MLock();
                        boolean locked = mlock.lockAndGetValue(name, key, 30000L);
                        if (!locked) {
                            ConcurrentMapManager.this.throwCME(key);
                        }
                        Data oldObject = null;
                        Data oldValue = mlock.oldValue;
                        if (oldValue != null) {
                            oldObject = threadContext.isClient() ? oldValue : threadContext.toObject(oldValue);
                        }
                        txn.attachRemoveOp(name, key, null, oldObject == null);
                        return oldObject != null;
                    }
                    return txn.attachRemoveOp(name, key, null, false) != null;
                }
                catch (Exception e1) {
                    ConcurrentMapManager.this.logger.log(Level.WARNING, e1.getMessage(), e1);
                    return false;
                }
            }
            boolean removed = this.booleanCall(ClusterOperation.CONCURRENT_MAP_REMOVE_ITEM, name, key, value, 0L, -1L);
            if (removed) {
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE);
            }
            return removed;
        }
    }

    class MValueCount
    extends MTargetAwareOp {
        MValueCount() {
        }

        public Object count(String name, Object key, long timeout) {
            this.request.setLongRequest();
            return this.objectCall(ClusterOperation.CONCURRENT_MAP_VALUE_COUNT, name, key, null, timeout, -1L);
        }

        public boolean isMigrationAware() {
            return true;
        }
    }

    class MGet
    extends MTargetAwareOp {
        Object keyObject = null;

        MGet() {
        }

        public Object get(String name, Object key, long timeout) {
            Object value;
            this.keyObject = key;
            ThreadContext tc = ThreadContext.get();
            TransactionImpl txn = tc.getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1 && txn.has(name, key)) {
                return txn.get(name, key);
            }
            CMap cMap = (CMap)ConcurrentMapManager.this.maps.get(name);
            if (cMap != null) {
                Data valueData;
                Record record;
                Object value2;
                NearCache nearCache = cMap.nearCache;
                if (nearCache != null && (value2 = nearCache.get(key)) != null) {
                    return value2;
                }
                Data dataKey = IOUtil.toData(key);
                Record ownedRecord = cMap.getOwnedRecord(dataKey);
                if (ownedRecord != null && ownedRecord.isActive() && ownedRecord.isValid()) {
                    long version = ownedRecord.getVersion();
                    Object result = null;
                    if (tc.isClient()) {
                        Data valueData2 = ownedRecord.getValueData();
                        if (valueData2 != null && valueData2.size() > 0) {
                            result = valueData2;
                        }
                    } else {
                        Object value3 = ownedRecord.getValue();
                        if (value3 != null) {
                            result = value3;
                        }
                    }
                    if (result != null && ownedRecord.getVersion() == version) {
                        ownedRecord.setLastAccessed();
                        return result;
                    }
                }
                if (cMap.readBackupData && (record = (Record)cMap.mapRecords.get(dataKey)) != null && cMap.isBackup(record) && record.isActive() && record.isValid() && (valueData = record.getValueData()) != null && valueData.size() > 0) {
                    return tc.isClient() ? valueData : IOUtil.toObject(valueData);
                }
            }
            if ((value = this.objectCall(ClusterOperation.CONCURRENT_MAP_GET, name, key, null, timeout, -1L)) instanceof AddressAwareException) {
                ConcurrentMapManager.this.rethrowException(this.request.operation, (AddressAwareException)value);
            }
            return value;
        }

        public void reset() {
            this.keyObject = null;
            super.reset();
        }

        public final void handleNoneRedoResponse(Packet packet) {
            Data value;
            NearCache nearCache;
            CMap cMap = (CMap)ConcurrentMapManager.this.maps.get(this.request.name);
            if (cMap != null && (nearCache = cMap.nearCache) != null && (value = packet.getValueData()) != null && value.size() > 0) {
                nearCache.put(this.keyObject, this.request.key, packet.getValueData());
            }
            super.handleNoneRedoResponse(packet);
        }

        public boolean isMigrationAware() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PutAllCallable
    implements Callable<Boolean>,
    HazelcastInstanceAware,
    DataSerializable {
        private String mapName;
        private Pairs pairs;
        private FactoryImpl factory = null;

        public PutAllCallable() {
        }

        public PutAllCallable(String mapName, Pairs pairs) {
            this.mapName = mapName;
            this.pairs = pairs;
        }

        @Override
        public Boolean call() throws Exception {
            final ConcurrentMapManager c = this.factory.node.concurrentMapManager;
            CMap cmap = c.getMap(this.mapName);
            if (cmap == null) {
                c.enqueueAndWait(new Processable(){

                    public void process() {
                        c.getOrCreateMap(PutAllCallable.this.mapName);
                    }
                }, 100);
                cmap = c.getMap(this.mapName);
            }
            if (cmap != null) {
                for (KeyValue keyValue : this.pairs.getKeyValues()) {
                    Object value = cmap.getMapIndexService().hasIndexedAttributes() ? keyValue.getValue() : keyValue.getValueData();
                    IMap map = (IMap)this.factory.getOrCreateProxyByName(cmap.name);
                    map.put(keyValue.getKeyData(), value);
                }
            }
            return Boolean.TRUE;
        }

        @Override
        public void readData(DataInput in) throws IOException {
            this.mapName = in.readUTF();
            this.pairs = new Pairs();
            this.pairs.readData(in);
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            out.writeUTF(this.mapName);
            this.pairs.writeData(out);
        }

        @Override
        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.factory = (FactoryImpl)hazelcastInstance;
        }
    }

    class MAddKeyListener
    extends MTargetAwareOp {
        MAddKeyListener() {
        }

        public boolean addListener(String name, boolean add, Object key, boolean includeValue) {
            ClusterOperation operation = add ? ClusterOperation.ADD_LISTENER : ClusterOperation.REMOVE_LISTENER;
            this.setLocal(operation, name, key, null, -1L, -1L);
            this.request.longValue = includeValue ? 1L : 0L;
            this.request.setBooleanRequest();
            this.doOp();
            return this.getResultAsBoolean();
        }

        public boolean isMigrationAware() {
            return true;
        }
    }

    class MGetDataRecordEntry
    extends MTargetAwareOp {
        MGetDataRecordEntry() {
        }

        public DataRecordEntry get(String name, Object key) {
            Object result = this.objectCall(ClusterOperation.CONCURRENT_MAP_GET_DATA_RECORD_ENTRY, name, key, null, 0L, -1L);
            if (result instanceof Data) {
                result = IOUtil.toObject((Data)result);
            }
            return (DataRecordEntry)result;
        }
    }

    class MGetMapEntry
    extends MTargetAwareOp {
        MGetMapEntry() {
        }

        public MapEntry get(String name, Object key) {
            CMap.CMapEntry mapEntry;
            Object result = this.objectCall(ClusterOperation.CONCURRENT_MAP_GET_MAP_ENTRY, name, key, null, 0L, -1L);
            if (result instanceof Data) {
                result = IOUtil.toObject((Data)result);
            }
            if ((mapEntry = (CMap.CMapEntry)result) != null) {
                mapEntry.setHazelcastInstance(ConcurrentMapManager.this.node.factory);
                mapEntry.set(name, key);
            }
            return mapEntry;
        }
    }

    class MMigrate
    extends MBackupAwareOp {
        MMigrate() {
        }

        public boolean migrateMulti(Record record, Data value) {
            this.request.setFromRecord(record);
            this.request.value = value;
            this.request.operation = ClusterOperation.CONCURRENT_MAP_MIGRATE_RECORD;
            this.request.setBooleanRequest();
            this.doOp();
            boolean result = this.getResultAsBoolean();
            this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
            return result;
        }

        public boolean migrate(Record record) {
            this.request.setFromRecord(record);
            if (this.request.key == null) {
                throw new RuntimeException("req.key is null " + this.request.redoCount);
            }
            this.request.operation = ClusterOperation.CONCURRENT_MAP_MIGRATE_RECORD;
            this.request.setBooleanRequest();
            this.doOp();
            boolean result = this.getResultAsBoolean();
            this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_PUT);
            return result;
        }

        public void setTarget() {
            Block block;
            this.target = ConcurrentMapManager.this.getKeyOwner(this.request);
            if (this.target == null && (block = ConcurrentMapManager.this.blocks[this.request.blockId]) != null) {
                this.target = block.getMigrationAddress();
            }
        }
    }

    class MEvict
    extends MBackupAndMigrationAwareOp {
        MEvict() {
        }

        public boolean evict(String name, Object key) {
            return this.evict(ClusterOperation.CONCURRENT_MAP_EVICT, name, key);
        }

        public boolean evict(ClusterOperation operation, String name, Object key) {
            Data k = key instanceof Data ? (Data)key : IOUtil.toData(key);
            this.request.setLocal(operation, name, k, null, 0, -1L, -1L, ConcurrentMapManager.this.thisAddress);
            this.request.setBooleanRequest();
            this.doOp();
            boolean result = this.getResultAsBoolean();
            if (result) {
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE);
            }
            return result;
        }

        public final void handleNoneRedoResponse(Packet packet) {
            NearCache nearCache = (NearCache)ConcurrentMapManager.this.mapCaches.get(this.request.name);
            if (nearCache != null) {
                nearCache.invalidate(this.request.key);
            }
            super.handleNoneRedoResponse(packet);
        }
    }

    class MContainsKey
    extends MTargetAwareOp {
        Object keyObject = null;
        NearCache nearCache = null;

        MContainsKey() {
        }

        public boolean containsEntry(String name, Object key, Object value) {
            return this.booleanCall(ClusterOperation.CONCURRENT_MAP_CONTAINS_ENTRY, name, key, value, 0L, -1L);
        }

        public boolean containsKey(String name, Object key) {
            Record record;
            CMap cMap;
            this.keyObject = key;
            this.nearCache = (NearCache)ConcurrentMapManager.this.mapCaches.get(name);
            Data dataKey = IOUtil.toData(key);
            if (this.nearCache != null) {
                if (this.nearCache.containsKey(key)) {
                    return true;
                }
                if (this.nearCache.getMaxSize() == Integer.MAX_VALUE) {
                    return false;
                }
            }
            if ((cMap = (CMap)ConcurrentMapManager.this.maps.get(name)) != null && (record = cMap.getOwnedRecord(dataKey)) != null && record.isActive() && record.isValid() && record.getValueData() != null) {
                if (cMap.readBackupData) {
                    return true;
                }
                PartitionServiceImpl.PartitionProxy partition = ConcurrentMapManager.this.partitionManager.partitionServiceImpl.getPartition(record.getBlockId());
                if (partition != null && !partition.isMigrating() && partition.getOwner() != null && partition.getOwner().localMember()) {
                    return true;
                }
            }
            return this.booleanCall(ClusterOperation.CONCURRENT_MAP_CONTAINS_KEY, name, dataKey, null, 0L, -1L);
        }

        public void reset() {
            this.keyObject = null;
            this.nearCache = null;
            super.reset();
        }

        protected void setResult(Object obj) {
            if (obj != null && obj == Boolean.TRUE && this.nearCache != null) {
                this.nearCache.setContainsKey(this.keyObject, this.request.key);
            }
            super.setResult(obj);
        }

        public boolean isMigrationAware() {
            return true;
        }
    }

    class MLock
    extends MBackupAndMigrationAwareOp {
        volatile Data oldValue = null;

        MLock() {
        }

        public boolean unlock(String name, Object key, long timeout) {
            boolean unlocked = this.booleanCall(ClusterOperation.CONCURRENT_MAP_UNLOCK, name, key, null, timeout, -1L);
            if (unlocked) {
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_LOCK);
            }
            return unlocked;
        }

        public boolean lock(String name, Object key, long timeout) {
            boolean locked = this.booleanCall(ClusterOperation.CONCURRENT_MAP_LOCK, name, key, null, timeout, -1L);
            if (locked) {
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_LOCK);
            }
            return locked;
        }

        public boolean lockAndGetValue(String name, Object key, long timeout) {
            return this.lockAndGetValue(name, key, null, timeout);
        }

        public boolean lockAndGetValue(String name, Object key, Object value, long timeout) {
            boolean locked = this.booleanCall(ClusterOperation.CONCURRENT_MAP_TRY_LOCK_AND_GET, name, key, value, timeout, -1L);
            if (locked) {
                this.backup(ClusterOperation.CONCURRENT_MAP_BACKUP_LOCK);
            }
            return locked;
        }

        public void afterGettingResult(Request request) {
            if (request.operation == ClusterOperation.CONCURRENT_MAP_TRY_LOCK_AND_GET && this.oldValue == null) {
                this.oldValue = request.value;
            }
            super.afterGettingResult(request);
        }

        public void handleNoneRedoResponse(Packet packet) {
            if (this.request.operation == ClusterOperation.CONCURRENT_MAP_TRY_LOCK_AND_GET) {
                this.oldValue = packet.getValueData();
                this.request.value = packet.getValueData();
            }
            super.handleNoneRedoResponse(packet);
        }
    }
}

