/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MulticastConfig
implements DataSerializable {
    public static final boolean DEFAULT_ENABLED = true;
    public static final String DEFAULT_MULTICAST_GROUP = "224.2.2.3";
    public static final int DEFAULT_MULTICAST_PORT = 54327;
    public static final int DEFAULT_MULTICAST_TIMEOUT_SECONDS = 2;
    private boolean enabled = true;
    private String multicastGroup = "224.2.2.3";
    private int multicastPort = 54327;
    private int multicastTimeoutSeconds = 2;

    public boolean isEnabled() {
        return this.enabled;
    }

    public MulticastConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getMulticastGroup() {
        return this.multicastGroup;
    }

    public MulticastConfig setMulticastGroup(String multicastGroup) {
        this.multicastGroup = multicastGroup;
        return this;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public MulticastConfig setMulticastPort(int multicastPort) {
        this.multicastPort = multicastPort;
        return this;
    }

    public int getMulticastTimeoutSeconds() {
        return this.multicastTimeoutSeconds;
    }

    public MulticastConfig setMulticastTimeoutSeconds(int multicastTimeoutSeconds) {
        this.multicastTimeoutSeconds = multicastTimeoutSeconds;
        return this;
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeBoolean(this.enabled);
        out.writeUTF(this.multicastGroup);
        out.writeInt(this.multicastPort);
        out.writeInt(this.multicastTimeoutSeconds);
    }

    public void readData(DataInput in) throws IOException {
        this.enabled = in.readBoolean();
        this.multicastGroup = in.readUTF();
        this.multicastPort = in.readInt();
        this.multicastTimeoutSeconds = in.readInt();
    }

    public String toString() {
        return "MulticastConfig [enabled=" + this.enabled + ", multicastGroup=" + this.multicastGroup + ", multicastPort=" + this.multicastPort + ", multicastTimeoutSeconds=" + this.multicastTimeoutSeconds + "]";
    }
}

