/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.Instance;
import com.hazelcast.core.MapEntry;
import com.hazelcast.core.Transaction;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.ThreadContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransactionImpl
implements Transaction {
    public static final long DEFAULT_TXN_TIMEOUT = 30000L;
    private final long id;
    private final FactoryImpl factory;
    private final List<TransactionRecord> transactionRecords = new CopyOnWriteArrayList<TransactionRecord>();
    private int status = 0;

    public TransactionImpl(FactoryImpl factory, long txnId) {
        this.id = txnId;
        this.factory = factory;
    }

    public Object attachAddOp(String name, Object key) {
        TransactionRecord rec = this.findTransactionRecord(name, key);
        if (rec == null) {
            rec = new TransactionRecord(name, key, 1, true);
            this.transactionRecords.add(rec);
            return null;
        }
        Object old = rec.value;
        rec.value = (Integer)rec.value + 1;
        rec.removed = false;
        return old;
    }

    public Object attachPutOp(String name, Object key, Object value, boolean newRecord) {
        return this.attachPutOp(name, key, value, 0L, -1L, newRecord);
    }

    public Object attachPutOp(String name, Object key, Object value, long timeout, boolean newRecord) {
        return this.attachPutOp(name, key, value, timeout, -1L, newRecord);
    }

    public Object attachPutOp(String name, Object key, Object value, long timeout, long ttl, boolean newRecord) {
        Instance.InstanceType instanceType = ConcurrentMapManager.getInstanceType(name);
        Object matchValue = instanceType.isMultiMap() ? value : null;
        TransactionRecord rec = this.findTransactionRecord(name, key, matchValue);
        if (rec == null) {
            rec = new TransactionRecord(name, key, value, newRecord);
            rec.timeout = timeout;
            rec.ttl = ttl;
            this.transactionRecords.add(rec);
            return null;
        }
        Object old = rec.value;
        rec.value = value;
        rec.removed = false;
        return old;
    }

    public Object attachRemoveOp(String name, Object key, Object value, boolean newRecord) {
        return this.attachRemoveOp(name, key, value, newRecord, 1);
    }

    public Object attachRemoveOp(String name, Object key, Object value, boolean newRecord, int valueCount) {
        Instance.InstanceType instanceType = ConcurrentMapManager.getInstanceType(name);
        Object matchValue = instanceType.isMultiMap() ? value : null;
        TransactionRecord rec = this.findTransactionRecord(name, key, matchValue);
        Object oldValue = null;
        if (rec == null) {
            rec = new TransactionRecord(name, key, value, newRecord);
            this.transactionRecords.add(rec);
        } else {
            oldValue = rec.value;
            rec.value = value;
        }
        rec.valueCount = valueCount;
        rec.removed = true;
        return oldValue;
    }

    @Override
    public void begin() throws IllegalStateException {
        if (this.status == 1) {
            throw new IllegalStateException("Transaction is already active");
        }
        this.status = 1;
    }

    @Override
    public void commit() throws IllegalStateException {
        if (this.status != 1) {
            throw new IllegalStateException("Transaction is not active");
        }
        this.status = 6;
        try {
            for (TransactionRecord transactionRecord : this.transactionRecords) {
                transactionRecord.commit();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.finalizeTxn();
            this.status = 3;
        }
    }

    public boolean containsValue(String name, Object value) {
        for (TransactionRecord transactionRecord : this.transactionRecords) {
            if (!transactionRecord.name.equals(name) || transactionRecord.removed || !value.equals(transactionRecord.value)) continue;
            return true;
        }
        return false;
    }

    public TransactionRecord findTransactionRecord(String name, Object key) {
        return this.findTransactionRecord(name, key, null);
    }

    public TransactionRecord findTransactionRecord(String name, Object key, Object value) {
        for (TransactionRecord transactionRecord : this.transactionRecords) {
            if (!transactionRecord.name.equals(name) || transactionRecord.key == null || !transactionRecord.key.equals(key) || value != null && !value.equals(transactionRecord.value)) continue;
            return transactionRecord;
        }
        return null;
    }

    public Object get(String name, Object key) {
        TransactionRecord rec = this.findTransactionRecord(name, key);
        if (rec == null) {
            return null;
        }
        if (rec.removed) {
            return null;
        }
        rec.lastAccess = System.currentTimeMillis();
        return rec.value;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public boolean has(String name, Object key) {
        return this.findTransactionRecord(name, key) != null;
    }

    public boolean has(String name, Object key, Object value) {
        return this.findTransactionRecord(name, key, value) != null;
    }

    public boolean isNew(String name, Object key) {
        TransactionRecord rec = this.findTransactionRecord(name, key);
        return rec != null && !rec.removed && rec.newRecord;
    }

    public boolean isRemoved(String name, Object key) {
        TransactionRecord rec = this.findTransactionRecord(name, key);
        return rec != null && rec.removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws IllegalStateException {
        if (this.status == 0 || this.status == 8 || this.status == 3 || this.status == 4) {
            throw new IllegalStateException("Transaction is not ready to rollback. Status= " + this.status);
        }
        this.status = 7;
        try {
            for (TransactionRecord transactionRecord : this.transactionRecords) {
                transactionRecord.rollback();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.finalizeTxn();
            this.status = 4;
        }
    }

    public int size(String name) {
        int size = 0;
        for (TransactionRecord transactionRecord : this.transactionRecords) {
            if (!transactionRecord.name.equals(name)) continue;
            if (transactionRecord.removed) {
                if (transactionRecord.instanceType.isSet()) {
                    --size;
                    continue;
                }
                if (transactionRecord.newRecord || transactionRecord.instanceType.isQueue()) continue;
                size -= transactionRecord.valueCount;
                continue;
            }
            if (!transactionRecord.newRecord) continue;
            if (transactionRecord.instanceType.isList()) {
                size += ((Integer)transactionRecord.value).intValue();
                continue;
            }
            ++size;
        }
        return size;
    }

    public List newValues(String name) {
        ArrayList<Object> lsValues = null;
        for (TransactionRecord transactionRecord : this.transactionRecords) {
            if (!transactionRecord.name.equals(name) || transactionRecord.removed || transactionRecord.value == null || !transactionRecord.newRecord) continue;
            if (lsValues == null) {
                lsValues = new ArrayList<Object>(2);
            }
            lsValues.add(transactionRecord.value);
        }
        return lsValues;
    }

    public List<Map.Entry> newEntries(String name) {
        ArrayList<MapEntry> lsEntries = null;
        for (TransactionRecord transactionRecord : this.transactionRecords) {
            if (!transactionRecord.name.equals(name) || transactionRecord.removed || transactionRecord.value == null || !transactionRecord.newRecord) continue;
            if (lsEntries == null) {
                lsEntries = new ArrayList<MapEntry>(2);
            }
            lsEntries.add(BaseManager.createSimpleMapEntry(this.factory, name, transactionRecord.key, transactionRecord.value));
        }
        return lsEntries;
    }

    public Map newKeys(String name) {
        HashMap<Object, Object> newEntries = null;
        for (TransactionRecord transactionRecord : this.transactionRecords) {
            if (!transactionRecord.name.equals(name) || transactionRecord.removed || transactionRecord.value == null || !transactionRecord.newRecord) continue;
            if (newEntries == null) {
                newEntries = new HashMap<Object, Object>();
            }
            newEntries.put(transactionRecord.key, transactionRecord.value);
        }
        return newEntries;
    }

    public String toString() {
        return "TransactionImpl [" + this.id + "]";
    }

    private void finalizeTxn() {
        this.transactionRecords.clear();
        this.status = 0;
        ThreadContext.get().finalizeTxn();
    }

    private class TransactionRecord {
        public String name;
        public Object key;
        public Object value;
        public boolean removed = false;
        public boolean newRecord = false;
        public Instance.InstanceType instanceType = null;
        public long lastAccess = -1L;
        public int valueCount = 1;
        public long timeout = 0L;
        public long ttl = -1L;

        public TransactionRecord(String name, Object key, Object value, boolean newRecord) {
            this.name = name;
            this.key = key;
            this.value = value;
            this.newRecord = newRecord;
            this.instanceType = ConcurrentMapManager.getInstanceType(name);
        }

        public void commit() {
            if (this.instanceType == Instance.InstanceType.QUEUE) {
                this.commitQueue();
            } else {
                this.commitMap();
            }
        }

        public void commitMap() {
            if (this.removed) {
                if (this.instanceType.isSet()) {
                    ConcurrentMapManager.MRemoveItem mRemoveItem = ((TransactionImpl)TransactionImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MRemoveItem();
                    mRemoveItem.removeItem(this.name, this.key);
                } else if (!this.newRecord) {
                    if (this.instanceType.isMap()) {
                        ((TransactionImpl)TransactionImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MRemove().remove(this.name, this.key, -1L);
                    } else if (this.instanceType.isMultiMap()) {
                        ((TransactionImpl)TransactionImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MRemoveMulti().remove(this.name, this.key, this.value);
                    }
                } else {
                    ((TransactionImpl)TransactionImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MLock().unlock(this.name, this.key, -1L);
                }
            } else if (this.instanceType.isList()) {
                int count = (Integer)this.value;
                for (int i = 0; i < count; ++i) {
                    ((TransactionImpl)TransactionImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MAdd().addToList(this.name, this.key);
                }
            } else if (this.instanceType.isMultiMap()) {
                ((TransactionImpl)TransactionImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MPutMulti().put(this.name, this.key, this.value);
            } else {
                ((TransactionImpl)TransactionImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MPut().put(this.name, this.key, this.value, -1L, this.ttl);
            }
        }

        public void commitQueue() {
            if (!this.removed) {
                this.offerAgain(false);
            }
        }

        public void rollback() {
            if (this.instanceType == Instance.InstanceType.QUEUE) {
                this.rollbackQueue();
            } else {
                this.rollbackMap();
            }
        }

        public void rollbackMap() {
            MProxy mapProxy = null;
            Object proxy = TransactionImpl.this.factory.getOrCreateProxyByName(this.name);
            if (proxy instanceof MProxy) {
                mapProxy = (MProxy)proxy;
            }
            if (mapProxy != null) {
                mapProxy.unlock(this.key);
            }
        }

        public void rollbackQueue() {
            if (this.removed) {
                ((TransactionImpl)TransactionImpl.this).factory.node.blockingQueueManager.rollbackPoll(this.name, this.key, this.value);
            }
        }

        private void offerAgain(boolean first) {
            ((TransactionImpl)TransactionImpl.this).factory.node.blockingQueueManager.offerCommit(this.name, this.key, this.value);
        }

        public String toString() {
            return "TransactionRecord{instanceType=" + (Object)((Object)this.instanceType) + ", name='" + this.name + '\'' + ", key=" + this.key + ", value=" + this.value + ", removed=" + this.removed + ", newRecord=" + this.newRecord + ", lastAccess=" + this.lastAccess + ", valueCount=" + this.valueCount + '}';
        }
    }
}

