/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.ClientRunnable;
import com.hazelcast.client.Connection;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.NoMemberAvailableException;
import com.hazelcast.core.Member;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IORunnable
extends ClientRunnable {
    protected Map<Long, Call> callMap;
    protected final HazelcastClient client;
    final ILogger logger = Logger.getLogger(this.getClass().getName());
    protected static final Call RECONNECT_CALL = new Call(-1L, null);

    public IORunnable(HazelcastClient client, Map<Long, Call> calls) {
        this.client = client;
        this.callMap = calls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            super.run();
            this.logger.log(Level.INFO, this.getClass().getSimpleName() + " is finished ok.");
        }
        catch (Throwable e) {
            this.logger.log(Level.WARNING, this.getClass().getSimpleName() + " got exception:" + e.getMessage() + ", shutdown client.", e);
            this.interruptWaitingCallsAndShutdown(true);
        }
        finally {
            this.logger.log(Level.INFO, this.getClass().getSimpleName() + " is finished.");
        }
    }

    public void interruptWaitingCallsAndShutdown(boolean shutdown) {
        this.interruptWaitingCalls();
        if (shutdown) {
            this.client.shutdown();
        }
    }

    public void interruptWaitingCalls() {
        Collection<Call> values = this.callMap.values();
        Iterator<Call> it = values.iterator();
        while (it.hasNext()) {
            Call call = it.next();
            if (call == RECONNECT_CALL) continue;
            this.logger.log(Level.INFO, "cancel call " + call);
            call.setResponse(new NoMemberAvailableException());
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onDisconnect(Connection oldConnection) {
        Map<Long, Call> map = this.callMap;
        synchronized (map) {
            boolean shouldExecuteOnDisconnect = this.client.getConnectionManager().shouldExecuteOnDisconnect(oldConnection);
            if (!shouldExecuteOnDisconnect) {
                return false;
            }
            Member leftMember = oldConnection.getMember();
            Collection<Call> calls = this.callMap.values();
            for (Call call : calls) {
                Call removed;
                if (call == RECONNECT_CALL || (removed = this.callMap.remove(call.getId())) == null || this.client.getOutRunnable().queue.contains(removed)) continue;
                this.logger.log(Level.FINE, Thread.currentThread() + ": Calling on disconnect " + leftMember);
                removed.onDisconnect(leftMember);
            }
            return true;
        }
    }

    private boolean restoredConnection(Connection connection, long oldConnectionId) {
        return connection != null && (long)connection.getVersion() != oldConnectionId;
    }

    protected boolean restoredConnection(Connection oldConnection, Connection newConnection) {
        long oldConnectionId = oldConnection == null ? -1L : (long)oldConnection.getVersion();
        return this.restoredConnection(newConnection, oldConnectionId);
    }
}

