/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.AtomicNumberClientProxy;
import com.hazelcast.client.Call;
import com.hazelcast.client.ClientProperties;
import com.hazelcast.client.ClientThreadContext;
import com.hazelcast.client.ClusterClientException;
import com.hazelcast.client.ClusterClientProxy;
import com.hazelcast.client.Connection;
import com.hazelcast.client.ConnectionManager;
import com.hazelcast.client.DefaultClientBinder;
import com.hazelcast.client.ExecutorServiceClientProxy;
import com.hazelcast.client.IdGeneratorClientProxy;
import com.hazelcast.client.InRunnable;
import com.hazelcast.client.LifecycleServiceClientImpl;
import com.hazelcast.client.ListClientProxy;
import com.hazelcast.client.LockClientProxy;
import com.hazelcast.client.MapClientProxy;
import com.hazelcast.client.MultiMapClientProxy;
import com.hazelcast.client.OutRunnable;
import com.hazelcast.client.PacketReader;
import com.hazelcast.client.PacketWriter;
import com.hazelcast.client.PartitionClientProxy;
import com.hazelcast.client.QueueClientProxy;
import com.hazelcast.client.SetClientProxy;
import com.hazelcast.client.TopicClientProxy;
import com.hazelcast.client.TransactionClientProxy;
import com.hazelcast.client.impl.ListenerManager;
import com.hazelcast.config.Config;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.AtomicNumber;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceListener;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.Semaphore;
import com.hazelcast.core.Transaction;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.util.AddressUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HazelcastClient
implements HazelcastInstance {
    private static final AtomicInteger clientIdCounter = new AtomicInteger();
    final Map<Long, Call> calls = new ConcurrentHashMap<Long, Call>(100);
    final ListenerManager listenerManager;
    private final OutRunnable out;
    final InRunnable in;
    final ConnectionManager connectionManager;
    final Map<Object, Object> mapProxies = new ConcurrentHashMap<Object, Object>(100);
    final ConcurrentMap<String, ExecutorServiceClientProxy> mapExecutors = new ConcurrentHashMap<String, ExecutorServiceClientProxy>(2);
    final IMap mapLockProxy;
    final ClusterClientProxy clusterClientProxy;
    final PartitionClientProxy partitionClientProxy;
    final LifecycleServiceClientImpl lifecycleService;
    static final ILogger logger = Logger.getLogger(HazelcastClient.class.getName());
    final int id;
    private final ClientProperties properties;

    private HazelcastClient(ClientProperties properties, boolean shuffle, InetSocketAddress[] clusterMembers, boolean automatic) {
        this.properties = properties;
        this.id = clientIdCounter.incrementAndGet();
        String groupName = properties.getProperty(ClientProperties.ClientPropertyName.GROUP_NAME);
        String prefix = "hz.client." + this.id + ".";
        this.lifecycleService = new LifecycleServiceClientImpl(this);
        this.lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTING);
        this.connectionManager = automatic ? new ConnectionManager(this, this.lifecycleService, clusterMembers[0]) : new ConnectionManager(this, this.lifecycleService, clusterMembers, shuffle);
        this.connectionManager.setBinder(new DefaultClientBinder(this));
        this.out = new OutRunnable(this, this.calls, new PacketWriter());
        this.in = new InRunnable(this, this.out, this.calls, new PacketReader());
        this.listenerManager = new ListenerManager(this);
        try {
            Connection c = this.connectionManager.getInitConnection();
            if (c == null) {
                throw new IllegalStateException("Unable to connect to cluster");
            }
        }
        catch (IOException e) {
            throw new ClusterClientException(e.getMessage(), e);
        }
        new Thread((Runnable)this.out, prefix + "OutThread").start();
        new Thread((Runnable)this.in, prefix + "InThread").start();
        new Thread((Runnable)this.listenerManager, prefix + "Listener").start();
        this.mapLockProxy = this.getMap("__hz_Locks");
        this.clusterClientProxy = new ClusterClientProxy(this);
        this.partitionClientProxy = new PartitionClientProxy(this);
        if (automatic) {
            this.getCluster().addMembershipListener(this.connectionManager);
            this.connectionManager.updateMembers();
        }
        this.lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTED);
    }

    GroupConfig groupConfig() {
        String groupName = this.properties.getProperty(ClientProperties.ClientPropertyName.GROUP_NAME);
        String groupPassword = this.properties.getProperty(ClientProperties.ClientPropertyName.GROUP_PASSWORD);
        return new GroupConfig(groupName, groupPassword);
    }

    public InRunnable getInRunnable() {
        return this.in;
    }

    public OutRunnable getOutRunnable() {
        return this.out;
    }

    ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    private HazelcastClient(ClientProperties properties, InetSocketAddress address) {
        this(properties, false, new InetSocketAddress[]{address}, true);
    }

    public static HazelcastClient newHazelcastClient(String groupName, String groupPassword, String ... addresses) {
        return HazelcastClient.newHazelcastClient(ClientProperties.crateBaseClientProperties(groupName, groupPassword), addresses);
    }

    public static HazelcastClient newHazelcastClient(ClientProperties properties, String ... addresses) {
        return HazelcastClient.newHazelcastClient(properties, true, addresses);
    }

    public static HazelcastClient newHazelcastClient(ClientProperties properties, List<String> addresses) {
        List<String> handleMembers = AddressUtil.handleMembers(addresses);
        return HazelcastClient.newHazelcastClient(properties, handleMembers.toArray(new String[0]));
    }

    public static HazelcastClient newHazelcastClient(String groupName, String groupPassword, boolean shuffle, String ... addresses) {
        return HazelcastClient.newHazelcastClient(ClientProperties.crateBaseClientProperties(groupName, groupPassword), shuffle, addresses);
    }

    public static HazelcastClient newHazelcastClient(ClientProperties properties, boolean shuffle, String ... addresses) {
        InetSocketAddress[] socketAddressArr = new InetSocketAddress[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            InetSocketAddress inetSocketAddress;
            socketAddressArr[i] = inetSocketAddress = HazelcastClient.parse(addresses[i]);
        }
        return HazelcastClient.newHazelcastClient(properties, shuffle, socketAddressArr);
    }

    private static InetSocketAddress parse(String address) {
        String[] separated = address.split(":");
        int port = separated.length > 1 ? Integer.valueOf(separated[1]) : 5701;
        InetSocketAddress inetSocketAddress = new InetSocketAddress(separated[0], port);
        return inetSocketAddress;
    }

    public static HazelcastClient newHazelcastClient(String groupName, String groupPassword, boolean shuffle, InetSocketAddress ... addresses) {
        return HazelcastClient.newHazelcastClient(ClientProperties.crateBaseClientProperties(groupName, groupPassword), shuffle, addresses);
    }

    public static HazelcastClient newHazelcastClient(ClientProperties clientProperties, boolean shuffle, InetSocketAddress ... addresses) {
        return new HazelcastClient(clientProperties, shuffle, addresses, false);
    }

    public static HazelcastClient newHazelcastClient(String groupName, String groupPassword, String address) {
        InetSocketAddress inetSocketAddress = HazelcastClient.parse(address);
        return new HazelcastClient(ClientProperties.crateBaseClientProperties(groupName, groupPassword), inetSocketAddress);
    }

    public static HazelcastClient newHazelcastClient(ClientProperties clientProperties, String address) {
        InetSocketAddress inetSocketAddress = HazelcastClient.parse(address);
        return new HazelcastClient(clientProperties, inetSocketAddress);
    }

    @Override
    public Config getConfig() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PartitionService getPartitionService() {
        return this.partitionClientProxy;
    }

    @Override
    public LoggingService getLoggingService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <K, V> IMap<K, V> getMap(String name) {
        return (IMap)this.getClientProxy("c:" + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V, E> Object getClientProxy(Object o) {
        Instance proxy = this.mapProxies.get(o);
        if (proxy == null) {
            Map<Object, Object> map = this.mapProxies;
            synchronized (map) {
                proxy = this.mapProxies.get(o);
                if (proxy == null) {
                    if (o instanceof String) {
                        String name = (String)o;
                        proxy = name.startsWith("c:") ? new MapClientProxy(this, name) : (name.startsWith("m:l:") ? new ListClientProxy(this, name) : (name.startsWith("m:s:") ? new SetClientProxy(this, name) : (name.startsWith("q:") ? new QueueClientProxy(this, name) : (name.startsWith("t:") ? new TopicClientProxy(this, name) : (name.startsWith("a:") ? new AtomicNumberClientProxy(this, name) : (name.startsWith("i:") ? new IdGeneratorClientProxy(this, name) : (name.startsWith("m:u:") ? new MultiMapClientProxy(this, name) : new LockClientProxy(o, this))))))));
                        this.mapProxies.put(o, proxy);
                    } else {
                        proxy = new LockClientProxy(o, this);
                    }
                }
            }
        }
        return this.mapProxies.get(o);
    }

    @Override
    public Transaction getTransaction() {
        ClientThreadContext trc = ClientThreadContext.get();
        TransactionClientProxy proxy = (TransactionClientProxy)trc.getTransaction(this);
        return proxy;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public void addInstanceListener(InstanceListener instanceListener) {
        this.clusterClientProxy.addInstanceListener(instanceListener);
    }

    @Override
    public Cluster getCluster() {
        return this.clusterClientProxy;
    }

    public ClientProperties getProperties() {
        return this.properties;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.getExecutorService("default");
    }

    @Override
    public ExecutorService getExecutorService(String name) {
        ExecutorServiceClientProxy old;
        if (name == null) {
            throw new IllegalArgumentException("ExecutorService name cannot be null");
        }
        ExecutorServiceClientProxy executorServiceProxy = (ExecutorServiceClientProxy)this.mapExecutors.get(name);
        if (executorServiceProxy == null && (old = this.mapExecutors.putIfAbsent(name, executorServiceProxy = new ExecutorServiceClientProxy(this, name))) != null) {
            executorServiceProxy = old;
        }
        return executorServiceProxy;
    }

    @Override
    public IdGenerator getIdGenerator(String name) {
        return (IdGenerator)this.getClientProxy("i:" + name);
    }

    @Override
    public AtomicNumber getAtomicNumber(String name) {
        return (AtomicNumber)this.getClientProxy("a:" + name);
    }

    @Override
    public Semaphore getSemaphore(String name) {
        return (Semaphore)this.getClientProxy("smp:" + name);
    }

    @Override
    public Collection<Instance> getInstances() {
        return this.clusterClientProxy.getInstances();
    }

    @Override
    public <E> IList<E> getList(String name) {
        return (IList)this.getClientProxy("m:l:" + name);
    }

    @Override
    public ILock getLock(Object obj) {
        return new LockClientProxy(obj, this);
    }

    @Override
    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        return (MultiMap)this.getClientProxy("m:u:" + name);
    }

    @Override
    public String getName() {
        return this.properties.getProperty(ClientProperties.ClientPropertyName.GROUP_NAME);
    }

    @Override
    public <E> IQueue<E> getQueue(String name) {
        return (IQueue)this.getClientProxy("q:" + name);
    }

    @Override
    public <E> ISet<E> getSet(String name) {
        return (ISet)this.getClientProxy("m:s:" + name);
    }

    @Override
    public <E> ITopic<E> getTopic(String name) {
        return (ITopic)this.getClientProxy("t:" + name);
    }

    @Override
    public void removeInstanceListener(InstanceListener instanceListener) {
        this.clusterClientProxy.removeInstanceListener(instanceListener);
    }

    @Override
    public void shutdown() {
        this.lifecycleService.shutdown();
    }

    void doShutdown() {
        logger.log(Level.INFO, "HazelcastClient[ " + this.id + "] is shutting down.");
        this.connectionManager.shutdown();
        this.out.shutdown();
        this.in.shutdown();
        this.listenerManager.shutdown();
        ClientThreadContext.shutdown();
    }

    protected void destroy(String proxyName) {
        this.mapProxies.remove(proxyName);
    }

    @Override
    public void restart() {
        this.lifecycleService.restart();
    }

    @Override
    public LifecycleService getLifecycleService() {
        return this.lifecycleService;
    }

    static void runAsyncAndWait(final Runnable runnable) {
        HazelcastClient.callAsyncAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                runnable.run();
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <V> V callAsyncAndWait(Callable<V> callable) {
        ExecutorService es = Executors.newSingleThreadExecutor();
        try {
            V v;
            Future<V> future = es.submit(callable);
            try {
                v = future.get();
            }
            catch (Throwable e) {
                e.printStackTrace();
                V v2 = null;
                es.shutdown();
                return v2;
            }
            return v;
        }
        finally {
            es.shutdown();
        }
    }
}

