/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.config.AsymmetricEncryptionConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.Interfaces;
import com.hazelcast.config.Join;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.TopicConfig;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HazelcastConfigBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlConfigBuilder springXmlConfigBuilder = new SpringXmlConfigBuilder(parserContext);
        springXmlConfigBuilder.handleConfig(element);
        return springXmlConfigBuilder.getBeanDefinition();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SpringXmlConfigBuilder
    extends AbstractXmlConfigHelper {
        private final ParserContext parserContext;
        private BeanDefinitionBuilder configBuilder;
        private ManagedMap mapConfigManagedMap;
        private ManagedMap queueManagedMap;
        private ManagedMap topicManagedMap;
        private ManagedMap executorManagedMap;
        final Map<String, Integer> counter = new HashMap<String, Integer>();

        public SpringXmlConfigBuilder(ParserContext parserContext) {
            this.parserContext = parserContext;
            this.configBuilder = BeanDefinitionBuilder.rootBeanDefinition(Config.class);
            this.mapConfigManagedMap = new ManagedMap();
            this.queueManagedMap = new ManagedMap();
            this.topicManagedMap = new ManagedMap();
            this.executorManagedMap = new ManagedMap();
            this.configBuilder.addPropertyValue("mapConfigs", (Object)this.mapConfigManagedMap);
            this.configBuilder.addPropertyValue("QConfigs", (Object)this.queueManagedMap);
            this.configBuilder.addPropertyValue("topicConfigs", (Object)this.topicManagedMap);
            this.configBuilder.addPropertyValue("executorConfigMap", (Object)this.executorManagedMap);
        }

        public AbstractBeanDefinition getBeanDefinition() {
            return this.configBuilder.getBeanDefinition();
        }

        private String nextId(String id) {
            Integer idx = this.counter.get(id);
            idx = (idx != null ? idx : 0) + 1;
            this.counter.put(id, idx);
            return id + idx;
        }

        protected BeanDefinitionBuilder createBeanBuilder(Class clazz, String id) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((Class)clazz);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, this.nextId(id));
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)this.parserContext.getRegistry());
            return builder;
        }

        protected BeanDefinitionBuilder createAndFillBeanBuilder(Node node, Class clazz, String propertyName, BeanDefinitionBuilder parent, String ... exceptPropertyNames) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(clazz, propertyName);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            this.fillValues(node, builder, exceptPropertyNames);
            parent.addPropertyValue(propertyName, (Object)beanDefinition);
            return builder;
        }

        protected void createAndFillListedBean(Node node, Class clazz, String propertyName, ManagedMap managedMap) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(clazz, propertyName);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getValue(attName);
            builder.addPropertyValue("name", (Object)name);
            this.fillValues(node, builder, new String[0]);
            managedMap.put((Object)name, (Object)beanDefinition);
        }

        protected void fillValues(Node node, BeanDefinitionBuilder builder, String ... excludeNames) {
            HashSet<String> epn = excludeNames != null && excludeNames.length > 0 ? new HashSet<String>(Arrays.asList(excludeNames)) : null;
            this.fillAttributeValues(node, builder, (Collection<String>)epn);
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String name = this.xmlToJavaName(this.cleanNodeName(n));
                if (epn != null && epn.contains(name)) continue;
                String value = this.getValue(n);
                builder.addPropertyValue(name, (Object)value);
            }
        }

        private void fillAttributeValues(Node node, BeanDefinitionBuilder builder, Collection<String> epn) {
            NamedNodeMap atts = node.getAttributes();
            if (atts != null) {
                for (int a = 0; a < atts.getLength(); ++a) {
                    Node att = atts.item(a);
                    String name = this.xmlToJavaName(att.getNodeName());
                    if (epn != null && epn.contains(name)) continue;
                    String value = att.getNodeValue();
                    builder.addPropertyValue(name, (Object)value);
                }
            }
        }

        public void handleConfig(Element docElement) {
            for (Node node : new AbstractXmlConfigHelper.IterableNodeList(docElement, 1)) {
                String nodeName = this.cleanNodeName(node.getNodeName());
                if ("network".equals(nodeName)) {
                    this.handleNetwork(node);
                    continue;
                }
                if ("group".equals(nodeName)) {
                    this.handleGroup(node);
                    continue;
                }
                if ("properties".equals(nodeName)) {
                    this.handleProperties(node);
                    continue;
                }
                if ("executor-service".equals(nodeName)) {
                    this.handleExecutor(node);
                    continue;
                }
                if ("queue".equals(nodeName)) {
                    this.handleQueue(node);
                    continue;
                }
                if ("map".equals(nodeName)) {
                    this.handleMap(node);
                    continue;
                }
                if ("topic".equals(nodeName)) {
                    this.handleTopic(node);
                    continue;
                }
                if (!"merge-policies".equals(nodeName)) continue;
                this.handleMergePolicies(node);
            }
        }

        public void handleNetwork(Node node) {
            BeanDefinitionBuilder networkConfigBuilder = this.createBeanBuilder(NetworkConfig.class, "networkConfig");
            AbstractBeanDefinition beanDefinition = networkConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, this.configBuilder, null);
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String nodeName = this.cleanNodeName(child);
                if ("join".equals(nodeName)) {
                    this.handleJoin(child, networkConfigBuilder);
                    continue;
                }
                if ("interfaces".equals(nodeName)) {
                    this.handleInterfaces(child, networkConfigBuilder);
                    continue;
                }
                if ("symmetric-encryption".equals(nodeName)) {
                    this.handleSymmetricEncryption(child, networkConfigBuilder);
                    continue;
                }
                if (!"asymmetric-encryption".equals(nodeName)) continue;
                this.handleAsymmetricEncryption(child, networkConfigBuilder);
            }
            this.configBuilder.addPropertyValue("networkConfig", (Object)beanDefinition);
        }

        protected void handleViaReflection(Node child) {
            Method method;
            String methodName = this.xmlToJavaName("handle-" + this.cleanNodeName(child));
            try {
                method = this.getClass().getMethod(methodName, Node.class);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                return;
            }
            try {
                method.invoke((Object)this, child);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void handleGroup(Node node) {
            this.createAndFillBeanBuilder(node, GroupConfig.class, "groupConfig", this.configBuilder, new String[0]);
        }

        public void handleProperties(Node node) {
            this.handleProperties(node, this.configBuilder);
        }

        public void handleInterfaces(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(Interfaces.class, "interfaces");
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            NamedNodeMap atts = node.getAttributes();
            if (atts != null) {
                for (int a = 0; a < atts.getLength(); ++a) {
                    Node att = atts.item(a);
                    String name = this.xmlToJavaName(att.getNodeName());
                    String value = att.getNodeValue();
                    builder.addPropertyValue(name, (Object)value);
                }
            }
            ManagedList interafesSet = new ManagedList();
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String name = this.xmlToJavaName(this.cleanNodeName(n));
                String value = this.getValue(n);
                if (!"interface".equals(name)) continue;
                interafesSet.add((Object)value);
            }
            builder.addPropertyValue("interfaces", (Object)interafesSet);
            networkConfigBuilder.addPropertyValue("interfaces", (Object)beanDefinition);
        }

        public void handleJoin(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder joinConfigBuilder = this.createBeanBuilder(Join.class, "join");
            AbstractBeanDefinition beanDefinition = joinConfigBuilder.getBeanDefinition();
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String name = this.cleanNodeName(child);
                if ("multicast".equals(name)) {
                    this.handleMulticast(child, joinConfigBuilder);
                    continue;
                }
                if (!"tcp-ip".equals(name)) continue;
                this.handleTcpIp(child, joinConfigBuilder);
            }
            networkConfigBuilder.addPropertyValue("join", (Object)beanDefinition);
        }

        public void handleAsymmetricEncryption(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            this.createAndFillBeanBuilder(node, AsymmetricEncryptionConfig.class, "asymmetricEncryptionConfig", networkConfigBuilder, new String[0]);
        }

        public void handleSymmetricEncryption(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            this.createAndFillBeanBuilder(node, SymmetricEncryptionConfig.class, "symmetricEncryptionConfig", networkConfigBuilder, new String[0]);
        }

        public void handleExecutor(Node node) {
            this.createAndFillListedBean(node, ExecutorConfig.class, "executorConfig", this.executorManagedMap);
        }

        public void handleMulticast(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            this.createAndFillBeanBuilder(node, MulticastConfig.class, "multicastConfig", joinConfigBuilder, new String[0]);
        }

        public void handleTcpIp(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            BeanDefinitionBuilder builder = this.createAndFillBeanBuilder(node, TcpIpConfig.class, "tcpIpConfig", joinConfigBuilder, "interface", "member", "members");
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                String value;
                String name = this.xmlToJavaName(this.cleanNodeName(n.getNodeName()));
                if ("member".equals(name)) {
                    value = this.getValue(n);
                    builder.addPropertyValue("members", (Object)value);
                    continue;
                }
                if (!"members".equals(name)) continue;
                value = this.getValue(n);
                builder.addPropertyValue("members", (Object)value);
            }
        }

        public void handleQueue(Node node) {
            this.createAndFillListedBean(node, QueueConfig.class, "queueConfig", this.queueManagedMap);
        }

        public void handleMap(Node node) {
            BeanDefinitionBuilder mapConfigBuilder = this.createBeanBuilder(MapConfig.class, "mapConfig");
            AbstractBeanDefinition beanDefinition = mapConfigBuilder.getBeanDefinition();
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getValue(attName);
            mapConfigBuilder.addPropertyValue("name", (Object)name);
            this.fillValues(node, mapConfigBuilder, "mapStore", "nearCache");
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                String nname = this.cleanNodeName(n.getNodeName());
                if ("map-store".equals(nname)) {
                    this.handleMapStoreConfig(n, mapConfigBuilder);
                    continue;
                }
                if (!"near-cache".equals(nname)) continue;
                this.handleNearCacheConfig(n, mapConfigBuilder);
            }
            this.mapConfigManagedMap.put((Object)name, (Object)beanDefinition);
            mapConfigBuilder = null;
        }

        public void handleNearCacheConfig(Node node, BeanDefinitionBuilder mapConfigBuilder) {
            BeanDefinitionBuilder nearCacheConfigBuilder = this.createBeanBuilder(NearCacheConfig.class, "nearCacheConfig");
            AbstractBeanDefinition beanDefinition = nearCacheConfigBuilder.getBeanDefinition();
            this.fillValues(node, nearCacheConfigBuilder, new String[0]);
            mapConfigBuilder.addPropertyValue("nearCacheConfig", (Object)beanDefinition);
            nearCacheConfigBuilder = null;
        }

        public void handleMapStoreConfig(Node node, BeanDefinitionBuilder mapConfigBuilder) {
            BeanDefinitionBuilder mapStoreConfigBuilder = this.createBeanBuilder(MapStoreConfig.class, "mapStoreConfig");
            AbstractBeanDefinition beanDefinition = mapStoreConfigBuilder.getBeanDefinition();
            String implAttrName = "implementation";
            NamedNodeMap attrs = node.getAttributes();
            Node implRef = attrs.getNamedItem("implementation");
            Assert.isTrue((attrs.getNamedItem("class-name") != null || implRef != null ? 1 : 0) != 0, (String)"Either 'class-name' or 'implementation' attribute of MapStoreConfig has to be specified!");
            this.fillValues(node, mapStoreConfigBuilder, "implementation");
            this.handleProperties(node, mapStoreConfigBuilder);
            if (implRef != null) {
                mapStoreConfigBuilder.addPropertyReference(implRef.getNodeName(), implRef.getNodeValue());
            }
            mapConfigBuilder.addPropertyValue("mapStoreConfig", (Object)beanDefinition);
            mapStoreConfigBuilder = null;
        }

        public void handleProperties(Node node, BeanDefinitionBuilder beanDefinitionBuilder) {
            ManagedMap properties = new ManagedMap();
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                String name = this.cleanNodeName(n.getNodeName());
                if (!"property".equals(name)) continue;
                String propertyName = this.getTextContent(n.getAttributes().getNamedItem("name")).trim();
                String value = this.getValue(n);
                properties.put((Object)propertyName, (Object)value);
            }
            beanDefinitionBuilder.addPropertyValue("properties", (Object)properties);
        }

        public void handleTopic(Node node) {
            this.createAndFillListedBean(node, TopicConfig.class, "topicConfig", this.topicManagedMap);
        }

        public void handleMergePolicies(Node node) {
            this.createAndFillBeanBuilder(node, MergePolicyConfig.class, "mergePolicyConfig", this.configBuilder, new String[0]);
        }
    }
}

