/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor;

import com.hazelcast.core.Member;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.monitor.ClusterStateView;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterStateViewImpl
implements ClusterStateView,
DataSerializable {
    Map<Member, int[]> memberPartitions = new ConcurrentHashMap<Member, int[]>();
    Set<String> instanceNames = new HashSet<String>();

    public ClusterStateViewImpl(Set<String> instanceNames) {
        this.instanceNames = instanceNames;
    }

    public ClusterStateViewImpl() {
    }

    public void setPartition(Member member, int[] partitions) {
        this.memberPartitions.put(member, partitions);
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeInt(this.memberPartitions.size());
        Set<Map.Entry<Member, int[]>> memberStatEntries = this.memberPartitions.entrySet();
        for (Map.Entry<Member, int[]> memberStatEntry : memberStatEntries) {
            memberStatEntry.getKey().writeData(out);
            int[] partitions = memberStatEntry.getValue();
            out.writeInt(partitions.length);
            for (int partition : partitions) {
                out.writeInt(partition);
            }
        }
        int nameCount = this.instanceNames.size();
        out.writeInt(nameCount);
        for (String name : this.instanceNames) {
            out.writeUTF(name);
        }
    }

    @Override
    public void readData(DataInput in) throws IOException {
        int memberStatsCount = in.readInt();
        for (int i = 0; i < memberStatsCount; ++i) {
            MemberImpl member = new MemberImpl();
            member.readData(in);
            int partitionCount = in.readInt();
            int[] partitions = new int[partitionCount];
            for (int a = 0; a < partitionCount; ++a) {
                partitions[a] = in.readInt();
            }
            this.memberPartitions.put(member, partitions);
        }
        int nameCount = in.readInt();
        for (int i = 0; i < nameCount; ++i) {
            this.instanceNames.add(in.readUTF());
        }
    }

    private Set<String> getInstances(String prefix) {
        HashSet<String> names = new HashSet<String>();
        for (String name : this.instanceNames) {
            if (!name.startsWith(prefix)) continue;
            names.add(name.substring(prefix.length()));
        }
        return names;
    }

    @Override
    public Set<String> getMaps() {
        return this.getInstances("c:");
    }

    @Override
    public Set<String> getMultiMaps() {
        return this.getInstances("m:u:");
    }

    @Override
    public Set<String> getQueues() {
        return this.getInstances("q:");
    }

    @Override
    public Set<String> getSets() {
        return this.getInstances("m:s:");
    }

    @Override
    public Set<String> getLists() {
        return this.getInstances("m:l:");
    }

    @Override
    public Set<String> getTopics() {
        return this.getInstances("t:");
    }

    @Override
    public Set<String> getAtomicNumbers() {
        return this.getInstances("a:");
    }

    @Override
    public Set<String> getIdGenerators() {
        return this.getInstances("i:");
    }

    @Override
    public Set<Member> getMembers() {
        return this.memberPartitions.keySet();
    }

    @Override
    public int[] getPartitions(Member member) {
        return this.memberPartitions.get(member);
    }

    public String toString() {
        return "ClusterStateViewImpl{instanceNames=" + this.instanceNames + ", memberPartitions=" + this.memberPartitions + '}';
    }
}

