/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.JoinInfo;
import com.hazelcast.config.Config;
import com.hazelcast.core.Member;
import com.hazelcast.impl.FallThroughRunnable;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.MulticastListener;
import com.hazelcast.impl.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class SplitBrainHandler
implements Runnable {
    final Node node;
    final ILogger logger;
    volatile long lastRun = 0L;
    volatile boolean inProgress = false;
    final long FIRST_RUN_DELAY_MILLIS;
    final long NEXT_RUN_DELAY_MILLIS;
    final boolean multicastEnabled;
    final boolean tcpEnabled;

    public SplitBrainHandler(Node node) {
        this.node = node;
        this.logger = node.getLogger(SplitBrainHandler.class.getName());
        this.FIRST_RUN_DELAY_MILLIS = node.getGroupProperties().MERGE_FIRST_RUN_DELAY_SECONDS.getLong() * 1000L;
        this.NEXT_RUN_DELAY_MILLIS = node.getGroupProperties().MERGE_NEXT_RUN_DELAY_SECONDS.getLong() * 1000L;
        Config config = node.getConfig();
        this.multicastEnabled = config.getNetworkConfig().getJoin().getMulticastConfig().isEnabled();
        this.tcpEnabled = config.getNetworkConfig().getJoin().getTcpIpConfig().isEnabled();
        this.lastRun = System.currentTimeMillis() + this.FIRST_RUN_DELAY_MILLIS;
    }

    public void run() {
        if (this.node.isMaster() && this.node.joined() && this.node.isActive()) {
            long now = System.currentTimeMillis();
            if (!this.inProgress && now - this.lastRun > this.NEXT_RUN_DELAY_MILLIS && this.node.clusterManager.shouldTryMerge()) {
                this.inProgress = true;
                this.node.executorManager.executeNow(new FallThroughRunnable(){

                    public void doRun() {
                        SplitBrainHandler.this.searchForOtherClusters();
                        SplitBrainHandler.this.lastRun = System.currentTimeMillis();
                        SplitBrainHandler.this.inProgress = false;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchForOtherClusters() {
        if (this.multicastEnabled && this.node.multicastService != null) {
            final LinkedBlockingQueue q = new LinkedBlockingQueue();
            MulticastListener listener = new MulticastListener(){

                public void onMessage(Object msg) {
                    if (msg != null && msg instanceof JoinInfo) {
                        JoinInfo joinInfo = (JoinInfo)msg;
                        if (SplitBrainHandler.this.node.address != null && !SplitBrainHandler.this.node.address.equals(joinInfo.address)) {
                            q.offer(msg);
                        }
                    }
                }
            };
            this.node.multicastService.addMulticastListener(listener);
            this.node.multicastService.send(this.node.createJoinInfo());
            try {
                JoinInfo joinInfo = (JoinInfo)q.poll(3L, TimeUnit.SECONDS);
                if (joinInfo != null && this.shouldMerge(joinInfo)) {
                    this.logger.log(Level.WARNING, this.node.address + " is merging [multicast] to " + joinInfo.address);
                    this.node.factory.restart();
                    return;
                }
            }
            catch (InterruptedException ignored) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.node.multicastService.removeMulticastListener(listener);
            }
        }
        if (this.tcpEnabled) {
            Collection<Address> colPossibleAddresses;
            try {
                colPossibleAddresses = Node.getPossibleMembers(this.node.getConfig(), this.node.getThisAddress(), this.logger);
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                return;
            }
            colPossibleAddresses.remove(this.node.getThisAddress());
            for (Member member : this.node.getClusterImpl().getMembers()) {
                colPossibleAddresses.remove(((MemberImpl)member).getAddress());
            }
            if (colPossibleAddresses.size() == 0) {
                return;
            }
            for (Address possibleAddress : colPossibleAddresses) {
                this.logger.log(Level.FINEST, this.node.getThisAddress() + " is connecting to " + possibleAddress);
                this.node.connectionManager.getOrConnect(possibleAddress);
            }
            for (Address possibleAddress : colPossibleAddresses) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                Connection conn = this.node.connectionManager.getOrConnect(possibleAddress);
                if (conn == null) continue;
                JoinInfo response = this.node.clusterManager.checkJoin(conn);
                if (this.shouldMerge(response)) {
                    this.logger.log(Level.WARNING, this.node.address + " is merging [tcp/ip] to " + possibleAddress);
                    this.lastRun = System.currentTimeMillis() + this.FIRST_RUN_DELAY_MILLIS;
                    this.node.factory.restart();
                }
                return;
            }
        }
    }

    boolean shouldMerge(JoinInfo joinInfo) {
        boolean shouldMerge = false;
        if (joinInfo != null) {
            try {
                boolean validJoinRequest;
                try {
                    validJoinRequest = this.node.validateJoinRequest(joinInfo);
                }
                catch (Exception e) {
                    validJoinRequest = false;
                }
                if (validJoinRequest) {
                    for (Member member : this.node.getClusterImpl().getMembers()) {
                        MemberImpl memberImpl = (MemberImpl)member;
                        if (!memberImpl.getAddress().equals(joinInfo.address)) continue;
                        return false;
                    }
                    int currentMemberCount = this.node.getClusterImpl().getMembers().size();
                    if (joinInfo.getMemberCount() > currentMemberCount) {
                        shouldMerge = true;
                    } else if (joinInfo.getMemberCount() == currentMemberCount && this.node.getThisAddress().hashCode() > joinInfo.address.hashCode()) {
                        shouldMerge = true;
                    }
                }
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                return false;
            }
        }
        return shouldMerge;
    }
}

