/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.monitor.LocalMapOperationStats;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MapOperationStatsImpl
implements LocalMapOperationStats {
    long periodStart;
    long periodEnd;
    OperationStat gets = new OperationStat(0L, 0L);
    OperationStat puts = new OperationStat(0L, 0L);
    OperationStat removes = new OperationStat(0L, 0L);
    long numberOfOtherOperations;
    long numberOfEvents;

    public void writeData(DataOutput out) throws IOException {
        this.puts.writeData(out);
        this.gets.writeData(out);
        this.removes.writeData(out);
        out.writeLong(this.numberOfOtherOperations);
        out.writeLong(this.numberOfEvents);
        out.writeLong(this.periodStart);
        out.writeLong(this.periodEnd);
    }

    public void readData(DataInput in) throws IOException {
        this.puts = new OperationStat();
        this.puts.readData(in);
        this.gets = new OperationStat();
        this.gets.readData(in);
        this.removes = new OperationStat();
        this.removes.readData(in);
        this.numberOfOtherOperations = in.readLong();
        this.numberOfEvents = in.readLong();
        this.periodStart = in.readLong();
        this.periodEnd = in.readLong();
    }

    public long total() {
        return this.puts.count + this.gets.count + this.removes.count + this.numberOfOtherOperations;
    }

    public long getPeriodStart() {
        return this.periodStart;
    }

    public long getPeriodEnd() {
        return this.periodEnd;
    }

    public long getNumberOfPuts() {
        return this.puts.count;
    }

    public long getNumberOfGets() {
        return this.gets.count;
    }

    public long getTotalPutLatency() {
        return this.puts.totalLatency;
    }

    public long getTotalGetLatency() {
        return this.gets.totalLatency;
    }

    public long getTotalRemoveLatency() {
        return this.removes.totalLatency;
    }

    public long getNumberOfRemoves() {
        return this.removes.count;
    }

    public long getNumberOfOtherOperations() {
        return this.numberOfOtherOperations;
    }

    public long getNumberOfEvents() {
        return this.numberOfEvents;
    }

    public String toString() {
        return "LocalMapOperationStats{total= " + this.total() + "\n, puts:" + this.puts + "\n, gets:" + this.gets + "\n, removes:" + this.removes + "\n, others: " + this.numberOfOtherOperations + "\n, received events: " + this.numberOfEvents + "}";
    }

    class OperationStat
    implements DataSerializable {
        long count;
        long totalLatency;

        public OperationStat() {
            this(0L, 0L);
        }

        public OperationStat(long c, long l) {
            this.count = c;
            this.totalLatency = l;
        }

        public String toString() {
            return "OperationStat{count=" + this.count + ", averageLatency=" + (this.count == 0L ? 0L : this.totalLatency / this.count) + '}';
        }

        public void writeData(DataOutput out) throws IOException {
            out.writeLong(this.count);
            out.writeLong(this.totalLatency);
        }

        public void readData(DataInput in) throws IOException {
            this.count = in.readLong();
            this.totalLatency = in.readLong();
        }

        public void add(long c, long l) {
            this.count += c;
            this.totalLatency += l;
        }
    }
}

