/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.Node;
import com.hazelcast.logging.ILogger;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class ExecutorThreadFactory
implements ThreadFactory {
    final ILogger logger;
    final ThreadGroup group;
    final AtomicInteger threadNumber = new AtomicInteger(1);
    final String namePrefix;
    final ClassLoader classLoader;
    final Node node;

    public ExecutorThreadFactory(Node node, String threadNamePrefix, ClassLoader classLoader) {
        this.node = node;
        this.group = node.threadGroup;
        this.classLoader = classLoader;
        this.namePrefix = threadNamePrefix;
        this.logger = node.getLogger(ExecutorThreadFactory.class.getName());
    }

    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        t.setContextClassLoader(this.classLoader);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        try {
            throw new RuntimeException("New Thread " + t);
        }
        catch (RuntimeException e1) {
            e1.printStackTrace();
            this.logger.log(Level.WARNING, "Hazelcast Created a New Thread", e1);
            return t;
        }
    }
}

