/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.AtomicNumber;
import com.hazelcast.core.Instance;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.base.FactoryAwareNamedProxy;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;

public class AtomicNumberImpl
extends FactoryAwareNamedProxy
implements AtomicNumber,
DataSerializable {
    AtomicNumber base = null;
    Data nameAsData = null;

    public AtomicNumberImpl() {
    }

    public AtomicNumberImpl(String name, FactoryImpl factory) {
        this.setName(name);
        this.setHazelcastInstance(factory);
        this.base = new AtomicNumberReal();
    }

    Data getNameAsData() {
        if (this.nameAsData == null) {
            this.nameAsData = IOUtil.toData(this.name);
        }
        return this.nameAsData;
    }

    private void ensure() {
        this.factory.initialChecks();
        if (this.base == null) {
            this.base = (AtomicNumber)this.factory.getOrCreateProxyByName(this.name);
        }
    }

    public Object getId() {
        this.ensure();
        return this.base.getId();
    }

    public String toString() {
        return "IdGenerator [" + this.getName() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtomicNumberImpl that = (AtomicNumberImpl)o;
        return !(this.name == null ? that.name != null : !this.name.equals(that.name));
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public Instance.InstanceType getInstanceType() {
        this.ensure();
        return this.base.getInstanceType();
    }

    public void destroy() {
        this.ensure();
        this.base.destroy();
    }

    public String getName() {
        this.ensure();
        return this.base.getName();
    }

    public long addAndGet(long delta) {
        this.ensure();
        return this.base.addAndGet(delta);
    }

    public boolean compareAndSet(long expect, long update) {
        this.ensure();
        return this.base.compareAndSet(expect, update);
    }

    public boolean weakCompareAndSet(long expect, long update) {
        this.ensure();
        return this.base.weakCompareAndSet(expect, update);
    }

    public long decrementAndGet() {
        this.ensure();
        return this.base.decrementAndGet();
    }

    public long get() {
        this.ensure();
        return this.base.get();
    }

    public long getAndAdd(long delta) {
        this.ensure();
        return this.base.getAndAdd(delta);
    }

    public long getAndSet(long newValue) {
        this.ensure();
        return this.base.getAndSet(newValue);
    }

    public long incrementAndGet() {
        this.ensure();
        return this.base.incrementAndGet();
    }

    public void lazySet(long newValue) {
        this.ensure();
        this.base.lazySet(newValue);
    }

    public void set(long newValue) {
        this.ensure();
        this.base.set(newValue);
    }

    private class AtomicNumberReal
    implements AtomicNumber {
        private AtomicNumberReal() {
        }

        public String getName() {
            return AtomicNumberImpl.this.name.substring("a:".length());
        }

        ConcurrentMapManager.MAtomic newMAtomic(ClusterOperation op, long value, long expected) {
            ConcurrentMapManager concurrentMapManager = ((AtomicNumberImpl)AtomicNumberImpl.this).factory.node.concurrentMapManager;
            concurrentMapManager.getClass();
            return new ConcurrentMapManager.MAtomic(concurrentMapManager, AtomicNumberImpl.this.getNameAsData(), op, value, expected);
        }

        ConcurrentMapManager.MAtomic newMAtomic(ClusterOperation op, long value) {
            ConcurrentMapManager concurrentMapManager = ((AtomicNumberImpl)AtomicNumberImpl.this).factory.node.concurrentMapManager;
            concurrentMapManager.getClass();
            return new ConcurrentMapManager.MAtomic(concurrentMapManager, AtomicNumberImpl.this.getNameAsData(), op, value);
        }

        public long addAndGet(long delta) {
            ConcurrentMapManager.MAtomic a = this.newMAtomic(ClusterOperation.ATOMIC_NUMBER_ADD_AND_GET, delta);
            long result = a.doLongAtomic();
            a.backup(result);
            return result;
        }

        public boolean compareAndSet(long expect, long update) {
            ConcurrentMapManager.MAtomic a = this.newMAtomic(ClusterOperation.ATOMIC_NUMBER_COMPARE_AND_SET, update, expect);
            boolean result = a.doBooleanAtomic();
            if (result) {
                a.backup(update);
            }
            return result;
        }

        public boolean weakCompareAndSet(long expect, long update) {
            return this.compareAndSet(expect, update);
        }

        public long decrementAndGet() {
            return this.addAndGet(-1L);
        }

        public long get() {
            return this.addAndGet(0L);
        }

        public long getAndAdd(long delta) {
            ConcurrentMapManager.MAtomic a = this.newMAtomic(ClusterOperation.ATOMIC_NUMBER_GET_AND_ADD, delta);
            long result = a.doLongAtomic();
            a.backup(result + delta);
            return result;
        }

        public long getAndSet(long newValue) {
            ConcurrentMapManager.MAtomic a = this.newMAtomic(ClusterOperation.ATOMIC_NUMBER_GET_AND_SET, newValue);
            long result = a.doLongAtomic();
            a.backup(newValue);
            return result;
        }

        public long incrementAndGet() {
            return this.addAndGet(1L);
        }

        public void lazySet(long newValue) {
            this.set(newValue);
        }

        public void set(long newValue) {
            this.getAndSet(newValue);
        }

        public Instance.InstanceType getInstanceType() {
            return Instance.InstanceType.ATOMIC_NUMBER;
        }

        public void destroy() {
            new ConcurrentMapManager.MRemove(((AtomicNumberImpl)AtomicNumberImpl.this).factory.node.concurrentMapManager).remove("c:hz_AtomicNumber", AtomicNumberImpl.this.nameAsData, 0L);
        }

        public Object getId() {
            return AtomicNumberImpl.this.name;
        }
    }
}

