/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.IOUtil;
import com.hazelcast.client.Packet;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.client.QueueItemIterator;
import com.hazelcast.client.impl.QueueItemListenerManager;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.Instance;
import com.hazelcast.core.ItemListener;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.monitor.LocalQueueStats;
import com.hazelcast.nio.Data;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueClientProxy<E>
extends AbstractQueue<E>
implements IQueue<E> {
    protected final ProxyHelper proxyHelper;
    protected final String name;
    final Object lock = new Object();

    public QueueClientProxy(HazelcastClient hazelcastClient, String name) {
        this.name = name;
        this.proxyHelper = new ProxyHelper(name, hazelcastClient);
    }

    @Override
    public String getName() {
        return this.name.substring("q:".length());
    }

    @Override
    public Instance.InstanceType getInstanceType() {
        return Instance.InstanceType.QUEUE;
    }

    @Override
    public void destroy() {
        this.proxyHelper.destroy();
    }

    @Override
    public Object getId() {
        return this.name;
    }

    @Override
    public String toString() {
        return "Queue{name='" + this.name + '\'' + '}';
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public LocalQueueStats getLocalQueueStats() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E e) {
        ProxyHelper.check(e);
        return this.innerOffer(e, 0L);
    }

    @Override
    public E poll() {
        return this.innerPoll(0L);
    }

    @Override
    public E peek() {
        return (E)this.proxyHelper.doOp(ClusterOperation.BLOCKING_QUEUE_PEEK, null, null);
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        ProxyHelper.check(e);
        ProxyHelper.checkTime(l, timeUnit);
        long l2 = l = l < 0L ? 0L : l;
        if (e == null) {
            throw new NullPointerException();
        }
        return this.innerOffer(e, timeUnit.toMillis(l));
    }

    private boolean innerOffer(E e, long millis) {
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.BLOCKING_QUEUE_OFFER, e, millis);
    }

    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        ProxyHelper.checkTime(l, timeUnit);
        l = l < 0L ? 0L : l;
        return this.innerPoll(timeUnit.toMillis(l));
    }

    private E innerPoll(long millis) {
        return (E)this.proxyHelper.doOp(ClusterOperation.BLOCKING_QUEUE_POLL, null, millis);
    }

    @Override
    public E take() throws InterruptedException {
        return this.innerPoll(-1L);
    }

    @Override
    public void put(E e) throws InterruptedException {
        ProxyHelper.check(e);
        this.innerOffer(e, -1L);
    }

    @Override
    public int remainingCapacity() {
        return (Integer)this.proxyHelper.doOp(ClusterOperation.BLOCKING_QUEUE_REMAINING_CAPACITY, null, null);
    }

    @Override
    public int drainTo(Collection<? super E> objects) {
        return this.drainTo(objects, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super E> objects, int i) {
        E e;
        int counter;
        if (objects == null) {
            throw new NullPointerException("drainTo null!");
        }
        if (i < 0) {
            throw new IllegalArgumentException("Negative maxElements:" + i);
        }
        if (i == 0) {
            return 0;
        }
        if (objects instanceof IQueue && ((IQueue)objects).getName().equals(this.getName())) {
            throw new IllegalArgumentException("Cannot drainTo self!");
        }
        for (counter = 0; (e = this.poll()) != null && counter < i; ++counter) {
            objects.add(e);
        }
        return counter;
    }

    @Override
    public int size() {
        return (Integer)this.proxyHelper.doOp(ClusterOperation.BLOCKING_QUEUE_SIZE, null, null);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof IQueue && o != null) {
            return this.getName().equals(((IQueue)o).getName());
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.BLOCKING_QUEUE_REMOVE, null, o);
    }

    @Override
    public Iterator<E> iterator() {
        Object[] dItems = (Object[])this.proxyHelper.doOp(ClusterOperation.BLOCKING_QUEUE_ENTRIES, null, null);
        Object[] entries = new Object[dItems.length];
        int i = 0;
        for (Object entry : dItems) {
            entries[i++] = IOUtil.toObject(((Data)entry).buffer);
        }
        return new QueueItemIterator<Object>(entries, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addItemListener(ItemListener<E> listener, boolean includeValue) {
        ProxyHelper.check(listener);
        Object object = this.lock;
        synchronized (object) {
            boolean shouldCall = this.listenerManager().noListenerRegistered(this.name);
            this.listenerManager().registerListener(this.name, listener);
            if (shouldCall) {
                Call c = this.listenerManager().createNewAddItemListenerCall(this.proxyHelper);
                this.proxyHelper.doCall(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeItemListener(ItemListener<E> listener) {
        ProxyHelper.check(listener);
        Object object = this.lock;
        synchronized (object) {
            this.listenerManager().removeListener(this.name, listener);
            Packet request = this.proxyHelper.createRequestPacket(ClusterOperation.REMOVE_LISTENER, null, null);
            Call c = this.proxyHelper.createCall(request);
            this.proxyHelper.doCall(c);
        }
    }

    private QueueItemListenerManager listenerManager() {
        return this.proxyHelper.getHazelcastClient().getListenerManager().getQueueItemListenerManager();
    }
}

