/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.logging;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggerFactory;
import com.hazelcast.logging.NoLogFactory;
import com.hazelcast.logging.StandardLoggerFactory;
import com.hazelcast.nio.Serializer;

public class Logger {
    private static volatile LoggerFactory loggerFactory = null;
    private static final Object factoryLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ILogger getLogger(String name) {
        if (loggerFactory == null) {
            Object object = factoryLock;
            synchronized (object) {
                if (loggerFactory == null) {
                    String loggerType;
                    String loggerClass = System.getProperty("hazelcast.logging.class");
                    if (loggerClass != null) {
                        try {
                            loggerFactory = (LoggerFactory)Serializer.classForName(loggerClass).newInstance();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (loggerFactory == null && (loggerType = System.getProperty("hazelcast.logging.type")) != null) {
                        if ("log4j".equals(loggerType)) {
                            try {
                                loggerFactory = (LoggerFactory)Serializer.classForName("com.hazelcast.logging.Log4jFactory").newInstance();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else if ("slf4j".equals(loggerType)) {
                            try {
                                loggerFactory = (LoggerFactory)Serializer.classForName("com.hazelcast.logging.Slf4jFactory").newInstance();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else if ("none".equals(loggerType)) {
                            loggerFactory = new NoLogFactory();
                        }
                    }
                    if (loggerFactory == null) {
                        loggerFactory = new StandardLoggerFactory();
                    }
                }
            }
        }
        return loggerFactory.getLogger(name);
    }
}

